/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.test;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Database;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2DatabaseGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Filesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2HBA;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2LogicalVolumeManager;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2TableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabase;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabase2TableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabaseGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabaseGroup2Database;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk2DiskPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphDiskPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2SubsystemFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2SwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2VirtualFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolume2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphMediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphMediaChanger2TapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2PoolPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphPoolPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Pool;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2SubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2SwitchPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2Filesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2MediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2TapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2VolumePerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumePerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone2ZoneMember;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2Zone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2ZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneMember;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet2Zone;

public class SampleGraphModel
extends GraphModel
implements Serializable {
    private int wwnCount = 0;
    private int fabricCount = 0;
    private int swCount = 0;
    private int subsystemCount = 0;
    private int diskCount = 0;
    private int poolCount = 0;
    private int volumeCount = 0;
    private int computerCount = 0;
    private int tapeLibraryCount = 0;
    private int tapeDriveCount = 0;
    private int mediaChangerCount = 0;
    private int otherCount = 0;
    private int zsetCount = 0;
    private int zoneCount = 0;

    public static void main(String[] args) {
        SampleGraphModel app = new SampleGraphModel();
    }

    public SampleGraphModel() {
        super(null);
        try {
            this.data1();
            this.data2();
            this.calculateFabricMeta();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void data2() throws Exception {
        int i;
        String wwn = this.generateWWN();
        String fabricIDStr = "fabric" + this.generateFabricID();
        GraphFabric fabric3 = new GraphFabric(fabricIDStr);
        GraphFabric.ID fabric3ID = (GraphFabric.ID)fabric3.getEntityID();
        fabric3.setDisplayName(wwn);
        fabric3.setWWN(wwn);
        fabric3.setActive(Boolean.TRUE);
        fabric3.setIsPhysical(Boolean.TRUE);
        fabric3.setHealthStatus(GraphModelConstant.STATUS_WARNING);
        this.put(fabric3);
        String wwn2 = this.generateWWN();
        String fabricIDStr2 = "fabric" + this.generateFabricID();
        GraphFabric fabric4 = new GraphFabric(fabricIDStr2);
        GraphFabric.ID fabric4ID = (GraphFabric.ID)fabric4.getEntityID();
        fabric4.setDisplayName(wwn2);
        fabric4.setWWN(wwn2);
        fabric4.setActive(Boolean.TRUE);
        fabric4.setName("vfabric-tsm");
        fabric4.setParentLabel(fabric3.getDisplayName());
        fabric4.setIsPhysical(Boolean.FALSE);
        fabric4.setHealthStatus(GraphModelConstant.STATUS_MISSING);
        this.put(fabric4);
        GraphFabric2VirtualFabric fabric2vfabric = new GraphFabric2VirtualFabric(fabric3ID.getID() + "+" + fabric4ID.getID());
        fabric2vfabric.setFabricID(fabric3ID);
        fabric2vfabric.setVirtualFabricID(fabric4ID);
        fabric2vfabric.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric2vfabric);
        String wwn3 = this.generateWWN();
        String fabricIDStr3 = "fabric" + this.generateFabricID();
        GraphFabric fabric5 = new GraphFabric(fabricIDStr3);
        GraphFabric.ID fabric5ID = (GraphFabric.ID)fabric5.getEntityID();
        fabric5.setDisplayName(wwn3);
        fabric5.setWWN(wwn3);
        fabric5.setActive(Boolean.FALSE);
        fabric5.setName("vfabric-ace");
        fabric5.setParentLabel(fabric3.getDisplayName());
        fabric5.setIsPhysical(Boolean.FALSE);
        fabric5.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
        this.put(fabric5);
        GraphFabric2VirtualFabric fabric2vfabric2 = new GraphFabric2VirtualFabric(fabric3ID.getID() + "+" + fabric5ID.getID());
        fabric2vfabric2.setFabricID(fabric3ID);
        fabric2vfabric2.setVirtualFabricID(fabric5ID);
        fabric2vfabric2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric2vfabric2);
        Vector<GraphFCPort> sw3FCPortV = new Vector<GraphFCPort>();
        boolean sw3FCPortCount = false;
        String wwn4 = this.generateWWN();
        String swIDStr = "sw" + this.generateSwitchID();
        GraphSwitch sw3 = new GraphSwitch(swIDStr);
        GraphSwitch.ID sw3ID = (GraphSwitch.ID)sw3.getEntityID();
        sw3.setDisplayName("many ports");
        sw3.setWWN(wwn4);
        sw3.setVendor("Cisco");
        sw3.setModel("MDS 9206");
        sw3.setSerialNumber("999");
        sw3.setIPAddress("9.29.22.10");
        sw3.setVersion("3.2");
        sw3.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
        Vector<GraphFabric.ID> fabricIDV = new Vector<GraphFabric.ID>();
        this.put(sw3);
        GraphFabric2Switch fabric_sw = new GraphFabric2Switch(fabric3ID.getID() + "+" + sw3ID.getID());
        fabric_sw.setFabricID(fabric3ID);
        fabric_sw.setSwitchID(sw3ID);
        fabric_sw.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_sw);
        fabricIDV.add(fabric3ID);
        for (int i2 = 0; i2 < 256; ++i2) {
            wwn4 = this.generateWWN();
            GraphFCPort fcport = new GraphFCPort(wwn4);
            GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
            fcport.setDisplayName(wwn4);
            fcport.setName(wwn4);
            fcport.setPortNumber(String.valueOf(i2));
            fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport);
            sw3FCPortV.add(fcport);
            GraphSwitch2FCPort sw_fcport = new GraphSwitch2FCPort(sw3ID.getID() + "+" + fcportID.getID());
            sw_fcport.setSwitchID(sw3ID);
            sw_fcport.setFCPortID(fcportID);
            sw_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_fcport);
        }
        Vector<GraphFCPort> sw4FCPortV = new Vector<GraphFCPort>();
        int sw4FCPortCount = 0;
        String wwn5 = this.generateWWN();
        String swIDStr2 = "sw" + this.generateSwitchID();
        GraphSwitch sw4 = new GraphSwitch(swIDStr2);
        GraphSwitch.ID sw4ID = (GraphSwitch.ID)sw4.getEntityID();
        sw4.setDisplayName(wwn5);
        sw4.setWWN(wwn5);
        sw4.setVendor("Cisco");
        sw4.setModel("MDS 9206");
        sw4.setSerialNumber("999");
        sw4.setIPAddress("9.29.22.10");
        sw4.setVersion("3.2");
        sw4.setParentWWN(sw3.getDisplayName());
        sw4.setHealthStatus(GraphModelConstant.STATUS_MISSING);
        Vector<GraphFabric.ID> fabricIDV2 = new Vector<GraphFabric.ID>();
        this.put(sw4);
        GraphFabric2Switch fabric_sw2 = new GraphFabric2Switch(fabric4ID.getID() + "+" + sw4ID.getID());
        fabric_sw2.setFabricID(fabric4ID);
        fabric_sw2.setSwitchID(sw4ID);
        fabric_sw2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_sw2);
        fabricIDV2.add(fabric4ID);
        for (int i3 = 0; i3 < 16; ++i3) {
            GraphFCPort fcport = (GraphFCPort)sw3FCPortV.elementAt(i3);
            GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
            sw4FCPortV.add(fcport);
            GraphSwitch2FCPort sw_fcport = new GraphSwitch2FCPort(sw4ID.getID() + "+" + fcportID.getID());
            sw_fcport.setSwitchID(sw4ID);
            sw_fcport.setFCPortID(fcportID);
            sw_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_fcport);
        }
        Vector<GraphFCPort> sw10FCPortV = new Vector<GraphFCPort>();
        int sw10FCPortCount = 0;
        String wwn6 = this.generateWWN();
        String swIDStr3 = "sw" + this.generateSwitchID();
        GraphSwitch sw10 = new GraphSwitch(swIDStr3);
        GraphSwitch.ID sw10ID = (GraphSwitch.ID)sw10.getEntityID();
        sw10.setDisplayName(wwn6);
        sw10.setWWN(wwn6);
        sw10.setVendor("Cisco");
        sw10.setModel("MDS 9206");
        sw10.setSerialNumber("999");
        sw10.setIPAddress("9.29.22.11");
        sw10.setVersion("3.2");
        sw10.setParentWWN(sw3.getDisplayName());
        sw10.setHealthStatus(GraphModelConstant.STATUS_MISSING);
        Vector<GraphFabric.ID> fabricIDV3 = new Vector<GraphFabric.ID>();
        this.put(sw10);
        GraphFabric2Switch fabric_sw3 = new GraphFabric2Switch(fabric4ID.getID() + "+" + sw10ID.getID());
        fabric_sw3.setFabricID(fabric4ID);
        fabric_sw3.setSwitchID(sw10ID);
        fabric_sw3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_sw3);
        fabricIDV3.add(fabric4ID);
        for (int i4 = 96; i4 < 99; ++i4) {
            GraphFCPort fcport = (GraphFCPort)sw3FCPortV.elementAt(i4);
            GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
            fcport.setPortNumber(null);
            sw10FCPortV.add(fcport);
            GraphSwitch2FCPort sw_fcport = new GraphSwitch2FCPort(sw10ID.getID() + "+" + fcportID.getID());
            sw_fcport.setSwitchID(sw10ID);
            sw_fcport.setFCPortID(fcportID);
            sw_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_fcport);
        }
        GraphSwitch2Switch sw4_sw10 = new GraphSwitch2Switch(sw4ID.getID() + "+" + sw10ID.getID());
        sw4_sw10.setSwitch1ID(sw4ID);
        sw4_sw10.setSwitch2ID(sw10ID);
        sw4_sw10.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(sw4_sw10);
        GraphFCPort.ID sw4PortID = (GraphFCPort.ID)((GraphFCPort)sw4FCPortV.get(sw4FCPortCount)).getEntityID();
        ++sw4FCPortCount;
        GraphFCPort.ID sw10PortID = (GraphFCPort.ID)((GraphFCPort)sw10FCPortV.get(sw10FCPortCount)).getEntityID();
        ++sw10FCPortCount;
        GraphFCPort2FCPort fcport_fcport = new GraphFCPort2FCPort(sw4PortID.getID() + "+" + sw10PortID.getID());
        fcport_fcport.setFCPort1ID(sw4PortID);
        fcport_fcport.setFCPort2ID(sw10PortID);
        fcport_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fcport_fcport);
        Vector<GraphFCPort> sw5FCPortV = new Vector<GraphFCPort>();
        int sw5FCPortCount = 0;
        String wwn7 = this.generateWWN();
        String swIDStr4 = "sw" + this.generateSwitchID();
        GraphSwitch sw5 = new GraphSwitch(swIDStr4);
        GraphSwitch.ID sw5ID = (GraphSwitch.ID)sw5.getEntityID();
        sw5.setDisplayName("Randy Johnson");
        sw5.setWWN(wwn7);
        sw5.setVendor("Cisco");
        sw5.setModel("MDS 9206");
        sw5.setSerialNumber("999");
        sw5.setIPAddress("9.29.22.20");
        sw5.setVersion("3.2");
        sw5.setParentWWN(sw3.getDisplayName());
        sw5.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
        sw5.setOperationalStatus(new Integer(4));
        Vector<GraphFabric.ID> fabricIDV4 = new Vector<GraphFabric.ID>();
        this.put(sw5);
        GraphFabric2Switch fabric_sw4 = new GraphFabric2Switch(fabric5ID.getID() + "+" + sw5ID.getID());
        fabric_sw4.setFabricID(fabric5ID);
        fabric_sw4.setSwitchID(sw5ID);
        fabric_sw4.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_sw4);
        fabricIDV4.add(fabric5ID);
        for (int i5 = 16; i5 < 32; ++i5) {
            GraphFCPort fcport = (GraphFCPort)sw3FCPortV.elementAt(i5);
            GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
            sw5FCPortV.add(fcport);
            GraphSwitch2FCPort sw_fcport = new GraphSwitch2FCPort(sw5ID.getID() + "+" + fcportID.getID());
            sw_fcport.setSwitchID(sw5ID);
            sw_fcport.setFCPortID(fcportID);
            sw_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_fcport);
        }
        Vector<GraphFCPort> sw6FCPortV = new Vector<GraphFCPort>();
        int sw6FCPortCount = 0;
        String wwn8 = this.generateWWN();
        String swIDStr5 = "sw" + this.generateSwitchID();
        GraphSwitch sw6 = new GraphSwitch(swIDStr5);
        GraphSwitch.ID sw6ID = (GraphSwitch.ID)sw6.getEntityID();
        sw6.setDisplayName("Mike Mussina");
        sw6.setWWN(wwn8);
        sw6.setVendor("Cisco");
        sw6.setModel("MDS 9206");
        sw6.setSerialNumber("999");
        sw6.setIPAddress("9.29.22.20");
        sw6.setVersion("3.2");
        sw6.setParentWWN(sw3.getDisplayName());
        sw6.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
        Vector<GraphFabric.ID> fabricIDV5 = new Vector<GraphFabric.ID>();
        sw6.setOperationalStatus(new Integer(32));
        this.put(sw6);
        GraphFabric2Switch fabric_sw5 = new GraphFabric2Switch(fabric5ID.getID() + "+" + sw6ID.getID());
        fabric_sw5.setFabricID(fabric5ID);
        fabric_sw5.setSwitchID(sw6ID);
        fabric_sw5.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_sw5);
        fabricIDV5.add(fabric5ID);
        for (int i6 = 32; i6 < 48; ++i6) {
            GraphFCPort fcport = (GraphFCPort)sw3FCPortV.elementAt(i6);
            GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
            sw6FCPortV.add(fcport);
            GraphSwitch2FCPort sw_fcport = new GraphSwitch2FCPort(sw6ID.getID() + "+" + fcportID.getID());
            sw_fcport.setSwitchID(sw6ID);
            sw_fcport.setFCPortID(fcportID);
            sw_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_fcport);
        }
        GraphSwitch2Switch sw5_sw6 = new GraphSwitch2Switch(sw5ID.getID() + "+" + sw6ID.getID());
        sw5_sw6.setSwitch1ID(sw5ID);
        sw5_sw6.setSwitch2ID(sw6ID);
        sw5_sw6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(sw5_sw6);
        GraphFCPort.ID sw5PortID = (GraphFCPort.ID)((GraphFCPort)sw5FCPortV.get(sw5FCPortCount)).getEntityID();
        ++sw5FCPortCount;
        GraphFCPort.ID sw6PortID = (GraphFCPort.ID)((GraphFCPort)sw6FCPortV.get(sw6FCPortCount)).getEntityID();
        ++sw6FCPortCount;
        GraphFCPort2FCPort fcport_fcport2 = new GraphFCPort2FCPort(sw5PortID.getID() + "+" + sw6PortID.getID());
        fcport_fcport2.setFCPort1ID(sw5PortID);
        fcport_fcport2.setFCPort2ID(sw6PortID);
        fcport_fcport2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fcport_fcport2);
        Vector<GraphFCPort> sw7FCPortV = new Vector<GraphFCPort>();
        int sw7FCPortCount = 0;
        String wwn9 = this.generateWWN();
        String swIDStr6 = "sw" + this.generateSwitchID();
        GraphSwitch sw7 = new GraphSwitch(swIDStr6);
        GraphSwitch.ID sw7ID = (GraphSwitch.ID)sw7.getEntityID();
        sw7.setDisplayName("Chien-Ming Wang");
        sw7.setWWN(wwn9);
        sw7.setVendor("Cisco");
        sw7.setModel("MDS 9206");
        sw7.setSerialNumber("999");
        sw7.setIPAddress("9.29.22.20");
        sw7.setVersion("3.2");
        sw7.setParentWWN(sw3.getDisplayName());
        sw7.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
        Vector<GraphFabric.ID> fabricIDV6 = new Vector<GraphFabric.ID>();
        sw7.setOperationalStatus(new Integer(16));
        this.put(sw7);
        GraphFabric2Switch fabric_sw6 = new GraphFabric2Switch(fabric5ID.getID() + "+" + sw7ID.getID());
        fabric_sw6.setFabricID(fabric5ID);
        fabric_sw6.setSwitchID(sw7ID);
        fabric_sw6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_sw6);
        fabricIDV6.add(fabric5ID);
        for (int i7 = 48; i7 < 64; ++i7) {
            GraphFCPort fcport = (GraphFCPort)sw3FCPortV.elementAt(i7);
            GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
            sw7FCPortV.add(fcport);
            GraphSwitch2FCPort sw_fcport = new GraphSwitch2FCPort(sw7ID.getID() + "+" + fcportID.getID());
            sw_fcport.setSwitchID(sw7ID);
            sw_fcport.setFCPortID(fcportID);
            sw_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_fcport);
        }
        GraphSwitch2Switch sw5_sw7 = new GraphSwitch2Switch(sw5ID.getID() + "+" + sw7ID.getID());
        sw5_sw7.setSwitch1ID(sw5ID);
        sw5_sw7.setSwitch2ID(sw7ID);
        sw5_sw7.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(sw5_sw7);
        GraphFCPort.ID sw5PortID2 = (GraphFCPort.ID)((GraphFCPort)sw5FCPortV.get(sw5FCPortCount)).getEntityID();
        ++sw5FCPortCount;
        GraphFCPort.ID sw7PortID = (GraphFCPort.ID)((GraphFCPort)sw7FCPortV.get(sw7FCPortCount)).getEntityID();
        ++sw7FCPortCount;
        GraphFCPort2FCPort fcport_fcport3 = new GraphFCPort2FCPort(sw5PortID2.getID() + "+" + sw7PortID.getID());
        fcport_fcport3.setFCPort1ID(sw5PortID2);
        fcport_fcport3.setFCPort2ID(sw7PortID);
        fcport_fcport3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fcport_fcport3);
        for (int i8 = 0; i8 < 2; ++i8) {
            GraphSwitch2Switch sw7_sw6 = new GraphSwitch2Switch(sw7ID.getID() + "+" + sw6ID.getID() + "+" + i8);
            sw7_sw6.setSwitch1ID(sw7ID);
            sw7_sw6.setSwitch2ID(sw6ID);
            sw7_sw6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw7_sw6);
            sw7PortID = (GraphFCPort.ID)((GraphFCPort)sw7FCPortV.get(sw7FCPortCount)).getEntityID();
            ++sw7FCPortCount;
            GraphFCPort.ID sw6PortID2 = (GraphFCPort.ID)((GraphFCPort)sw6FCPortV.get(sw6FCPortCount)).getEntityID();
            ++sw6FCPortCount;
            GraphFCPort2FCPort fcport_fcport4 = new GraphFCPort2FCPort(sw7PortID.getID() + "+" + sw6PortID2.getID());
            fcport_fcport4.setFCPort1ID(sw7PortID);
            fcport_fcport4.setFCPort2ID(sw6PortID2);
            fcport_fcport4.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_fcport4);
        }
        Vector<GraphFCPort> sw8FCPortV = new Vector<GraphFCPort>();
        int sw8FCPortCount = 0;
        String wwn10 = this.generateWWN();
        String swIDStr7 = "sw" + this.generateSwitchID();
        GraphSwitch sw8 = new GraphSwitch(swIDStr7);
        GraphSwitch.ID sw8ID = (GraphSwitch.ID)sw8.getEntityID();
        sw8.setDisplayName("Shawn Chacon");
        sw8.setWWN(wwn10);
        sw8.setVendor("Cisco");
        sw8.setModel("MDS 9206");
        sw8.setSerialNumber("999");
        sw8.setIPAddress("9.29.22.20");
        sw8.setVersion("3.2");
        sw8.setParentWWN(sw3.getDisplayName());
        sw8.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
        Vector<GraphFabric.ID> fabricIDV7 = new Vector<GraphFabric.ID>();
        this.put(sw8);
        GraphFabric2Switch fabric_sw7 = new GraphFabric2Switch(fabric5ID.getID() + "+" + sw8ID.getID());
        fabric_sw7.setFabricID(fabric5ID);
        fabric_sw7.setSwitchID(sw8ID);
        fabric_sw7.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_sw7);
        fabricIDV7.add(fabric5ID);
        for (i = 64; i < 96; ++i) {
            GraphFCPort fcport = (GraphFCPort)sw3FCPortV.elementAt(i);
            GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
            sw8FCPortV.add(fcport);
            GraphSwitch2FCPort sw_fcport = new GraphSwitch2FCPort(sw8ID.getID() + "+" + fcportID.getID());
            sw_fcport.setSwitchID(sw8ID);
            sw_fcport.setFCPortID(fcportID);
            sw_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_fcport);
        }
        for (i = 0; i < 4; ++i) {
            GraphSwitch2Switch sw5_sw8 = new GraphSwitch2Switch(sw5ID.getID() + "+" + sw8ID.getID() + "+" + i);
            sw5_sw8.setSwitch1ID(sw5ID);
            sw5_sw8.setSwitch2ID(sw8ID);
            sw5_sw8.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw5_sw8);
            GraphFCPort.ID sw5PortID3 = (GraphFCPort.ID)((GraphFCPort)sw5FCPortV.get(sw5FCPortCount)).getEntityID();
            ++sw5FCPortCount;
            GraphFCPort.ID sw8PortID = (GraphFCPort.ID)((GraphFCPort)sw8FCPortV.get(sw8FCPortCount)).getEntityID();
            ++sw8FCPortCount;
            GraphFCPort2FCPort fcport_fcport5 = new GraphFCPort2FCPort(sw5PortID3.getID() + "+" + sw8PortID.getID());
            fcport_fcport5.setFCPort1ID(sw5PortID3);
            fcport_fcport5.setFCPort2ID(sw8PortID);
            fcport_fcport5.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_fcport5);
        }
        GraphSwitch2Switch sw8_sw6 = new GraphSwitch2Switch(sw8ID.getID() + "+" + sw6ID.getID());
        sw8_sw6.setSwitch1ID(sw8ID);
        sw8_sw6.setSwitch2ID(sw6ID);
        sw8_sw6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(sw8_sw6);
        GraphFCPort.ID sw8PortID = (GraphFCPort.ID)((GraphFCPort)sw8FCPortV.get(sw8FCPortCount)).getEntityID();
        ++sw8FCPortCount;
        GraphFCPort.ID sw6PortID3 = (GraphFCPort.ID)((GraphFCPort)sw6FCPortV.get(sw6FCPortCount)).getEntityID();
        ++sw6FCPortCount;
        GraphFCPort2FCPort fcport_fcport6 = new GraphFCPort2FCPort(sw8PortID.getID() + "+" + sw6PortID3.getID());
        fcport_fcport6.setFCPort1ID(sw8PortID);
        fcport_fcport6.setFCPort2ID(sw6PortID3);
        fcport_fcport6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fcport_fcport6);
        GraphSwitch2Switch sw7_sw8 = new GraphSwitch2Switch(sw7ID.getID() + "+" + sw8ID.getID());
        sw7_sw8.setSwitch1ID(sw7ID);
        sw7_sw8.setSwitch2ID(sw8ID);
        sw7_sw8.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(sw7_sw8);
        GraphFCPort.ID sw7PortID2 = (GraphFCPort.ID)((GraphFCPort)sw7FCPortV.get(sw7FCPortCount)).getEntityID();
        ++sw7FCPortCount;
        GraphFCPort.ID sw8PortID2 = (GraphFCPort.ID)((GraphFCPort)sw8FCPortV.get(sw8FCPortCount)).getEntityID();
        ++sw8FCPortCount;
        fcport_fcport6 = new GraphFCPort2FCPort(sw7PortID2.getID() + "+" + sw8PortID2.getID());
        fcport_fcport6.setFCPort1ID(sw7PortID2);
        fcport_fcport6.setFCPort2ID(sw8PortID2);
        fcport_fcport6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fcport_fcport6);
    }

    /*
     * Opcode count of 14619 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void data1() throws Exception {
        GraphZone2ZoneMember zone2zmem;
        GraphZoneMember.ID zmemID;
        GraphFabric.ID xxID;
        Enumeration enu4;
        GraphSwitch.ID swID;
        Enumeration enu3;
        GraphFCPort.ID fcp2ID;
        Enumeration enu2;
        GraphFCPort.ID fcpID;
        GraphFCPort fcp;
        Enumeration enu22;
        GraphFCPort fcp2;
        GraphFabric2TapeLibrary fabric1_tapeLibrary;
        int i;
        Vector<GraphFabric.ID> fabricIDV;
        GraphComputer.ID computerID;
        GraphComputer computer;
        String computerIDStr;
        int i2;
        GraphFilesystem.ID filesystemID;
        GraphFilesystem filesystem;
        GraphFCPort2FCPort fcport_fcport;
        GraphFCPort.ID swPortID;
        GraphFCPort.ID fcportID;
        GraphFCPort fcport;
        String wwn;
        GraphComputer2HBA computer_hba;
        GraphHBA.ID hbaID;
        GraphComputer2Volume computer2volume;
        GraphComputer2Lun computer2lun;
        GraphVolume2Lun volume2lun;
        GraphLun.ID lunID;
        GraphLun lun;
        GraphSwitch2Computer sw_computer;
        GraphFabric2Computer fabric_computer;
        Vector<GraphFabric.ID> fabricIDV2;
        GraphComputer.ID computerID2;
        GraphComputer computer2;
        String computerIDStr2;
        int i3;
        int i4;
        int i5;
        int i6;
        int i7;
        GraphSubsystem2Volume subsystem0_volume;
        GraphPool2Volume pool_volume;
        GraphVolume2VolumePerf volume_perf;
        GraphVolumePerf.ID perfID;
        GraphVolumePerf perf;
        GraphVolume.ID volumeID;
        GraphVolume volume;
        String volumeIDStr;
        GraphSubsystem2Disk subsystem0_disk;
        GraphPool2Disk pool_disk;
        GraphDisk.ID diskID;
        GraphDisk disk;
        String diskIDStr;
        int i8;
        GraphEntity perf2;
        GraphSwitch2Subsystem sw_subsystem0;
        int i9;
        GraphEntity.ID perfID2;
        GraphEntity.ID perfID3;
        String wwn2 = this.generateWWN();
        String fabricIDStr = "fabric" + this.generateFabricID();
        GraphFabric fabric0 = new GraphFabric(fabricIDStr);
        GraphFabric.ID fabric0ID = (GraphFabric.ID)fabric0.getEntityID();
        fabric0.setDisplayName(wwn2);
        fabric0.setWWN(wwn2);
        fabric0.setActive(Boolean.TRUE);
        fabric0.setIsPhysical(Boolean.TRUE);
        fabric0.setUDP1("B3-251");
        fabric0.setUDP2("Prasenjit");
        fabric0.setHealthStatus(GraphModelConstant.STATUS_WARNING);
        fabric0.setOperationalStatus(new Integer(4));
        this.put(fabric0);
        String wwn3 = this.generateWWN();
        String fabricIDStr2 = "fabric" + this.generateFabricID();
        GraphFabric fabric1 = new GraphFabric(fabricIDStr2);
        GraphFabric.ID fabric1ID = (GraphFabric.ID)fabric1.getEntityID();
        fabric1.setDisplayName("Hello everyone, I have a long name");
        fabric1.setWWN(wwn3);
        fabric1.setActive(Boolean.TRUE);
        fabric1.setIsPhysical(Boolean.TRUE);
        fabric1.setUDP1("B3-251");
        fabric1.setUDP2("Kaladhar");
        fabric1.setHealthStatus(GraphModelConstant.STATUS_WARNING);
        this.put(fabric1);
        Vector<GraphFCPort> sw0FCPortV = new Vector<GraphFCPort>();
        int sw0FCPortCount = 0;
        String wwn4 = this.generateWWN();
        String swIDStr = "sw" + this.generateSwitchID();
        GraphSwitch sw0 = new GraphSwitch(swIDStr);
        GraphSwitch.ID sw0ID = (GraphSwitch.ID)sw0.getEntityID();
        sw0.setDisplayName("ibm-sw0");
        sw0.setWWN(wwn4);
        sw0.setVendor("Brocade");
        sw0.setModel("2106");
        sw0.setSerialNumber("56345");
        sw0.setIPAddress("9.4.3.22");
        sw0.setVersion("1.2");
        sw0.setElementManager("http://9.4.3.22");
        sw0.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        sw0.setUDP1("B3-251");
        sw0.setUDP2("Prasenjit");
        Vector<GraphFabric.ID> fabricIDV3 = new Vector<GraphFabric.ID>();
        this.put(sw0);
        GraphFabric2Switch fabric_sw = new GraphFabric2Switch(fabric0ID.getID() + "+" + sw0ID.getID());
        fabric_sw.setFabricID(fabric0ID);
        fabric_sw.setSwitchID(sw0ID);
        fabric_sw.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_sw);
        fabricIDV3.add(fabric0ID);
        for (int i10 = 0; i10 < 32; ++i10) {
            wwn4 = this.generateWWN();
            GraphFCPort fcport2 = new GraphFCPort(wwn4);
            GraphFCPort.ID fcportID2 = (GraphFCPort.ID)fcport2.getEntityID();
            fcport2.setDisplayName(wwn4);
            fcport2.setName(wwn4);
            fcport2.setPortNumber(String.valueOf(i10));
            if (i10 == 20) {
                fcport2.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else if (i10 == 7) {
                fcport2.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else {
                fcport2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fcport2);
            sw0FCPortV.add(fcport2);
            GraphSwitch2FCPort sw_fcport = new GraphSwitch2FCPort(sw0ID.getID() + "+" + fcportID2.getID());
            sw_fcport.setSwitchID(sw0ID);
            sw_fcport.setFCPortID(fcportID2);
            sw_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_fcport);
            GraphSwitchFCPortPerf perf3 = new GraphSwitchFCPortPerf(wwn4);
            perfID3 = (GraphSwitchFCPortPerf.ID)perf3.getEntityID();
            if (i10 == 20) {
                perf3.setPacketRateRx(new Double(0.0));
                perf3.setPacketRateTx(new Double(0.0));
                perf3.setDataRateRx(new Double(0.0));
                perf3.setDataRateTx(new Double(0.0));
                perf3.setErrorFrameRate(new Double(0.0));
                perf3.setLinkFailureRate(new Double(0.0));
                perf3.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else if (i10 == 7) {
                perf3.setPacketRateRx(new Double(50.0));
                perf3.setPacketRateTx(new Double(30.0));
                perf3.setDataRateRx(new Double(2.0));
                perf3.setDataRateTx(new Double(1.0));
                perf3.setErrorFrameRate(new Double(0.01));
                perf3.setLinkFailureRate(new Double(0.02));
                perf3.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else {
                perf3.setPacketRateRx(new Double(800.0));
                perf3.setPacketRateTx(new Double(80.0));
                perf3.setDataRateRx(new Double(40.0));
                perf3.setDataRateTx(new Double(10.0));
                perf3.setErrorFrameRate(new Double(0.01));
                perf3.setLinkFailureRate(new Double(0.02));
                perf3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(perf3);
            GraphFCPort2SwitchFCPortPerf fcport_perf = new GraphFCPort2SwitchFCPortPerf(fcportID2.getID() + "+" + perfID3.getID());
            fcport_perf.setFCPortID(fcportID2);
            fcport_perf.setSwitchFCPortPerfID((GraphSwitchFCPortPerf.ID)perfID3);
            fcport_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_perf);
        }
        GraphSwitchPerf perf4 = new GraphSwitchPerf(sw0.getWWN());
        GraphSwitchPerf.ID perfID4 = (GraphSwitchPerf.ID)perf4.getEntityID();
        perf4.setHealthStatus(GraphModelConstant.STATUS_WARNING);
        this.put(perf4);
        GraphSwitch2SwitchPerf sw_perf = new GraphSwitch2SwitchPerf(sw0ID.getID() + "+" + perfID4.getID());
        sw_perf.setSwitchID(sw0ID);
        sw_perf.setSwitchPerfID(perfID4);
        sw_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(sw_perf);
        Vector<GraphFCPort> sw1FCPortV = new Vector<GraphFCPort>();
        int sw1FCPortCount = 0;
        String wwn5 = this.generateWWN();
        String swIDStr2 = "sw" + this.generateSwitchID();
        GraphSwitch sw1 = new GraphSwitch(swIDStr2);
        GraphSwitch.ID sw1ID = (GraphSwitch.ID)sw1.getEntityID();
        sw1.setDisplayName(wwn5);
        sw1.setWWN(wwn5);
        sw1.setVendor("Brocade");
        sw1.setModel("2106");
        sw1.setSerialNumber("56666");
        sw1.setIPAddress("9.4.3.25");
        sw1.setVersion("1.2");
        sw1.setElementManager("http://9.4.3.25");
        sw1.setHealthStatus(GraphModelConstant.STATUS_WARNING);
        sw1.setUDP1("B3-251");
        sw1.setUDP2("Prasenjit");
        Vector<GraphFabric.ID> fabricIDV4 = new Vector<GraphFabric.ID>();
        this.put(sw1);
        GraphFabric2Switch fabric_sw2 = new GraphFabric2Switch(fabric0.getEntityID().getID() + "+" + sw1ID.getID());
        fabric_sw2.setFabricID(fabric0ID);
        fabric_sw2.setSwitchID(sw1ID);
        fabric_sw2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_sw2);
        fabricIDV4.add(fabric0ID);
        for (int i11 = 0; i11 < 64; ++i11) {
            wwn5 = this.generateWWN();
            GraphFCPort fcport3 = new GraphFCPort(wwn5);
            GraphFCPort.ID fcportID3 = (GraphFCPort.ID)fcport3.getEntityID();
            fcport3.setDisplayName(wwn5);
            fcport3.setName(wwn5);
            fcport3.setPortNumber(String.valueOf(i11));
            if (i11 == 1) {
                fcport3.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else if (i11 == 13 || i11 == 11) {
                fcport3.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else {
                fcport3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fcport3);
            sw1FCPortV.add(fcport3);
            GraphSwitch2FCPort sw_fcport = new GraphSwitch2FCPort(sw1ID.getID() + "+" + fcportID3.getID());
            sw_fcport.setSwitchID(sw1ID);
            sw_fcport.setFCPortID(fcportID3);
            sw_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_fcport);
            GraphSwitchFCPortPerf perf5 = new GraphSwitchFCPortPerf(wwn5);
            perfID2 = (GraphSwitchFCPortPerf.ID)perf5.getEntityID();
            if (i11 == 1) {
                perf5.setPacketRateRx(new Double(0.0));
                perf5.setPacketRateTx(new Double(0.0));
                perf5.setDataRateRx(new Double(0.0));
                perf5.setDataRateTx(new Double(0.0));
                perf5.setErrorFrameRate(new Double(0.0));
                perf5.setLinkFailureRate(new Double(0.0));
                perf5.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else if (i11 == 13 || i11 == 11) {
                perf5.setPacketRateRx(new Double(400.0));
                perf5.setPacketRateTx(new Double(60.0));
                perf5.setDataRateRx(new Double(20.0));
                perf5.setDataRateTx(new Double(2.0));
                perf5.setErrorFrameRate(new Double(0.0));
                perf5.setLinkFailureRate(new Double(0.0));
                perf5.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else {
                perf5.setPacketRateRx(new Double(800.0));
                perf5.setPacketRateTx(new Double(80.0));
                perf5.setDataRateRx(new Double(40.0));
                perf5.setDataRateTx(new Double(10.0));
                perf5.setErrorFrameRate(new Double(0.0));
                perf5.setLinkFailureRate(new Double(0.0));
                perf5.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(perf5);
            GraphFCPort2SwitchFCPortPerf fcport_perf = new GraphFCPort2SwitchFCPortPerf(fcportID3.getID() + "+" + perfID2.getID());
            fcport_perf.setFCPortID(fcportID3);
            fcport_perf.setSwitchFCPortPerfID((GraphSwitchFCPortPerf.ID)perfID2);
            fcport_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_perf);
        }
        GraphSwitchPerf perf6 = new GraphSwitchPerf(sw1.getWWN());
        perfID3 = (GraphSwitchPerf.ID)perf6.getEntityID();
        perf6.setHealthStatus(GraphModelConstant.STATUS_WARNING);
        this.put(perf6);
        GraphSwitch2SwitchPerf sw_perf2 = new GraphSwitch2SwitchPerf(sw1ID.getID() + "+" + perfID3.getID());
        sw_perf2.setSwitchID(sw1ID);
        sw_perf2.setSwitchPerfID((GraphSwitchPerf.ID)perfID3);
        sw_perf2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(sw_perf2);
        GraphSwitch2Switch sw0_sw1 = new GraphSwitch2Switch(sw0ID.getID() + "+" + sw1ID.getID());
        sw0_sw1.setSwitch1ID(sw0ID);
        sw0_sw1.setSwitch2ID(sw1ID);
        sw0_sw1.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(sw0_sw1);
        GraphFCPort.ID sw0PortID = (GraphFCPort.ID)((GraphFCPort)sw0FCPortV.get(sw0FCPortCount)).getEntityID();
        ++sw0FCPortCount;
        GraphFCPort.ID sw1PortID = (GraphFCPort.ID)((GraphFCPort)sw1FCPortV.get(sw1FCPortCount)).getEntityID();
        ++sw1FCPortCount;
        GraphFCPort2FCPort fcport_fcport2 = new GraphFCPort2FCPort(sw0PortID.getID() + "+" + sw1PortID.getID());
        fcport_fcport2.setFCPort1ID(sw0PortID);
        fcport_fcport2.setFCPort2ID(sw1PortID);
        fcport_fcport2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fcport_fcport2);
        Vector<GraphFCPort> sw2FCPortV = new Vector<GraphFCPort>();
        int sw2FCPortCount = 0;
        String wwn6 = this.generateWWN();
        String swIDStr3 = "sw" + this.generateSwitchID();
        GraphSwitch sw2 = new GraphSwitch(swIDStr3);
        GraphSwitch.ID sw2ID = (GraphSwitch.ID)sw2.getEntityID();
        sw2.setDisplayName("I have a very long long long long long long long name");
        sw2.setWWN(wwn6);
        sw2.setVendor("Cisco");
        sw2.setModel("3532");
        sw2.setSerialNumber("56666");
        sw2.setIPAddress("9.4.9.1");
        sw2.setVersion("5.3.3");
        sw2.setElementManager("http://9.4.9.1");
        sw2.setHealthStatus(GraphModelConstant.STATUS_WARNING);
        sw2.setUDP1("G1-200");
        sw2.setUDP2("Kaladhar");
        Vector<GraphFabric.ID> fabricIDV5 = new Vector<GraphFabric.ID>();
        this.put(sw2);
        GraphFabric2Switch fabric_sw3 = new GraphFabric2Switch(fabric1.getEntityID().getID() + "+" + sw2ID.getID());
        fabric_sw3.setFabricID(fabric1ID);
        fabric_sw3.setSwitchID(sw2ID);
        fabric_sw3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_sw3);
        fabricIDV5.add(fabric1ID);
        for (int i12 = 0; i12 < 288; ++i12) {
            wwn6 = this.generateWWN();
            GraphFCPort fcport4 = new GraphFCPort(wwn6);
            GraphFCPort.ID fcportID4 = (GraphFCPort.ID)fcport4.getEntityID();
            fcport4.setDisplayName(wwn6);
            fcport4.setName(wwn6);
            fcport4.setPortNumber(String.valueOf(i12));
            if (i12 == 47) {
                fcport4.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else if (i12 == 43 || i12 == 16) {
                fcport4.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else {
                fcport4.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fcport4);
            sw2FCPortV.add(fcport4);
            GraphSwitch2FCPort sw_fcport = new GraphSwitch2FCPort(sw2ID.getID() + "+" + fcportID4.getID());
            sw_fcport.setSwitchID(sw2ID);
            sw_fcport.setFCPortID(fcportID4);
            sw_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_fcport);
            GraphSwitchFCPortPerf perf7 = new GraphSwitchFCPortPerf(wwn6);
            GraphSwitchFCPortPerf.ID perfID5 = (GraphSwitchFCPortPerf.ID)perf7.getEntityID();
            if (i12 == 46) {
                perf7.setPacketRateRx(new Double(0.0));
                perf7.setPacketRateTx(new Double(0.0));
                perf7.setDataRateRx(new Double(0.0));
                perf7.setDataRateTx(new Double(0.0));
                perf7.setErrorFrameRate(new Double(0.0));
                perf7.setLinkFailureRate(new Double(0.0));
                perf7.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else if (i12 == 43 || i12 == 16) {
                perf7.setPacketRateRx(new Double(5.0));
                perf7.setPacketRateTx(new Double(3.0));
                perf7.setDataRateRx(new Double(20.0));
                perf7.setDataRateTx(new Double(10.0));
                perf7.setErrorFrameRate(new Double(0.0));
                perf7.setLinkFailureRate(new Double(0.0));
                perf7.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else {
                perf7.setPacketRateRx(new Double(800.0));
                perf7.setPacketRateTx(new Double(80.0));
                perf7.setDataRateRx(new Double(40.0));
                perf7.setDataRateTx(new Double(10.0));
                perf7.setErrorFrameRate(new Double(0.0));
                perf7.setLinkFailureRate(new Double(0.0));
                perf7.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(perf7);
            GraphFCPort2SwitchFCPortPerf fcport_perf = new GraphFCPort2SwitchFCPortPerf(fcportID4.getID() + "+" + perfID5.getID());
            fcport_perf.setFCPortID(fcportID4);
            fcport_perf.setSwitchFCPortPerfID(perfID5);
            fcport_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_perf);
        }
        GraphSwitchPerf perf8 = new GraphSwitchPerf(sw2.getWWN());
        perfID2 = (GraphSwitchPerf.ID)perf8.getEntityID();
        perf8.setHealthStatus(GraphModelConstant.STATUS_WARNING);
        this.put(perf8);
        GraphSwitch2SwitchPerf sw_perf3 = new GraphSwitch2SwitchPerf(sw2ID.getID() + "+" + perfID2.getID());
        sw_perf3.setSwitchID(sw2ID);
        sw_perf3.setSwitchPerfID((GraphSwitchPerf.ID)perfID2);
        sw_perf3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(sw_perf3);
        Vector<GraphVolume> subsystem0Volume0V = new Vector<GraphVolume>();
        int subsystem0Volume0Count = 0;
        Vector<GraphVolume> subsystem0Volume1V = new Vector<GraphVolume>();
        int subsystem0Volume1Count = 0;
        Vector<GraphFCPort> subsystem0FCPortV = new Vector<GraphFCPort>();
        int subsystem0FCPortCount = 0;
        String subsystemIDStr = "subsystem" + this.generateSubsystemID();
        GraphSubsystem subsystem0 = new GraphSubsystem(subsystemIDStr);
        GraphSubsystem.ID subsystem0ID = (GraphSubsystem.ID)subsystem0.getEntityID();
        subsystem0.setDisplayName("lakers.almaden.ibm.com");
        subsystem0.setAllocatedCapacity(new Long(0x3200000000L));
        subsystem0.setAvailableCapacity(new Long(0x7D00000000L));
        subsystem0.setBackendStorageCapacity(new Long(0L));
        subsystem0.setVendor("IBM");
        subsystem0.setModel("DS8000");
        subsystem0.setCache(new Long(0x800000L));
        subsystem0.setType("Step 1");
        subsystem0.setSerialNumber("12345");
        subsystem0.setIPAddress("9.1.9.24");
        subsystem0.setCodeLevel("5.1.0.2");
        subsystem0.setElementManager("http://9.1.9.24");
        subsystem0.setIsSVC(Boolean.FALSE);
        subsystem0.setHealthStatus(GraphModelConstant.STATUS_WARNING);
        subsystem0.setUDP1("B3-251");
        subsystem0.setUDP2("Cheryl");
        subsystem0.setUDP3("one Faulty port");
        this.put(subsystem0);
        Vector<GraphFabric.ID> fabricIDV6 = new Vector<GraphFabric.ID>();
        GraphSubsystemPerf perf9 = new GraphSubsystemPerf((String)subsystem0ID.getID());
        GraphSubsystemPerf.ID perfID6 = (GraphSubsystemPerf.ID)perf9.getEntityID();
        perf9.setIORateRx(new Double(20.0));
        perf9.setIORateTx(new Double(20.0));
        perf9.setDataRateRx(new Double(200.0));
        perf9.setDataRateTx(new Double(300.0));
        perf9.setResponseTimeRx(new Double(22.0));
        perf9.setResponseTimeTx(new Double(32.0));
        perf9.setCacheHitRx(new Double(80.0));
        perf9.setCacheHitTx(new Double(70.0));
        perf9.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(perf9);
        GraphSubsystem2SubsystemPerf subsystem_perf = new GraphSubsystem2SubsystemPerf(subsystem0ID.getID() + "+" + perfID6.getID());
        subsystem_perf.setSubsystemID(subsystem0ID);
        subsystem_perf.setSubsystemPerfID(perfID6);
        subsystem_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(subsystem_perf);
        GraphFabric2Subsystem fabric_subsystem0 = new GraphFabric2Subsystem(fabric0.getEntityID().getID() + "+" + subsystem0ID.getID());
        fabric_subsystem0.setFabricID(fabric0ID);
        fabric_subsystem0.setSubsystemID(subsystem0ID);
        fabric_subsystem0.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_subsystem0);
        fabricIDV6.add(fabric0ID);
        for (i9 = 0; i9 < 2; ++i9) {
            sw_subsystem0 = new GraphSwitch2Subsystem(sw0ID.getID() + "+" + subsystem0ID.getID() + "+" + i9);
            sw_subsystem0.setSwitchID(sw0ID);
            sw_subsystem0.setSubsystemID(subsystem0ID);
            sw_subsystem0.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_subsystem0);
        }
        for (i9 = 0; i9 < 2; ++i9) {
            sw_subsystem0 = new GraphSwitch2Subsystem(sw1ID.getID() + "+" + subsystem0ID.getID() + "+" + i9);
            sw_subsystem0.setSwitchID(sw1ID);
            sw_subsystem0.setSubsystemID(subsystem0ID);
            if (i9 == 0) {
                sw_subsystem0.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            } else {
                sw_subsystem0.setHealthStatus(GraphModelConstant.STATUS_MISSING);
            }
            this.put(sw_subsystem0);
        }
        for (i9 = 0; i9 < 16; ++i9) {
            GraphFCPort2FCPort fcport_fcport3;
            GraphFCPort.ID swPortID2;
            String wwn7 = this.generateWWN();
            GraphFCPort fcport5 = new GraphFCPort(wwn7);
            GraphFCPort.ID fcportID5 = (GraphFCPort.ID)fcport5.getEntityID();
            fcport5.setDisplayName(wwn7);
            fcport5.setName(wwn7);
            if (i9 == 2) {
                fcport5.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else {
                fcport5.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fcport5);
            subsystem0FCPortV.add(fcport5);
            GraphSubsystem2FCPort subsystem0_fcport = new GraphSubsystem2FCPort(subsystem0ID.getID() + "+" + fcportID5.getID());
            subsystem0_fcport.setSubsystemID(subsystem0ID);
            subsystem0_fcport.setFCPortID(fcportID5);
            subsystem0_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem0_fcport);
            if (i9 == 0 || i9 == 1) {
                swPortID2 = (GraphFCPort.ID)((GraphFCPort)sw0FCPortV.get(sw0FCPortCount)).getEntityID();
                ++sw0FCPortCount;
                fcportID5 = (GraphFCPort.ID)((GraphFCPort)subsystem0FCPortV.get(subsystem0FCPortCount)).getEntityID();
                ++subsystem0FCPortCount;
                fcport_fcport3 = new GraphFCPort2FCPort(swPortID2.getID() + "+" + fcportID5.getID());
                fcport_fcport3.setFCPort1ID(swPortID2);
                fcport_fcport3.setFCPort2ID(fcportID5);
                fcport_fcport3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(fcport_fcport3);
            } else if (i9 == 2 || i9 == 3 || i9 == 4) {
                swPortID2 = (GraphFCPort.ID)((GraphFCPort)sw1FCPortV.get(sw1FCPortCount)).getEntityID();
                ++sw1FCPortCount;
                fcportID5 = (GraphFCPort.ID)((GraphFCPort)subsystem0FCPortV.get(subsystem0FCPortCount)).getEntityID();
                ++subsystem0FCPortCount;
                fcport_fcport3 = new GraphFCPort2FCPort(swPortID2.getID() + "+" + fcportID5.getID());
                fcport_fcport3.setFCPort1ID(swPortID2);
                fcport_fcport3.setFCPort2ID(fcportID5);
                if (i9 == 2) {
                    fcport_fcport3.setHealthStatus(GraphModelConstant.STATUS_MISSING);
                } else {
                    fcport_fcport3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(fcport_fcport3);
            }
            perf2 = new GraphSubsystemFCPortPerf(wwn7);
            GraphSubsystemFCPortPerf.ID perfID7 = (GraphSubsystemFCPortPerf.ID)perf2.getEntityID();
            if (i9 == 2) {
                ((GraphSubsystemFCPortPerf)perf2).setIORateRx(new Double(0.0));
                ((GraphSubsystemFCPortPerf)perf2).setIORateTx(new Double(0.0));
                ((GraphSubsystemFCPortPerf)perf2).setDataRateRx(new Double(0.0));
                ((GraphSubsystemFCPortPerf)perf2).setDataRateTx(new Double(0.0));
                ((GraphSubsystemFCPortPerf)perf2).setResponseTimeRx(new Double(0.0));
                ((GraphSubsystemFCPortPerf)perf2).setResponseTimeTx(new Double(0.0));
                perf2.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else if (i9 == 3) {
                ((GraphSubsystemFCPortPerf)perf2).setIORateRx(new Double(50.0));
                ((GraphSubsystemFCPortPerf)perf2).setIORateTx(new Double(30.0));
                ((GraphSubsystemFCPortPerf)perf2).setDataRateRx(new Double(2.0));
                ((GraphSubsystemFCPortPerf)perf2).setDataRateTx(new Double(1.0));
                ((GraphSubsystemFCPortPerf)perf2).setResponseTimeRx(new Double(20.0));
                ((GraphSubsystemFCPortPerf)perf2).setResponseTimeTx(new Double(40.0));
                perf2.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else if (i9 != 15 && i9 != 14) {
                if (i9 > 4) {
                    perf2.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
                } else {
                    ((GraphSubsystemFCPortPerf)perf2).setIORateRx(new Double(800.0));
                    ((GraphSubsystemFCPortPerf)perf2).setIORateTx(new Double(80.0));
                    ((GraphSubsystemFCPortPerf)perf2).setDataRateRx(new Double(40.0));
                    ((GraphSubsystemFCPortPerf)perf2).setDataRateTx(new Double(10.0));
                    ((GraphSubsystemFCPortPerf)perf2).setResponseTimeRx(new Double(200.0));
                    ((GraphSubsystemFCPortPerf)perf2).setResponseTimeTx(new Double(400.0));
                    perf2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
            }
            if (i9 == 15) continue;
            this.put(perf2);
            GraphFCPort2SubsystemFCPortPerf fcport_perf = new GraphFCPort2SubsystemFCPortPerf(fcportID5.getID() + "+" + perfID7.getID());
            fcport_perf.setFCPortID(fcportID5);
            fcport_perf.setSubsystemFCPortPerfID(perfID7);
            fcport_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_perf);
        }
        String poolIDStr = "pool" + this.generatePoolID();
        GraphPool pool = new GraphPool(poolIDStr);
        GraphPool.ID poolID = (GraphPool.ID)pool.getEntityID();
        pool.setDisplayName("test_" + poolIDStr);
        pool.setRAIDLevel("raid5");
        pool.setTotalManagedSpace(new Long(0x1900000000L));
        pool.setRemainingManagedSpace(new Long(0x780000000L));
        pool.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(pool);
        GraphSubsystem2Pool subsystem0_pool = new GraphSubsystem2Pool(subsystem0ID.getID() + "+" + poolID.getID());
        subsystem0_pool.setSubsystemID(subsystem0ID);
        subsystem0_pool.setPoolID(poolID);
        subsystem0_pool.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(subsystem0_pool);
        GraphPoolPerf perf10 = new GraphPoolPerf(poolIDStr);
        GraphPoolPerf.ID perfID8 = (GraphPoolPerf.ID)perf10.getEntityID();
        perf10.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(perf10);
        GraphPool2PoolPerf pool_perf = new GraphPool2PoolPerf(poolID.getID() + "+" + perfID8.getID());
        pool_perf.setPoolID(poolID);
        pool_perf.setPoolPerfID(perfID8);
        pool_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(pool_perf);
        for (i8 = 0; i8 < 5; ++i8) {
            diskIDStr = "disk" + this.generateDiskID();
            disk = new GraphDisk(diskIDStr);
            diskID = (GraphDisk.ID)disk.getEntityID();
            disk.setDisplayName("test_" + diskIDStr);
            disk.setCapacity(new Long(0x780000000L));
            disk.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(disk);
            pool_disk = new GraphPool2Disk(poolID.getID() + "+" + diskID.getID());
            pool_disk.setPoolID(poolID);
            pool_disk.setDiskID(diskID);
            pool_disk.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(pool_disk);
            subsystem0_disk = new GraphSubsystem2Disk(subsystem0ID.getID() + "+" + diskID.getID());
            subsystem0_disk.setSubsystemID(subsystem0ID);
            subsystem0_disk.setDiskID(diskID);
            subsystem0_disk.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem0_disk);
        }
        for (i8 = 0; i8 < 12; ++i8) {
            volumeIDStr = "vol" + this.generateVolumeID();
            volume = new GraphVolume(volumeIDStr);
            volumeID = (GraphVolume.ID)volume.getEntityID();
            volume.setDisplayName("test_" + volumeIDStr);
            volume.setCapacity(new Long(0x3C0000000L));
            if (i8 == 0 || i8 == 1) {
                volume.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else {
                volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            volume.setFormat(GraphVolume.FORMAT_FB);
            this.put(volume);
            subsystem0Volume0V.add(volume);
            perf = new GraphVolumePerf((String)volumeID.getID());
            perfID = (GraphVolumePerf.ID)perf.getEntityID();
            perf.setIORateRx(new Double(2.0));
            perf.setIORateTx(new Double(2.0));
            perf.setDataRateRx(new Double(20.0));
            perf.setDataRateTx(new Double(30.0));
            perf.setResponseTimeRx(new Double(25.0));
            perf.setResponseTimeTx(new Double(35.0));
            perf.setCacheHitRx(new Double(50.0));
            perf.setCacheHitTx(new Double(50.0));
            perf.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            this.put(perf);
            volume_perf = new GraphVolume2VolumePerf(volumeID.getID() + "+" + perfID.getID());
            volume_perf.setVolumeID(volumeID);
            volume_perf.setVolumePerfID(perfID);
            volume_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(volume_perf);
            pool_volume = new GraphPool2Volume(poolID.getID() + "+" + volumeID.getID());
            pool_volume.setPoolID(poolID);
            pool_volume.setVolumeID(volumeID);
            if (i8 == 0 || i8 == 1) {
                pool_volume.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else {
                pool_volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(pool_volume);
            subsystem0_volume = new GraphSubsystem2Volume(subsystem0ID.getID() + "+" + volumeID.getID());
            subsystem0_volume.setSubsystemID(subsystem0ID);
            subsystem0_volume.setVolumeID(volumeID);
            if (i8 == 0 || i8 == 1) {
                subsystem0_volume.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else {
                subsystem0_volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(subsystem0_volume);
        }
        poolIDStr = "pool" + this.generatePoolID();
        pool = new GraphPool(poolIDStr);
        poolID = (GraphPool.ID)pool.getEntityID();
        pool.setDisplayName("test_" + poolIDStr);
        pool.setRAIDLevel("raid10");
        pool.setTotalManagedSpace(new Long(0xA0000000000L));
        pool.setRemainingManagedSpace(new Long(0L));
        pool.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(pool);
        subsystem0_pool = new GraphSubsystem2Pool(subsystem0ID.getID() + "+" + poolID.getID());
        subsystem0_pool.setSubsystemID(subsystem0ID);
        subsystem0_pool.setPoolID(poolID);
        subsystem0_pool.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(subsystem0_pool);
        perf = new GraphPoolPerf(poolIDStr);
        perfID8 = (GraphPoolPerf.ID)perf.getEntityID();
        perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(perf);
        pool_perf = new GraphPool2PoolPerf(poolID.getID() + "+" + perfID8.getID());
        pool_perf.setPoolID(poolID);
        pool_perf.setPoolPerfID(perfID8);
        pool_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(pool_perf);
        for (i7 = 0; i7 < 10; ++i7) {
            diskIDStr = "disk" + this.generateDiskID();
            disk = new GraphDisk(diskIDStr);
            diskID = (GraphDisk.ID)disk.getEntityID();
            disk.setDisplayName("test_" + diskIDStr);
            disk.setCapacity(new Long(0x780000000L));
            if (i7 == 2) {
                disk.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else {
                disk.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(disk);
            pool_disk = new GraphPool2Disk(poolID.getID() + "+" + diskID.getID());
            pool_disk.setPoolID(poolID);
            pool_disk.setDiskID(diskID);
            if (i7 == 2) {
                pool_disk.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else {
                pool_disk.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(pool_disk);
            subsystem0_disk = new GraphSubsystem2Disk(subsystem0ID.getID() + "+" + diskID.getID());
            subsystem0_disk.setSubsystemID(subsystem0ID);
            subsystem0_disk.setDiskID(diskID);
            if (i7 == 2) {
                subsystem0_disk.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else {
                subsystem0_disk.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(subsystem0_disk);
        }
        for (i7 = 0; i7 < 50; ++i7) {
            volumeIDStr = "vol" + this.generateVolumeID();
            volume = new GraphVolume(volumeIDStr);
            volumeID = (GraphVolume.ID)volume.getEntityID();
            volume.setDisplayName("test_" + volumeIDStr);
            volume.setCapacity(new Long(0x100000L));
            volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            volume.setFormat(GraphVolume.FORMAT_CKD_3380);
            this.put(volume);
            subsystem0Volume1V.add(volume);
            perf = new GraphVolumePerf((String)volumeID.getID());
            perfID = (GraphVolumePerf.ID)perf.getEntityID();
            perf.setIORateRx(new Double(2.0));
            perf.setIORateTx(new Double(2.0));
            perf.setDataRateRx(new Double(20.0));
            perf.setDataRateTx(new Double(30.0));
            perf.setResponseTimeRx(new Double(25.0));
            perf.setResponseTimeTx(new Double(35.0));
            perf.setCacheHitRx(new Double(50.0));
            perf.setCacheHitTx(new Double(30.0));
            perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(perf);
            volume_perf = new GraphVolume2VolumePerf(volumeID.getID() + "+" + perfID.getID());
            volume_perf.setVolumeID(volumeID);
            volume_perf.setVolumePerfID(perfID);
            volume_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(volume_perf);
            pool_volume = new GraphPool2Volume(poolID.getID() + "+" + volumeID.getID());
            pool_volume.setPoolID(poolID);
            pool_volume.setVolumeID(volumeID);
            pool_volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(pool_volume);
            subsystem0_volume = new GraphSubsystem2Volume(subsystem0ID.getID() + "+" + volumeID.getID());
            subsystem0_volume.setSubsystemID(subsystem0ID);
            subsystem0_volume.setVolumeID(volumeID);
            subsystem0_volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem0_volume);
        }
        GraphVolume srcVolume = (GraphVolume)subsystem0Volume1V.elementAt(6);
        GraphVolume.ID srcVolumeID = (GraphVolume.ID)srcVolume.getEntityID();
        srcVolume.setFlashCopyType(GraphVolume.FLASHCOPYTYPE_SOURCE);
        for (int i13 = 14; i13 < 17; ++i13) {
            GraphVolume targetVolume = (GraphVolume)subsystem0Volume1V.elementAt(i13);
            GraphVolume.ID targetVolumeID = (GraphVolume.ID)targetVolume.getEntityID();
            targetVolume.setFlashCopyType(GraphVolume.FLASHCOPYTYPE_TARGET);
            GraphVolume2Volume src2target = new GraphVolume2Volume(srcVolumeID.getID() + "+" + targetVolumeID.getID());
            src2target.setSourceID(srcVolumeID);
            src2target.setTargetID(targetVolumeID);
            src2target.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(src2target);
        }
        GraphVolume srctargetVolume = (GraphVolume)subsystem0Volume1V.elementAt(20);
        GraphVolume.ID srctargetVolumeID = (GraphVolume.ID)srctargetVolume.getEntityID();
        srctargetVolume.setFlashCopyType(GraphVolume.FLASHCOPYTYPE_SOURCETARGET);
        GraphVolume2Volume src2srctarget = new GraphVolume2Volume(srcVolumeID.getID() + "+" + srctargetVolumeID.getID());
        src2srctarget.setSourceID(srcVolumeID);
        src2srctarget.setTargetID(srctargetVolumeID);
        src2srctarget.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(src2srctarget);
        for (int i14 = 26; i14 < 29; ++i14) {
            GraphVolume targetVolume = (GraphVolume)subsystem0Volume1V.elementAt(i14);
            GraphVolume.ID targetVolumeID = (GraphVolume.ID)targetVolume.getEntityID();
            targetVolume.setFlashCopyType(GraphVolume.FLASHCOPYTYPE_TARGET);
            GraphVolume2Volume src2target = new GraphVolume2Volume(srctargetVolumeID.getID() + "+" + targetVolumeID.getID());
            src2target.setSourceID(srctargetVolume);
            src2target.setTargetID(targetVolumeID);
            src2target.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(src2target);
        }
        for (int i15 = 0; i15 < 4; ++i15) {
            String diskIDStr2 = "disk" + this.generateDiskID();
            GraphDisk disk2 = new GraphDisk(diskIDStr2);
            GraphDisk.ID diskID2 = (GraphDisk.ID)disk2.getEntityID();
            disk2.setDisplayName(diskIDStr2);
            disk2.setCapacity(new Long(0x780000000L));
            disk2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(disk2);
            GraphSubsystem2Disk subsystem0_disk2 = new GraphSubsystem2Disk(subsystem0ID.getID() + "+" + diskID2.getID());
            subsystem0_disk2.setSubsystemID(subsystem0ID);
            subsystem0_disk2.setDiskID(diskID2);
            subsystem0_disk2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem0_disk2);
        }
        Vector<GraphVolume> subsystem1Volume0V = new Vector<GraphVolume>();
        int subsystem1Volume0Count = 0;
        Vector<GraphFCPort> subsystem1FCPortV = new Vector<GraphFCPort>();
        int subsystem1FCPortCount = 0;
        String subsystemIDStr2 = "subsystem" + this.generateSubsystemID();
        GraphSubsystem subsystem1 = new GraphSubsystem(subsystemIDStr2);
        GraphSubsystem.ID subsystem1ID = (GraphSubsystem.ID)subsystem1.getEntityID();
        subsystem1.setDisplayName("angels");
        subsystem1.setAllocatedCapacity(new Long(2147483648000L));
        subsystem1.setAvailableCapacity(new Long(0x7D00000000L));
        subsystem1.setBackendStorageCapacity(new Long(0L));
        subsystem1.setVendor("IBM");
        subsystem1.setModel("DS6000");
        subsystem1.setCache(new Long(0x200000L));
        subsystem1.setType("High Availability");
        subsystem1.setSerialNumber("6e-pp988");
        subsystem1.setIPAddress("9.1.9.25");
        subsystem1.setCodeLevel("5.0.1");
        subsystem1.setElementManager("http://9.1.9.25");
        subsystem1.setIsSVC(Boolean.FALSE);
        subsystem1.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
        subsystem1.setUDP1("B3-251");
        subsystem1.setUDP2("Eric");
        this.put(subsystem1);
        Vector<GraphFabric.ID> fabricIDV7 = new Vector<GraphFabric.ID>();
        perf2 = new GraphSubsystemPerf((String)subsystem1ID.getID());
        GraphSubsystemPerf.ID perfID9 = (GraphSubsystemPerf.ID)perf2.getEntityID();
        ((GraphSubsystemPerf)perf2).setIORateRx(new Double(20.0));
        ((GraphSubsystemPerf)perf2).setIORateTx(new Double(20.0));
        ((GraphSubsystemPerf)perf2).setDataRateRx(new Double(200.0));
        ((GraphSubsystemPerf)perf2).setDataRateTx(new Double(300.0));
        ((GraphSubsystemPerf)perf2).setResponseTimeRx(new Double(22.0));
        ((GraphSubsystemPerf)perf2).setResponseTimeTx(new Double(32.0));
        ((GraphSubsystemPerf)perf2).setCacheHitRx(new Double(80.0));
        ((GraphSubsystemPerf)perf2).setCacheHitTx(new Double(20.0));
        perf2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(perf2);
        GraphSubsystem2SubsystemPerf subsystem_perf2 = new GraphSubsystem2SubsystemPerf(subsystem1ID.getID() + "+" + perfID9.getID());
        subsystem_perf2.setSubsystemID(subsystem1ID);
        subsystem_perf2.setSubsystemPerfID(perfID9);
        subsystem_perf2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(subsystem_perf2);
        GraphFabric2Subsystem fabric_subsystem1 = new GraphFabric2Subsystem(fabric1.getEntityID().getID() + "+" + subsystem1ID.getID());
        fabric_subsystem1.setFabricID(fabric1ID);
        fabric_subsystem1.setSubsystemID(subsystem1ID);
        fabric_subsystem1.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_subsystem1);
        fabricIDV7.add(fabric1ID);
        GraphSwitch2Subsystem sw_subsystem1 = new GraphSwitch2Subsystem(sw2ID.getID() + "+" + subsystem1ID.getID());
        sw_subsystem1.setSwitchID(sw2ID);
        sw_subsystem1.setSubsystemID(subsystem1ID);
        sw_subsystem1.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(sw_subsystem1);
        for (int i16 = 0; i16 < 4; ++i16) {
            String wwn8 = this.generateWWN();
            GraphFCPort fcport6 = new GraphFCPort(wwn8);
            GraphFCPort.ID fcportID6 = (GraphFCPort.ID)fcport6.getEntityID();
            fcport6.setDisplayName(wwn8);
            fcport6.setName(wwn8);
            fcport6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport6);
            subsystem1FCPortV.add(fcport6);
            GraphSubsystem2FCPort subsystem1_fcport = new GraphSubsystem2FCPort(subsystem1ID.getID() + "+" + fcportID6.getID());
            subsystem1_fcport.setSubsystemID(subsystem1ID);
            subsystem1_fcport.setFCPortID(fcportID6);
            subsystem1_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem1_fcport);
            if (i16 == 0) {
                GraphFCPort.ID swPortID3 = (GraphFCPort.ID)((GraphFCPort)sw2FCPortV.get(sw2FCPortCount)).getEntityID();
                ++sw2FCPortCount;
                fcportID6 = (GraphFCPort.ID)((GraphFCPort)subsystem1FCPortV.get(subsystem1FCPortCount)).getEntityID();
                ++subsystem1FCPortCount;
                GraphFCPort2FCPort fcport_fcport4 = new GraphFCPort2FCPort(swPortID3.getID() + "+" + fcportID6.getID());
                fcport_fcport4.setFCPort1ID(swPortID3);
                fcport_fcport4.setFCPort2ID(fcportID6);
                fcport_fcport4.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(fcport_fcport4);
            }
            GraphSubsystemFCPortPerf perf11 = new GraphSubsystemFCPortPerf(wwn8);
            GraphSubsystemFCPortPerf.ID perfID10 = (GraphSubsystemFCPortPerf.ID)perf11.getEntityID();
            perf11.setIORateRx(new Double(800.0));
            perf11.setIORateTx(new Double(80.0));
            perf11.setDataRateRx(new Double(40.0));
            perf11.setDataRateTx(new Double(10.0));
            perf11.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(perf11);
            GraphFCPort2SubsystemFCPortPerf fcport_perf = new GraphFCPort2SubsystemFCPortPerf(fcportID6.getID() + "+" + perfID10.getID());
            fcport_perf.setFCPortID(fcportID6);
            fcport_perf.setSubsystemFCPortPerfID(perfID10);
            fcport_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_perf);
        }
        for (int j = 0; j < 10; ++j) {
            int i17;
            String poolIDStr2 = "pool" + this.generatePoolID();
            GraphPool pool2 = new GraphPool(poolIDStr2);
            GraphPool.ID poolID2 = (GraphPool.ID)pool2.getEntityID();
            pool2.setDisplayName(poolIDStr2);
            pool2.setRAIDLevel("raid5");
            pool2.setTotalManagedSpace(new Long(0x3200000000L));
            pool2.setRemainingManagedSpace(new Long(0xC80000000L));
            pool2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(pool2);
            GraphSubsystem2Pool subsystem1_pool = new GraphSubsystem2Pool(subsystem1ID.getID() + "+" + poolID2.getID());
            subsystem1_pool.setSubsystemID(subsystem1ID);
            subsystem1_pool.setPoolID(poolID2);
            subsystem1_pool.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem1_pool);
            for (i17 = 0; i17 < 10; ++i17) {
                String diskIDStr3 = "disk" + this.generateDiskID();
                GraphDisk disk3 = new GraphDisk(diskIDStr3);
                GraphDisk.ID diskID3 = (GraphDisk.ID)disk3.getEntityID();
                disk3.setDisplayName(diskIDStr3);
                disk3.setCapacity(new Long(0x780000000L));
                disk3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(disk3);
                GraphPool2Disk pool_disk2 = new GraphPool2Disk(poolID2.getID() + "+" + diskID3.getID());
                pool_disk2.setPoolID(poolID2);
                pool_disk2.setDiskID(diskID3);
                pool_disk2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(pool_disk2);
                GraphSubsystem2Disk subsystem1_disk = new GraphSubsystem2Disk(subsystem1ID.getID() + "+" + diskID3.getID());
                subsystem1_disk.setSubsystemID(subsystem1ID);
                subsystem1_disk.setDiskID(diskID3);
                subsystem1_disk.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(subsystem1_disk);
            }
            for (i17 = 0; i17 < 100; ++i17) {
                String volumeIDStr2 = "vol" + this.generateVolumeID();
                GraphVolume volume2 = new GraphVolume(volumeIDStr2);
                GraphVolume.ID volumeID2 = (GraphVolume.ID)volume2.getEntityID();
                volume2.setDisplayName(volumeIDStr2);
                volume2.setCapacity(new Long(0x3C0000000L));
                volume2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                volume2.setFormat(GraphVolume.FORMAT_FB);
                this.put(volume2);
                subsystem1Volume0V.add(volume2);
                GraphPool2Volume pool_volume2 = new GraphPool2Volume(poolID2.getID() + "+" + volumeID2.getID());
                pool_volume2.setPoolID(poolID2);
                pool_volume2.setVolumeID(volumeID2);
                pool_volume2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(pool_volume2);
                GraphSubsystem2Volume subsystem1_volume = new GraphSubsystem2Volume(subsystem1ID.getID() + "+" + volumeID2.getID());
                subsystem1_volume.setSubsystemID(subsystem1ID);
                subsystem1_volume.setVolumeID(volumeID2);
                subsystem1_volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(subsystem1_volume);
            }
        }
        Vector<GraphVolume> subsystem2Volume0V = new Vector<GraphVolume>();
        int subsystem2Volume0Count = 0;
        Vector<GraphFCPort> subsystem2FCPortV = new Vector<GraphFCPort>();
        int subsystem2FCPortCount = 0;
        String subsystemIDStr3 = "subsystem" + this.generateSubsystemID();
        GraphSubsystem subsystem2 = new GraphSubsystem(subsystemIDStr3);
        GraphSubsystem.ID subsystem2ID = (GraphSubsystem.ID)subsystem2.getEntityID();
        subsystem2.setDisplayName("spurs.almaden.ibm.com");
        subsystem2.setAllocatedCapacity(new Long(2147483648000L));
        subsystem2.setAvailableCapacity(new Long(0x7D00000000L));
        subsystem2.setVendor("IBM");
        subsystem2.setModel("DS4800");
        subsystem2.setCache(new Long(524288L));
        subsystem2.setType("High Availability");
        subsystem2.setSerialNumber("6e-pp987");
        subsystem2.setIPAddress("9.1.9.26");
        subsystem2.setCodeLevel("5.0.1");
        subsystem2.setElementManager("http://9.1.9.26");
        subsystem2.setIsSVC(Boolean.FALSE);
        subsystem2.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
        subsystem2.setUDP1("G1-200");
        subsystem2.setUDP2("Roberto");
        this.put(subsystem2);
        Vector<GraphFabric.ID> fabricIDV8 = new Vector<GraphFabric.ID>();
        GraphSubsystemPerf perf12 = new GraphSubsystemPerf((String)subsystem2ID.getID());
        GraphSubsystemPerf.ID perfID11 = (GraphSubsystemPerf.ID)perf12.getEntityID();
        perf12.setIORateRx(new Double(20.0));
        perf12.setIORateTx(new Double(20.0));
        perf12.setDataRateRx(new Double(200.0));
        perf12.setDataRateTx(new Double(300.0));
        perf12.setResponseTimeRx(new Double(22.0));
        perf12.setResponseTimeTx(new Double(32.0));
        perf12.setCacheHitRx(new Double(80.0));
        perf12.setCacheHitTx(new Double(40.0));
        perf12.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(perf12);
        GraphSubsystem2SubsystemPerf subsystem_perf3 = new GraphSubsystem2SubsystemPerf(subsystem2ID.getID() + "+" + perfID11.getID());
        subsystem_perf3.setSubsystemID(subsystem2ID);
        subsystem_perf3.setSubsystemPerfID(perfID11);
        subsystem_perf3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(subsystem_perf3);
        GraphFabric2Subsystem fabric_subsystem2 = new GraphFabric2Subsystem(fabric1.getEntityID().getID() + "+" + subsystem2ID.getID());
        fabric_subsystem2.setFabricID(fabric1ID);
        fabric_subsystem2.setSubsystemID(subsystem2ID);
        fabric_subsystem2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_subsystem2);
        fabricIDV8.add(fabric1ID);
        GraphSwitch2Subsystem sw_subsystem2 = new GraphSwitch2Subsystem(sw2ID.getID() + "+" + subsystem2ID.getID());
        sw_subsystem2.setSwitchID(sw2ID);
        sw_subsystem2.setSubsystemID(subsystem2ID);
        sw_subsystem2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(sw_subsystem2);
        for (int i18 = 0; i18 < 4; ++i18) {
            String wwn9 = this.generateWWN();
            GraphFCPort fcport7 = new GraphFCPort(wwn9);
            GraphFCPort.ID fcportID7 = (GraphFCPort.ID)fcport7.getEntityID();
            fcport7.setDisplayName(wwn9);
            fcport7.setName(wwn9);
            fcport7.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport7);
            subsystem2FCPortV.add(fcport7);
            GraphSubsystem2FCPort subsystem2_fcport = new GraphSubsystem2FCPort(subsystem2ID.getID() + "+" + fcportID7.getID());
            subsystem2_fcport.setSubsystemID(subsystem2ID);
            subsystem2_fcport.setFCPortID(fcportID7);
            subsystem2_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem2_fcport);
            if (i18 == 0) {
                GraphFCPort.ID swPortID4 = (GraphFCPort.ID)((GraphFCPort)sw2FCPortV.get(sw2FCPortCount)).getEntityID();
                ++sw2FCPortCount;
                fcportID7 = (GraphFCPort.ID)((GraphFCPort)subsystem2FCPortV.get(subsystem2FCPortCount)).getEntityID();
                ++subsystem2FCPortCount;
                GraphFCPort2FCPort fcport_fcport5 = new GraphFCPort2FCPort(swPortID4.getID() + "+" + fcportID7.getID());
                fcport_fcport5.setFCPort1ID(swPortID4);
                fcport_fcport5.setFCPort2ID(fcportID7);
                fcport_fcport5.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(fcport_fcport5);
            }
            GraphSubsystemFCPortPerf perf13 = new GraphSubsystemFCPortPerf(wwn9);
            GraphSubsystemFCPortPerf.ID perfID12 = (GraphSubsystemFCPortPerf.ID)perf13.getEntityID();
            perf13.setIORateRx(new Double(800.0));
            perf13.setIORateTx(new Double(80.0));
            perf13.setDataRateRx(new Double(40.0));
            perf13.setDataRateTx(new Double(10.0));
            perf13.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(perf13);
            GraphFCPort2SubsystemFCPortPerf fcport_perf = new GraphFCPort2SubsystemFCPortPerf(fcportID7.getID() + "+" + perfID12.getID());
            fcport_perf.setFCPortID(fcportID7);
            fcport_perf.setSubsystemFCPortPerfID(perfID12);
            fcport_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_perf);
        }
        String poolIDStr3 = "pool" + this.generatePoolID();
        GraphPool pool3 = new GraphPool(poolIDStr3);
        GraphPool.ID poolID3 = (GraphPool.ID)pool3.getEntityID();
        pool3.setDisplayName(poolIDStr3);
        pool3.setTotalManagedSpace(new Long(0x3200000000L));
        pool3.setRemainingManagedSpace(new Long(0x1900000000L));
        pool3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(pool3);
        GraphSubsystem2Pool subsystem2_pool = new GraphSubsystem2Pool(subsystem2ID.getID() + "+" + poolID3.getID());
        subsystem2_pool.setSubsystemID(subsystem2ID);
        subsystem2_pool.setPoolID(poolID3);
        subsystem2_pool.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(subsystem2_pool);
        for (i6 = 0; i6 < 5; ++i6) {
            String diskIDStr4 = "disk" + this.generateDiskID();
            GraphDisk disk4 = new GraphDisk(diskIDStr4);
            GraphDisk.ID diskID4 = (GraphDisk.ID)disk4.getEntityID();
            disk4.setDisplayName(diskIDStr4);
            disk4.setCapacity(new Long(0x780000000L));
            disk4.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            this.put(disk4);
            GraphPool2Disk pool_disk3 = new GraphPool2Disk(poolID3.getID() + "+" + diskID4.getID());
            pool_disk3.setPoolID(poolID3);
            pool_disk3.setDiskID(diskID4);
            pool_disk3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(pool_disk3);
            GraphSubsystem2Disk subsystem2_disk = new GraphSubsystem2Disk(subsystem2ID.getID() + "+" + diskID4.getID());
            subsystem2_disk.setSubsystemID(subsystem2ID);
            subsystem2_disk.setDiskID(diskID4);
            subsystem2_disk.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem2_disk);
        }
        for (i6 = 0; i6 < 100; ++i6) {
            String volumeIDStr3 = "vol" + this.generateVolumeID();
            GraphVolume volume3 = new GraphVolume(volumeIDStr3);
            GraphVolume.ID volumeID3 = (GraphVolume.ID)volume3.getEntityID();
            volume3.setDisplayName(volumeIDStr3);
            volume3.setCapacity(new Long(0x280000000L));
            volume3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            volume3.setFormat(GraphVolume.FORMAT_FB);
            this.put(volume3);
            subsystem2Volume0V.add(volume3);
            GraphVolumePerf perf14 = new GraphVolumePerf((String)volumeID3.getID());
            GraphVolumePerf.ID perfID13 = (GraphVolumePerf.ID)perf14.getEntityID();
            perf14.setIORateRx(new Double(2.0));
            perf14.setIORateTx(new Double(2.0));
            perf14.setDataRateRx(new Double(20.0));
            perf14.setDataRateTx(new Double(30.0));
            perf14.setCacheHitRx(new Double(50.0));
            perf14.setCacheHitTx(new Double(30.0));
            perf14.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(perf14);
            GraphVolume2VolumePerf volume_perf2 = new GraphVolume2VolumePerf(volumeID3.getID() + "+" + perfID13.getID());
            volume_perf2.setVolumeID(volumeID3);
            volume_perf2.setVolumePerfID(perfID13);
            volume_perf2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(volume_perf2);
            GraphPool2Volume pool_volume3 = new GraphPool2Volume(poolID3.getID() + "+" + volumeID3.getID());
            pool_volume3.setPoolID(poolID3);
            pool_volume3.setVolumeID(volumeID3);
            pool_volume3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(pool_volume3);
            GraphSubsystem2Volume subsystem2_volume = new GraphSubsystem2Volume(subsystem2ID.getID() + "+" + volumeID3.getID());
            subsystem2_volume.setSubsystemID(subsystem2ID);
            subsystem2_volume.setVolumeID(volumeID3);
            subsystem2_volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem2_volume);
        }
        Vector<GraphVolume> subsystem3Volume0V = new Vector<GraphVolume>();
        boolean subsystem3Volume0Count = false;
        Vector subsystem3FCPortV = new Vector();
        boolean subsystem3FCPortCount = false;
        String subsystemIDStr4 = "subsystem" + this.generateSubsystemID();
        GraphSubsystem subsystem3 = new GraphSubsystem(subsystemIDStr4);
        GraphSubsystem.ID subsystem3ID = (GraphSubsystem.ID)subsystem3.getEntityID();
        subsystem3.setDisplayName("76ers.almaden.ibm.com");
        subsystem3.setAllocatedCapacity(new Long(0xFA00000000L));
        subsystem3.setAvailableCapacity(new Long(0xC800000000L));
        subsystem3.setBackendStorageCapacity(new Long(0L));
        subsystem3.setVendor("IBM");
        subsystem3.setModel("FAStT 600");
        subsystem3.setCache(new Long(0x100000L));
        subsystem3.setType("Turbo");
        subsystem3.setSerialNumber("45678");
        subsystem3.setIPAddress("9.1.9.28");
        subsystem3.setCodeLevel("4.3.b2");
        subsystem3.setElementManager("http://9.1.9.28");
        subsystem3.setIsSVC(Boolean.FALSE);
        subsystem3.setUDP1("B3-251");
        subsystem3.setUDP2("Divyesh");
        subsystem3.setHealthStatus(GraphModelConstant.STATUS_MISSING);
        this.put(subsystem3);
        Vector fabricIDV9 = new Vector();
        GraphSubsystemPerf perf15 = new GraphSubsystemPerf((String)subsystem3ID.getID());
        GraphSubsystemPerf.ID perfID14 = (GraphSubsystemPerf.ID)perf15.getEntityID();
        perf15.setIORateRx(new Double(20.0));
        perf15.setIORateTx(new Double(20.0));
        perf15.setDataRateRx(new Double(200.0));
        perf15.setDataRateTx(new Double(300.0));
        perf15.setResponseTimeRx(new Double(22.0));
        perf15.setResponseTimeTx(new Double(32.0));
        perf15.setCacheHitRx(new Double(80.0));
        perf15.setCacheHitTx(new Double(50.0));
        perf15.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(perf15);
        GraphSubsystem2SubsystemPerf subsystem_perf4 = new GraphSubsystem2SubsystemPerf(subsystem3ID.getID() + "+" + perfID14.getID());
        subsystem_perf4.setSubsystemID(subsystem3ID);
        subsystem_perf4.setSubsystemPerfID(perfID14);
        subsystem_perf4.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(subsystem_perf4);
        for (int i19 = 0; i19 < 4; ++i19) {
            String wwn10 = this.generateWWN();
            GraphFCPort fcport8 = new GraphFCPort(wwn10);
            GraphFCPort.ID fcportID8 = (GraphFCPort.ID)fcport8.getEntityID();
            fcport8.setDisplayName(wwn10);
            fcport8.setName(wwn10);
            fcport8.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport8);
            subsystem2FCPortV.add(fcport8);
            GraphSubsystem2FCPort subsystem3_fcport = new GraphSubsystem2FCPort(subsystem3ID.getID() + "+" + fcportID8.getID());
            subsystem3_fcport.setSubsystemID(subsystem3ID);
            subsystem3_fcport.setFCPortID(fcportID8);
            subsystem3_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem3_fcport);
        }
        String poolIDStr4 = "pool" + this.generatePoolID();
        GraphPool pool4 = new GraphPool(poolIDStr4);
        GraphPool.ID poolID4 = (GraphPool.ID)pool4.getEntityID();
        pool4.setDisplayName(poolIDStr4);
        pool4.setRAIDLevel("raid5");
        pool4.setTotalManagedSpace(new Long(0x1900000000L));
        pool4.setRemainingManagedSpace(new Long(0x780000000L));
        pool4.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(pool4);
        GraphSubsystem2Pool subsystem3_pool = new GraphSubsystem2Pool(subsystem3ID.getID() + "+" + poolID4.getID());
        subsystem3_pool.setSubsystemID(subsystem3ID);
        subsystem3_pool.setPoolID(poolID4);
        subsystem3_pool.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(subsystem3_pool);
        for (i5 = 0; i5 < 5; ++i5) {
            String diskIDStr5 = "disk" + this.generateDiskID();
            GraphDisk disk5 = new GraphDisk(diskIDStr5);
            GraphDisk.ID diskID5 = (GraphDisk.ID)disk5.getEntityID();
            disk5.setDisplayName(diskIDStr5);
            disk5.setCapacity(new Long(0x780000000L));
            disk5.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(disk5);
            GraphPool2Disk pool_disk4 = new GraphPool2Disk(poolID4.getID() + "+" + diskID5.getID());
            pool_disk4.setPoolID(poolID4);
            pool_disk4.setDiskID(diskID5);
            pool_disk4.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(pool_disk4);
            GraphSubsystem2Disk subsystem3_disk = new GraphSubsystem2Disk(subsystem3ID.getID() + "+" + diskID5.getID());
            subsystem3_disk.setSubsystemID(subsystem3ID);
            subsystem3_disk.setDiskID(diskID5);
            subsystem3_disk.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem3_disk);
        }
        for (i5 = 0; i5 < 3; ++i5) {
            String volumeIDStr4 = "vol" + this.generateVolumeID();
            GraphVolume volume4 = new GraphVolume(volumeIDStr4);
            GraphVolume.ID volumeID4 = (GraphVolume.ID)volume4.getEntityID();
            volume4.setDisplayName(volumeIDStr4);
            volume4.setCapacity(new Long(0x280000000L));
            volume4.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            volume4.setFormat(GraphVolume.FORMAT_FB);
            this.put(volume4);
            subsystem3Volume0V.add(volume4);
            GraphVolumePerf perf16 = new GraphVolumePerf((String)volumeID4.getID());
            GraphVolumePerf.ID perfID15 = (GraphVolumePerf.ID)perf16.getEntityID();
            perf16.setIORateRx(new Double(2.0));
            perf16.setIORateTx(new Double(2.0));
            perf16.setDataRateRx(new Double(20.0));
            perf16.setDataRateTx(new Double(30.0));
            perf16.setCacheHitRx(new Double(50.0));
            perf16.setCacheHitTx(new Double(70.0));
            perf16.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(perf16);
            GraphVolume2VolumePerf volume_perf3 = new GraphVolume2VolumePerf(volumeID4.getID() + "+" + perfID15.getID());
            volume_perf3.setVolumeID(volumeID4);
            volume_perf3.setVolumePerfID(perfID15);
            volume_perf3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(volume_perf3);
            GraphPool2Volume pool_volume4 = new GraphPool2Volume(poolID4.getID() + "+" + volumeID4.getID());
            pool_volume4.setPoolID(poolID4);
            pool_volume4.setVolumeID(volumeID4);
            pool_volume4.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(pool_volume4);
            GraphSubsystem2Volume subsystem3_volume = new GraphSubsystem2Volume(subsystem3ID.getID() + "+" + volumeID4.getID());
            subsystem3_volume.setSubsystemID(subsystem3ID);
            subsystem3_volume.setVolumeID(volumeID4);
            subsystem3_volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem3_volume);
        }
        Vector<GraphVolume> subsystem4Volume0V = new Vector<GraphVolume>();
        boolean subsystem4Volume0Count = false;
        Vector subsystem4FCPortV = new Vector();
        boolean subsystem4FCPortCount = false;
        String subsystemIDStr5 = "subsystem" + this.generateSubsystemID();
        GraphSubsystem subsystem4 = new GraphSubsystem(subsystemIDStr5);
        GraphSubsystem.ID subsystem4ID = (GraphSubsystem.ID)subsystem4.getEntityID();
        subsystem4.setDisplayName("Stress test");
        subsystem4.setAllocatedCapacity(new Long(2147483648000L));
        subsystem4.setAvailableCapacity(new Long(0x7D00000000L));
        subsystem4.setBackendStorageCapacity(new Long(0L));
        subsystem4.setVendor("IBM");
        subsystem4.setModel("DS8000");
        subsystem4.setCache(new Long(0x200000L));
        subsystem4.setType("High Availability");
        subsystem4.setSerialNumber("6e-pp988");
        subsystem4.setIPAddress("9.1.9.55");
        subsystem4.setCodeLevel("5.0.1");
        subsystem4.setElementManager("http://9.1.9.55");
        subsystem4.setIsSVC(Boolean.FALSE);
        subsystem4.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
        subsystem4.setUDP1("B3-251");
        subsystem4.setUDP2("Sumant");
        this.put(subsystem4);
        Vector fabricIDV10 = new Vector();
        for (int j = 0; j < 10; ++j) {
            String poolIDStr5 = "pool" + this.generatePoolID();
            GraphPool pool5 = new GraphPool(poolIDStr5);
            GraphPool.ID poolID5 = (GraphPool.ID)pool5.getEntityID();
            pool5.setDisplayName(poolIDStr5);
            pool5.setRAIDLevel("raid5");
            pool5.setTotalManagedSpace(new Long(0x3200000000L));
            pool5.setRemainingManagedSpace(new Long(0xC80000000L));
            pool5.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(pool5);
            GraphSubsystem2Pool subsystem4_pool = new GraphSubsystem2Pool(subsystem4ID.getID() + "+" + poolID5.getID());
            subsystem4_pool.setSubsystemID(subsystem4ID);
            subsystem4_pool.setPoolID(poolID5);
            subsystem4_pool.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(subsystem4_pool);
            for (int i20 = 0; i20 < 10; ++i20) {
                String diskIDStr6 = "disk" + this.generateDiskID();
                GraphDisk disk6 = new GraphDisk(diskIDStr6);
                GraphDisk.ID diskID6 = (GraphDisk.ID)disk6.getEntityID();
                disk6.setDisplayName(diskIDStr6);
                disk6.setCapacity(new Long(0x780000000L));
                disk6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(disk6);
                GraphPool2Disk pool_disk5 = new GraphPool2Disk(poolID5.getID() + "+" + diskID6.getID());
                pool_disk5.setPoolID(poolID5);
                pool_disk5.setDiskID(diskID6);
                pool_disk5.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(pool_disk5);
                GraphSubsystem2Disk subsystem4_disk = new GraphSubsystem2Disk(subsystem4ID.getID() + "+" + diskID6.getID());
                subsystem4_disk.setSubsystemID(subsystem4ID);
                subsystem4_disk.setDiskID(diskID6);
                subsystem4_disk.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(subsystem4_disk);
            }
            int stressTest_numVolumesPerPool = 1600;
            for (int i21 = 0; i21 < stressTest_numVolumesPerPool; ++i21) {
                String volumeIDStr5 = "vol" + this.generateVolumeID();
                GraphVolume volume5 = new GraphVolume(volumeIDStr5);
                GraphVolume.ID volumeID5 = (GraphVolume.ID)volume5.getEntityID();
                volume5.setDisplayName(volumeIDStr5);
                volume5.setCapacity(new Long(0x3C0000000L));
                volume5.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                volume5.setFormat(GraphVolume.FORMAT_FB);
                if (i21 < 10) {
                    volume5.setIsAssigned(Boolean.FALSE);
                } else {
                    volume5.setIsAssigned(Boolean.TRUE);
                }
                this.put(volume5);
                subsystem4Volume0V.add(volume5);
                GraphPool2Volume pool_volume5 = new GraphPool2Volume(poolID5.getID() + "+" + volumeID5.getID());
                pool_volume5.setPoolID(poolID5);
                pool_volume5.setVolumeID(volumeID5);
                pool_volume5.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(pool_volume5);
                GraphSubsystem2Volume subsystem4_volume = new GraphSubsystem2Volume(subsystem4ID.getID() + "+" + volumeID5.getID());
                subsystem4_volume.setSubsystemID(subsystem4ID);
                subsystem4_volume.setVolumeID(volumeID5);
                subsystem4_volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(subsystem4_volume);
            }
        }
        Vector<GraphVolume> svc0Volume0V = new Vector<GraphVolume>();
        int svc0Volume0Count = 0;
        Vector<GraphFCPort> svc0FCPortV = new Vector<GraphFCPort>();
        int svc0FCPortCount = 0;
        String svcIDStr = "svc" + this.generateSubsystemID();
        GraphSubsystem svc0 = new GraphSubsystem(svcIDStr);
        GraphSubsystem.ID svc0ID = (GraphSubsystem.ID)svc0.getEntityID();
        svc0.setDisplayName("yankee.almaden.ibm.com");
        svc0.setAllocatedCapacity(new Long(2147483648000L));
        svc0.setAvailableCapacity(new Long(0x7D00000000L));
        svc0.setBackendStorageCapacity(new Long(2684354560000L));
        svc0.setVendor("IBM");
        svc0.setModel("SVC");
        svc0.setCache(new Long(0x100000L));
        svc0.setType("High Availability");
        svc0.setSerialNumber("6e-pp987");
        svc0.setIPAddress("9.1.9.77");
        svc0.setCodeLevel("5.0.1");
        svc0.setElementManager("http://9.1.9.77");
        svc0.setIsSVC(Boolean.TRUE);
        svc0.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        svc0.setUDP1("G1-200");
        svc0.setUDP2("Srini");
        this.put(svc0);
        Vector fabricIDV11 = new Vector();
        GraphSubsystemPerf perf17 = new GraphSubsystemPerf((String)svc0ID.getID());
        GraphSubsystemPerf.ID perfID16 = (GraphSubsystemPerf.ID)perf17.getEntityID();
        perf17.setIORateRx(new Double(20.0));
        perf17.setIORateTx(new Double(20.0));
        perf17.setDataRateRx(new Double(200.0));
        perf17.setDataRateTx(new Double(300.0));
        perf17.setResponseTimeRx(new Double(22.0));
        perf17.setResponseTimeTx(new Double(32.0));
        perf17.setCacheHitRx(new Double(80.0));
        perf17.setCacheHitTx(new Double(10.0));
        perf17.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(perf17);
        GraphSubsystem2SubsystemPerf subsystem_perf5 = new GraphSubsystem2SubsystemPerf(svc0ID.getID() + "+" + perfID16.getID());
        subsystem_perf5.setSubsystemID(svc0ID);
        subsystem_perf5.setSubsystemPerfID(perfID16);
        subsystem_perf5.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(subsystem_perf5);
        GraphFabric2Subsystem fabric_svc0 = new GraphFabric2Subsystem(fabric0.getEntityID().getID() + "+" + svc0ID.getID());
        fabric_svc0.setFabricID(fabric0ID);
        fabric_svc0.setSubsystemID(svc0ID);
        fabric_svc0.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(fabric_svc0);
        GraphSwitch2Subsystem sw_svc0 = new GraphSwitch2Subsystem(sw0ID.getID() + "+" + svc0ID.getID());
        sw_svc0.setSwitchID(sw0ID);
        sw_svc0.setSubsystemID(svc0ID);
        sw_svc0.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(sw_svc0);
        for (int i22 = 0; i22 < 4; ++i22) {
            String wwn11 = this.generateWWN();
            GraphFCPort fcport9 = new GraphFCPort(wwn11);
            GraphFCPort.ID fcportID9 = (GraphFCPort.ID)fcport9.getEntityID();
            fcport9.setDisplayName(wwn11);
            fcport9.setName(wwn11);
            fcport9.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport9);
            svc0FCPortV.add(fcport9);
            GraphSubsystem2FCPort svc0_fcport = new GraphSubsystem2FCPort(svc0ID.getID() + "+" + fcportID9.getID());
            svc0_fcport.setSubsystemID(svc0ID);
            svc0_fcport.setFCPortID(fcportID9);
            svc0_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(svc0_fcport);
            if (i22 != 0) continue;
            GraphFCPort.ID swPortID5 = (GraphFCPort.ID)((GraphFCPort)sw0FCPortV.get(sw0FCPortCount)).getEntityID();
            ++sw0FCPortCount;
            fcportID9 = (GraphFCPort.ID)((GraphFCPort)svc0FCPortV.get(svc0FCPortCount)).getEntityID();
            ++svc0FCPortCount;
            GraphFCPort2FCPort fcport_fcport6 = new GraphFCPort2FCPort(swPortID5.getID() + "+" + fcportID9.getID());
            fcport_fcport6.setFCPort1ID(swPortID5);
            fcport_fcport6.setFCPort2ID(fcportID9);
            fcport_fcport6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_fcport6);
        }
        String poolIDStr6 = "pool" + this.generatePoolID();
        GraphPool pool6 = new GraphPool(poolIDStr6);
        GraphPool.ID poolID6 = (GraphPool.ID)pool6.getEntityID();
        pool6.setDisplayName(poolIDStr6);
        pool6.setRAIDLevel("raid0");
        pool6.setTotalManagedSpace(new Long(0x3200000000L));
        pool6.setRemainingManagedSpace(new Long(0x1900000000L));
        pool6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(pool6);
        GraphSubsystem2Pool svc0_pool = new GraphSubsystem2Pool(svc0ID.getID() + "+" + poolID6.getID());
        svc0_pool.setSubsystemID(svc0ID);
        svc0_pool.setPoolID(poolID6);
        svc0_pool.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(svc0_pool);
        GraphPoolPerf perf18 = new GraphPoolPerf(poolIDStr6);
        GraphPoolPerf.ID perfID17 = (GraphPoolPerf.ID)perf18.getEntityID();
        perf18.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(perf18);
        GraphPool2PoolPerf pool_perf2 = new GraphPool2PoolPerf(poolID6.getID() + "+" + perfID17.getID());
        pool_perf2.setPoolID(poolID6);
        pool_perf2.setPoolPerfID(perfID17);
        pool_perf2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        this.put(pool_perf2);
        for (i4 = 0; i4 < 5; ++i4) {
            String diskIDStr7 = "disk" + this.generateDiskID();
            GraphDisk disk7 = new GraphDisk(diskIDStr7);
            GraphDisk.ID diskID7 = (GraphDisk.ID)disk7.getEntityID();
            disk7.setDisplayName(diskIDStr7);
            disk7.setCapacity(new Long(0x780000000L));
            disk7.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(disk7);
            GraphVolume.ID volumeID6 = (GraphVolume.ID)((GraphVolume)subsystem0Volume1V.get(subsystem0Volume1Count)).getEntityID();
            ++subsystem0Volume1Count;
            GraphVolume2Disk volume2disk = new GraphVolume2Disk(volumeID6.getID() + "+" + diskID7.getID());
            volume2disk.setVolumeID(volumeID6);
            volume2disk.setDiskID(diskID7);
            volume2disk.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(volume2disk);
            GraphPool2Disk pool_disk6 = new GraphPool2Disk(poolID6.getID() + "+" + diskID7.getID());
            pool_disk6.setPoolID(poolID6);
            pool_disk6.setDiskID(diskID7);
            pool_disk6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(pool_disk6);
            GraphSubsystem2Disk svc0_disk = new GraphSubsystem2Disk(svc0ID.getID() + "+" + diskID7.getID());
            svc0_disk.setSubsystemID(svc0ID);
            svc0_disk.setDiskID(diskID7);
            svc0_disk.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(svc0_disk);
            GraphDiskPerf perf19 = new GraphDiskPerf(diskIDStr7);
            GraphDiskPerf.ID perfID18 = (GraphDiskPerf.ID)perf19.getEntityID();
            perf19.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(perf19);
            GraphDisk2DiskPerf disk_perf = new GraphDisk2DiskPerf(poolID6.getID() + "+" + perfID18.getID());
            disk_perf.setDiskID(diskID7);
            disk_perf.setDiskPerfID(perfID18);
            disk_perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(disk_perf);
        }
        for (i4 = 0; i4 < 10; ++i4) {
            String volumeIDStr6 = "vol" + this.generateVolumeID();
            GraphVolume volume6 = new GraphVolume(volumeIDStr6);
            GraphVolume.ID volumeID7 = (GraphVolume.ID)volume6.getEntityID();
            volume6.setDisplayName(volumeIDStr6);
            volume6.setCapacity(new Long(0x280000000L));
            volume6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            volume6.setFormat(GraphVolume.FORMAT_FB);
            this.put(volume6);
            svc0Volume0V.add(volume6);
            GraphVolumePerf perf20 = new GraphVolumePerf((String)volumeID7.getID());
            GraphVolumePerf.ID perfID19 = (GraphVolumePerf.ID)perf20.getEntityID();
            perf20.setIORateRx(new Double(2.0));
            perf20.setIORateTx(new Double(2.0));
            perf20.setDataRateRx(new Double(20.0));
            perf20.setDataRateTx(new Double(30.0));
            perf20.setResponseTimeRx(new Double(25.0));
            perf20.setResponseTimeTx(new Double(35.0));
            perf20.setCacheHitRx(new Double(50.0));
            perf20.setCacheHitTx(new Double(80.0));
            perf20.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(perf20);
            GraphVolume2VolumePerf volume_perf4 = new GraphVolume2VolumePerf(volumeID7.getID() + "+" + perfID19.getID());
            volume_perf4.setVolumeID(volumeID7);
            volume_perf4.setVolumePerfID(perfID19);
            volume_perf4.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(volume_perf4);
            GraphPool2Volume pool_volume6 = new GraphPool2Volume(poolID6.getID() + "+" + volumeID7.getID());
            pool_volume6.setPoolID(poolID6);
            pool_volume6.setVolumeID(volumeID7);
            pool_volume6.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(pool_volume6);
            GraphSubsystem2Volume svc0_volume = new GraphSubsystem2Volume(svc0ID.getID() + "+" + volumeID7.getID());
            svc0_volume.setSubsystemID(svc0ID);
            svc0_volume.setVolumeID(volumeID7);
            svc0_volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(svc0_volume);
        }
        for (i3 = 0; i3 < 3; ++i3) {
            computerIDStr2 = "computer" + this.generateComputerID();
            computer2 = new GraphComputer(computerIDStr2);
            computerID2 = (GraphComputer.ID)computer2.getEntityID();
            computer2.setDisplayName("swarm" + i3);
            computer2.setOperationalStatus(new Integer(0));
            computer2.setOSType("MacOS");
            computer2.setOSVersion("10");
            computer2.setHostname("swarm" + i3 + ".almaden.ibm.com");
            computer2.setIPAddress("9.1.22." + i3);
            computer2.setGUID("tivoli-swarm-" + i3);
            if (i3 == 0) {
                computer2.setAgentsInstalled("{data,device}");
            } else {
                computer2.setAgentsInstalled("{data}");
            }
            if (i3 == 0) {
                computer2.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else {
                computer2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            computer2.setUDP1("B3-255");
            computer2.setUDP2("Fabricdeep");
            if (i3 == 0) {
                computer2.setUDP3("Bad Volume");
            }
            fabricIDV2 = new Vector<GraphFabric.ID>();
            this.put(computer2);
            fabric_computer = new GraphFabric2Computer(fabric0.getEntityID().getID() + "+" + computerID2.getID());
            fabric_computer.setFabricID(fabric0ID);
            fabric_computer.setComputerID(computerID2);
            fabric_computer.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fabric_computer);
            fabricIDV2.add(fabric0ID);
            sw_computer = new GraphSwitch2Computer(sw0ID.getID() + "+" + computerID2.getID());
            sw_computer.setSwitchID(sw0ID);
            sw_computer.setComputerID(computerID2);
            sw_computer.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_computer);
            String wwn12 = this.generateWWN();
            GraphFCPort fcport10 = new GraphFCPort(wwn12);
            GraphFCPort.ID fcportID10 = (GraphFCPort.ID)fcport10.getEntityID();
            fcport10.setDisplayName(wwn12);
            fcport10.setName(wwn12);
            fcport10.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport10);
            GraphComputer2FCPort computer_fcport = new GraphComputer2FCPort(computerID2.getID() + "+" + fcportID10.getID());
            computer_fcport.setComputerID(computerID2);
            computer_fcport.setFCPortID(fcportID10);
            computer_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_fcport);
            GraphFCPort.ID swPortID6 = (GraphFCPort.ID)((GraphFCPort)sw0FCPortV.get(sw0FCPortCount)).getEntityID();
            ++sw0FCPortCount;
            GraphFCPort2FCPort fcport_fcport7 = new GraphFCPort2FCPort(swPortID6.getID() + "+" + fcportID10.getID());
            fcport_fcport7.setFCPort1ID(swPortID6);
            fcport_fcport7.setFCPort2ID(fcportID10);
            fcport_fcport7.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_fcport7);
            for (int j = 0; j < 2; ++j) {
                GraphVolume.ID volumeID8 = (GraphVolume.ID)((GraphVolume)subsystem0Volume0V.get(subsystem0Volume0Count)).getEntityID();
                ++subsystem0Volume0Count;
                lun = new GraphLun(computerID2.getID() + "-lun" + j);
                lunID = (GraphLun.ID)lun.getEntityID();
                lun.setDisplayName("lun" + String.valueOf(j));
                lun.setLunID(new Integer(j));
                if (i3 == 0) {
                    lun.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                } else {
                    lun.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(lun);
                volume2lun = new GraphVolume2Lun(volumeID8.getID() + "+" + lunID.getID());
                volume2lun.setVolumeID(volumeID8);
                volume2lun.setLunID(lunID);
                if (i3 == 0) {
                    volume2lun.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                } else {
                    volume2lun.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(volume2lun);
                computer2lun = new GraphComputer2Lun(computerID2.getID() + "+" + lunID.getID());
                computer2lun.setComputerID(computerID2);
                computer2lun.setLunID(lunID);
                if (i3 == 0) {
                    computer2lun.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                } else {
                    computer2lun.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(computer2lun);
                computer2volume = new GraphComputer2Volume(computerID2.getID() + "+" + volumeID8.getID());
                computer2volume.setComputerID(computerID2);
                computer2volume.setVolumeID(volumeID8);
                if (i3 == 0) {
                    computer2volume.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                } else {
                    computer2volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(computer2volume);
            }
        }
        for (i3 = 0; i3 < 6; ++i3) {
            computerIDStr2 = "computer" + this.generateComputerID();
            computer2 = new GraphComputer(computerIDStr2);
            computerID2 = (GraphComputer.ID)computer2.getEntityID();
            computer2.setDisplayName("score" + i3 + ".almaden.ibm.com");
            computer2.setOperationalStatus(new Integer(0));
            computer2.setOSType("Windows2000");
            computer2.setOSVersion("Adv4");
            computer2.setHostname("score" + i3 + ".almaden.ibm.com");
            computer2.setIPAddress("9.1.23." + i3);
            computer2.setGUID("tivoli-score-" + i3);
            computer2.setAgentsInstalled("{data}");
            computer2.setUDP1("B2-225");
            computer2.setUDP2("Andreas");
            if (i3 == 0) {
                computer2.setUDP3("Slow Switch FCPort");
            } else if (i3 == 1) {
                computer2.setUDP3("Faulty Memory");
            } else if (i3 == 2 || i3 == 3) {
                computer2.setUDP3("Offline Computer");
            }
            if (i3 == 0) {
                computer2.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else if (i3 == 1) {
                computer2.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else if (i3 == 2 || i3 == 3) {
                computer2.setHealthStatus(GraphModelConstant.STATUS_MISSING);
            } else if (i3 == 4) {
                computer2.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            } else {
                computer2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            fabricIDV2 = new Vector();
            this.put(computer2);
            fabric_computer = new GraphFabric2Computer(fabric0ID.getID() + "+" + computerID2.getID());
            fabric_computer.setFabricID(fabric0ID);
            fabric_computer.setComputerID(computerID2);
            if (i3 == 0) {
                fabric_computer.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else if (i3 == 2 || i3 == 3) {
                fabric_computer.setHealthStatus(GraphModelConstant.STATUS_MISSING);
            } else {
                fabric_computer.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fabric_computer);
            fabricIDV2.add(fabric0ID);
            sw_computer = new GraphSwitch2Computer(sw0ID.getID() + "+" + computerID2.getID());
            sw_computer.setSwitchID(sw0ID);
            sw_computer.setComputerID(computerID2);
            if (i3 == 0) {
                sw_computer.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else if (i3 == 2 || i3 == 3) {
                sw_computer.setHealthStatus(GraphModelConstant.STATUS_MISSING);
            } else {
                sw_computer.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(sw_computer);
            sw_computer = new GraphSwitch2Computer(sw1ID.getID() + "+" + computerID2.getID());
            sw_computer.setSwitchID(sw1ID);
            sw_computer.setComputerID(computerID2);
            if (i3 == 0) {
                sw_computer.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            } else if (i3 == 2 || i3 == 3) {
                sw_computer.setHealthStatus(GraphModelConstant.STATUS_MISSING);
            } else {
                sw_computer.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(sw_computer);
            String hbawwn = this.generateWWN();
            GraphHBA hba = new GraphHBA(hbawwn);
            hbaID = (GraphHBA.ID)hba.getEntityID();
            hba.setDisplayName(hbawwn);
            hba.setWWN(hbawwn);
            if (i3 == 2 || i3 == 3) {
                hba.setHealthStatus(GraphModelConstant.STATUS_MISSING);
            } else {
                hba.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            hba.setVendor("qlogic");
            hba.setModel("qla2300");
            hba.setSerialNumber("serial# 12345");
            hba.setFirmwareVersion("firmware 123");
            hba.setDriverName("driver name abc");
            hba.setDriverVersion("driver 1.3");
            hba.setAPIVersion("api 1.2");
            this.put(hba);
            computer_hba = new GraphComputer2HBA(computerID2.getID() + "+" + hbaID.getID());
            computer_hba.setComputerID(computerID2);
            computer_hba.setHBAID(hbaID);
            if (i3 == 2 || i3 == 3) {
                computer_hba.setHealthStatus(GraphModelConstant.STATUS_MISSING);
            } else {
                computer_hba.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(computer_hba);
            wwn = this.generateWWN();
            fcport = new GraphFCPort(wwn);
            fcportID = (GraphFCPort.ID)fcport.getEntityID();
            fcport.setDisplayName(wwn);
            fcport.setName(wwn);
            if (i3 == 2 || i3 == 3) {
                fcport.setHealthStatus(GraphModelConstant.STATUS_MISSING);
            } else {
                fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fcport);
            GraphComputer2FCPort computer_fcport = new GraphComputer2FCPort(computerID2.getID() + "+" + fcportID.getID());
            computer_fcport.setComputerID(computerID2);
            computer_fcport.setFCPortID(fcportID);
            computer_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_fcport);
            GraphHBA2FCPort hba_fcport = new GraphHBA2FCPort(hbaID.getID() + "+" + fcportID.getID());
            hba_fcport.setHBAID(hbaID);
            hba_fcport.setFCPortID(fcportID);
            hba_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(hba_fcport);
            swPortID = (GraphFCPort.ID)((GraphFCPort)sw0FCPortV.get(sw0FCPortCount)).getEntityID();
            ++sw0FCPortCount;
            fcport_fcport = new GraphFCPort2FCPort(swPortID.getID() + "+" + fcportID.getID());
            fcport_fcport.setFCPort1ID(swPortID);
            fcport_fcport.setFCPort2ID(fcportID);
            if (i3 == 0) {
                fcport_fcport.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else if (i3 == 2 || i3 == 3) {
                fcport_fcport.setHealthStatus(GraphModelConstant.STATUS_MISSING);
            } else {
                fcport_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fcport_fcport);
            wwn = this.generateWWN();
            fcport = new GraphFCPort(wwn);
            fcportID = (GraphFCPort.ID)fcport.getEntityID();
            fcport.setDisplayName(wwn);
            fcport.setName(wwn);
            if (i3 == 2 || i3 == 3) {
                fcport.setHealthStatus(GraphModelConstant.STATUS_MISSING);
            } else {
                fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fcport);
            computer_fcport = new GraphComputer2FCPort(computerID2.getID() + "+" + fcportID.getID());
            computer_fcport.setComputerID(computerID2);
            computer_fcport.setFCPortID(fcportID);
            computer_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_fcport);
            hba_fcport = new GraphHBA2FCPort(hbaID.getID() + "+" + fcportID.getID());
            hba_fcport.setHBAID(hbaID);
            hba_fcport.setFCPortID(fcportID);
            hba_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(hba_fcport);
            swPortID = (GraphFCPort.ID)((GraphFCPort)sw1FCPortV.get(sw1FCPortCount)).getEntityID();
            ++sw1FCPortCount;
            fcport_fcport = new GraphFCPort2FCPort(swPortID.getID() + "+" + fcportID.getID());
            fcport_fcport.setFCPort1ID(swPortID);
            fcport_fcport.setFCPort2ID(fcportID);
            if (i3 == 2 || i3 == 3) {
                fcport_fcport.setHealthStatus(GraphModelConstant.STATUS_MISSING);
            } else {
                fcport_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fcport_fcport);
            for (int j = 0; j < 3 && (i3 % 2 != 0 || j != 1); ++j) {
                GraphVolume.ID volumeID9 = (GraphVolume.ID)((GraphVolume)subsystem0Volume1V.get(subsystem0Volume1Count)).getEntityID();
                ++subsystem0Volume1Count;
                lun = new GraphLun(computerID2.getID() + "-lun" + j);
                lunID = (GraphLun.ID)lun.getEntityID();
                lun.setDisplayName("lun" + String.valueOf(j));
                lun.setLunID(new Integer(j));
                if (i3 == 2 || i3 == 3) {
                    lun.setHealthStatus(GraphModelConstant.STATUS_MISSING);
                } else {
                    lun.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(lun);
                volume2lun = new GraphVolume2Lun(volumeID9.getID() + "+" + lunID.getID());
                volume2lun.setVolumeID(volumeID9);
                volume2lun.setLunID(lunID);
                if (i3 == 2 || i3 == 3) {
                    volume2lun.setHealthStatus(GraphModelConstant.STATUS_MISSING);
                } else {
                    volume2lun.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(volume2lun);
                computer2lun = new GraphComputer2Lun(computerID2.getID() + "+" + lunID.getID());
                computer2lun.setComputerID(computerID2);
                computer2lun.setLunID(lunID);
                computer2lun.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(computer2lun);
                computer2volume = new GraphComputer2Volume(computerID2.getID() + "+" + volumeID9.getID());
                computer2volume.setComputerID(computerID2);
                computer2volume.setVolumeID(volumeID9);
                if (i3 == 2 || i3 == 3) {
                    computer2volume.setHealthStatus(GraphModelConstant.STATUS_MISSING);
                } else {
                    computer2volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(computer2volume);
                int zz = j == 1 ? 2 : 1;
                for (int z = 0; z < zz; ++z) {
                    filesystem = new GraphFilesystem(computerID2.getID() + "-fs" + j + "-" + z);
                    filesystemID = (GraphFilesystem.ID)filesystem.getEntityID();
                    filesystem.setDisplayName("fs-" + j + "-" + z);
                    if (j == 1) {
                        filesystem.setHealthStatus(GraphModelConstant.STATUS_WARNING);
                    } else {
                        filesystem.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    }
                    this.put(filesystem);
                    GraphFilesystem2Lun filesystem2lun = new GraphFilesystem2Lun(filesystemID.getID() + "+" + lunID.getID());
                    filesystem2lun.setFilesystemID(filesystemID);
                    filesystem2lun.setLunID(lunID);
                    this.put(filesystem2lun);
                }
            }
        }
        for (i3 = 0; i3 < 40; ++i3) {
            computerIDStr2 = "computer" + this.generateComputerID();
            computer2 = new GraphComputer(computerIDStr2);
            computerID2 = (GraphComputer.ID)computer2.getEntityID();
            computer2.setDisplayName("ace" + i3);
            computer2.setOperationalStatus(new Integer(0));
            if (i3 < 30) {
                computer2.setOSType("RedHat");
                computer2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            } else {
                computer2.setOSType("WinXP");
                computer2.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            }
            computer2.setOSVersion("sp2");
            computer2.setHostname("ace" + i3 + ".almaden.ibm.com");
            computer2.setIPAddress("9.1.24." + i3);
            computer2.setGUID("tivoli-ace-" + i3);
            computer2.setAgentsInstalled("{data}");
            computer2.setUDP1("G1-123");
            computer2.setUDP2("Gauri");
            fabricIDV2 = new Vector();
            this.put(computer2);
            fabric_computer = new GraphFabric2Computer(fabric1.getEntityID().getID() + "+" + computerID2.getID());
            fabric_computer.setFabricID(fabric1ID);
            fabric_computer.setComputerID(computerID2);
            fabric_computer.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fabric_computer);
            fabricIDV2.add(fabric1ID);
            sw_computer = new GraphSwitch2Computer(sw2ID.getID() + "+" + computerID2.getID());
            sw_computer.setSwitchID(sw2ID);
            sw_computer.setComputerID(computerID2);
            sw_computer.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_computer);
            String hbawwn = this.generateWWN();
            GraphHBA hba = new GraphHBA(hbawwn);
            hbaID = (GraphHBA.ID)hba.getEntityID();
            hba.setDisplayName(hbawwn);
            hba.setWWN(hbawwn);
            hba.setVendor("QLogic");
            hba.setSerialNumber("HBA" + i3);
            hba.setModel("QLA2300");
            hba.setFirmwareVersion("firmware 123");
            hba.setDriverName("driver name abc");
            hba.setDriverVersion("driver 1.3");
            hba.setAPIVersion("api 1.2");
            hba.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(hba);
            computer_hba = new GraphComputer2HBA(computerID2.getID() + "+" + hbaID.getID());
            computer_hba.setComputerID(computerID2);
            computer_hba.setHBAID(hbaID);
            computer_hba.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_hba);
            wwn = this.generateWWN();
            fcport = new GraphFCPort(wwn);
            fcportID = (GraphFCPort.ID)fcport.getEntityID();
            fcport.setDisplayName(wwn);
            fcport.setName(wwn);
            fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport);
            GraphComputer2FCPort computer_fcport = new GraphComputer2FCPort(computerID2.getID() + "+" + fcportID.getID());
            computer_fcport.setComputerID(computerID2);
            computer_fcport.setFCPortID(fcportID);
            computer_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_fcport);
            GraphHBA2FCPort hba_fcport = new GraphHBA2FCPort(hbaID.getID() + "+" + fcportID.getID());
            hba_fcport.setHBAID(hbaID);
            hba_fcport.setFCPortID(fcportID);
            hba_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(hba_fcport);
            swPortID = (GraphFCPort.ID)((GraphFCPort)sw2FCPortV.get(sw2FCPortCount)).getEntityID();
            ++sw2FCPortCount;
            fcport_fcport = new GraphFCPort2FCPort(swPortID.getID() + "+" + fcportID.getID());
            fcport_fcport.setFCPort1ID(swPortID);
            fcport_fcport.setFCPort2ID(fcportID);
            fcport_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_fcport);
            hbawwn = this.generateWWN();
            hba = new GraphHBA(hbawwn);
            hbaID = (GraphHBA.ID)hba.getEntityID();
            hba.setDisplayName(hbawwn);
            hba.setWWN(hbawwn);
            hba.setVendor("QLogic");
            hba.setSerialNumber("HBA" + i3);
            hba.setModel("QLA2300");
            hba.setFirmwareVersion("firmware 123");
            hba.setDriverName("driver name abc");
            hba.setDriverVersion("driver 1.3");
            hba.setAPIVersion("api 1.2");
            hba.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(hba);
            computer_hba = new GraphComputer2HBA(computerID2.getID() + "+" + hbaID.getID());
            computer_hba.setComputerID(computerID2);
            computer_hba.setHBAID(hbaID);
            computer_hba.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_hba);
            wwn = this.generateWWN();
            fcport = new GraphFCPort(wwn);
            fcportID = (GraphFCPort.ID)fcport.getEntityID();
            fcport.setDisplayName(wwn);
            fcport.setName(wwn);
            fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport);
            computer_fcport = new GraphComputer2FCPort(computerID2.getID() + "+" + fcportID.getID());
            computer_fcport.setComputerID(computerID2);
            computer_fcport.setFCPortID(fcportID);
            computer_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_fcport);
            hba_fcport = new GraphHBA2FCPort(hbaID.getID() + "+" + fcportID.getID());
            hba_fcport.setHBAID(hbaID);
            hba_fcport.setFCPortID(fcportID);
            hba_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(hba_fcport);
            hbawwn = this.generateWWN();
            hba = new GraphHBA(hbawwn);
            hbaID = (GraphHBA.ID)hba.getEntityID();
            hba.setDisplayName(hbawwn);
            hba.setWWN(hbawwn);
            hba.setSerialNumber("HBA" + i3);
            hba.setModel("QLA2300");
            hba.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(hba);
            computer_hba = new GraphComputer2HBA(computerID2.getID() + "+" + hbaID.getID());
            computer_hba.setComputerID(computerID2);
            computer_hba.setHBAID(hbaID);
            computer_hba.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_hba);
        }
        Vector<GraphComputer> hg3V = new Vector<GraphComputer>();
        for (int i23 = 0; i23 < 7; ++i23) {
            String computerIDStr3 = "computer" + this.generateComputerID();
            GraphComputer computer3 = new GraphComputer(computerIDStr3);
            GraphComputer.ID computerID3 = (GraphComputer.ID)computer3.getEntityID();
            computer3.setDisplayName("blade" + i23 + ".almaden.ibm.com");
            computer3.setOperationalStatus(new Integer(0));
            computer3.setOSType("Windows2000");
            computer3.setOSVersion("Adv4");
            if (i23 == 2 || i23 == 5) {
                computer3.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else if (i23 == 4) {
                computer3.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else {
                computer3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            computer3.setHostname("blade" + i23 + ".almaden.ibm.com");
            computer3.setIPAddress("9.1.24." + i23);
            computer3.setGUID("tivoli-blade-" + i23);
            computer3.setAgentsInstalled("{data}");
            computer3.setUDP1("B3-251");
            computer3.setUDP2("Eser");
            if (i23 == 0) {
                computer3.setUDP3("Two Fabrics");
            } else if (i23 == 2) {
                computer3.setUDP3("Broken Switch FCPort");
            } else if (i23 == 4) {
                computer3.setUDP3("Slow Switch FCPort");
            } else if (i23 == 5) {
                computer3.setUDP3("Bad HBA");
            }
            Vector<GraphFabric.ID> fabricIDV12 = new Vector<GraphFabric.ID>();
            this.put(computer3);
            hg3V.add(computer3);
            GraphFabric2Computer fabric_computer2 = new GraphFabric2Computer(fabric0ID.getID() + "+" + computerID3.getID());
            fabric_computer2.setFabricID(fabric0ID);
            fabric_computer2.setComputerID(computerID3);
            fabric_computer2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fabric_computer2);
            fabricIDV12.add(fabric0ID);
            fabric_computer2 = new GraphFabric2Computer(fabric1.getEntityID().getID() + "+" + computerID3.getID());
            fabric_computer2.setFabricID(fabric1ID);
            fabric_computer2.setComputerID(computerID3);
            fabric_computer2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fabric_computer2);
            fabricIDV12.add(fabric1ID);
            GraphSwitch2Computer sw_computer2 = new GraphSwitch2Computer(sw1ID.getID() + "+" + computerID3.getID());
            sw_computer2.setSwitchID(sw1ID);
            sw_computer2.setComputerID(computerID3);
            if (i23 == 2 || i23 == 5) {
                sw_computer2.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else if (i23 == 4) {
                sw_computer2.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else {
                sw_computer2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(sw_computer2);
            sw_computer2 = new GraphSwitch2Computer(sw2ID.getID() + "+" + computerID3.getID());
            sw_computer2.setSwitchID(sw2ID);
            sw_computer2.setComputerID(computerID3);
            sw_computer2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_computer2);
            String hbawwn = this.generateWWN();
            GraphHBA hba = new GraphHBA(hbawwn);
            GraphHBA.ID hbaID2 = (GraphHBA.ID)hba.getEntityID();
            hba.setDisplayName(hbawwn);
            hba.setWWN(hbawwn);
            hba.setSerialNumber("HBA" + i23);
            hba.setModel("QLA2302");
            if (i23 == 5) {
                hba.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else {
                hba.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(hba);
            GraphComputer2HBA computer_hba2 = new GraphComputer2HBA(computerID3.getID() + "+" + hbaID2.getID());
            computer_hba2.setComputerID(computerID3);
            computer_hba2.setHBAID(hbaID2);
            computer_hba2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_hba2);
            String wwn13 = this.generateWWN();
            GraphFCPort fcport11 = new GraphFCPort(wwn13);
            GraphFCPort.ID fcportID11 = (GraphFCPort.ID)fcport11.getEntityID();
            fcport11.setDisplayName(wwn13);
            fcport11.setName(wwn13);
            if (i23 == 5) {
                fcport11.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else {
                fcport11.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fcport11);
            GraphComputer2FCPort computer_fcport = new GraphComputer2FCPort(computerID3.getID() + "+" + fcportID11.getID());
            computer_fcport.setComputerID(computerID3);
            computer_fcport.setFCPortID(fcportID11);
            computer_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_fcport);
            GraphHBA2FCPort hba_fcport = new GraphHBA2FCPort(hbaID2.getID() + "+" + fcportID11.getID());
            hba_fcport.setHBAID(hbaID2);
            hba_fcport.setFCPortID(fcportID11);
            hba_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(hba_fcport);
            GraphFCPort.ID swPortID7 = (GraphFCPort.ID)((GraphFCPort)sw1FCPortV.get(sw1FCPortCount)).getEntityID();
            ++sw1FCPortCount;
            GraphFCPort2FCPort fcport_fcport8 = new GraphFCPort2FCPort(swPortID7.getID() + "+" + fcportID11.getID());
            fcport_fcport8.setFCPort1ID(swPortID7);
            fcport_fcport8.setFCPort2ID(fcportID11);
            if (i23 == 2 || i23 == 5) {
                fcport_fcport8.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else if (i23 == 4) {
                fcport_fcport8.setHealthStatus(GraphModelConstant.STATUS_WARNING);
            } else {
                fcport_fcport8.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fcport_fcport8);
            wwn13 = this.generateWWN();
            fcport11 = new GraphFCPort(wwn13);
            fcportID11 = (GraphFCPort.ID)fcport11.getEntityID();
            fcport11.setDisplayName(wwn13);
            fcport11.setName(wwn13);
            if (i23 == 5) {
                fcport11.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else {
                fcport11.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fcport11);
            computer_fcport = new GraphComputer2FCPort(computerID3.getID() + "+" + fcportID11.getID());
            computer_fcport.setComputerID(computerID3);
            computer_fcport.setFCPortID(fcportID11);
            computer_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_fcport);
            hba_fcport = new GraphHBA2FCPort(hbaID2.getID() + "+" + fcportID11.getID());
            hba_fcport.setHBAID(hbaID2);
            hba_fcport.setFCPortID(fcportID11);
            hba_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(hba_fcport);
            swPortID7 = (GraphFCPort.ID)((GraphFCPort)sw2FCPortV.get(sw2FCPortCount)).getEntityID();
            ++sw2FCPortCount;
            fcport_fcport8 = new GraphFCPort2FCPort(swPortID7.getID() + "+" + fcportID11.getID());
            fcport_fcport8.setFCPort1ID(swPortID7);
            fcport_fcport8.setFCPort2ID(fcportID11);
            if (i23 == 5) {
                fcport_fcport8.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
            } else {
                fcport_fcport8.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            }
            this.put(fcport_fcport8);
            for (int j = 0; j < 2; ++j) {
                GraphVolume.ID volumeID10 = null;
                if (j == 0) {
                    volumeID10 = (GraphVolume.ID)((GraphVolume)subsystem1Volume0V.get(subsystem1Volume0Count)).getEntityID();
                    ++subsystem1Volume0Count;
                } else {
                    volumeID10 = (GraphVolume.ID)((GraphVolume)subsystem2Volume0V.get(subsystem2Volume0Count)).getEntityID();
                    ++subsystem2Volume0Count;
                }
                GraphLun lun2 = new GraphLun(computerID3.getID() + "-lun" + j);
                GraphLun.ID lunID2 = (GraphLun.ID)lun2.getEntityID();
                lun2.setDisplayName("lun" + String.valueOf(j));
                lun2.setLunID(new Integer(j));
                if (i23 == 5) {
                    lun2.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                } else {
                    lun2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(lun2);
                GraphVolume2Lun volume2lun2 = new GraphVolume2Lun(volumeID10.getID() + "+" + lunID2.getID());
                volume2lun2.setVolumeID(volumeID10);
                volume2lun2.setLunID(lunID2);
                if (i23 == 5) {
                    volume2lun2.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                } else {
                    volume2lun2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(volume2lun2);
                GraphComputer2Lun computer2lun2 = new GraphComputer2Lun(computerID3.getID() + "+" + lunID2.getID());
                computer2lun2.setComputerID(computerID3);
                computer2lun2.setLunID(lunID2);
                computer2lun2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(computer2lun2);
                GraphComputer2Volume computer2volume2 = new GraphComputer2Volume(computerID3.getID() + "+" + volumeID10.getID());
                computer2volume2.setComputerID(computerID3);
                computer2volume2.setVolumeID(volumeID10);
                if (i23 == 5) {
                    computer2volume2.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                } else {
                    computer2volume2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(computer2volume2);
            }
        }
        Vector<GraphComputer> hg4V = new Vector<GraphComputer>();
        for (i2 = 0; i2 < 2; ++i2) {
            int k;
            int j;
            int j2;
            GraphFCPort2FCPort fcport_fcport9;
            GraphFCPort.ID swPortID8;
            GraphComputer2FCPort computer_fcport;
            GraphFCPort.ID fcportID12;
            int j3;
            computerIDStr = "computer" + this.generateComputerID();
            computer = new GraphComputer(computerIDStr);
            computerID = (GraphComputer.ID)computer.getEntityID();
            computer.setDisplayName("sugar" + i2);
            computer.setOperationalStatus(new Integer(0));
            computer.setOSType("Windows2000");
            computer.setOSVersion("Adv4");
            computer.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            computer.setHostname("sugar" + i2);
            computer.setIPAddress("9.1.88." + i2);
            computer.setGUID("tivoli-superman-" + i2);
            computer.setAgentsInstalled("{data,fabric}");
            computer.setUDP1("B3-251");
            computer.setUDP2("Eser");
            fabricIDV = new Vector();
            this.put(computer);
            hg4V.add(computer);
            GraphFabric2Computer fabric_computer3 = new GraphFabric2Computer(fabric0ID.getID() + "+" + computerID.getID());
            fabric_computer3.setFabricID(fabric0ID);
            fabric_computer3.setComputerID(computerID);
            fabric_computer3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fabric_computer3);
            fabricIDV.add(fabric0ID);
            fabric_computer3 = new GraphFabric2Computer(fabric1.getEntityID().getID() + "+" + computerID.getID());
            fabric_computer3.setFabricID(fabric1ID);
            fabric_computer3.setComputerID(computerID);
            fabric_computer3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fabric_computer3);
            fabricIDV.add(fabric1ID);
            GraphSwitch2Computer sw_computer3 = new GraphSwitch2Computer(sw1ID.getID() + "+" + computerID.getID());
            sw_computer3.setSwitchID(sw1ID);
            sw_computer3.setComputerID(computerID);
            sw_computer3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_computer3);
            sw_computer3 = new GraphSwitch2Computer(sw2ID.getID() + "+" + computerID.getID());
            sw_computer3.setSwitchID(sw2ID);
            sw_computer3.setComputerID(computerID);
            sw_computer3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_computer3);
            String hbawwn = this.generateWWN();
            GraphHBA hba = new GraphHBA(hbawwn);
            GraphHBA.ID hbaID3 = (GraphHBA.ID)hba.getEntityID();
            hba.setDisplayName(hbawwn);
            hba.setWWN(hbawwn);
            hba.setSerialNumber("HBA0");
            hba.setModel("QLA2302");
            hba.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(hba);
            GraphComputer2HBA computer_hba3 = new GraphComputer2HBA(computerID.getID() + "+" + hbaID3.getID());
            computer_hba3.setComputerID(computerID);
            computer_hba3.setHBAID(hbaID3);
            computer_hba3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_hba3);
            for (j3 = 0; j3 < 2; ++j3) {
                String wwn14 = this.generateWWN();
                GraphFCPort fcport12 = new GraphFCPort(wwn14);
                fcportID12 = (GraphFCPort.ID)fcport12.getEntityID();
                fcport12.setDisplayName(wwn14);
                fcport12.setName(wwn14);
                fcport12.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(fcport12);
                computer_fcport = new GraphComputer2FCPort(computerID.getID() + "+" + fcportID12.getID());
                computer_fcport.setComputerID(computerID);
                computer_fcport.setFCPortID(fcportID12);
                computer_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(computer_fcport);
                GraphHBA2FCPort hba_fcport = new GraphHBA2FCPort(hbaID3.getID() + "+" + fcportID12.getID());
                hba_fcport.setHBAID(hbaID3);
                hba_fcport.setFCPortID(fcportID12);
                hba_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(hba_fcport);
                swPortID8 = (GraphFCPort.ID)((GraphFCPort)sw1FCPortV.get(sw1FCPortCount)).getEntityID();
                ++sw1FCPortCount;
                fcport_fcport9 = new GraphFCPort2FCPort(swPortID8.getID() + "+" + fcportID12.getID());
                fcport_fcport9.setFCPort1ID(swPortID8);
                fcport_fcport9.setFCPort2ID(fcportID12);
                fcport_fcport9.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(fcport_fcport9);
            }
            hbawwn = this.generateWWN();
            hba = new GraphHBA(hbawwn);
            hbaID3 = (GraphHBA.ID)hba.getEntityID();
            hba.setDisplayName(hbawwn);
            hba.setWWN(hbawwn);
            hba.setSerialNumber("HBA1");
            hba.setModel("QLA2302");
            hba.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(hba);
            computer_hba3 = new GraphComputer2HBA(computerID.getID() + "+" + hbaID3.getID());
            computer_hba3.setComputerID(computerID);
            computer_hba3.setHBAID(hbaID3);
            computer_hba3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(computer_hba3);
            for (j3 = 0; j3 < 2; ++j3) {
                String wwn15 = this.generateWWN();
                GraphFCPort fcport13 = new GraphFCPort(wwn15);
                fcportID12 = (GraphFCPort.ID)fcport13.getEntityID();
                fcport13.setDisplayName(wwn15);
                fcport13.setName(wwn15);
                fcport13.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(fcport13);
                computer_fcport = new GraphComputer2FCPort(computerID.getID() + "+" + fcportID12.getID());
                computer_fcport.setComputerID(computerID);
                computer_fcport.setFCPortID(fcportID12);
                computer_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(computer_fcport);
                GraphHBA2FCPort hba_fcport = new GraphHBA2FCPort(hbaID3.getID() + "+" + fcportID12.getID());
                hba_fcport.setHBAID(hbaID3);
                hba_fcport.setFCPortID(fcportID12);
                hba_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(hba_fcport);
                swPortID8 = (GraphFCPort.ID)((GraphFCPort)sw2FCPortV.get(sw2FCPortCount)).getEntityID();
                ++sw2FCPortCount;
                fcport_fcport9 = new GraphFCPort2FCPort(swPortID8.getID() + "+" + fcportID12.getID());
                fcport_fcport9.setFCPort1ID(swPortID8);
                fcport_fcport9.setFCPort2ID(fcportID12);
                fcport_fcport9.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(fcport_fcport9);
            }
            Vector<GraphLun> lunV = new Vector<GraphLun>();
            for (int j4 = 0; j4 < 14; ++j4) {
                GraphVolume.ID volumeID11 = null;
                if (j4 < 2) {
                    volumeID11 = (GraphVolume.ID)((GraphVolume)subsystem0Volume1V.get(subsystem0Volume1Count)).getEntityID();
                    ++subsystem0Volume1Count;
                } else if (j4 < 4) {
                    volumeID11 = (GraphVolume.ID)((GraphVolume)svc0Volume0V.get(svc0Volume0Count)).getEntityID();
                    ++svc0Volume0Count;
                } else {
                    volumeID11 = (GraphVolume.ID)((GraphVolume)subsystem2Volume0V.get(subsystem2Volume0Count)).getEntityID();
                    ++subsystem2Volume0Count;
                }
                GraphLun lun3 = new GraphLun(computerID.getID() + "-lun-" + j4);
                GraphLun.ID lunID3 = (GraphLun.ID)lun3.getEntityID();
                lun3.setDisplayName("lun-" + j4);
                lun3.setLunID(new Integer(j4));
                lun3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(lun3);
                lunV.add(lun3);
                GraphVolume2Lun volume2lun3 = new GraphVolume2Lun(volumeID11.getID() + "+" + lunID3.getID());
                volume2lun3.setVolumeID(volumeID11);
                volume2lun3.setLunID(lunID3);
                volume2lun3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(volume2lun3);
                GraphComputer2Lun computer2lun3 = new GraphComputer2Lun(computerID.getID() + "+" + lunID3.getID());
                computer2lun3.setComputerID(computerID);
                computer2lun3.setLunID(lunID3);
                computer2lun3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(computer2lun3);
                GraphComputer2Volume computer2volume3 = new GraphComputer2Volume(computerID.getID() + "+" + volumeID11.getID());
                computer2volume3.setComputerID(computerID);
                computer2volume3.setVolumeID(volumeID11);
                computer2volume3.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(computer2volume3);
            }
            Vector<GraphLogicalVolume> logicalVolumeV = new Vector<GraphLogicalVolume>();
            GraphLogicalVolumeManager lvm = new GraphLogicalVolumeManager(computerID.getID() + "lvm0");
            GraphLogicalVolumeManager.ID lvmID = (GraphLogicalVolumeManager.ID)lvm.getEntityID();
            lvm.setDisplayName("lvm0");
            lvm.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(lvm);
            GraphComputer2LogicalVolumeManager computer_lvm = new GraphComputer2LogicalVolumeManager(computerID.getID() + "+" + lvmID.getID());
            computer_lvm.setComputerID(computerID);
            computer_lvm.setLogicalVolumeManagerID(lvmID);
            this.put(computer_lvm);
            int lvCount = 0;
            for (j2 = 4; j2 < 14; ++j2) {
                GraphLun.ID lunID4 = (GraphLun.ID)((GraphLun)lunV.get(j2)).getEntityID();
                GraphLogicalVolumeManager2Lun lvm2lun = new GraphLogicalVolumeManager2Lun(lvmID.getID() + "+" + lunID4.getID());
                lvm2lun.setLogicalVolumeManagerID(lvmID);
                lvm2lun.setLunID(lunID4);
                this.put(lvm2lun);
                if (j2 >= 10) continue;
                int z = j2 < 6 ? 2 : 1;
                for (int k2 = 0; k2 < z; ++k2) {
                    GraphLogicalVolume logicalVolume = new GraphLogicalVolume(computerID.getID() + "-lv-" + lvCount);
                    GraphLogicalVolume.ID logicalVolumeID = (GraphLogicalVolume.ID)logicalVolume.getEntityID();
                    logicalVolume.setDisplayName("lv-" + lvCount);
                    logicalVolume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    ++lvCount;
                    this.put(logicalVolume);
                    logicalVolumeV.add(logicalVolume);
                    GraphComputer2LogicalVolume computer_logicalVolume = new GraphComputer2LogicalVolume(computerID.getID() + "+" + logicalVolumeID.getID());
                    computer_logicalVolume.setComputerID(computerID);
                    computer_logicalVolume.setLogicalVolumeID(logicalVolumeID);
                    this.put(computer_logicalVolume);
                    GraphLogicalVolumeManager2LogicalVolume lvm2logicalVolume = new GraphLogicalVolumeManager2LogicalVolume(lvmID.getID() + "+" + logicalVolumeID.getID());
                    lvm2logicalVolume.setLogicalVolumeManagerID(lvmID);
                    lvm2logicalVolume.setLogicalVolumeID(logicalVolumeID);
                    this.put(lvm2logicalVolume);
                    GraphLogicalVolume2Lun logicalVolume2lun = new GraphLogicalVolume2Lun(logicalVolumeID.getID() + "+" + lunID4.getID());
                    logicalVolume2lun.setLogicalVolumeID(logicalVolumeID);
                    logicalVolume2lun.setLunID(lunID4);
                    this.put(logicalVolume2lun);
                }
            }
            int filesystemCount = 0;
            Vector<GraphFilesystem> filesystemV = new Vector<GraphFilesystem>();
            for (j = 0; j < 2; ++j) {
                GraphLun.ID lunID5 = (GraphLun.ID)((GraphLun)lunV.get(j)).getEntityID();
                for (k = 0; k < (j == 0 ? 2 : 1); ++k) {
                    filesystem = new GraphFilesystem(computerID.getID() + "fs" + filesystemCount);
                    filesystemID = (GraphFilesystem.ID)filesystem.getEntityID();
                    filesystem.setDisplayName("fs" + filesystemCount);
                    filesystem.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(filesystem);
                    ++filesystemCount;
                    filesystemV.add(filesystem);
                    GraphComputer2Filesystem computer_filesystem = new GraphComputer2Filesystem(computerID.getID() + "+" + filesystemID.getID());
                    computer_filesystem.setComputerID(computerID);
                    computer_filesystem.setFilesystemID(filesystemID);
                    this.put(computer_filesystem);
                    GraphFilesystem2Lun filesystem2lun = new GraphFilesystem2Lun(filesystemID.getID() + "+" + lunID5.getID());
                    filesystem2lun.setFilesystemID(filesystemID);
                    filesystem2lun.setLunID(lunID5);
                    this.put(filesystem2lun);
                }
            }
            for (j = 0; j < 2; ++j) {
                GraphLogicalVolume.ID logicalVolumeID = (GraphLogicalVolume.ID)((GraphLogicalVolume)logicalVolumeV.get(j)).getEntityID();
                for (k = 0; k < (j == 0 ? 2 : 1); ++k) {
                    filesystem = new GraphFilesystem(computerID.getID() + "fs" + filesystemCount);
                    filesystemID = (GraphFilesystem.ID)filesystem.getEntityID();
                    filesystem.setDisplayName("fs" + filesystemCount);
                    filesystem.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(filesystem);
                    ++filesystemCount;
                    filesystemV.add(filesystem);
                    GraphComputer2Filesystem computer_filesystem = new GraphComputer2Filesystem(computerID.getID() + "+" + filesystemID.getID());
                    computer_filesystem.setComputerID(computerID);
                    computer_filesystem.setFilesystemID(filesystemID);
                    this.put(computer_filesystem);
                    GraphFilesystem2LogicalVolume filesystem2logicalVolume = new GraphFilesystem2LogicalVolume(filesystemID.getID() + "+" + logicalVolumeID.getID());
                    filesystem2logicalVolume.setFilesystemID(filesystemID);
                    filesystem2logicalVolume.setLogicalVolumeID(logicalVolumeID);
                    this.put(filesystem2logicalVolume);
                }
            }
            int databaseCount = 0;
            int tableSpaceCount = 0;
            for (j2 = 0; j2 < 2; ++j2) {
                GraphDatabaseGroup databaseGroup = new GraphDatabaseGroup(computerID.getID() + "+databaseGroup" + j2);
                GraphDatabaseGroup.ID databaseGroupID = (GraphDatabaseGroup.ID)databaseGroup.getEntityID();
                databaseGroup.setDisplayName("databaseGroup" + j2);
                databaseGroup.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(databaseGroup);
                GraphComputer2DatabaseGroup computer_databaseGroup = new GraphComputer2DatabaseGroup(computerID.getID() + "+" + databaseGroupID.getID());
                computer_databaseGroup.setComputerID(computerID);
                computer_databaseGroup.setDatabaseGroupID(databaseGroupID);
                this.put(computer_databaseGroup);
                for (int k3 = 0; k3 < 2; ++k3) {
                    GraphDatabase database = new GraphDatabase(computerID.getID() + "fs" + databaseCount);
                    GraphDatabase.ID databaseID = (GraphDatabase.ID)database.getEntityID();
                    database.setDisplayName("database" + databaseCount);
                    database.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(database);
                    ++databaseCount;
                    GraphComputer2Database computer_database = new GraphComputer2Database(computerID.getID() + "+" + databaseID.getID());
                    computer_database.setComputerID(computerID);
                    computer_database.setDatabaseID(databaseID);
                    this.put(computer_database);
                    GraphDatabaseGroup2Database databaseGroup2database = new GraphDatabaseGroup2Database(databaseGroupID.getID() + "+" + databaseID.getID());
                    databaseGroup2database.setDatabaseGroupID(databaseGroupID);
                    databaseGroup2database.setDatabaseID(databaseID);
                    this.put(databaseGroup2database);
                    for (int m = 0; m < 2; ++m) {
                        GraphTableSpace tableSpace = new GraphTableSpace(computerID.getID() + "tableSpace" + tableSpaceCount);
                        GraphTableSpace.ID tableSpaceID = (GraphTableSpace.ID)tableSpace.getEntityID();
                        tableSpace.setDisplayName("tableSpace" + tableSpaceCount);
                        tableSpace.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                        this.put(tableSpace);
                        ++tableSpaceCount;
                        GraphComputer2TableSpace computer_tableSpace = new GraphComputer2TableSpace(computerID.getID() + "+" + tableSpaceID.getID());
                        computer_tableSpace.setComputerID(computerID);
                        computer_tableSpace.setTableSpaceID(tableSpaceID);
                        this.put(computer_tableSpace);
                        GraphDatabase2TableSpace database2tableSpace = new GraphDatabase2TableSpace(databaseID.getID() + "+" + tableSpaceID.getID());
                        database2tableSpace.setDatabaseID(databaseID);
                        database2tableSpace.setTableSpaceID(tableSpaceID);
                        this.put(database2tableSpace);
                        if (k3 == 0) {
                            GraphFilesystem.ID filesystemID2 = (GraphFilesystem.ID)((GraphFilesystem)filesystemV.elementAt(j2 * 2 + k3)).getEntityID();
                            GraphTableSpace2Filesystem tableSpace2filesystem = new GraphTableSpace2Filesystem(tableSpaceID.getID() + "+" + filesystemID2.getID());
                            tableSpace2filesystem.setTableSpaceID(tableSpaceID);
                            tableSpace2filesystem.setFilesystemID(filesystemID2);
                            this.put(tableSpace2filesystem);
                            continue;
                        }
                        if (j2 == 0) {
                            GraphLun.ID lunID6 = (GraphLun.ID)((GraphLun)lunV.get(3)).getEntityID();
                            GraphTableSpace2Lun tableSpace2lun = new GraphTableSpace2Lun(tableSpaceID.getID() + "+" + lunID6.getID());
                            tableSpace2lun.setTableSpaceID(tableSpaceID);
                            tableSpace2lun.setLunID(lunID6);
                            this.put(tableSpace2lun);
                            continue;
                        }
                        GraphLogicalVolume.ID logicalVolumeID = (GraphLogicalVolume.ID)((GraphLogicalVolume)logicalVolumeV.get(3)).getEntityID();
                        GraphTableSpace2LogicalVolume tableSpace2logicalVolume = new GraphTableSpace2LogicalVolume(tableSpaceID.getID() + "+" + logicalVolumeID.getID());
                        tableSpace2logicalVolume.setTableSpaceID(tableSpaceID);
                        tableSpace2logicalVolume.setLogicalVolumeID(logicalVolumeID);
                        this.put(tableSpace2logicalVolume);
                    }
                }
            }
        }
        for (i2 = 0; i2 < 4; ++i2) {
            computerIDStr = "computer" + this.generateComputerID();
            computer = new GraphComputer(computerIDStr);
            computerID = (GraphComputer.ID)computer.getEntityID();
            switch (i2) {
                case 0: {
                    computer.setDisplayName("monkey");
                    break;
                }
                case 1: {
                    computer.setDisplayName("rabbit");
                    break;
                }
                case 2: {
                    computer.setDisplayName("elepant");
                    break;
                }
                case 3: {
                    computer.setDisplayName("snake");
                }
            }
            computer.setOperationalStatus(new Integer(0));
            computer.setOSType("WinXP");
            computer.setOSVersion("SP2");
            computer.setHostname(computer.getDisplayName());
            computer.setIPAddress("9.1.25." + i2);
            computer.setGUID("tivoli-isolated-" + i2);
            computer.setAgentsInstalled("{data}");
            computer.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            computer.setUDP2("WSPO");
            fabricIDV = new Vector<GraphFabric.ID>();
            this.put(computer);
        }
        Vector<GraphTapeLibrary> tapeLibraryV = new Vector<GraphTapeLibrary>();
        for (int i24 = 0; i24 < 1; ++i24) {
            int k;
            int j;
            int j5;
            String tapeLibraryIDStr = "tapeLibrary" + this.generateTapeLibraryID();
            GraphTapeLibrary tapeLibrary = new GraphTapeLibrary(tapeLibraryIDStr);
            GraphTapeLibrary.ID tapeLibraryID = (GraphTapeLibrary.ID)tapeLibrary.getEntityID();
            tapeLibrary.setDisplayName("patriots");
            tapeLibrary.setVendor("IBM");
            tapeLibrary.setModel("3510");
            tapeLibrary.setSerialNumber("323222b");
            tapeLibrary.setFirmwareVersion("1.2.3");
            tapeLibrary.setNumOfDrives(new Integer(4));
            tapeLibrary.setNumOfCartridges(new Integer(128));
            tapeLibrary.setMaxNumOfCartridges(new Integer(512));
            tapeLibrary.setElementManager("http://9.22.12.10");
            tapeLibrary.setUDP1("TSM-Almaden");
            tapeLibrary.setUDP2("Madhukar");
            tapeLibrary.setUDP3("Conneciton change");
            tapeLibrary.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(tapeLibrary);
            Vector<GraphFabric.ID> fabricIDV13 = new Vector<GraphFabric.ID>();
            tapeLibraryV.add(tapeLibrary);
            GraphFabric2TapeLibrary fabric0_tapeLibrary = new GraphFabric2TapeLibrary(fabric0.getEntityID().getID() + "+" + tapeLibraryID.getID());
            fabric0_tapeLibrary.setFabricID(fabric0ID);
            fabric0_tapeLibrary.setTapeLibraryID(tapeLibraryID);
            fabric0_tapeLibrary.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fabric0_tapeLibrary);
            fabricIDV13.add(fabric0ID);
            for (j5 = 0; j5 < 4; ++j5) {
                GraphSwitch2TapeLibrary sw0_tapeLibrary = new GraphSwitch2TapeLibrary(sw0ID.getID() + "+" + tapeLibraryID.getID() + "+" + j5);
                sw0_tapeLibrary.setSwitchID(sw0ID);
                sw0_tapeLibrary.setTapeLibraryID(tapeLibraryID);
                sw0_tapeLibrary.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(sw0_tapeLibrary);
            }
            for (j5 = 0; j5 < 4; ++j5) {
                GraphSwitch2TapeLibrary sw1_tapeLibrary = new GraphSwitch2TapeLibrary(sw1ID.getID() + "+" + tapeLibraryID.getID() + "+" + j5);
                sw1_tapeLibrary.setSwitchID(sw1ID);
                sw1_tapeLibrary.setTapeLibraryID(tapeLibraryID);
                sw1_tapeLibrary.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(sw1_tapeLibrary);
            }
            Vector<GraphTapeDrive> tapeDriveV = new Vector<GraphTapeDrive>();
            int tapeDriveCount = 0;
            for (j = 0; j < 4; ++j) {
                String tapeDriveIDStr = "tapeDrive" + this.generateTapeDriveID();
                GraphTapeDrive tapeDrive = new GraphTapeDrive(tapeDriveIDStr);
                GraphTapeDrive.ID tapeDriveID = (GraphTapeDrive.ID)tapeDrive.getEntityID();
                tapeDrive.setDisplayName("Drive " + j);
                tapeDrive.setNeedCleaning(Boolean.FALSE);
                if (j < 2) {
                    tapeDrive.setHealthStatus(GraphModelConstant.STATUS_WARNING);
                } else {
                    tapeDrive.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(tapeDrive);
                tapeDriveV.add(tapeDrive);
                GraphTapeLibrary2TapeDrive tapeLibrary_tapeDrive = new GraphTapeLibrary2TapeDrive(tapeLibraryID.getID() + "+" + tapeDriveID.getID());
                tapeLibrary_tapeDrive.setTapeLibraryID(tapeLibraryID);
                tapeLibrary_tapeDrive.setTapeDriveID(tapeDriveID);
                tapeLibrary_tapeDrive.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(tapeLibrary_tapeDrive);
                for (k = 0; k < 2; ++k) {
                    GraphFCPort2FCPort fcport_fcport10;
                    String wwn16 = this.generateWWN();
                    GraphFCPort fcport14 = new GraphFCPort(wwn16);
                    GraphFCPort.ID fcportID13 = (GraphFCPort.ID)fcport14.getEntityID();
                    fcport14.setDisplayName(wwn16);
                    fcport14.setName(wwn16);
                    fcport14.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(fcport14);
                    GraphTapeLibrary2FCPort tapeLibrary_fcport = new GraphTapeLibrary2FCPort(tapeLibraryID.getID() + "+" + fcportID13.getID());
                    tapeLibrary_fcport.setTapeLibraryID(tapeLibraryID);
                    tapeLibrary_fcport.setFCPortID(fcportID13);
                    tapeLibrary_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(tapeLibrary_fcport);
                    GraphTapeDrive2FCPort tapeDrive_fcport = new GraphTapeDrive2FCPort(tapeDriveID.getID() + "+" + fcportID13.getID());
                    tapeDrive_fcport.setTapeDriveID(tapeDriveID);
                    tapeDrive_fcport.setFCPortID(fcportID13);
                    tapeDrive_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(tapeDrive_fcport);
                    if (k == 0) {
                        GraphFCPort.ID sw0PortID2 = (GraphFCPort.ID)((GraphFCPort)sw0FCPortV.get(sw0FCPortCount)).getEntityID();
                        ++sw0FCPortCount;
                        fcport_fcport10 = new GraphFCPort2FCPort(sw0PortID2.getID() + "+" + fcportID13.getID());
                        fcport_fcport10.setFCPort1ID(sw0PortID2);
                        fcport_fcport10.setFCPort2ID(fcportID13);
                        fcport_fcport10.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                        this.put(fcport_fcport10);
                        continue;
                    }
                    GraphFCPort.ID sw1PortID2 = (GraphFCPort.ID)((GraphFCPort)sw1FCPortV.get(sw1FCPortCount)).getEntityID();
                    ++sw1FCPortCount;
                    fcport_fcport10 = new GraphFCPort2FCPort(sw1PortID2.getID() + "+" + fcportID13.getID());
                    fcport_fcport10.setFCPort1ID(sw1PortID2);
                    fcport_fcport10.setFCPort2ID(fcportID13);
                    fcport_fcport10.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(fcport_fcport10);
                }
            }
            for (j = 0; j < 2; ++j) {
                GraphMediaChanger2TapeDrive mediaChanger_tapeDrive;
                GraphTapeDrive.ID tapeDriveID;
                String mediaChangerIDStr = "mediaChanger" + this.generateMediaChangerID();
                GraphMediaChanger mediaChanger = new GraphMediaChanger(mediaChangerIDStr);
                GraphMediaChanger.ID mediaChangerID = (GraphMediaChanger.ID)mediaChanger.getEntityID();
                mediaChanger.setDisplayName("MediaChanger " + j);
                mediaChanger.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(mediaChanger);
                GraphTapeLibrary2MediaChanger tapeLibrary_mediaChanger = new GraphTapeLibrary2MediaChanger(tapeLibraryID.getID() + "+" + mediaChangerID.getID());
                tapeLibrary_mediaChanger.setTapeLibraryID(tapeLibraryID);
                tapeLibrary_mediaChanger.setMediaChangerID(mediaChangerID);
                tapeLibrary_mediaChanger.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(tapeLibrary_mediaChanger);
                if (j == 0) {
                    for (k = 0; k < 2; ++k) {
                        tapeDriveID = (GraphTapeDrive.ID)((GraphTapeDrive)tapeDriveV.get(tapeDriveCount)).getEntityID();
                        ++tapeDriveCount;
                        mediaChanger_tapeDrive = new GraphMediaChanger2TapeDrive(mediaChangerID.getID() + "+" + tapeDriveID.getID());
                        mediaChanger_tapeDrive.setMediaChangerID(mediaChangerID);
                        mediaChanger_tapeDrive.setTapeDriveID(tapeDriveID);
                        mediaChanger_tapeDrive.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                        this.put(mediaChanger_tapeDrive);
                    }
                    continue;
                }
                for (k = 0; k < 2; ++k) {
                    tapeDriveID = (GraphTapeDrive.ID)((GraphTapeDrive)tapeDriveV.get(tapeDriveCount)).getEntityID();
                    ++tapeDriveCount;
                    mediaChanger_tapeDrive = new GraphMediaChanger2TapeDrive(mediaChangerID.getID() + "+" + tapeDriveID.getID());
                    mediaChanger_tapeDrive.setMediaChangerID(mediaChangerID);
                    mediaChanger_tapeDrive.setTapeDriveID(tapeDriveID);
                    mediaChanger_tapeDrive.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(mediaChanger_tapeDrive);
                }
            }
        }
        Vector<GraphTapeLibrary> tapeLibrary2V = new Vector<GraphTapeLibrary>();
        for (i = 0; i < 1; ++i) {
            int k;
            int j;
            String tapeLibraryIDStr = "tapeLibrary" + this.generateTapeLibraryID();
            GraphTapeLibrary tapeLibrary = new GraphTapeLibrary(tapeLibraryIDStr);
            GraphTapeLibrary.ID tapeLibraryID = (GraphTapeLibrary.ID)tapeLibrary.getEntityID();
            tapeLibrary.setDisplayName("Astro");
            tapeLibrary.setVendor("IBM");
            tapeLibrary.setModel("3512");
            tapeLibrary.setSerialNumber("888765");
            tapeLibrary.setFirmwareVersion("1.2.3");
            tapeLibrary.setNumOfDrives(new Integer(16));
            tapeLibrary.setNumOfCartridges(new Integer(512));
            tapeLibrary.setMaxNumOfCartridges(new Integer(2048));
            tapeLibrary.setElementManager("http://9.22.12.11");
            tapeLibrary.setUDP1("TSM-Watson");
            tapeLibrary.setUDP2("Madhukar");
            tapeLibrary.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(tapeLibrary);
            Vector<GraphFabric.ID> fabricIDV14 = new Vector<GraphFabric.ID>();
            tapeLibrary2V.add(tapeLibrary);
            fabric1_tapeLibrary = new GraphFabric2TapeLibrary(fabric1.getEntityID().getID() + "+" + tapeLibraryID.getID());
            fabric1_tapeLibrary.setFabricID(fabric1ID);
            fabric1_tapeLibrary.setTapeLibraryID(tapeLibraryID);
            fabric1_tapeLibrary.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fabric1_tapeLibrary);
            fabricIDV14.add(fabric0ID);
            for (int j6 = 0; j6 < 16; ++j6) {
                GraphSwitch2TapeLibrary sw2_tapeLibrary = new GraphSwitch2TapeLibrary(sw2ID.getID() + "+" + tapeLibraryID.getID() + "+" + j6);
                sw2_tapeLibrary.setSwitchID(sw2ID);
                sw2_tapeLibrary.setTapeLibraryID(tapeLibraryID);
                sw2_tapeLibrary.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(sw2_tapeLibrary);
            }
            Vector<GraphTapeDrive> tapeDriveV = new Vector<GraphTapeDrive>();
            int tapeDriveCount = 0;
            for (j = 0; j < 16; ++j) {
                String tapeDriveIDStr = "tapeDrive" + this.generateTapeDriveID();
                GraphTapeDrive tapeDrive = new GraphTapeDrive(tapeDriveIDStr);
                GraphTapeDrive.ID tapeDriveID = (GraphTapeDrive.ID)tapeDrive.getEntityID();
                tapeDrive.setDisplayName("Drive " + j);
                tapeDrive.setNeedCleaning(Boolean.FALSE);
                if (j < 2) {
                    tapeDrive.setHealthStatus(GraphModelConstant.STATUS_WARNING);
                } else {
                    tapeDrive.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(tapeDrive);
                tapeDriveV.add(tapeDrive);
                GraphTapeLibrary2TapeDrive tape_tapeDrive = new GraphTapeLibrary2TapeDrive(tapeLibraryID.getID() + "+" + tapeDriveID.getID());
                tape_tapeDrive.setTapeLibraryID(tapeLibraryID);
                tape_tapeDrive.setTapeDriveID(tapeDriveID);
                tape_tapeDrive.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(tape_tapeDrive);
                for (k = 0; k < 1; ++k) {
                    String wwn17 = this.generateWWN();
                    GraphFCPort fcport15 = new GraphFCPort(wwn17);
                    GraphFCPort.ID fcportID14 = (GraphFCPort.ID)fcport15.getEntityID();
                    fcport15.setDisplayName(wwn17);
                    fcport15.setName(wwn17);
                    fcport15.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(fcport15);
                    GraphTapeLibrary2FCPort tape_fcport = new GraphTapeLibrary2FCPort(tapeLibraryID.getID() + "+" + fcportID14.getID());
                    tape_fcport.setTapeLibraryID(tapeLibraryID);
                    tape_fcport.setFCPortID(fcportID14);
                    tape_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(tape_fcport);
                    GraphTapeDrive2FCPort tapeDrive_fcport = new GraphTapeDrive2FCPort(tapeDriveID.getID() + "+" + fcportID14.getID());
                    tapeDrive_fcport.setTapeDriveID(tapeDriveID);
                    tapeDrive_fcport.setFCPortID(fcportID14);
                    tapeDrive_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(tapeDrive_fcport);
                    GraphFCPort.ID sw2PortID = (GraphFCPort.ID)((GraphFCPort)sw2FCPortV.get(sw1FCPortCount)).getEntityID();
                    ++sw2FCPortCount;
                    GraphFCPort2FCPort fcport_fcport11 = new GraphFCPort2FCPort(sw2PortID.getID() + "+" + fcportID14.getID());
                    fcport_fcport11.setFCPort1ID(sw2PortID);
                    fcport_fcport11.setFCPort2ID(fcportID14);
                    fcport_fcport11.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(fcport_fcport11);
                }
            }
            for (j = 0; j < 2; ++j) {
                GraphMediaChanger2TapeDrive mediaChanger_tapeDrive;
                GraphTapeDrive.ID tapeDriveID;
                String mediaChangerIDStr = "mediaChanger" + this.generateMediaChangerID();
                GraphMediaChanger mediaChanger = new GraphMediaChanger(mediaChangerIDStr);
                GraphMediaChanger.ID mediaChangerID = (GraphMediaChanger.ID)mediaChanger.getEntityID();
                mediaChanger.setDisplayName("MediaChanger " + j);
                if (j == 0) {
                    mediaChanger.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                } else {
                    mediaChanger.setHealthStatus(GraphModelConstant.STATUS_WARNING);
                }
                this.put(mediaChanger);
                GraphTapeLibrary2MediaChanger tape_mediaChanger = new GraphTapeLibrary2MediaChanger(tapeLibraryID.getID() + "+" + mediaChangerID.getID());
                tape_mediaChanger.setTapeLibraryID(tapeLibraryID);
                tape_mediaChanger.setMediaChangerID(mediaChangerID);
                tape_mediaChanger.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(tape_mediaChanger);
                if (j == 0) {
                    for (k = 0; k < 2; ++k) {
                        tapeDriveID = (GraphTapeDrive.ID)((GraphTapeDrive)tapeDriveV.get(tapeDriveCount)).getEntityID();
                        ++tapeDriveCount;
                        mediaChanger_tapeDrive = new GraphMediaChanger2TapeDrive(mediaChangerID.getID() + "+" + tapeDriveID.getID());
                        mediaChanger_tapeDrive.setMediaChangerID(mediaChangerID);
                        mediaChanger_tapeDrive.setTapeDriveID(tapeDriveID);
                        mediaChanger_tapeDrive.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                        this.put(mediaChanger_tapeDrive);
                    }
                    continue;
                }
                for (k = 0; k < 2; ++k) {
                    tapeDriveID = (GraphTapeDrive.ID)((GraphTapeDrive)tapeDriveV.get(tapeDriveCount)).getEntityID();
                    ++tapeDriveCount;
                    mediaChanger_tapeDrive = new GraphMediaChanger2TapeDrive(mediaChangerID.getID() + "+" + tapeDriveID.getID());
                    mediaChanger_tapeDrive.setMediaChangerID(mediaChangerID);
                    mediaChanger_tapeDrive.setTapeDriveID(tapeDriveID);
                    mediaChanger_tapeDrive.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    this.put(mediaChanger_tapeDrive);
                }
            }
        }
        for (i = 0; i < 1; ++i) {
            int j;
            String tapeIDStr = "tapeLibrary" + this.generateTapeLibraryID();
            GraphTapeLibrary tape = new GraphTapeLibrary(tapeIDStr);
            GraphTapeLibrary.ID tapeID = (GraphTapeLibrary.ID)tape.getEntityID();
            tape.setDisplayName("WhiteSox");
            tape.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(tape);
            Vector<GraphFabric.ID> fabricIDV15 = new Vector<GraphFabric.ID>();
            fabric1_tapeLibrary = new GraphFabric2TapeLibrary(fabric1.getEntityID().getID() + "+" + tapeID.getID());
            fabric1_tapeLibrary.setFabricID(fabric1ID);
            fabric1_tapeLibrary.setTapeLibraryID(tapeID);
            fabric1_tapeLibrary.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fabric1_tapeLibrary);
            fabricIDV15.add(fabric1ID);
            for (j = 0; j < 2; ++j) {
                GraphSwitch2TapeLibrary sw2_tapeLibrary = new GraphSwitch2TapeLibrary(sw2ID.getID() + "+" + tapeID.getID() + "+" + j);
                sw2_tapeLibrary.setSwitchID(sw2ID);
                sw2_tapeLibrary.setTapeLibraryID(tapeID);
                sw2_tapeLibrary.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(sw2_tapeLibrary);
            }
            for (j = 0; j < 2; ++j) {
                String wwn18 = this.generateWWN();
                GraphFCPort fcport16 = new GraphFCPort(wwn18);
                GraphFCPort.ID fcportID15 = (GraphFCPort.ID)fcport16.getEntityID();
                fcport16.setDisplayName(wwn18);
                fcport16.setName(wwn18);
                fcport16.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(fcport16);
                GraphTapeLibrary2FCPort tapeLibrary_fcport = new GraphTapeLibrary2FCPort(tapeID.getID() + "+" + fcportID15.getID());
                tapeLibrary_fcport.setTapeLibraryID(tapeID);
                tapeLibrary_fcport.setFCPortID(fcportID15);
                tapeLibrary_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(tapeLibrary_fcport);
                GraphFCPort.ID swPortID9 = (GraphFCPort.ID)((GraphFCPort)sw2FCPortV.get(sw2FCPortCount)).getEntityID();
                ++sw2FCPortCount;
                GraphFCPort2FCPort fcport_fcport12 = new GraphFCPort2FCPort(swPortID9.getID() + "+" + fcportID15.getID());
                fcport_fcport12.setFCPort1ID(swPortID9);
                fcport_fcport12.setFCPort2ID(fcportID15);
                fcport_fcport12.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                this.put(fcport_fcport12);
            }
        }
        Vector<GraphOther> otherV = new Vector<GraphOther>();
        for (int i25 = 0; i25 < 2; ++i25) {
            String wwn19 = this.generateWWN();
            String otherIDStr = "other" + this.generateOtherID();
            GraphOther other = new GraphOther(otherIDStr);
            GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
            other.setDisplayName(wwn19);
            other.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            other.setUDP1("B3-251");
            other.setUDP2("Danny");
            this.put(other);
            Vector<GraphFabric.ID> fabricIDV16 = new Vector<GraphFabric.ID>();
            otherV.add(other);
            GraphFabric2Other fabric_other = new GraphFabric2Other(fabric0.getEntityID().getID() + "+" + otherID.getID());
            fabric_other.setFabricID(fabric0ID);
            fabric_other.setOtherID(otherID);
            fabric_other.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fabric_other);
            fabricIDV16.add(fabric0ID);
            GraphSwitch2Other sw_other = new GraphSwitch2Other(sw0ID.getID() + "+" + otherID.getID());
            sw_other.setSwitchID(sw0ID);
            sw_other.setOtherID(otherID);
            sw_other.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_other);
            GraphFCPort fcport17 = new GraphFCPort(wwn19);
            GraphFCPort.ID fcportID16 = (GraphFCPort.ID)fcport17.getEntityID();
            fcport17.setDisplayName(wwn19);
            fcport17.setName(wwn19);
            fcport17.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport17);
            GraphOther2FCPort other_fcport = new GraphOther2FCPort(otherID.getID() + "+" + fcportID16.getID());
            other_fcport.setOtherID(otherID);
            other_fcport.setFCPortID(fcportID16);
            other_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(other_fcport);
            GraphFCPort.ID swPortID10 = (GraphFCPort.ID)((GraphFCPort)sw0FCPortV.get(sw0FCPortCount)).getEntityID();
            ++sw0FCPortCount;
            GraphFCPort2FCPort fcport_fcport13 = new GraphFCPort2FCPort(swPortID10.getID() + "+" + fcportID16.getID());
            fcport_fcport13.setFCPort1ID(swPortID10);
            fcport_fcport13.setFCPort2ID(fcportID16);
            fcport_fcport13.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_fcport13);
            for (int j = 0; j < 2; ++j) {
                GraphVolume.ID volumeID12 = (GraphVolume.ID)((GraphVolume)subsystem0Volume0V.get(subsystem0Volume0Count)).getEntityID();
                ++subsystem0Volume0Count;
                GraphLun lun4 = new GraphLun(otherID.getID() + "-lun" + j);
                GraphLun.ID lunID7 = (GraphLun.ID)lun4.getEntityID();
                lun4.setDisplayName("lun" + String.valueOf(j));
                lun4.setLunID(new Integer(j));
                if (i25 == 0) {
                    lun4.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                } else {
                    lun4.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(lun4);
                GraphVolume2Lun volume2lun4 = new GraphVolume2Lun(volumeID12.getID() + "+" + lunID7.getID());
                volume2lun4.setVolumeID(volumeID12);
                volume2lun4.setLunID(lunID7);
                if (i25 == 0) {
                    volume2lun4.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                } else {
                    volume2lun4.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(volume2lun4);
                GraphOther2Lun other2lun = new GraphOther2Lun(otherID.getID() + "+" + lunID7.getID());
                other2lun.setOtherID(otherID);
                other2lun.setLunID(lunID7);
                if (i25 == 0) {
                    other2lun.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                } else {
                    other2lun.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(other2lun);
                GraphOther2Volume other2volume = new GraphOther2Volume(otherID.getID() + "+" + volumeID12.getID());
                other2volume.setOtherID(otherID);
                other2volume.setVolumeID(volumeID12);
                if (i25 == 0) {
                    other2volume.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                } else {
                    other2volume.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                }
                this.put(other2volume);
            }
        }
        Vector other2V = new Vector();
        for (int i26 = 0; i26 < 20; ++i26) {
            String wwn20 = this.generateWWN();
            String otherIDStr = "other" + this.generateOtherID();
            GraphOther other = new GraphOther(otherIDStr);
            GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
            other.setDisplayName(wwn20);
            other.setUDP2("Ramani");
            other.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            this.put(other);
            Vector<GraphFabric.ID> fabricIDV17 = new Vector<GraphFabric.ID>();
            otherV.add(other);
            GraphFabric2Other fabric_other = new GraphFabric2Other(fabric1.getEntityID().getID() + "+" + otherID.getID());
            fabric_other.setFabricID(fabric1ID);
            fabric_other.setOtherID(otherID);
            fabric_other.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fabric_other);
            fabricIDV17.add(fabric0ID);
            GraphSwitch2Other sw_other = new GraphSwitch2Other(sw2ID.getID() + "+" + otherID.getID());
            sw_other.setSwitchID(sw2ID);
            sw_other.setOtherID(otherID);
            sw_other.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(sw_other);
            GraphFCPort fcport18 = new GraphFCPort(wwn20);
            GraphFCPort.ID fcportID17 = (GraphFCPort.ID)fcport18.getEntityID();
            fcport18.setDisplayName(wwn20);
            fcport18.setName(wwn20);
            fcport18.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport18);
            GraphOther2FCPort other_fcport = new GraphOther2FCPort(otherID.getID() + "+" + fcportID17.getID());
            other_fcport.setOtherID(otherID);
            other_fcport.setFCPortID(fcportID17);
            other_fcport.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(other_fcport);
            GraphFCPort.ID swPortID11 = (GraphFCPort.ID)((GraphFCPort)sw2FCPortV.get(sw2FCPortCount)).getEntityID();
            ++sw2FCPortCount;
            GraphFCPort2FCPort fcport_fcport14 = new GraphFCPort2FCPort(swPortID11.getID() + "+" + fcportID17.getID());
            fcport_fcport14.setFCPort1ID(swPortID11);
            fcport_fcport14.setFCPort2ID(fcportID17);
            fcport_fcport14.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
            this.put(fcport_fcport14);
        }
        GraphZoneFabric zfabric = new GraphZoneFabric(fabric0ID.getID().toString());
        GraphZoneFabric.ID zfabricID = (GraphZoneFabric.ID)zfabric.getEntityID();
        zfabric.setFabricID(fabric0ID);
        zfabric.setDisplayName(fabric0.getDisplayName());
        this.put(zfabric);
        String zsetIDStr = "zset" + this.generateZsetID();
        String zsetName = "Gold";
        GraphZoneSet zset = new GraphZoneSet(zsetIDStr);
        GraphZoneSet.ID zsetID = (GraphZoneSet.ID)zset.getEntityID();
        zset.setDisplayName(zsetName);
        zset.setActive(Boolean.TRUE);
        this.put(zset);
        GraphZoneFabric2ZoneSet zfabric2zset = new GraphZoneFabric2ZoneSet(zfabric.getEntityID() + "+" + zset.getEntityID());
        zfabric2zset.setZoneFabricID(zfabricID);
        zfabric2zset.setZoneSetID(zsetID);
        this.put(zfabric2zset);
        HashSet<GraphFCPort> swFCPortHS = new HashSet<GraphFCPort>();
        String zoneIDStr = "zone" + this.generateZoneID();
        String zoneName = "ComputerZone";
        GraphZone zone = new GraphZone(zoneIDStr);
        GraphZone.ID zoneID = (GraphZone.ID)zone.getEntityID();
        zone.setDisplayName(zoneName);
        zone.setActive(Boolean.TRUE);
        this.put(zone);
        GraphZoneFabric2Zone zfabric2zone = new GraphZoneFabric2Zone(zfabricID.getID() + "+" + zoneID.getID());
        zfabric2zone.setZoneFabricID(zfabricID);
        zfabric2zone.setZoneID(zoneID);
        this.put(zfabric2zone);
        GraphZoneSet2Zone zset2zone = new GraphZoneSet2Zone(zsetID.getID() + "+" + zoneID.getID());
        zset2zone.setZoneSetID(zsetID);
        zset2zone.setZoneID(zoneID);
        this.put(zset2zone);
        for (int i27 = 0; i27 < 3; ++i27) {
            GraphComputer computer4 = (GraphComputer)hg3V.elementAt(i27);
            GraphComputer.ID computerID4 = (GraphComputer.ID)computer4.getEntityID();
            Enumeration enu = this.associator(GraphComputer2FCPort.TYPE, computerID4);
            while (enu.hasMoreElements()) {
                GraphFCPort fcp3 = (GraphFCPort)enu.nextElement();
                GraphFCPort.ID fcpID2 = (GraphFCPort.ID)fcp3.getEntityID();
                Enumeration enu23 = this.associator(GraphFCPort2FCPort.TYPE, fcpID2);
                while (enu23.hasMoreElements()) {
                    GraphFCPort swfcp = (GraphFCPort)enu23.nextElement();
                    GraphFCPort.ID swfcpID = (GraphFCPort.ID)swfcp.getEntityID();
                    Enumeration enu32 = this.associator(GraphSwitch2FCPort.TYPE, swfcpID);
                    while (enu32.hasMoreElements()) {
                        GraphSwitch sw = (GraphSwitch)enu32.nextElement();
                        GraphSwitch.ID swID2 = (GraphSwitch.ID)sw.getEntityID();
                        Enumeration enu42 = this.associatorID(GraphFabric2Switch.TYPE, swID2);
                        while (enu42.hasMoreElements()) {
                            GraphFabric.ID xxID2 = (GraphFabric.ID)enu42.nextElement();
                            if (!xxID2.equals(fabric0ID)) continue;
                            GraphZoneMember zmem = new GraphZoneMember(computerID4.getID() + "+" + fcpID2.getID());
                            GraphZoneMember.ID zmemID2 = (GraphZoneMember.ID)zmem.getEntityID();
                            zmem.setDisplayName(zmemID2.getID().toString());
                            zmem.setFCPortID(fcpID2);
                            zmem.setFCPortLabel(fcp3.getDisplayName());
                            zmem.setFCPortPortNumber(fcp3.getPortNumber());
                            zmem.setParentID(computerID4);
                            zmem.setParentLabel(computer4.getDisplayName());
                            this.put(zmem);
                            GraphZone2ZoneMember zone2zmem2 = new GraphZone2ZoneMember(zoneID.getID() + "+" + zmemID2.getID());
                            zone2zmem2.setZoneID(zoneID);
                            zone2zmem2.setZoneMemberID(zmemID2);
                            this.put(zone2zmem2);
                            swFCPortHS.add(swfcp);
                            zmem = new GraphZoneMember(swID2.getID() + "+" + swfcpID.getID());
                            zmemID2 = (GraphZoneMember.ID)zmem.getEntityID();
                            zmem.setDisplayName(zmemID2.getID().toString());
                            zmem.setFCPortID(swfcpID);
                            zmem.setFCPortLabel(swfcp.getDisplayName());
                            zmem.setFCPortPortNumber(swfcp.getPortNumber());
                            zmem.setParentID(swID2);
                            zmem.setParentLabel(sw.getDisplayName());
                            this.put(zmem);
                            zone2zmem2 = new GraphZone2ZoneMember(zoneID.getID() + "+" + zmemID2.getID());
                            zone2zmem2.setZoneID(zoneID);
                            zone2zmem2.setZoneMemberID(zmemID2);
                            this.put(zone2zmem2);
                        }
                    }
                }
            }
        }
        zoneIDStr = "zone" + this.generateZoneID();
        zoneName = "SubsystemZone";
        zone = new GraphZone(zoneIDStr);
        zoneID = (GraphZone.ID)zone.getEntityID();
        zone.setDisplayName(zoneName);
        zone.setActive(Boolean.TRUE);
        this.put(zone);
        zfabric2zone = new GraphZoneFabric2Zone(zfabricID.getID() + "+" + zoneID.getID());
        zfabric2zone.setZoneFabricID(zfabricID);
        zfabric2zone.setZoneID(zoneID);
        this.put(zfabric2zone);
        zset2zone = new GraphZoneSet2Zone(zsetID.getID() + "+" + zoneID.getID());
        zset2zone.setZoneSetID(zsetID);
        zset2zone.setZoneID(zoneID);
        this.put(zset2zone);
        GraphSubsystem subsystem = subsystem0;
        GraphSubsystem.ID subsystemID = subsystem0ID;
        Enumeration enu = this.associator(GraphSubsystem2FCPort.TYPE, subsystemID);
        while (enu.hasMoreElements()) {
            fcp2 = (GraphFCPort)enu.nextElement();
            GraphFCPort.ID fcpID3 = (GraphFCPort.ID)fcp2.getEntityID();
            enu22 = this.associator(GraphFCPort2FCPort.TYPE, fcpID3);
            while (enu22.hasMoreElements()) {
                GraphFCPort swfcp = (GraphFCPort)enu22.nextElement();
                GraphFCPort.ID swfcpID = (GraphFCPort.ID)swfcp.getEntityID();
                Enumeration enu33 = this.associator(GraphSwitch2FCPort.TYPE, swfcpID);
                while (enu33.hasMoreElements()) {
                    GraphSwitch sw = (GraphSwitch)enu33.nextElement();
                    GraphSwitch.ID swID3 = (GraphSwitch.ID)sw.getEntityID();
                    Enumeration enu43 = this.associatorID(GraphFabric2Switch.TYPE, swID3);
                    while (enu43.hasMoreElements()) {
                        GraphFabric.ID xxID3 = (GraphFabric.ID)enu43.nextElement();
                        if (!xxID3.equals(fabric0ID)) continue;
                        swFCPortHS.add(swfcp);
                        GraphZoneMember zmem = new GraphZoneMember(subsystemID.getID() + "+" + fcpID3.getID());
                        GraphZoneMember.ID zmemID3 = (GraphZoneMember.ID)zmem.getEntityID();
                        zmem.setDisplayName(zmemID3.getID().toString());
                        zmem.setFCPortID(fcpID3);
                        zmem.setFCPortLabel(fcp2.getDisplayName());
                        zmem.setFCPortPortNumber(fcp2.getPortNumber());
                        zmem.setParentID(subsystemID);
                        zmem.setParentLabel(subsystem.getDisplayName());
                        this.put(zmem);
                        GraphZone2ZoneMember zone2zmem3 = new GraphZone2ZoneMember(zoneID.getID() + "+" + zmemID3.getID());
                        zone2zmem3.setZoneID(zoneID);
                        zone2zmem3.setZoneMemberID(zmemID3);
                        this.put(zone2zmem3);
                        zmem = new GraphZoneMember(swID3.getID() + "+" + swfcpID.getID());
                        zmemID3 = (GraphZoneMember.ID)zmem.getEntityID();
                        zmem.setDisplayName(zmemID3.getID().toString());
                        zmem.setFCPortID(swfcpID);
                        zmem.setFCPortLabel(swfcp.getDisplayName());
                        zmem.setFCPortPortNumber(swfcp.getPortNumber());
                        zmem.setParentID(swID3);
                        zmem.setParentLabel(sw.getDisplayName());
                        this.put(zmem);
                        zone2zmem3 = new GraphZone2ZoneMember(zoneID.getID() + "+" + zmemID3.getID());
                        zone2zmem3.setZoneID(zoneID);
                        zone2zmem3.setZoneMemberID(zmemID3);
                        this.put(zone2zmem3);
                    }
                }
            }
        }
        zoneIDStr = "zone" + this.generateZoneID();
        zoneName = "SwitchZone";
        zone = new GraphZone(zoneIDStr);
        zoneID = (GraphZone.ID)zone.getEntityID();
        zone.setDisplayName(zoneName);
        zone.setActive(Boolean.TRUE);
        this.put(zone);
        zfabric2zone = new GraphZoneFabric2Zone(zfabricID.getID() + "+" + zoneID.getID());
        zfabric2zone.setZoneFabricID(zfabricID);
        zfabric2zone.setZoneID(zoneID);
        this.put(zfabric2zone);
        zset2zone = new GraphZoneSet2Zone(zsetID.getID() + "+" + zoneID.getID());
        zset2zone.setZoneSetID(zsetID);
        zset2zone.setZoneID(zoneID);
        this.put(zset2zone);
        for (GraphFCPort swfcp : swFCPortHS) {
            GraphFCPort.ID swfcpID = (GraphFCPort.ID)swfcp.getEntityID();
            Enumeration swEnu = this.associator(GraphSwitch2FCPort.TYPE, swfcpID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                GraphSwitch.ID swID4 = (GraphSwitch.ID)sw.getEntityID();
                GraphZoneMember zmem = new GraphZoneMember(swID4.getID() + "+" + swfcpID.getID());
                GraphZoneMember.ID zmemID4 = (GraphZoneMember.ID)zmem.getEntityID();
                zmem.setDisplayName(zmemID4.getID().toString());
                zmem.setFCPortID(swfcpID);
                zmem.setFCPortLabel(swfcp.getDisplayName());
                zmem.setFCPortPortNumber(swfcp.getPortNumber());
                zmem.setParentID(swID4);
                zmem.setParentLabel(sw.getDisplayName());
                this.put(zmem);
                GraphZone2ZoneMember zone2zmem4 = new GraphZone2ZoneMember(zoneID.getID() + "+" + zmemID4.getID());
                zone2zmem4.setZoneID(zoneID);
                zone2zmem4.setZoneMemberID(zmemID4);
                this.put(zone2zmem4);
            }
        }
        String zoneIDStr2 = "zone" + this.generateZoneID();
        String zoneName2 = "StandAloneZone";
        GraphZone zone2 = new GraphZone(zoneIDStr2);
        GraphZone.ID zoneID2 = (GraphZone.ID)zone2.getEntityID();
        zone2.setDisplayName(zoneName2);
        zone2.setActive(Boolean.FALSE);
        this.put(zone2);
        GraphZoneFabric2Zone zfabric2zone2 = new GraphZoneFabric2Zone(zfabricID.getID() + "+" + zoneID2.getID());
        zfabric2zone2.setZoneFabricID(zfabricID);
        zfabric2zone2.setZoneID(zoneID2);
        this.put(zfabric2zone2);
        GraphComputer computer5 = (GraphComputer)hg3V.elementAt(0);
        GraphComputer.ID computerID5 = (GraphComputer.ID)computer5.getEntityID();
        Enumeration enu5 = this.associator(GraphComputer2FCPort.TYPE, computerID5);
        while (enu5.hasMoreElements()) {
            fcp = (GraphFCPort)enu5.nextElement();
            fcpID = (GraphFCPort.ID)fcp.getEntityID();
            enu2 = this.associatorID(GraphFCPort2FCPort.TYPE, fcpID);
            while (enu2.hasMoreElements()) {
                fcp2ID = (GraphFCPort.ID)enu2.nextElement();
                enu3 = this.associatorID(GraphSwitch2FCPort.TYPE, fcp2ID);
                while (enu3.hasMoreElements()) {
                    swID = (GraphSwitch.ID)enu3.nextElement();
                    enu4 = this.associatorID(GraphFabric2Switch.TYPE, swID);
                    while (enu4.hasMoreElements()) {
                        xxID = (GraphFabric.ID)enu4.nextElement();
                        if (!xxID.equals(fabric0ID)) continue;
                        GraphZoneMember zmem = new GraphZoneMember(computerID5.getID() + "+" + fcpID.getID());
                        zmemID = (GraphZoneMember.ID)zmem.getEntityID();
                        zmem.setDisplayName(zmemID.getID().toString());
                        zmem.setFCPortID(fcpID);
                        zmem.setFCPortLabel(fcp.getDisplayName());
                        zmem.setFCPortPortNumber(fcp.getPortNumber());
                        zmem.setParentID(computerID5);
                        zmem.setParentLabel(computer5.getDisplayName());
                        this.put(zmem);
                        zone2zmem = new GraphZone2ZoneMember(zoneID2.getID() + "+" + zmemID.getID());
                        zone2zmem.setZoneID(zoneID2);
                        zone2zmem.setZoneMemberID(zmemID);
                        this.put(zone2zmem);
                    }
                }
            }
        }
        GraphSubsystem subsystem5 = subsystem0;
        GraphSubsystem.ID subsystemID2 = subsystem0ID;
        enu5 = this.associator(GraphSubsystem2FCPort.TYPE, subsystemID2);
        while (enu5.hasMoreElements()) {
            fcp = (GraphFCPort)enu5.nextElement();
            fcpID = (GraphFCPort.ID)fcp.getEntityID();
            enu2 = this.associatorID(GraphFCPort2FCPort.TYPE, fcpID);
            while (enu2.hasMoreElements()) {
                fcp2ID = (GraphFCPort.ID)enu2.nextElement();
                enu3 = this.associatorID(GraphSwitch2FCPort.TYPE, fcp2ID);
                while (enu3.hasMoreElements()) {
                    swID = (GraphSwitch.ID)enu3.nextElement();
                    enu4 = this.associatorID(GraphFabric2Switch.TYPE, swID);
                    while (enu4.hasMoreElements()) {
                        xxID = (GraphFabric.ID)enu4.nextElement();
                        if (!xxID.equals(fabric0ID)) continue;
                        GraphZoneMember zmem = new GraphZoneMember(subsystemID2.getID() + "+" + fcpID.getID());
                        zmemID = (GraphZoneMember.ID)zmem.getEntityID();
                        zmem.setDisplayName(zmemID.getID().toString());
                        zmem.setFCPortID(fcpID);
                        zmem.setFCPortLabel(fcp.getDisplayName());
                        zmem.setFCPortPortNumber(fcp.getPortNumber());
                        zmem.setParentID(subsystemID2);
                        zmem.setParentLabel(subsystem5.getDisplayName());
                        this.put(zmem);
                        zone2zmem = new GraphZone2ZoneMember(zoneID2.getID() + "+" + zmemID.getID());
                        zone2zmem.setZoneID(zoneID2);
                        zone2zmem.setZoneMemberID(zmemID);
                        this.put(zone2zmem);
                    }
                }
            }
        }
        GraphTapeLibrary tape = (GraphTapeLibrary)tapeLibraryV.elementAt(0);
        GraphTapeLibrary.ID tapeID = (GraphTapeLibrary.ID)tape.getEntityID();
        enu5 = this.associator(GraphTapeLibrary2FCPort.TYPE, tapeID);
        while (enu5.hasMoreElements()) {
            fcp = (GraphFCPort)enu5.nextElement();
            fcpID = (GraphFCPort.ID)fcp.getEntityID();
            enu2 = this.associatorID(GraphFCPort2FCPort.TYPE, fcpID);
            while (enu2.hasMoreElements()) {
                fcp2ID = (GraphFCPort.ID)enu2.nextElement();
                enu3 = this.associatorID(GraphSwitch2FCPort.TYPE, fcp2ID);
                while (enu3.hasMoreElements()) {
                    swID = (GraphSwitch.ID)enu3.nextElement();
                    enu4 = this.associatorID(GraphFabric2Switch.TYPE, swID);
                    while (enu4.hasMoreElements()) {
                        xxID = (GraphFabric.ID)enu4.nextElement();
                        if (!xxID.equals(fabric0ID)) continue;
                        GraphZoneMember zmem = new GraphZoneMember(tapeID.getID() + "+" + fcpID.getID());
                        zmemID = (GraphZoneMember.ID)zmem.getEntityID();
                        zmem.setDisplayName(zmemID.getID().toString());
                        zmem.setFCPortID(fcpID);
                        zmem.setFCPortLabel(fcp.getDisplayName());
                        zmem.setFCPortPortNumber(fcp.getPortNumber());
                        zmem.setParentID(tapeID);
                        zmem.setParentLabel(tape.getDisplayName());
                        this.put(zmem);
                        zone2zmem = new GraphZone2ZoneMember(zoneID2.getID() + "+" + zmemID.getID());
                        zone2zmem.setZoneID(zoneID2);
                        zone2zmem.setZoneMemberID(zmemID);
                        this.put(zone2zmem);
                    }
                }
            }
        }
        GraphOther other = (GraphOther)otherV.elementAt(0);
        GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
        enu5 = this.associator(GraphOther2FCPort.TYPE, otherID);
        while (enu5.hasMoreElements()) {
            fcp = (GraphFCPort)enu5.nextElement();
            fcpID = (GraphFCPort.ID)fcp.getEntityID();
            enu2 = this.associatorID(GraphFCPort2FCPort.TYPE, fcpID);
            while (enu2.hasMoreElements()) {
                fcp2ID = (GraphFCPort.ID)enu2.nextElement();
                enu3 = this.associatorID(GraphSwitch2FCPort.TYPE, fcp2ID);
                while (enu3.hasMoreElements()) {
                    swID = (GraphSwitch.ID)enu3.nextElement();
                    enu4 = this.associatorID(GraphFabric2Switch.TYPE, swID);
                    while (enu4.hasMoreElements()) {
                        xxID = (GraphFabric.ID)enu4.nextElement();
                        if (!xxID.equals(fabric0ID)) continue;
                        GraphZoneMember zmem = new GraphZoneMember(otherID.getID() + "+" + fcpID.getID());
                        zmemID = (GraphZoneMember.ID)zmem.getEntityID();
                        zmem.setDisplayName(zmemID.getID().toString());
                        zmem.setFCPortID(fcpID);
                        zmem.setFCPortLabel(fcp.getDisplayName());
                        zmem.setFCPortPortNumber(fcp.getPortNumber());
                        zmem.setParentID(otherID);
                        zmem.setParentLabel(other.getDisplayName());
                        this.put(zmem);
                        zone2zmem = new GraphZone2ZoneMember(zoneID2.getID() + "+" + zmemID.getID());
                        zone2zmem.setZoneID(zoneID2);
                        zone2zmem.setZoneMemberID(zmemID);
                        this.put(zone2zmem);
                    }
                }
            }
        }
        zfabric = new GraphZoneFabric(fabric1ID.getID().toString());
        zfabricID = (GraphZoneFabric.ID)zfabric.getEntityID();
        zfabric.setFabricID(fabric1ID);
        zfabric.setDisplayName(fabric1.getDisplayName());
        this.put(zfabric);
        zsetIDStr = "zset" + this.generateZsetID();
        zsetName = "Silver";
        zset = new GraphZoneSet(zsetIDStr);
        zsetID = (GraphZoneSet.ID)zset.getEntityID();
        zset.setDisplayName(zsetName);
        zset.setActive(Boolean.FALSE);
        this.put(zset);
        zfabric2zset = new GraphZoneFabric2ZoneSet(zfabric.getEntityID() + "+" + zset.getEntityID());
        zfabric2zset.setZoneFabricID(zfabricID);
        zfabric2zset.setZoneSetID(zsetID);
        this.put(zfabric2zset);
        String zoneIDStr3 = "zone" + this.generateZoneID();
        String zoneName3 = "Area20a";
        GraphZone zone3 = new GraphZone(zoneIDStr3);
        GraphZone.ID zoneID3 = (GraphZone.ID)zone3.getEntityID();
        zone3.setDisplayName(zoneName3);
        zone3.setActive(Boolean.FALSE);
        this.put(zone3);
        GraphZoneFabric2Zone zfabric2zone3 = new GraphZoneFabric2Zone(zfabricID.getID() + "+" + zoneID3.getID());
        zfabric2zone3.setZoneFabricID(zfabricID);
        zfabric2zone3.setZoneID(zoneID3);
        this.put(zfabric2zone3);
        GraphZoneSet2Zone zset2zone2 = new GraphZoneSet2Zone(zsetID.getID() + "+" + zoneID3.getID());
        zset2zone2.setZoneSetID(zsetID);
        zset2zone2.setZoneID(zoneID3);
        this.put(zset2zone2);
        for (int i28 = 0; i28 < 3; ++i28) {
            GraphComputer computer6 = (GraphComputer)hg3V.elementAt(i28);
            GraphComputer.ID computerID6 = (GraphComputer.ID)computer6.getEntityID();
            enu = this.associator(GraphComputer2FCPort.TYPE, computerID6);
            while (enu.hasMoreElements()) {
                fcp2 = (GraphFCPort)enu.nextElement();
                GraphFCPort.ID fcpID4 = (GraphFCPort.ID)fcp2.getEntityID();
                enu22 = this.associatorID(GraphFCPort2FCPort.TYPE, fcpID4);
                while (enu22.hasMoreElements()) {
                    GraphFCPort.ID fcp2ID2 = (GraphFCPort.ID)enu22.nextElement();
                    Enumeration enu34 = this.associatorID(GraphSwitch2FCPort.TYPE, fcp2ID2);
                    while (enu34.hasMoreElements()) {
                        GraphSwitch.ID swID5 = (GraphSwitch.ID)enu34.nextElement();
                        Enumeration enu44 = this.associatorID(GraphFabric2Switch.TYPE, swID5);
                        while (enu44.hasMoreElements()) {
                            GraphFabric.ID xxID4 = (GraphFabric.ID)enu44.nextElement();
                            if (!xxID4.equals(fabric1ID)) continue;
                            GraphZoneMember zmem = new GraphZoneMember(computerID6.getID() + "+" + fcpID4.getID());
                            GraphZoneMember.ID zmemID5 = (GraphZoneMember.ID)zmem.getEntityID();
                            zmem.setDisplayName(zmemID5.getID().toString());
                            zmem.setFCPortID(fcpID4);
                            zmem.setFCPortLabel(fcp2.getDisplayName());
                            zmem.setFCPortPortNumber(fcp2.getPortNumber());
                            zmem.setParentID(computerID6);
                            zmem.setParentLabel(computer6.getDisplayName());
                            this.put(zmem);
                            GraphZone2ZoneMember zone2zmem5 = new GraphZone2ZoneMember(zoneID3.getID() + "+" + zmemID5.getID());
                            zone2zmem5.setZoneID(zoneID3);
                            zone2zmem5.setZoneMemberID(zmemID5);
                            this.put(zone2zmem5);
                        }
                    }
                }
            }
        }
    }

    protected void calculateFabricMeta() {
        Enumeration fabricEnu = this.enumerate(GraphFabric.TYPE);
        while (fabricEnu.hasMoreElements()) {
            GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
            GraphFabric.ID fabricID = (GraphFabric.ID)fabric.getEntityID();
            int numOfComputers = 0;
            int numOfAbnormalComputers = 0;
            Enumeration computerEnu = this.associator(GraphFabric2Computer.TYPE, fabricID);
            while (computerEnu.hasMoreElements()) {
                GraphComputer computer = (GraphComputer)computerEnu.nextElement();
                ++numOfComputers;
                if (!GraphModelUtilities.isAbnormal(computer)) continue;
                ++numOfAbnormalComputers;
            }
            fabric.setNumOfComputers(new Integer(numOfComputers));
            fabric.setNumOfAbnormalComputers(new Integer(numOfAbnormalComputers));
            int numOfSwitches = 0;
            int numOfAbnormalSwitches = 0;
            Enumeration swEnu = this.associator(GraphFabric2Switch.TYPE, fabricID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                ++numOfSwitches;
                if (!GraphModelUtilities.isAbnormal(sw)) continue;
                ++numOfAbnormalSwitches;
            }
            fabric.setNumOfSwitches(new Integer(numOfSwitches));
            fabric.setNumOfAbnormalSwitches(new Integer(numOfAbnormalSwitches));
            int numOfSubsystems = 0;
            int numOfAbnormalSubsystems = 0;
            Enumeration subsystemEnu = this.associator(GraphFabric2Subsystem.TYPE, fabricID);
            while (subsystemEnu.hasMoreElements()) {
                GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                ++numOfSubsystems;
                if (!GraphModelUtilities.isAbnormal(subsystem)) continue;
                ++numOfAbnormalSubsystems;
            }
            fabric.setNumOfSubsystems(new Integer(numOfSubsystems));
            fabric.setNumOfAbnormalSubsystems(new Integer(numOfAbnormalSubsystems));
            int numOfTapeLibraries = 0;
            int numOfAbnormalTapeLibraries = 0;
            Enumeration tapeLibraryEnu = this.associator(GraphFabric2TapeLibrary.TYPE, fabricID);
            while (tapeLibraryEnu.hasMoreElements()) {
                GraphTapeLibrary tape = (GraphTapeLibrary)tapeLibraryEnu.nextElement();
                ++numOfTapeLibraries;
                if (!GraphModelUtilities.isAbnormal(tape)) continue;
                ++numOfAbnormalTapeLibraries;
            }
            fabric.setNumOfTapeLibraries(new Integer(numOfTapeLibraries));
            fabric.setNumOfAbnormalTapeLibraries(new Integer(numOfAbnormalTapeLibraries));
            int numOfOthers = 0;
            int numOfAbnormalOthers = 0;
            Enumeration otherEnu = this.associator(GraphFabric2Other.TYPE, fabricID);
            while (otherEnu.hasMoreElements()) {
                GraphOther other = (GraphOther)otherEnu.nextElement();
                ++numOfOthers;
                if (!GraphModelUtilities.isAbnormal(other)) continue;
                ++numOfAbnormalOthers;
            }
            fabric.setNumOfOthers(new Integer(numOfOthers));
            fabric.setNumOfAbnormalOthers(new Integer(numOfAbnormalOthers));
        }
    }

    private String generateWWN() {
        ++this.wwnCount;
        String s = Integer.toHexString(this.wwnCount);
        StringBuffer prefix = new StringBuffer();
        for (int i = 0; i < 16 - s.length(); ++i) {
            prefix.append("0");
        }
        return prefix.toString() + s;
    }

    private int generateFabricID() {
        return this.fabricCount++;
    }

    private int generateSwitchID() {
        return this.swCount++;
    }

    private int generateSubsystemID() {
        return this.subsystemCount++;
    }

    private int generateDiskID() {
        return this.diskCount++;
    }

    private int generatePoolID() {
        return this.poolCount++;
    }

    private int generateVolumeID() {
        return this.volumeCount++;
    }

    private int generateComputerID() {
        return this.computerCount++;
    }

    private int generateTapeLibraryID() {
        return this.tapeLibraryCount++;
    }

    private int generateTapeDriveID() {
        return this.tapeDriveCount++;
    }

    private int generateMediaChangerID() {
        return this.mediaChangerCount++;
    }

    private int generateOtherID() {
        return this.otherCount++;
    }

    private int generateZsetID() {
        return this.zsetCount++;
    }

    private int generateZoneID() {
        return this.zoneCount++;
    }
}

