/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;

public class GraphDebug {
    public static final String VM_PROP = "TopologyViewerDebug";
    public static final String VM_PROP2 = "TopologyViewerDebugOutputFile";
    public static final int LEVEL_OFF = 0;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_TEMPORARY = 3;
    public static final int LEVEL_HIGHLIGHT = 4;
    public static final int LEVEL_INFO = 5;
    public static final int LEVEL_TRACE = 6;
    public static String[] PREFIX = new String[]{"[OFF]", "[ERROR]", "[WARNING]", "[TEMPORARY]", "[HIGHLIGHT]", "[INFO]", "[TRACE]"};
    public static int current_level = 2;
    public static PrintWriter pw;

    public static int getCurrentLevel() {
        return current_level;
    }

    public static void setCurrentLevel(int level) {
        current_level = level;
    }

    private static void template(int level, String s) {
        StringBuffer sb = new StringBuffer();
        Date d = new Date(System.currentTimeMillis());
        sb.append(d.toString());
        sb.append(" ");
        sb.append(PREFIX[level]);
        sb.append(" ");
        sb.append(s);
        System.out.println(sb.toString());
        if (pw != null) {
            try {
                pw.println(sb.toString());
                pw.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void template(int level, Throwable s) {
        s.printStackTrace(System.out);
        if (pw != null) {
            s.printStackTrace(pw);
        }
    }

    public static boolean isErrorVisible() {
        return 1 <= current_level;
    }

    public static void error(String s) {
        if (GraphDebug.isErrorVisible()) {
            GraphDebug.template(1, s);
        }
    }

    public static boolean isWarningVisible() {
        return 2 <= current_level;
    }

    public static void warning(String s) {
        if (GraphDebug.isWarningVisible()) {
            GraphDebug.template(2, s);
        }
    }

    public static boolean isTemporaryVisible() {
        return 3 <= current_level;
    }

    public static void temporary(String s) {
        if (GraphDebug.isTemporaryVisible()) {
            GraphDebug.template(3, s);
        }
    }

    public static boolean isHighlightVisible() {
        return 4 <= current_level;
    }

    public static void highlight(String s) {
        if (GraphDebug.isHighlightVisible()) {
            GraphDebug.template(4, s);
        }
    }

    public static boolean isInfoVisible() {
        return 5 <= current_level;
    }

    public static void info(String s) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.template(5, s);
        }
    }

    public static boolean isTraceVisible() {
        return 6 <= current_level;
    }

    public static void trace(String s) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.template(6, s);
        }
    }

    public static void throwable(Throwable e) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.template(6, e);
        }
    }

    public static void exception(Throwable e) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.template(6, e);
        }
    }

    static {
        try {
            String outputFile;
            String s = System.getProperty(VM_PROP);
            if (s != null) {
                current_level = Integer.parseInt(s);
            }
            if ((outputFile = System.getProperty(VM_PROP2)) != null) {
                pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

