/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoLine;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoUnit;
import org.eclipse.aperi.gui.topo.widget.ITopoAssociationModel;

public abstract class AbstractJTopoBracketLine
extends AbstractJTopoLine {
    protected int fromYOffset;
    protected int toYOffset;
    protected int slot;

    protected AbstractJTopoBracketLine() {
        this((ITopoAssociationModel)null, true);
    }

    protected AbstractJTopoBracketLine(ITopoAssociationModel associationModel, boolean isWidgetModelListener) {
        super(associationModel, isWidgetModelListener);
        this.initState();
    }

    private void initState() {
        this.fromYOffset = 0;
        this.toYOffset = 0;
        this.slot = 0;
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    public int getFromYOffset() {
        return this.fromYOffset;
    }

    public void setFromYOffset(int fromYOffset) {
        this.fromYOffset = fromYOffset;
    }

    public int getToYOffset() {
        return this.toYOffset;
    }

    public void setToYOffset(int toYOffset) {
        this.toYOffset = toYOffset;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    implements LayoutManager {
        protected int gap = 20;

        protected DefaultLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            if (AbstractJTopoBracketLine.this.firstPassOfLayout) {
                AbstractJTopoBracketLine.this.setBounds(0, 0, 1, 1);
                return;
            }
            try {
                ITopoAssociationModel associationModel = (ITopoAssociationModel)AbstractJTopoBracketLine.this.widgetModel;
                if (associationModel == null) {
                    return;
                }
                AbstractJTopoUnit from = associationModel.getFromWidget().getLastVisibleUnit();
                AbstractJTopoUnit to = associationModel.getToWidget().getLastVisibleUnit();
                AbstractJTopoCanvas.CanvasPanel canvasPanel = AbstractJTopoBracketLine.this.canvas.getCanvasPanel();
                if (from != to) {
                    Point fromP = null;
                    Point toP = null;
                    fromP = from.getConnectingPoint();
                    fromP.y += -(from.getHeight() / 2) + AbstractJTopoBracketLine.this.fromYOffset;
                    toP = to.getConnectingPoint();
                    toP.y += -(to.getHeight() / 2) + AbstractJTopoBracketLine.this.toYOffset;
                    fromP = SwingUtilities.convertPoint(from.getParent(), fromP, canvasPanel);
                    toP = SwingUtilities.convertPoint(to.getParent(), toP, canvasPanel);
                    this.setBracketLine(fromP, toP, AbstractJTopoBracketLine.this.slot);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }

        protected void setBracketLine(Point p1, Point p2, int slot) {
            try {
                int xBase = 50;
                int xGap = 5;
                int xOffset = xBase + xGap * slot;
                Rectangle r1 = new Rectangle(p1.x - 2, p1.y - 2, 4, 4);
                Rectangle r2 = new Rectangle(p2.x - 2, p2.y - 2, 4, 4);
                Rectangle r = r1.union(r2);
                Point p3 = new Point(r.x + xOffset, p1.y);
                Point p4 = new Point(r.x + xOffset, p2.y);
                r.setBounds(r.x, r.y, xOffset + 5, r.height);
                AbstractJTopoBracketLine.this.setBounds(r);
                AbstractJTopoBracketLine.this.lineV.removeAllElements();
                AbstractJTopoBracketLine.this.lineV.add(new Line2D.Float(p1.x - r.x, p1.y - r.y, p3.x - r.x, p3.y - r.y));
                AbstractJTopoBracketLine.this.lineV.add(new Line2D.Float(p3.x - r.x, p3.y - r.y, p4.x - r.x, p4.y - r.y));
                AbstractJTopoBracketLine.this.lineV.add(new Line2D.Float(p4.x - r.x, p4.y - r.y, p2.x - r.x, p2.y - r.y));
                AbstractJTopoBracketLine.this.dot1.setRect(r1.x - r.x, r1.y - r.y, r1.width, r1.height);
                AbstractJTopoBracketLine.this.dot2.setRect(r2.x - r.x, r2.y - r.y, r2.width, r2.height);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

