/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoContainer;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoPin;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.JTopoBorderTop;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;

public abstract class AbstractJTopoPinContainer
extends AbstractJTopoContainer {
    protected Arrange_Pin arrangePin;

    protected AbstractJTopoPinContainer() {
        this((ITopoUnitModel)null, true);
    }

    protected AbstractJTopoPinContainer(ITopoUnitModel unitModel, boolean isWidgetModelListener) {
        super(unitModel, isWidgetModelListener);
        this.setBorder(new JTopoBorderTop());
        this.arrangePin = new Arrange_Pin();
    }

    public void setOverlayHealthEnabled(boolean b) {
        for (int i = 0; i < this.entityV.size(); ++i) {
            AbstractJTopoPin pin = (AbstractJTopoPin)this.entityV.elementAt(i);
            pin.setOverlayHealthEnabled(b);
        }
    }

    public void setOverlayPerfEnabled(boolean b) {
        for (int i = 0; i < this.entityV.size(); ++i) {
            AbstractJTopoPin pin = (AbstractJTopoPin)this.entityV.elementAt(i);
            pin.setOverlayPerfEnabled(b);
        }
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord r) {
        Collections.sort(this.entityV, new Arrange_Pin());
        this.removeAll();
        for (int i = 0; i < this.entityV.size(); ++i) {
            AbstractJTopoEntity entity = (AbstractJTopoEntity)this.entityV.elementAt(i);
            this.add(entity);
        }
        this.revalidate();
        this.repaint();
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    extends TopoLayoutUtilities.VerticalLayout {
    }

    protected class Arrange_ByType
    implements Comparator {
        public int compare(Object o1, Object o2) {
            AbstractJTopoEntity widget1 = (AbstractJTopoEntity)o1;
            AbstractJTopoEntity widget2 = (AbstractJTopoEntity)o2;
            GraphEntity entity1 = widget1.getFocusEntity();
            GraphEntity entity2 = widget2.getFocusEntity();
            if (entity1 == null && entity2 == null) {
                return 0;
            }
            if (entity1 == null) {
                return 1;
            }
            if (entity2 == null) {
                return -1;
            }
            int type1 = this.getType(entity1);
            int type2 = this.getType(entity2);
            int result = type1 - type2;
            return result;
        }

        protected int getType(GraphEntity entity) {
            int type = Integer.MAX_VALUE;
            if (entity instanceof GraphComputer) {
                type = 0;
            } else if (entity instanceof GraphSwitch) {
                type = 1;
            } else if (entity instanceof GraphSubsystem) {
                type = 2;
            } else if (entity instanceof GraphTapeLibrary) {
                type = 3;
            } else if (entity instanceof GraphOther) {
                type = 4;
            }
            return type;
        }

        public boolean equals(Object obj) {
            return this.equals(obj);
        }
    }

    protected class Arrange_Pin
    implements Comparator {
        protected AbstractJTopoContainer.Arrange_ByStatus arrangeByStatus;
        protected AbstractJTopoContainer.Arrange_ByDisplayName arrangeByDisplayName;
        protected Arrange_ByType arrangeByType;

        public Arrange_Pin() {
            this.arrangeByStatus = new AbstractJTopoContainer.Arrange_ByStatus(true);
            this.arrangeByDisplayName = new AbstractJTopoContainer.Arrange_ByDisplayName(true);
            this.arrangeByType = new Arrange_ByType();
        }

        public int compare(Object o1, Object o2) {
            int result = this.arrangeByStatus.compare(o1, o2);
            if (result != 0) {
                return result;
            }
            result = this.arrangeByType.compare(o1, o2);
            if (result != 0) {
                return result;
            }
            result = this.arrangeByDisplayName.compare(o1, o2);
            return result;
        }

        public boolean equals(Object obj) {
            return this.equals(obj);
        }
    }
}

