/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL0;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL1;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL2;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL0;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL2;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL0;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL1;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL2;
import org.eclipse.aperi.gui.topo.model.GraphModelPinList;
import org.eclipse.aperi.gui.topo.model.GraphModelStorageL0;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL1;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL2;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL0;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL1;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL2;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL1;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL2;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphStorageSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.ITopoBackend;
import org.eclipse.aperi.gui.topo.widget.ITopoFrontend;
import org.eclipse.aperi.gui.topo.widget.JTopoApp;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.gui.topo.widget.WidgetPool;

public class ControllerApp
implements ITopoFrontend {
    protected ITopoBackend backend;
    protected TopoSetting setting;
    protected JTopoApp topoApp;
    protected PinList pinList;
    protected Hashtable controllerViewsH;

    public ControllerApp() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, constructor");
        }
        TopoResource.init();
        WidgetPool widgetPool = WidgetPool.getInstance();
        this.topoApp = (JTopoApp)widgetPool.getWidget(JTopoApp.class);
        this.pinList = new PinList();
        this.controllerViewsH = new Hashtable();
    }

    public void destruct() {
        WidgetPool widgetPool;
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, destruct()");
        }
        Enumeration enu = this.controllerViewsH.elements();
        while (enu.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enu.nextElement();
            controllerView.destruct();
        }
        if (this.topoApp != null) {
            widgetPool = WidgetPool.getInstance();
            widgetPool.recycleWidget(this.topoApp);
        }
        this.pinList.destruct();
        widgetPool = WidgetPool.getInstance();
        widgetPool.destruct();
        this.backend = null;
        this.setting = null;
        this.topoApp = null;
        this.pinList = null;
        this.controllerViewsH = null;
    }

    public ITopoBackend getBackend() {
        return this.backend;
    }

    public TopoSetting getTopoSetting() {
        return this.setting;
    }

    public void setSessionModel(ITopoBackend backend, TopoSetting setting) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, setSessionModel(), backend=" + backend + ", setting=" + setting);
        }
        this.backend = backend;
        this.setting = setting;
        this.topoApp.setSessionModel(this);
    }

    public JTopoApp getTopoApp() {
        return this.topoApp;
    }

    public PinList getPinList() {
        return this.pinList;
    }

    public ControllerView getFocusedControllerView() {
        return this.topoApp.getFocusedTopoView().getControllerView();
    }

    public Enumeration getControllerViews() {
        return this.controllerViewsH.elements();
    }

    public ControllerView getControllerView(GraphModel.ID modelID) {
        return (ControllerView)this.controllerViewsH.get(modelID);
    }

    public void addControllerView(GraphModel.ID modelID, ControllerView controllerView) {
        this.controllerViewsH.put(modelID, controllerView);
    }

    public void removeControllerView(GraphModel.ID modelID) {
        this.controllerViewsH.remove(modelID);
    }

    public void openView(GraphModel.ID modelID) {
        ControllerView controllerView;
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, openView(), modelID=" + modelID);
        }
        if ((controllerView = this.getControllerView(modelID)) == null) {
            if (GraphDebug.isTraceVisible()) {
                GraphDebug.trace("ControllerApp, openView(), a new view is about to be opened");
            }
            controllerView = new ControllerView();
            this.controllerViewsH.put(modelID, controllerView);
            controllerView.setSessionModel(this, modelID);
        }
        controllerView.focus();
    }

    public void updateView(int rtnCode, GraphModel dataModel) {
        if (GraphDebug.isHighlightVisible()) {
            GraphDebug.highlight("ControllerApp, updateView(), data is returned from backend (rtnCode=" + rtnCode + ", modelID=" + dataModel.getModelID() + ") ------------");
        }
        if (rtnCode == 0) {
            GraphModel.ID modelID = dataModel.getModelID();
            if ("PinList".equals(modelID.getFocusLevel())) {
                Vector childFocusEntityIDV = ((GraphModel.MultiEntityID)modelID).getChildFocusEntityIDs();
                for (int i = childFocusEntityIDV.size() - 1; i >= 0; --i) {
                    GraphEntity.ID focusEntityID = (GraphEntity.ID)childFocusEntityIDV.elementAt(i);
                    if (dataModel.get(focusEntityID) != null) continue;
                    if (GraphDebug.isWarningVisible()) {
                        GraphDebug.warning("ControllerApp, updateView(), the PinList model is inconsistent with its childFocusEntityIDs(), focusEntityID=" + focusEntityID);
                    }
                    childFocusEntityIDV.remove(i);
                }
                this.pinList.setSessionModel(this, (GraphModelPinList)dataModel);
            } else {
                ControllerView controllerView;
                boolean isValid = true;
                if (modelID instanceof GraphModel.MultiEntityID) {
                    Vector childFocusEntityIDV = ((GraphModel.MultiEntityID)modelID).getChildFocusEntityIDs();
                    for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                        GraphEntity.ID focusEntityID = (GraphEntity.ID)childFocusEntityIDV.elementAt(i);
                        if (dataModel.get(focusEntityID) != null) continue;
                        if (GraphDebug.isWarningVisible()) {
                            GraphDebug.warning("ControllerApp, updateView(), the regular model is inconsistent with its childFocusEntityIDs(), focusEntityID=" + focusEntityID);
                        }
                        isValid = false;
                    }
                } else {
                    GraphEntity.ID focusEntityID = modelID.getFocusEntityID();
                    if (focusEntityID != null && dataModel.get(focusEntityID) == null) {
                        if (GraphDebug.isWarningVisible()) {
                            GraphDebug.warning("ControllerApp, updateView(), the regular model is inconsistent with the focusEntityID, focusEntityID=" + focusEntityID);
                        }
                        isValid = false;
                    }
                }
                if ((controllerView = this.getControllerView(modelID)) != null) {
                    SwingUtilities.invokeLater(new UpdateViewThread(controllerView, dataModel, isValid));
                } else if (GraphDebug.isErrorVisible()) {
                    GraphDebug.error("ControllerApp, updateView(), controllerView=null, modelID=" + modelID);
                }
            }
        } else {
            if (GraphDebug.isWarningVisible()) {
                GraphDebug.warning("ControllerApp, updateView(), backend reported an error, rtnCode=" + rtnCode);
            }
            this.showMsg(rtnCode, "");
        }
    }

    public Vector getOpenedViews() {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, getOpenedViews()");
        }
        Vector v = new Vector(this.controllerViewsH.keySet());
        ControllerView controllerView = this.getFocusedControllerView();
        GraphModel.ID modelID = controllerView.getModelID();
        v.remove(modelID);
        v.add(0, modelID);
        v.add(this.pinList.getModel().getModelID());
        return v;
    }

    public void showMsg(int rtnCode, String msg) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, showMsg(), rtnCode=" + rtnCode + ", msg=" + msg);
        }
        String s = GuiUtil.getString("TOPO_LABEL_DIALOG_SHOWMESSAGE_RTNCODE") + " " + rtnCode + "\r\n" + GuiUtil.getString("TOPO_LABEL_DIALOG_SHOWMESSAGE_MESSAGE") + " " + msg;
        JOptionPane.showMessageDialog(this.topoApp.getMainFrame().getContentPane(), s, GuiUtil.getString("TOPO_LABEL_DIALOG_SHOWMESSAGE_TITLE"), 2);
    }

    public void print() {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, print()");
        }
        ControllerView controllerView = this.getFocusedControllerView();
        controllerView.print();
    }

    public void startRefreshView(GraphModel.ID modelID) {
        ControllerView controllerView;
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, startRefreshView(), modelID=" + modelID);
        }
        if ((controllerView = this.getControllerView(modelID)) != null) {
            controllerView.startRefreshView();
        } else if (!"PinList".equals(modelID.getFocusLevel()) && GraphDebug.isErrorVisible()) {
            GraphDebug.error("ControllerApp, startRefreshView(), invalid modelID=" + modelID);
        }
    }

    public void finishRefreshView(GraphModel.ID modelID) {
        ControllerView controllerView;
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, finishRefreshView, modelID=" + modelID);
        }
        if ((controllerView = this.getControllerView(modelID)) != null) {
            controllerView.finishRefreshView();
        } else if (!"PinList".equals(modelID.getFocusLevel()) && GraphDebug.isErrorVisible()) {
            GraphDebug.error("ControllerApp, finishRefreshView(), invalid modelID=" + modelID);
        }
    }

    public void cancelAllRefresh() {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, cancelAllRefresh()");
        }
    }

    public void refreshView(GraphModel.ID modelID) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, refreshView() (set request to backend), modelID=" + modelID);
        }
        this.backend.refreshView(modelID);
        this.backend.refreshView(this.pinList.getModel().getModelID());
    }

    public void refreshAllViews() {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, refreshAllViews() (set request to backend)");
        }
        this.backend.refreshAllViews();
    }

    public void closeView(GraphModel.ID modelID) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, closeView(), modelID=" + modelID);
        }
        if ("Overview".equals(modelID.getFocusLevel())) {
            return;
        }
        ControllerView controllerView = this.getControllerView(modelID);
        if (controllerView != null) {
            this.controllerViewsH.remove(modelID);
            controllerView.destruct();
        } else if (GraphDebug.isErrorVisible()) {
            GraphDebug.error("ControllerApp, closeView(), controllerView=null");
        }
    }

    public void closeAllViews() {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, closeAllViews()");
        }
        Vector v = new Vector(this.controllerViewsH.keySet());
        for (int i = 0; i < v.size(); ++i) {
            GraphModel.ID modelID = (GraphModel.ID)v.elementAt(i);
            this.closeView(modelID);
        }
    }

    public void launchDetailPanel(GraphEntity.ID entityID) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, launchDetailPanel(), nodeID=" + entityID);
        }
        this.backend.launchDetailsPanel(entityID);
    }

    public void launchElementManager(GraphEntity entity) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, launchElementManager(), node=" + entity);
        }
        this.backend.launchElementManager(entity);
    }

    public void removeMissingEntity(Vector entityV) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, removeMissingEntity(), nodeV=" + entityV);
        }
        this.backend.removeEntity(entityV);
    }

    public void setOverlayHealthEnabled(boolean b) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, setOverlayHealthEnabled(), b=" + b);
        }
        Enumeration enu = this.controllerViewsH.elements();
        while (enu.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enu.nextElement();
            controllerView.setOverlayHealthEnabled(b);
        }
    }

    public void setOverlayPerfEnabled(boolean b) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, setOverlayPerfEnabled(), b=" + b);
        }
        Enumeration enu = this.controllerViewsH.elements();
        while (enu.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enu.nextElement();
            controllerView.setOverlayPerfEnabled(b);
        }
    }

    public void setFilteringLevel(int filteringLevel) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, setFilteringLevel(), filteringLevel=" + filteringLevel);
        }
        Enumeration enu = this.controllerViewsH.elements();
        while (enu.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enu.nextElement();
            controllerView.setFilteringLevel(filteringLevel);
        }
    }

    public void setShowConnectionEnabled(boolean b) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, setShowConnectionEnabled(), b=" + b);
        }
        Enumeration enu = this.controllerViewsH.elements();
        while (enu.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enu.nextElement();
            controllerView.setShowConnectionEnabled(b);
        }
    }

    public void setShowZoneEnabled(boolean b) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, setShowZoneEnabled(), b=" + b);
        }
        Enumeration enu = this.controllerViewsH.elements();
        while (enu.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enu.nextElement();
            controllerView.setShowZoneEnabled(b);
        }
    }

    public void openView(GraphEntity focusEntity, Vector childFocusEntityIDV) {
        GraphModel.ID modelID = null;
        if (focusEntity instanceof GraphFabricSummary) {
            modelID = new GraphModelFabricL0.ID();
        } else if (focusEntity instanceof GraphFabric) {
            modelID = new GraphModelFabricL2.ID((GraphFabric)focusEntity);
        } else if (focusEntity instanceof GraphComputerSummary) {
            modelID = new GraphModelComputerL0.ID();
        } else if (focusEntity instanceof GraphComputerGroup) {
            modelID = new GraphModelComputerL1.ID((GraphComputerGroup)focusEntity, childFocusEntityIDV);
        } else if (focusEntity instanceof GraphComputer) {
            modelID = new GraphModelComputerL2.ID((GraphComputer)focusEntity);
        } else if (focusEntity instanceof GraphSwitchSummary) {
            modelID = new GraphModelSwitchL0.ID();
        } else if (focusEntity instanceof GraphSwitchGroup) {
            modelID = new GraphModelSwitchL1.ID((GraphSwitchGroup)focusEntity, childFocusEntityIDV);
        } else if (focusEntity instanceof GraphSwitch) {
            GraphSwitch.ID focusEntityID = (GraphSwitch.ID)focusEntity.getEntityID();
            modelID = new GraphModelSwitchL2.ID((GraphSwitch)focusEntity);
        } else if (focusEntity instanceof GraphStorageSummary) {
            modelID = new GraphModelStorageL0.ID();
        } else if (focusEntity instanceof GraphSubsystemGroup) {
            modelID = new GraphModelSubsystemL1.ID((GraphSubsystemGroup)focusEntity, childFocusEntityIDV);
        } else if (focusEntity instanceof GraphSubsystem) {
            GraphSubsystem.ID focusEntityID = (GraphSubsystem.ID)focusEntity.getEntityID();
            modelID = new GraphModelSubsystemL2.ID((GraphSubsystem)focusEntity);
        } else if (focusEntity instanceof GraphTapeLibraryGroup) {
            modelID = new GraphModelTapeLibraryL1.ID((GraphTapeLibraryGroup)focusEntity, childFocusEntityIDV);
        } else if (focusEntity instanceof GraphTapeLibrary) {
            GraphTapeLibrary.ID focusEntityID = (GraphTapeLibrary.ID)focusEntity.getEntityID();
            modelID = new GraphModelTapeLibraryL2.ID((GraphTapeLibrary)focusEntity);
        } else if (focusEntity instanceof GraphOtherSummary) {
            modelID = new GraphModelOtherL0.ID();
        } else if (focusEntity instanceof GraphOtherGroup) {
            modelID = new GraphModelOtherL1.ID((GraphOtherGroup)focusEntity, childFocusEntityIDV);
        } else if (focusEntity instanceof GraphOther) {
            GraphOther.ID focusEntityID = (GraphOther.ID)focusEntity.getEntityID();
            modelID = new GraphModelOtherL2.ID((GraphOther)focusEntity);
        }
        if (modelID != null) {
            modelID.setNeedPerfData(this.setting.isOverlayPerfEnabled());
            modelID.setNeedZoneData(this.setting.isShowZoneEnabled);
            this.openView(modelID);
        } else {
            System.out.println("ControllerApp, openView(), Invalid jumping, focusEntity=" + focusEntity + ", childFocusEntityIDV=" + childFocusEntityIDV);
        }
    }

    public void setTopoSetting(TopoSetting topo) {
        this.setting = topo;
    }

    private class UpdateViewThread
    implements Runnable {
        private ControllerView controllerView;
        private GraphModel model;
        private boolean isValid;

        public UpdateViewThread(ControllerView controllerView, GraphModel model, boolean isValid) {
            this.controllerView = controllerView;
            this.model = model;
            this.isValid = isValid;
        }

        public void run() {
            if (this.isValid) {
                this.controllerView.setDataModel(this.model);
            } else {
                this.controllerView.invalidateView();
            }
        }
    }
}

