/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnModel;
import org.eclipse.aperi.gui.topo.widget.JCustomRendererTable;

public class DefaultTopoTableModel
extends AbstractTableModel {
    protected DefaultTopoTableColumnModel columnModel;
    protected RootNode rootNode;

    public DefaultTopoTableModel(DefaultTopoTableColumnModel cm) {
        this.columnModel = cm;
        this.rootNode = new RootNode();
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }

    public int getRowCount() {
        return this.rootNode.getRowCount();
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) throws ArrayIndexOutOfBoundsException {
        MemberNode member = this.findMemberNode(rowIndex);
        Object result = null;
        if (member != null) {
            Vector dataV = member.dataV;
            return member.getData(columnIndex);
        }
        return result;
    }

    public String getColumnName(int columnIndex) {
        TableColumn column = this.columnModel.getColumn(columnIndex);
        return column.getHeaderValue().toString();
    }

    public Class getColumnClass(int columnIndex) {
        TableColumn column = this.columnModel.getColumn(columnIndex);
        return column.getClass();
    }

    public void removeAll() {
        this.rootNode = new RootNode();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        MemberNode member = this.findMemberNode(rowIndex);
        if (member != null) {
            member.setData(columnIndex, aValue);
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void resetRowIndex() {
        this.rootNode.resetRowIndex();
    }

    public void sort(int sort_col, boolean sort_asc) {
        this.rootNode.sort(sort_col, sort_asc);
    }

    public MemberNode findMemberNode(int rowIndex) {
        return this.rootNode.findMemberNode(rowIndex);
    }

    public MemberNode findMemberNode(GraphEntity.ID nodeID) {
        if (nodeID == null) {
            return null;
        }
        return this.rootNode.findMemberNode(nodeID);
    }

    public Object findData(int rowIndex, int colIndex) {
        MemberNode member = this.findMemberNode(rowIndex);
        return member.getData(colIndex);
    }

    public void setSelectedAllMembers(boolean b) {
        this.rootNode.setSelectedAllMembers(b);
    }

    public void collapseAll(boolean b) {
        this.collapseAll_helper(this.rootNode, b);
        this.resetRowIndex();
        this.fireTableDataChanged();
    }

    protected void collapseAll_helper(GroupNode group, boolean b) {
        Vector memberV = group.getMemberVector();
        for (int i = 0; i < memberV.size(); ++i) {
            MemberNode member = (MemberNode)memberV.elementAt(i);
            if (!(member instanceof GroupNode)) continue;
            GroupNode g = (GroupNode)member;
            g.setCollapse(b);
            this.collapseAll_helper(g, b);
        }
    }

    public class RootNode
    extends GroupNode {
        public RootNode() {
            super(null);
            this.isCollapsed = false;
            this.level = 0;
        }

        public int getRowCount() {
            return super.getRowCount() - 1;
        }

        public void resetRowIndex() {
            this.setRowIndex(-1);
            int index = 0;
            for (int i = 0; i < this.memberV.size(); ++i) {
                MemberNode member = (MemberNode)this.memberV.elementAt(i);
                if (member instanceof GroupNode) {
                    GroupNode group = (GroupNode)member;
                    index = group.resetRowIndex(index);
                    continue;
                }
                member.setRowIndex(index++);
            }
        }
    }

    public class GroupNode
    extends MemberNode {
        protected boolean isCollapsed;
        protected Vector memberV;

        public GroupNode(GraphEntity.ID ref) {
            super(ref);
            this.isCollapsed = true;
            this.memberV = new Vector();
        }

        public boolean isCollapsed() {
            return this.isCollapsed;
        }

        public void setCollapse(boolean b) {
            this.isCollapsed = b;
        }

        public int getMemberCount() {
            return this.memberV.size();
        }

        public Vector getMemberVector() {
            return this.memberV;
        }

        public MemberNode getMember(int memberIndex) throws ArrayIndexOutOfBoundsException {
            if (memberIndex < 0 || memberIndex >= this.memberV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return (MemberNode)this.memberV.elementAt(memberIndex);
        }

        public void addMember(MemberNode member) {
            member.setParent(this);
            member.setLevel(this.level + 1);
            this.memberV.add(member);
        }

        public void insertMember(int memberIndex, MemberNode member) {
            if (memberIndex < 0 || memberIndex >= this.memberV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            member.setParent(this);
            member.setLevel(this.level + 1);
            this.memberV.insertElementAt(member, memberIndex);
        }

        public void removeMember(int memberIndex) {
            if (memberIndex < 0 || memberIndex >= this.memberV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            MemberNode member = (MemberNode)this.memberV.remove(memberIndex);
            if (member != null) {
                member.setParent(null);
                member.setLevel(-1);
            }
        }

        public void setMember(int memberIndex, MemberNode member) {
            if (memberIndex < 0 || memberIndex >= this.memberV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            member.setParent(this);
            member.setLevel(this.level + 1);
            this.memberV.setElementAt(member, memberIndex);
        }

        public Object getData(int columnIndex) {
            if (columnIndex < 0 || columnIndex >= this.dataV.size()) {
                return null;
            }
            return this.dataV.elementAt(columnIndex);
        }

        public void setData(int columnIndex, Object aValue) {
            if (columnIndex < 0 || columnIndex >= this.dataV.size()) {
                return;
            }
            this.dataV.setElementAt(aValue, columnIndex);
        }

        public int getRowCount() {
            int count = 1;
            if (!this.isCollapsed) {
                for (int i = 0; i < this.memberV.size(); ++i) {
                    MemberNode member = (MemberNode)this.memberV.elementAt(i);
                    count += member.getRowCount();
                }
            }
            return count;
        }

        public MemberNode findMemberNode(int row) {
            MemberNode result = null;
            if (this.rowIndex == row) {
                result = this;
            } else {
                MemberNode member;
                for (int i = 0; i < this.memberV.size() && (result = (member = (MemberNode)this.memberV.elementAt(i)).findMemberNode(row)) == null; ++i) {
                }
            }
            return result;
        }

        public MemberNode findMemberNode(GraphEntity.ID nodeID) {
            if (nodeID == null) {
                return null;
            }
            MemberNode result = null;
            if (this.ref != null && this.ref.equals(nodeID)) {
                result = this;
            } else {
                MemberNode member;
                for (int i = 0; i < this.memberV.size() && (result = (member = (MemberNode)this.memberV.elementAt(i)).findMemberNode(nodeID)) == null; ++i) {
                }
            }
            return result;
        }

        public int resetRowIndex(int startIndex) {
            int index = startIndex;
            this.setRowIndex(index++);
            if (startIndex == -1 || this.isCollapsed) {
                for (int i = 0; i < this.memberV.size(); ++i) {
                    MemberNode member = (MemberNode)this.memberV.elementAt(i);
                    if (member instanceof GroupNode) {
                        GroupNode group = (GroupNode)member;
                        group.resetRowIndex(-1);
                        continue;
                    }
                    member.setRowIndex(-1);
                }
            } else {
                for (int i = 0; i < this.memberV.size(); ++i) {
                    MemberNode member = (MemberNode)this.memberV.elementAt(i);
                    if (member instanceof GroupNode) {
                        GroupNode group = (GroupNode)member;
                        index = group.resetRowIndex(index);
                        continue;
                    }
                    member.setRowIndex(index++);
                }
            }
            return index;
        }

        public void setSelectedAllMembers(boolean b) {
            for (int i = 0; i < this.memberV.size(); ++i) {
                MemberNode member = (MemberNode)this.memberV.elementAt(i);
                member.setSelected(b);
                if (!(member instanceof GroupNode)) continue;
                GroupNode group = (GroupNode)member;
                group.setSelectedAllMembers(b);
            }
        }

        public void sort(int sort_col, boolean sort_asc) {
            Collections.sort(this.memberV, new MemberNodeComparator(sort_col, sort_asc));
            for (int i = 0; i < this.memberV.size(); ++i) {
                MemberNode member = (MemberNode)this.memberV.elementAt(i);
                if (!(member instanceof GroupNode)) continue;
                GroupNode group = (GroupNode)member;
                group.sort(sort_col, sort_asc);
            }
        }

        protected class MemberNodeComparator
        implements Comparator {
            private int sort_col;
            private boolean sort_asc;

            public MemberNodeComparator(int sort_col, boolean sort_asc) {
                this.sort_col = sort_col;
                this.sort_asc = sort_asc;
            }

            public int compare(Object o1, Object o2) {
                int result = 0;
                JCustomRendererTable.CustomCell cell1 = (JCustomRendererTable.CustomCell)((MemberNode)o1).getData(this.sort_col);
                JCustomRendererTable.CustomCell cell2 = (JCustomRendererTable.CustomCell)((MemberNode)o2).getData(this.sort_col);
                result = cell1 != null && cell2 != null ? cell1.compareTo(cell2) : (cell1 != null ? -1 : (cell2 != null ? 1 : 0));
                if (!this.sort_asc) {
                    result = -result;
                }
                return result;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof MemberNodeComparator)) {
                    return false;
                }
                MemberNodeComparator a = (MemberNodeComparator)obj;
                return this.sort_col == a.sort_col && this.sort_asc == a.sort_asc;
            }
        }
    }

    public class MemberNode {
        protected GraphEntity.ID ref;
        protected boolean selected;
        protected Vector dataV;
        protected GroupNode parent;
        protected int rowIndex;
        protected int level;

        public MemberNode(GraphEntity.ID ref) {
            this.ref = ref;
            this.selected = false;
            this.dataV = new Vector();
            this.parent = null;
            this.rowIndex = -1;
            this.level = -1;
        }

        public GraphEntity.ID getRef() {
            return this.ref;
        }

        public void setRef(GraphEntity.ID ref) {
            this.ref = ref;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean b) {
            this.selected = b;
        }

        public int getDataCount() {
            return this.dataV.size();
        }

        public Vector getDataVector() {
            return this.dataV;
        }

        public Object getData(int columnIndex) {
            if (columnIndex < 0 || columnIndex >= this.dataV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.dataV.elementAt(columnIndex);
        }

        public void addData(Object aValue) {
            this.dataV.add(aValue);
        }

        public void insertData(int dataIndex, Object aValue) {
            if (dataIndex < 0 || dataIndex >= this.dataV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.dataV.insertElementAt(aValue, dataIndex);
        }

        public void removeData(int dataIndex) {
            if (dataIndex < 0 || dataIndex >= this.dataV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.dataV.remove(dataIndex);
        }

        public void setData(int columnIndex, Object aValue) {
            if (columnIndex < 0 || columnIndex >= this.dataV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.dataV.setElementAt(aValue, columnIndex);
        }

        public GroupNode getParent() {
            return this.parent;
        }

        public void setParent(GroupNode parent) {
            this.parent = parent;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public int getRowCount() {
            return 1;
        }

        public boolean expand() {
            boolean change = false;
            for (GroupNode p = this.parent; p != null; p = p.getParent()) {
                if (!p.isCollapsed()) continue;
                p.setCollapse(false);
                change = true;
            }
            return change;
        }

        public MemberNode findMemberNode(int row) {
            return this.rowIndex == row ? this : null;
        }

        public MemberNode findMemberNode(GraphEntity.ID nodeID) {
            if (nodeID == null) {
                return null;
            }
            if (this.ref == null) {
                return null;
            }
            return this.ref.equals(nodeID) ? this : null;
        }
    }
}

