/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoBoxFabric
extends AbstractJTopoBox {
    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphFabric fabric = (GraphFabric)this.focusEntity;
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        if (fabric.getIsPhysical().booleanValue()) {
            groupModel.setType(GuiUtil.getString("TOPO_LABEL_ENTITY_FABRIC"));
        } else {
            groupModel.setType(GuiUtil.getString("TOPO_LABEL_ENTITY_VIRTUALFABRIC"));
        }
        groupModel.setLabel(fabric.getDisplayName());
        groupModel.setHealth(fabric.getHealthStatus());
        groupModel.setIconSelected(TopoResource.ICON_FABRIC_16_SELECTED);
        groupModel.setIconUnselected(TopoResource.ICON_FABRIC_16_UNSELECTED);
        groupModel.setIconMissing(TopoResource.ICON_FABRIC_16_MISSING);
        groupModel.removeAllSummaries();
        int computerTotal = fabric.getNumOfComputers();
        int computerUnfiltered = fabric.getNumOfAbnormalComputers();
        groupModel.addSummary(new ITopoGroupModel.Summary(computerTotal, computerUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_COMPUTER"), GuiUtil.getString("TOPO_LABEL_ENTITY_COMPUTERS")));
        int swTotal = fabric.getNumOfSwitches();
        int swUnfiltered = fabric.getNumOfAbnormalSwitches();
        groupModel.addSummary(new ITopoGroupModel.Summary(swTotal, swUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCH"), GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCHES")));
        int subsystemTotal = fabric.getNumOfSubsystems();
        int subsystemUnfiltered = fabric.getNumOfAbnormalSubsystems();
        groupModel.addSummary(new ITopoGroupModel.Summary(subsystemTotal, subsystemUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_SUBSYSTEM"), GuiUtil.getString("TOPO_LABEL_ENTITY_SUBSYSTEMS")));
        int tapeLibraryTotal = fabric.getNumOfTapeLibraries();
        int tapeLibraryUnfiltered = fabric.getNumOfAbnormalTapeLibraries();
        groupModel.addSummary(new ITopoGroupModel.Summary(tapeLibraryTotal, tapeLibraryUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_TAPELIBRARY"), GuiUtil.getString("TOPO_LABEL_ENTITY_TAPELIBRARIES")));
        int otherTotal = fabric.getNumOfOthers();
        int otherUnfiltered = fabric.getNumOfAbnormalOthers();
        groupModel.addSummary(new ITopoGroupModel.Summary(otherTotal, otherUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_OTHER"), GuiUtil.getString("TOPO_LABEL_ENTITY_OTHER")));
        int total = computerTotal + swTotal + subsystemTotal + tapeLibraryTotal + otherTotal;
        int unfiltered = computerUnfiltered + swUnfiltered + subsystemUnfiltered + tapeLibraryUnfiltered + otherUnfiltered;
        groupModel.setTotalCount(total);
        groupModel.setUnfilteredCount(unfiltered);
        groupModel.setGroupKey(fabric.getGroupKey());
        groupModel.fireModelChanged();
    }
}

