/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import java.util.ResourceBundle;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2SubsystemFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemFCPortPerf;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoIcon;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoIconFCPort
extends AbstractJTopoIcon {
    public JTopoIconFCPort() {
        this.initState();
    }

    private void initState() {
        this.labelMode = 1;
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphFCPort fcport = (GraphFCPort)this.focusEntity;
        ITopoNodeModel nodeModel = (ITopoNodeModel)this.widgetModel;
        nodeModel.setType(GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORT"));
        nodeModel.setLabel(fcport.getDisplayName());
        nodeModel.setHealth(fcport.getHealthStatus());
        boolean inUse = false;
        Enumeration enu = this.canvas.getDataModel().associator(GraphFCPort2FCPort.TYPE, this.focusEntityID);
        if (enu.hasMoreElements()) {
            inUse = true;
        }
        if (inUse) {
            nodeModel.setIconSelected(TopoResource.ICON_FCPORT_USED_SELECTED);
            nodeModel.setIconUnselected(TopoResource.ICON_FCPORT_USED_UNSELECTED);
            nodeModel.setIconMissing(TopoResource.ICON_FCPORT_USED_MISSING);
        } else {
            nodeModel.setIconSelected(TopoResource.ICON_FCPORT_EMPTY_SELECTED);
            nodeModel.setIconUnselected(TopoResource.ICON_FCPORT_EMPTY_UNSELECTED);
            nodeModel.setIconMissing(TopoResource.ICON_FCPORT_EMPTY_MISSING);
        }
        nodeModel.setPerf(fcport.getPerfStatus());
        String perfTooltip = null;
        enu = this.canvas.getDataModel().associator(GraphFCPort2SubsystemFCPortPerf.TYPE, this.focusEntityID);
        if (enu.hasMoreElements()) {
            GraphSubsystemFCPortPerf p = (GraphSubsystemFCPortPerf)enu.nextElement();
            String ioRateRx = GraphModelUtilities.formatDouble(p.getIORateRx());
            String ioRateTx = GraphModelUtilities.formatDouble(p.getIORateTx());
            String dataRateRx = GraphModelUtilities.formatDouble(p.getDataRateRx());
            String dataRateTx = GraphModelUtilities.formatDouble(p.getDataRateTx());
            String responseTimeRx = GraphModelUtilities.formatDouble(p.getResponseTimeRx());
            String responseTimeTx = GraphModelUtilities.formatDouble(p.getResponseTimeTx());
            ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.common.meta.MdRbMetrics");
            StringBuffer sb = new StringBuffer();
            sb.append("<HTML>");
            sb.append(GraphModelUtilities.getTooltipPerf(fcport.getPerfStatus()));
            sb.append("<HR width=120 align=left>");
            sb.append("<TABLE>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_PORT_SEND_IO_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + ioRateTx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_PORT_RECV_IO_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + ioRateRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_PORT_SEND_DATA_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + dataRateTx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_PORT_RECV_DATA_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + dataRateRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_PORT_RECV_RESP_TIME_NAME") + ":" + "</TD>");
            sb.append("<TD>" + responseTimeRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_PORT_SEND_RESP_TIME_NAME") + ":" + "</TD>");
            sb.append("<TD>" + responseTimeTx + "</TD>");
            sb.append("</TR>");
            sb.append("</TABLE>");
            sb.append("</HTML>");
            perfTooltip = sb.toString();
        }
        nodeModel.setPerfTooltip(perfTooltip);
        nodeModel.fireModelChanged();
    }
}

