/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import java.util.ResourceBundle;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2SwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoIcon;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoIconSwitchFCPort
extends AbstractJTopoIcon {
    public JTopoIconSwitchFCPort() {
        this.maxLabelWidth_compact = 40;
        this.maxLabelWidth_relax = 120;
    }

    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphFCPort fcport = (GraphFCPort)this.focusEntity;
        ITopoNodeModel nodeModel = (ITopoNodeModel)this.widgetModel;
        nodeModel.setType(GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORT"));
        String portNumber = fcport.getPortNumber();
        String displayName = fcport.getDisplayName();
        if (portNumber != null) {
            nodeModel.setLabel(portNumber);
        } else {
            nodeModel.setLabel(displayName);
        }
        nodeModel.setHealth(fcport.getHealthStatus());
        boolean inUse = false;
        Enumeration enu = this.canvas.getDataModel().associator(GraphFCPort2FCPort.TYPE, this.focusEntityID);
        if (enu.hasMoreElements()) {
            inUse = true;
        }
        if (inUse) {
            nodeModel.setIconSelected(TopoResource.ICON_FCPORT_USED_SELECTED);
            nodeModel.setIconUnselected(TopoResource.ICON_FCPORT_USED_UNSELECTED);
            nodeModel.setIconMissing(TopoResource.ICON_FCPORT_USED_MISSING);
        } else {
            nodeModel.setIconSelected(TopoResource.ICON_FCPORT_EMPTY_SELECTED);
            nodeModel.setIconUnselected(TopoResource.ICON_FCPORT_EMPTY_UNSELECTED);
            nodeModel.setIconMissing(TopoResource.ICON_FCPORT_EMPTY_MISSING);
        }
        nodeModel.setPerf(fcport.getPerfStatus());
        String perfTooltip = null;
        enu = this.canvas.getDataModel().associator(GraphFCPort2SwitchFCPortPerf.TYPE, this.focusEntityID);
        if (enu.hasMoreElements()) {
            GraphSwitchFCPortPerf p = (GraphSwitchFCPortPerf)enu.nextElement();
            String packetRateRx = GraphModelUtilities.formatDouble(p.getPacketRateRx());
            String packetRateTx = GraphModelUtilities.formatDouble(p.getPacketRateTx());
            String dataRateRx = GraphModelUtilities.formatDouble(p.getDataRateRx());
            String dataRateTx = GraphModelUtilities.formatDouble(p.getDataRateTx());
            String errorFrameRate = GraphModelUtilities.formatDouble(p.getErrorFrameRate());
            String linkFailureRate = GraphModelUtilities.formatDouble(p.getLinkFailureRate());
            ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.common.meta.MdRbMetrics");
            StringBuffer sb = new StringBuffer();
            sb.append("<HTML>");
            sb.append(GraphModelUtilities.getTooltipPerf(fcport.getPerfStatus()));
            sb.append("<HR width=120 align=left>");
            sb.append("<TABLE>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_PORT_SEND_PKT_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + packetRateTx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_PORT_RECV_PKT_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + packetRateRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_PORT_SEND_DATA_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + dataRateTx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_PORT_RECV_DATA_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + dataRateRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_ERR_FRAME_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + errorFrameRate + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_LNK_FAIL_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + linkFailureRate + "</TD>");
            sb.append("</TR>");
            sb.append("</TABLE>");
            sb.append("</HTML>");
            perfTooltip = sb.toString();
        }
        nodeModel.setPerfTooltip(perfTooltip);
        nodeModel.fireModelChanged();
    }
}

