/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import java.util.ResourceBundle;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2VolumePerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumePerf;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoIcon;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoIconVolume
extends AbstractJTopoIcon {
    protected void reattach() {
        Integer flashCopy;
        if (this.focusEntity == null) {
            return;
        }
        GraphVolume volume = (GraphVolume)this.focusEntity;
        ITopoNodeModel nodeModel = (ITopoNodeModel)this.widgetModel;
        if ("External".equals(this.getScope())) {
            nodeModel.setType(GuiUtil.getString("TOPO_LABEL_ENTITY_BACKENDVOLUME"));
        } else {
            nodeModel.setType(GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUME"));
        }
        nodeModel.setLabel(volume.getDisplayName());
        nodeModel.setHealth(volume.getHealthStatus());
        Integer n = flashCopy = volume == null ? null : volume.getFlashCopyType();
        if (GraphVolume.FLASHCOPYTYPE_SOURCE.equals(flashCopy)) {
            nodeModel.setIconSelected(TopoResource.ICON_VOLUME_SRC_32_SELECTED);
            nodeModel.setIconUnselected(TopoResource.ICON_VOLUME_SRC_32_UNSELECTED);
            nodeModel.setIconMissing(TopoResource.ICON_VOLUME_SRC_32_MISSING);
        } else if (GraphVolume.FLASHCOPYTYPE_TARGET.equals(flashCopy)) {
            nodeModel.setIconSelected(TopoResource.ICON_VOLUME_TARGET_32_SELECTED);
            nodeModel.setIconUnselected(TopoResource.ICON_VOLUME_TARGET_32_UNSELECTED);
            nodeModel.setIconMissing(TopoResource.ICON_VOLUME_TARGET_32_MISSING);
        } else if (GraphVolume.FLASHCOPYTYPE_SOURCETARGET.equals(flashCopy)) {
            nodeModel.setIconSelected(TopoResource.ICON_VOLUME_SRCTARGET_32_SELECTED);
            nodeModel.setIconUnselected(TopoResource.ICON_VOLUME_SRCTARGET_32_UNSELECTED);
            nodeModel.setIconMissing(TopoResource.ICON_VOLUME_SRCTARGET_32_MISSING);
        } else {
            nodeModel.setIconSelected(TopoResource.ICON_VOLUME_32_SELECTED);
            nodeModel.setIconUnselected(TopoResource.ICON_VOLUME_32_UNSELECTED);
            nodeModel.setIconMissing(TopoResource.ICON_VOLUME_32_MISSING);
        }
        nodeModel.setPerf(volume.getPerfStatus());
        String perfTooltip = null;
        Enumeration enu = this.canvas.getDataModel().associator(GraphVolume2VolumePerf.TYPE, this.focusEntityID);
        if (enu.hasMoreElements()) {
            GraphVolumePerf p = (GraphVolumePerf)enu.nextElement();
            String ioRateRx = GraphModelUtilities.formatDouble(p.getIORateRx());
            String ioRateTx = GraphModelUtilities.formatDouble(p.getIORateTx());
            String dataRateRx = GraphModelUtilities.formatDouble(p.getDataRateRx());
            String dataRateTx = GraphModelUtilities.formatDouble(p.getDataRateTx());
            String responseTimeRx = GraphModelUtilities.formatDouble(p.getResponseTimeRx());
            String responseTimeTx = GraphModelUtilities.formatDouble(p.getResponseTimeTx());
            String cacheHitRx = GraphModelUtilities.formatDouble(p.getCacheHitRx());
            String cacheHitTx = GraphModelUtilities.formatDouble(p.getCacheHitTx());
            ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.common.meta.MdRbMetrics");
            StringBuffer sb = new StringBuffer();
            sb.append("<HTML>");
            sb.append(GraphModelUtilities.getTooltipPerf(volume.getPerfStatus()));
            sb.append("<HR width=120 align=left>");
            sb.append("<TABLE>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_READ_IO_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + ioRateRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_WRITE_IO_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + ioRateTx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_READ_KB_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + dataRateRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_WRITE_KB_RATE_NAME") + ":" + "</TD>");
            sb.append("<TD>" + dataRateTx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_READ_RESP_TIME_NAME") + ":" + "</TD>");
            sb.append("<TD>" + responseTimeRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_WRITE_RESP_TIME_NAME") + ":" + "</TD>");
            sb.append("<TD>" + responseTimeTx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_READ_HITS_PERC_NAME") + ":" + "</TD>");
            sb.append("<TD>" + cacheHitRx + "</TD>");
            sb.append("</TR>");
            sb.append("<TR>");
            sb.append("<TD>" + rb.getString("MET_WRITE_HITS_PERC_NAME") + ":" + "</TD>");
            sb.append("<TD>" + cacheHitTx + "</TD>");
            sb.append("</TR>");
            sb.append("</TABLE>");
            sb.append("</HTML>");
            perfTooltip = sb.toString();
        }
        nodeModel.setPerfTooltip(perfTooltip);
        nodeModel.fireModelChanged();
    }
}

