/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewTapeLibraryL1Connectivity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSubview;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxSwitchGroup;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoSubviewTapeLibraryL1Connectivity
extends AbstractJTopoSubview {
    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphSubviewTapeLibraryL1Connectivity connectivity = (GraphSubviewTapeLibraryL1Connectivity)this.focusEntity;
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        groupModel.setType(connectivity.getDisplayName());
        groupModel.setLabel(connectivity.getDisplayName());
        groupModel.setHealth(connectivity.getHealthStatus());
        groupModel.setIconSelected(TopoResource.ICON_FABRICGROUP_16_SELECTED);
        groupModel.setIconUnselected(TopoResource.ICON_FABRICGROUP_16_UNSELECTED);
        groupModel.setIconMissing(TopoResource.ICON_FABRICGROUP_16_MISSING);
        groupModel.removeAllSummaries();
        int swTotal = connectivity.getNumOfSwitches();
        int swUnfiltered = connectivity.getNumOfAbnormalSwitches();
        groupModel.addSummary(new ITopoGroupModel.Summary(swTotal, swUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCH"), GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCHES")));
        int total = swTotal;
        int unfiltered = swUnfiltered;
        groupModel.setTotalCount(total);
        groupModel.setUnfilteredCount(unfiltered);
        groupModel.setGroupKey(connectivity.getGroupKey());
        groupModel.fireModelChanged();
    }

    protected AbstractJTopoBox.ContainerPanel createContainerPanel(ITopoGroupModel groupModel) {
        return new ContainerPanel((ITopoUnitModel)groupModel);
    }

    protected class ContainerPanel
    extends AbstractJTopoBox.ContainerPanel {
        protected JPanel swGroupPanel;

        public ContainerPanel(ITopoUnitModel unitModel) {
            super(unitModel);
            this.swGroupPanel = new JPanel();
            this.swGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            TopoLayoutUtilities.SquareGridLayout layout = new TopoLayoutUtilities.SquareGridLayout();
            this.swGroupPanel.setLayout(layout);
            this.initState();
        }

        private void initState() {
            this.add(this.swGroupPanel);
            this.removeAllEntities();
        }

        public void resetState() {
            super.resetState();
            this.initState();
        }

        public void addEntity(AbstractJTopoEntity entity) {
            this.entityV.add(entity);
            if (entity instanceof JTopoBoxSwitchGroup) {
                this.swGroupPanel.setVisible(true);
                this.swGroupPanel.add(entity);
            }
        }

        public void removeEntity(AbstractJTopoEntity entity) {
            this.entityV.remove(entity);
            if (entity instanceof JTopoBoxSwitchGroup) {
                this.swGroupPanel.remove(entity);
                this.swGroupPanel.setVisible(this.swGroupPanel.getComponentCount() > 0);
            }
        }

        public void removeAllEntities() {
            this.entityV.clear();
            this.swGroupPanel.removeAll();
            this.swGroupPanel.setVisible(false);
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        extends TopoLayoutUtilities.VerticalLayout {
            public DefaultLayout() {
                this.setMargin(15);
            }
        }
    }
}

