/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk;
import org.eclipse.aperi.gui.topo.model.bean.GraphDiskGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphDiskGroup2Disk;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTable;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnGroup;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnModel;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnRegular;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnStatus;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.JCustomRendererTable;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoTableDisk
extends AbstractJTopoTable {
    public JTopoTableDisk() {
        this.tableColumnModel = new DefaultTopoTableColumnModel();
        int columnCount = 0;
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnStatus(columnCount++, "TOPO_LABEL_ATTR_COMMON_LOCATED", null));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnStatus(columnCount++, "TOPO_LABEL_ATTR_COMMON_HEALTH", null));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnGroup(columnCount++));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_LABEL", 150));
        if (GraphDebug.isInfoVisible()) {
            this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_DEBUG", 150));
        }
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_OPERATIONALSTATUS"));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_VENDOR"));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_MODEL"));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_SERIAL"));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_CAPACITY"));
        this.table.setColumnModel(this.tableColumnModel);
        this.tableModel = new DefaultTopoTableModel(this.tableColumnModel);
        this.table.setModel(this.tableModel);
        this.arrangeRecordGroup = new AbstractJTopoTable.ArrangeRecord("TOPO_LABEL_ATTR_COMMON_GROUP", true);
        this.arrangeRecord = new AbstractJTopoTable.ArrangeRecord("TOPO_LABEL_ATTR_COMMON_LABEL", true);
    }

    protected void reattach() {
        DefaultTopoTableModel tableModel = (DefaultTopoTableModel)this.table.getModel();
        tableModel.removeAll();
        if (this.dataModel == null) {
            return;
        }
        DefaultTopoTableModel.RootNode root = tableModel.getRootNode();
        Enumeration enu2 = this.dataModel.enumerate(GraphDiskGroup.TYPE);
        while (enu2.hasMoreElements()) {
            GraphDiskGroup diskGroup = (GraphDiskGroup)enu2.nextElement();
            GraphDiskGroup.ID diskGroupID = (GraphDiskGroup.ID)diskGroup.getEntityID();
            if (Boolean.TRUE.equals(diskGroup.getIsFilterable())) continue;
            DefaultTopoTableModel.GroupNode group = null;
            if (!Boolean.TRUE.equals(diskGroup.getIsHelper())) {
                DefaultTopoTableModel defaultTopoTableModel = tableModel;
                defaultTopoTableModel.getClass();
                group = defaultTopoTableModel.new DefaultTopoTableModel.GroupNode(diskGroupID);
                root.addMember(group);
                group.addData(new JCustomRendererTable.StatusCell(null, null, null));
                group.addData(new JCustomRendererTable.StatusCell(GraphModelUtilities.getStatusAlias(diskGroup.getHealthStatus()), diskGroup.getHealthStatus(), TopoResource.getIconHealth(diskGroup.getHealthStatus())));
                group.addData(new JCustomRendererTable.GroupLabelCell(diskGroup.getDisplayName(), diskGroup.getSortingValue(), diskGroup.getCollationKey(), group));
            }
            Enumeration enu = this.dataModel.associator(GraphDiskGroup2Disk.TYPE, diskGroupID);
            while (enu.hasMoreElements()) {
                GraphDisk disk = (GraphDisk)enu.nextElement();
                GraphDisk.ID diskID = (GraphDisk.ID)disk.getEntityID();
                if (Boolean.TRUE.equals(disk.getIsFilterable())) continue;
                DefaultTopoTableModel defaultTopoTableModel = tableModel;
                defaultTopoTableModel.getClass();
                DefaultTopoTableModel.MemberNode member = defaultTopoTableModel.new DefaultTopoTableModel.MemberNode(diskID);
                if (group == null) {
                    root.addMember(member);
                } else {
                    group.addMember(member);
                }
                member.addData(new JCustomRendererTable.StatusCell(null, null, null));
                member.addData(new JCustomRendererTable.StatusCell(GraphModelUtilities.getStatusAlias(disk.getHealthStatus()), disk.getHealthStatus(), TopoResource.getIconHealth(disk.getHealthStatus())));
                if (group == null) {
                    member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)GuiUtil.getString("TOPO_LABEL_COMMON_NA"))));
                } else {
                    member.addData(new JCustomRendererTable.MemberGroupLabelCell(diskGroup.getDisplayName(), group));
                }
                member.addData(new JCustomRendererTable.CollatorCell(disk.getDisplayName(), disk.getCollationKey()));
                if (GraphDebug.isInfoVisible()) {
                    member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)disk.getEntityID().getID().toString())));
                }
                member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)GraphModelUtilities.getOperationalStatus(disk.getOperationalStatus()))));
                String vendor = disk.getVendor();
                if ("UNKNOWN".equalsIgnoreCase(vendor)) {
                    vendor = GuiUtil.getString("TOPO_LABEL_STATUS_UNKNOWN");
                }
                member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)vendor)));
                String model = disk.getModel();
                if ("UNKNOWN".equalsIgnoreCase(model)) {
                    model = GuiUtil.getString("TOPO_LABEL_STATUS_UNKNOWN");
                }
                member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)model)));
                member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)disk.getSerialNumber())));
                member.addData(new JCustomRendererTable.FormatedStringCell(GraphModelUtilities.byte2GBString(disk.getCapacity()), disk.getCapacity()));
            }
        }
        this.arrange();
    }
}

