/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelPinList;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ControllerView;

public class PinList {
    private ControllerApp controllerApp;
    private GraphModelPinList dataModel = new GraphModelPinList();

    public void destruct() {
        this.dataModel = null;
    }

    public ControllerApp getControllerApp() {
        return this.controllerApp;
    }

    public GraphModel getModel() {
        return this.dataModel;
    }

    public void setSessionModel(ControllerApp controllerApp, GraphModelPinList dataModel) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("PinList, setModel(), dataModel=" + dataModel.toString());
        }
        this.controllerApp = controllerApp;
        this.dataModel = dataModel;
        Enumeration enu = controllerApp.getControllerViews();
        while (enu.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enu.nextElement();
            controllerView.setPinList(this);
        }
    }

    public Vector getPins() {
        GraphModelPinList.ID modelID = (GraphModelPinList.ID)this.dataModel.getModelID();
        Vector entityIDV = modelID.getChildFocusEntityIDs();
        return entityIDV;
    }

    public boolean isInPinList(GraphEntity.ID entityID) {
        GraphModelPinList.ID modelID = (GraphModelPinList.ID)this.dataModel.getModelID();
        Vector entityIDV = modelID.getChildFocusEntityIDs();
        boolean found = false;
        for (int i = 0; i < entityIDV.size(); ++i) {
            GraphEntity.ID id = (GraphEntity.ID)entityIDV.elementAt(i);
            if (!id.equals(entityID)) continue;
            found = true;
            break;
        }
        return found;
    }

    public void addPins(Vector entityIDV) {
        GraphModelPinList.ID modelID = (GraphModelPinList.ID)this.dataModel.getModelID();
        modelID.setPinsToBeAdded(entityIDV);
        this.controllerApp.refreshView(modelID);
    }

    public void removePins(Vector entityIDV) {
        GraphModelPinList.ID modelID = (GraphModelPinList.ID)this.dataModel.getModelID();
        modelID.setPinsToBeRemoved(entityIDV);
        this.controllerApp.refreshView(modelID);
    }

    public void clearPinList() {
        GraphModelPinList.ID modelID = (GraphModelPinList.ID)this.dataModel.getModelID();
        modelID.setPinsToBeRemoved(modelID.getChildFocusEntityIDs());
        this.controllerApp.refreshView(modelID);
    }
}

