/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphAssociation;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBracketLine;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoIcon;
import org.eclipse.aperi.gui.topo.widget.ITopoAssociationModel;

public class TopoBrackletLineLayoutUtilities {
    public static void setYOffsetForBacketLayout(Vector widgetV, Vector bracketLineV) {
        int i;
        Record record;
        Collections.sort(widgetV, new Comparator(){

            public int compare(Object o1, Object o2) {
                AbstractJTopoEntity widget1 = (AbstractJTopoEntity)o1;
                AbstractJTopoEntity widget2 = (AbstractJTopoEntity)o2;
                Integer y1 = new Integer(widget1.getY());
                Integer y2 = new Integer(widget2.getY());
                return y1.compareTo(y2);
            }

            public boolean equals(Object obj) {
                return this.equals(obj);
            }
        });
        Hashtable<RecordID, Record> recordIDH = new Hashtable<RecordID, Record>();
        Vector<Record> recordV = new Vector<Record>();
        for (int i2 = 0; i2 < bracketLineV.size(); ++i2) {
            AbstractJTopoBracketLine bracketLine = (AbstractJTopoBracketLine)bracketLineV.elementAt(i2);
            RecordID recordID = new RecordID(bracketLine, widgetV);
            record = (Record)recordIDH.get(recordID);
            if (record == null) {
                record = new Record(recordID);
                recordIDH.put(recordID, record);
                recordV.add(record);
            }
            record.addBracketLine(bracketLine);
        }
        Collections.sort(recordV, new Comparator(){

            public int compare(Object o1, Object o2) {
                int widget2Index1;
                int diff2;
                Record record1 = (Record)o1;
                Record record2 = (Record)o2;
                RecordID recordID1 = record1.getRecordID();
                RecordID recordID2 = record2.getRecordID();
                int diff1 = recordID1.getDiff();
                if (diff1 < (diff2 = recordID2.getDiff())) {
                    return -1;
                }
                if (diff1 > diff2) {
                    return 1;
                }
                int widget1Index1 = recordID1.getWidget1Index();
                if (widget1Index1 < (widget2Index1 = recordID2.getWidget1Index())) {
                    return -1;
                }
                if (widget1Index1 > widget2Index1) {
                    return 1;
                }
                return 0;
            }

            public boolean equals(Object obj) {
                return this.equals(obj);
            }
        });
        int nextSlot = 2;
        for (int i3 = 0; i3 < recordV.size(); ++i3) {
            Record record2 = (Record)recordV.elementAt(i3);
            RecordID recordID = record2.getRecordID();
            int diff = recordID.getDiff();
            if (diff == 0) {
                record2.setSlot(0);
                continue;
            }
            if (diff == 1) {
                record2.setSlot(1);
                continue;
            }
            record2.setSlot(nextSlot++);
        }
        Hashtable<Integer, PointBuffer> pbH = new Hashtable<Integer, PointBuffer>();
        for (i = 0; i < widgetV.size(); ++i) {
            pbH.put(new Integer(i), new PointBuffer());
        }
        for (i = 0; i < recordV.size(); ++i) {
            record = (Record)recordV.elementAt(i);
            RecordID recordID = record.getRecordID();
            int widget1Index = recordID.getWidget1Index();
            int widget2Index = recordID.getWidget2Index();
            int diff = recordID.getDiff();
            PointBuffer pb1 = (PointBuffer)pbH.get(new Integer(widget1Index));
            PointBuffer pb2 = (PointBuffer)pbH.get(new Integer(widget2Index));
            if (diff == 0) continue;
            if (diff == 1) {
                pb1.setBottom(record);
                pb2.setTop(record);
                continue;
            }
            pb1.addFirst(record);
            pb2.addLast(record);
        }
        for (i = 0; i < widgetV.size(); ++i) {
            AbstractJTopoEntity widget = (AbstractJTopoEntity)widgetV.elementAt(i);
            int widgetIndex = i;
            PointBuffer pb = (PointBuffer)pbH.get(new Integer(i));
            Record[] records = pb.getFinalResult();
            int iconHeight = ((AbstractJTopoIcon)widget).iconTypeR.height;
            int gap = iconHeight / (records.length + 1);
            int yOffset = iconHeight / 2;
            if (gap < 3) {
                gap = 3;
                yOffset = (iconHeight - gap * (records.length + 1)) / 2;
            }
            for (int j = 0; j < records.length; ++j) {
                yOffset += gap;
                Record record3 = records[j];
                RecordID recordID = record3.getRecordID();
                if (recordID.getWidget1Index() == widgetIndex) {
                    record3.setYOffset1(yOffset);
                    continue;
                }
                record3.setYOffset2(yOffset);
            }
        }
        for (i = 0; i < recordV.size(); ++i) {
            record = (Record)recordV.elementAt(i);
            RecordID recordID = record.recordID;
            AbstractJTopoEntity widget1 = recordID.getWidget1();
            AbstractJTopoEntity widget2 = recordID.getWidget2();
            int yOffset1 = record.getYOffset1();
            int yOffset2 = record.getYOffset2();
            int slot = record.getSlot();
            Vector v = record.getBracketLines();
            for (int j = 0; j < v.size(); ++j) {
                AbstractJTopoBracketLine bracketLine = (AbstractJTopoBracketLine)v.elementAt(j);
                ITopoAssociationModel associationModel = (ITopoAssociationModel)bracketLine.getWidgetModel();
                associationModel.setFromWidget(widget1);
                associationModel.setToWidget(widget2);
                bracketLine.setFromYOffset(yOffset1);
                bracketLine.setToYOffset(yOffset2);
                bracketLine.setSlot(slot);
            }
        }
    }

    protected static class PointBuffer {
        private Record top;
        private Record bottom;
        private LinkedList list = new LinkedList();

        public void setTop(Record top) {
            this.top = top;
        }

        public void setBottom(Record bottom) {
            this.bottom = bottom;
        }

        public void addFirst(Record o) {
            this.list.addFirst(o);
        }

        public void addLast(Record o) {
            this.list.addLast(o);
        }

        public Record[] getFinalResult() {
            if (this.top != null) {
                this.list.addFirst(this.top);
            }
            if (this.bottom != null) {
                this.list.addLast(this.bottom);
            }
            return this.list.toArray(new Record[this.list.size()]);
        }
    }

    protected static class Record {
        protected RecordID recordID;
        protected Vector bracketLineV;
        protected int yOffset1;
        protected int yOffset2;
        protected int slot;

        public Record(RecordID recordID) {
            this.recordID = recordID;
            this.bracketLineV = new Vector();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Record(");
            sb.append("recordID=" + this.recordID);
            sb.append(", yOffset1=" + this.yOffset1 + ", yOffset2=" + this.yOffset2 + ", slot=" + this.slot);
            sb.append("\r\n   lineV={");
            for (int i = 0; i < this.bracketLineV.size(); ++i) {
                AbstractJTopoBracketLine bracketLine = (AbstractJTopoBracketLine)this.bracketLineV.elementAt(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(bracketLine.getFocusEntityID());
            }
            sb.append("}");
            return sb.toString();
        }

        public RecordID getRecordID() {
            return this.recordID;
        }

        public void addBracketLine(AbstractJTopoBracketLine line) {
            this.bracketLineV.add(line);
        }

        public Vector getBracketLines() {
            return this.bracketLineV;
        }

        public int getYOffset1() {
            return this.yOffset1;
        }

        public void setYOffset1(int offset) {
            this.yOffset1 = offset;
        }

        public int getYOffset2() {
            return this.yOffset2;
        }

        public void setYOffset2(int offset) {
            this.yOffset2 = offset;
        }

        public int getSlot() {
            return this.slot;
        }

        public void setSlot(int slot) {
            this.slot = slot;
        }
    }

    protected static class RecordID {
        private AbstractJTopoBracketLine bracketLine;
        private GraphEntity.ID entityID1;
        private GraphEntity.ID entityID2;
        private AbstractJTopoEntity widget1;
        private AbstractJTopoEntity widget2;
        private int widget1Index = -1;
        private int widget2Index = -1;
        private int diff = -1;

        public RecordID(AbstractJTopoBracketLine bracketLine, Vector widgetV) {
            this.bracketLine = bracketLine;
            GraphAssociation association = (GraphAssociation)bracketLine.getFocusEntity();
            this.entityID1 = association.getFromID();
            this.entityID2 = association.getToID();
            for (int i = 0; i < widgetV.size(); ++i) {
                AbstractJTopoEntity widget = (AbstractJTopoEntity)widgetV.elementAt(i);
                GraphEntity.ID entityID = widget.getFocusEntityID();
                if (entityID.equals(this.entityID1)) {
                    this.widget1 = widget;
                    this.widget1Index = i;
                }
                if (!entityID.equals(this.entityID2)) continue;
                this.widget2 = widget;
                this.widget2Index = i;
            }
            if (this.widget1Index > this.widget2Index) {
                int t = this.widget1Index;
                this.widget1Index = this.widget2Index;
                this.widget2Index = t;
                GraphEntity.ID ttt = this.entityID1;
                this.entityID1 = this.entityID2;
                this.entityID2 = ttt;
                AbstractJTopoEntity tt = this.widget1;
                this.widget1 = this.widget2;
                this.widget2 = tt;
            }
            this.diff = this.widget2Index - this.widget1Index;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("RecordID(");
            sb.append("line's entityID=" + this.bracketLine.getFocusEntityID());
            sb.append(", widget1Index=" + this.widget1Index + ", widget2Index=" + this.widget2Index + ", diff=" + this.diff);
            sb.append(", entityID1=" + this.entityID1 + ", entityID2=" + this.entityID2);
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordID)) {
                return false;
            }
            RecordID a = (RecordID)o;
            if (this.widget1Index != a.widget1Index) {
                return false;
            }
            return this.widget2Index == a.widget2Index;
        }

        public int hashCode() {
            return this.entityID1.hashCode() + this.entityID2.hashCode();
        }

        public AbstractJTopoBracketLine getLine() {
            return this.bracketLine;
        }

        public GraphEntity.ID getEntityID1() {
            return this.entityID1;
        }

        public GraphEntity.ID getEntityID2() {
            return this.entityID1;
        }

        public AbstractJTopoEntity getWidget1() {
            return this.widget1;
        }

        public AbstractJTopoEntity getWidget2() {
            return this.widget2;
        }

        public int getWidget1Index() {
            return this.widget1Index;
        }

        public int getWidget2Index() {
            return this.widget2Index;
        }

        public int getDiff() {
            return this.diff;
        }
    }
}

