/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.identity;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.identity.MainframeLinuxHWID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class HardwareID
implements Serializable {
    static final long serialVersionUID = 1177468458824214297L;
    private static final int MAX_HWID_LENGTH = 20;
    public byte[] hardwareID;
    public String manufacturer;
    public String hostName;
    public short osType;
    public short cpuArchitecture;
    private transient boolean isPCArchitecture;
    public static String model;
    public static String serialNumber;

    private void init(byte[] hwID, String mfr, String pHostName, short pOSType, short pCPUArch) {
        this.hardwareID = hwID;
        this.manufacturer = mfr;
        this.hostName = pHostName;
        this.osType = pOSType;
        this.cpuArchitecture = pCPUArch;
    }

    public HardwareID(byte[] hwID, String mfr, String pHostName, short pOSType, short pCPUArch) {
        this.init(hwID, mfr, pHostName, pOSType, pCPUArch);
    }

    public HardwareID(byte[] hwID, String mfr, String pHostName, short pOSType) {
        this.init(hwID, mfr, pHostName, pOSType, (short)0);
    }

    public HardwareID(byte[] hwID, String mfr) throws LocalizableException {
        MutableShort cpuArch = new MutableShort();
        short pOSType = HardwareID.getOSType(cpuArch);
        this.init(hwID, mfr, HardwareID.getLocalHostName(), pOSType, cpuArch.value);
    }

    public HardwareID(String localHostName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "HardwareID", "localHostName");
        }
        this.isPCArchitecture = false;
        this.manufacturer = "UNKNOWN";
        MutableShort cpuArch = new MutableShort();
        this.osType = HardwareID.getOSType(cpuArch);
        this.cpuArchitecture = cpuArch.value;
        cpuArch = null;
        HardwareID.initIDs();
        try {
            if (this.cpuArchitecture != 5) {
                this.queryHardware();
                if (this.osType == 1 || this.osType == 5) {
                    this.hardwareID = GUID.readGUID().toByteArray();
                }
            } else {
                MainframeLinuxHWID.query(this);
                this.manufacturer = "IBM";
            }
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(HardwareID.class.getName(), "HardwareID", e);
            }
            e.print();
        }
        if (this.hardwareID == null && this.isPCArchitecture) {
            MessageLog.logMessage("GEN0083I");
            try {
                this.queryEthernetCard();
                MessageLog.logMessage("GEN0084I");
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(HardwareID.class.getName(), "HardwareID", e);
                }
                e.print();
            }
        }
        this.hostName = localHostName;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "HardwareID");
        }
    }

    public HardwareID() throws LocalizableException {
        this(HardwareID.getLocalHostName());
    }

    public static native String getLocalHostName() throws LocalizableException;

    public void setBogusHardwareID(String bogus) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "setBogusHardwareID", "bogus");
        }
        this.hardwareID = bogus.getBytes();
        if (this.hardwareID.length > 20) {
            byte[] newArray = new byte[20];
            System.arraycopy(this.hardwareID, 0, newArray, 0, newArray.length);
            this.hardwareID = newArray;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "setBogusHardwareID");
        }
    }

    private static native void initIDs();

    private native void queryHardware() throws LocalizableException;

    private native void queryEthernetCard() throws LocalizableException;

    private static short handleHPUX() {
        int pos;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "handleHPUX", "");
        }
        int osType = 3;
        String osVersion = System.getProperty("os.version");
        if (osVersion != null && (pos = osVersion.indexOf(46)) >= 0) {
            int secondDot;
            if ((secondDot = osVersion.indexOf(46, ++pos)) < 0) {
                secondDot = osVersion.length();
            }
            String majorString = osVersion.substring(pos, secondDot);
            int major = 11;
            try {
                major = Integer.parseInt(majorString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (major == 10) {
                osType = 7;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "handleHPUX", (short)osType);
        }
        return (short)osType;
    }

    public static short getOSType(MutableShort cpuArchitecture) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "getOSType", "cpuArchitecture");
        }
        int osType = 0;
        cpuArchitecture.value = 0;
        String osName = System.getProperty("os.name", " ");
        if (osName.equalsIgnoreCase("Solaris")) {
            osType = 6;
            cpuArchitecture.value = (short)3;
        } else if (osName.equalsIgnoreCase("SunOS")) {
            osType = 6;
            cpuArchitecture.value = (short)3;
        } else if (osName.equalsIgnoreCase("linux")) {
            osType = 1;
            String osArch = System.getProperty("os.arch", " ");
            cpuArchitecture.value = (osArch = osArch.toLowerCase()).startsWith("s390") ? (short)5 : (osArch.startsWith("ppc") ? (short)1 : (short)2);
        } else if (osName.regionMatches(true, 0, "win", 0, 3)) {
            cpuArchitecture.value = (short)2;
            String osVersion = System.getProperty("os.version", " ");
            osType = osVersion.charAt(0) >= '5' ? 5 : 4;
        } else if (osName.equalsIgnoreCase("aix")) {
            osType = 2;
            cpuArchitecture.value = 1;
        } else if (osName.equalsIgnoreCase("HP-UX")) {
            osType = HardwareID.handleHPUX();
            cpuArchitecture.value = (short)4;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "getOSType", (short)osType);
        }
        return (short)osType;
    }

    public static short getOSType() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "getOSType", "");
        }
        MutableShort discarded = new MutableShort();
        short traceResult = HardwareID.getOSType(discarded);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "getOSType", traceResult);
        }
        return traceResult;
    }

    public static short getCPUArch() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "getCPUArch", "");
        }
        MutableShort cpuArch = new MutableShort();
        HardwareID.getOSType(cpuArch);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "getCPUArch", cpuArch.value);
        }
        return cpuArch.value;
    }

    public boolean equals(Object obj) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "equals", "obj");
        }
        HardwareID right = (HardwareID)obj;
        boolean bl = traceResult = Arrays.equals(this.hardwareID, right.hardwareID) && this.manufacturer.equals(right.manufacturer);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "equals", traceResult);
        }
        return traceResult;
    }
}

