/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;

public class ComplexQuery {
    private static boolean debug = false;
    private static final String DELIMITER = "'";

    private ComplexQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int sqlUpdate(DBConnection con, String sql, Hashtable params) throws SQLException {
        if (sql == null) {
            throw new SQLException("Error - no sql string provided");
        }
        if (con == null) {
            throw new SQLException("Error - no connection provided");
        }
        int rc = 0;
        DBPreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(sql);
            if (params != null) {
                TreeMap tMap = new TreeMap(params);
                Iterator iterator = tMap.keySet().iterator();
                int paramCounter = 1;
                while (iterator.hasNext()) {
                    ColumnInfo colInfo = (ColumnInfo)iterator.next();
                    DBQueryAssistant.setPreparedStatementParameter(stmt, colInfo, paramCounter, params);
                    ++paramCounter;
                }
            }
            rc = stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ignore) {}
            }
        }
        return rc;
    }

    public static DBResultSet sqlQuery(DBConnection con, String sql, Hashtable params) throws SQLException {
        if (sql == null) {
            throw new SQLException("Error - no sql string provided");
        }
        if (con == null) {
            throw new SQLException("Error - no connection provided");
        }
        DBPreparedStatement stmt = con.prepareStatement(sql);
        if (params != null) {
            TreeMap tMap = new TreeMap(params);
            Iterator iterator = tMap.keySet().iterator();
            int paramCounter = 1;
            while (iterator.hasNext()) {
                ColumnInfo colInfo = (ColumnInfo)iterator.next();
                DBQueryAssistant.setPreparedStatementParameter(stmt, colInfo, paramCounter, params);
                ++paramCounter;
            }
        }
        DBResultSet rs = null;
        try {
            rs = stmt.executeQuery();
        }
        catch (SQLException sqle) {
            try {
                stmt.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw sqle;
        }
        return rs;
    }

    public static Hashtable generateHashtable(Vector colInfoVec, Vector values) throws SQLException {
        if (colInfoVec.size() != values.size()) {
            throw new SQLException("Invalid parameters - vector sizes dont match");
        }
        Hashtable ret = new Hashtable();
        for (int i = 0; i < colInfoVec.size(); ++i) {
            ColumnInfo col = new ColumnInfo();
            col.setDataType(((ColumnInfo)colInfoVec.elementAt(i)).getDataType());
            col.setName(String.valueOf(10 + i));
            ret.put(col, values.elementAt(i));
        }
        return ret;
    }
}

