/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchTable;

public class CimkeySwitch
extends TResCimkeySwitchTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static CimkeySwitchCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new CimkeySwitchCursor(con, htWhereClause, columns);
    }

    public CimkeySwitch() {
        this.clear();
    }

    public CimkeySwitch(int CimkeySwitchId, String SwitchWwn, int CimNamespaceId, String Name2, short NameFormat, short CreationClassNameId, short Active) {
        this.clear();
        this.m_CimkeySwitchId = CimkeySwitchId;
        this.m_SwitchWwn = SwitchWwn;
        this.m_CimNamespaceId = CimNamespaceId;
        this.m_Name = Name2;
        this.m_NameFormat = NameFormat;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_Active = Active;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_CimkeySwitchId != Integer.MIN_VALUE) {
            htColsAndValues.put(CimkeySwitch.getColumnInfo("CIMKEY_SWITCH_ID"), String.valueOf(this.m_CimkeySwitchId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(CimkeySwitch.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_NameFormat != Short.MIN_VALUE) {
            htColsAndValues.put(CimkeySwitch.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_Active != Short.MIN_VALUE) {
            htColsAndValues.put(CimkeySwitch.getColumnInfo("ACTIVE"), String.valueOf(this.m_Active));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htColsAndValues.put(CimkeySwitch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htColsAndValues.put(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_CIMKEY_SWITCH", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeySwitch.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        if (htinput.get(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_CIMKEY_SWITCH", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(CimkeySwitch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_SWITCH", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeySwitch.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(CimkeySwitch.getColumnInfo("SWITCH_WWN"), htinput.get(CimkeySwitch.getColumnInfo("SWITCH_WWN")));
        if (htinput.get(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID"), htinput.get(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_SWITCH", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(CimkeySwitch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_SWITCH", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeySwitch.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(CimkeySwitch.getColumnInfo("SWITCH_WWN"), htinput.get(CimkeySwitch.getColumnInfo("SWITCH_WWN")));
        if (htinput.get(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID"), htinput.get(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_SWITCH", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(CimkeySwitch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CIMKEY_SWITCH", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CimkeySwitch retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        CimkeySwitch el = null;
        if (htinput.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(CimkeySwitch.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        htWhereClause.put(CimkeySwitch.getColumnInfo("SWITCH_WWN"), htinput.get(CimkeySwitch.getColumnInfo("SWITCH_WWN")));
        if (htinput.get(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        htWhereClause.put(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID"), htinput.get(CimkeySwitch.getColumnInfo("CIM_NAMESPACE_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CIMKEY_SWITCH", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new CimkeySwitch();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_SWITCH", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_SWITCH", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setCimkeySwitchId(DBrs.getInt("CIMKEY_SWITCH_ID"));
        this.setSwitchWwn(DBrs.getString("SWITCH_WWN"));
        this.setCimNamespaceId(DBrs.getInt("CIM_NAMESPACE_ID"));
        this.setName(DBrs.getString("NAME"));
        this.setNameFormat(DBrs.getShort("NAME_FORMAT"));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setActive(DBrs.getShort("ACTIVE"));
    }

    public static class CimkeySwitchCursor
    extends DBCursor {
        private CimkeySwitch element = new CimkeySwitch();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResCimkeySwitchTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResCimkeySwitchTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResCimkeySwitchTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return htWhereClause;
        }

        public CimkeySwitchCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_CIMKEY_SWITCH", con, CimkeySwitchCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public CimkeySwitch getObject() throws SQLException {
            CimkeySwitch el = null;
            if (this.DBrs != null) {
                el = new CimkeySwitch();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public CimkeySwitch getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

