/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResFabricTable;

public class Fabric
extends TResFabricTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static FabricCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new FabricCursor(con, htWhereClause, columns);
    }

    public Fabric() {
        this.clear();
    }

    public Fabric(String FabricWwn, int FabricId, String SanWwn, short SupportsZoning, short Active, String ParentFabricWwn, short IsPhysical, String DisplayName, short CreationClassNameId, short Detectable, int OperationalStatus, short ConsolidatedStatus, short PropagatedStatus, Timestamp ChangedTimestamp, String UserAttrib1, String UserAttrib2, String UserAttrib3, String Name2, Timestamp UpdateTimestamp, int GroupId) {
        this.clear();
        this.m_FabricWwn = FabricWwn;
        this.m_FabricId = FabricId;
        this.m_SanWwn = SanWwn;
        this.m_SupportsZoning = SupportsZoning;
        this.m_Active = Active;
        this.m_ParentFabricWwn = ParentFabricWwn;
        this.m_IsPhysical = IsPhysical;
        this.m_DisplayName = DisplayName;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_ChangedTimestamp = ChangedTimestamp;
        this.m_UserAttrib1 = UserAttrib1;
        this.m_UserAttrib2 = UserAttrib2;
        this.m_UserAttrib3 = UserAttrib3;
        this.m_Name = Name2;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_GroupId = GroupId;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_FabricId != Integer.MIN_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("FABRIC_ID"), String.valueOf(this.m_FabricId));
        }
        if (this.m_SanWwn != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("SAN_WWN"), this.m_SanWwn);
        }
        if (this.m_SupportsZoning != Short.MIN_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("SUPPORTS_ZONING"), String.valueOf(this.m_SupportsZoning));
        }
        if (this.m_Active != Short.MIN_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("ACTIVE"), String.valueOf(this.m_Active));
        }
        if (this.m_ParentFabricWwn != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("PARENT_FABRIC_WWN"), this.m_ParentFabricWwn);
        }
        if (this.m_IsPhysical != Short.MIN_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("IS_PHYSICAL"), String.valueOf(this.m_IsPhysical));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_ChangedTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("CHANGED_TIMESTAMP"), this.m_ChangedTimestamp);
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_GroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(Fabric.getColumnInfo("GROUP_ID"), String.valueOf(this.m_GroupId));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htColsAndValues.put(Fabric.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_FABRIC", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(Fabric.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        return DBQueryAssistant.performInsert("T_RES_FABRIC", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Fabric.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_FABRIC", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(Fabric.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Fabric.getColumnInfo("FABRIC_WWN"), htinput.get(Fabric.getColumnInfo("FABRIC_WWN")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_FABRIC", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Fabric.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_FABRIC", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(Fabric.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Fabric.getColumnInfo("FABRIC_WWN"), htinput.get(Fabric.getColumnInfo("FABRIC_WWN")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_FABRIC", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Fabric.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_FABRIC", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Fabric retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Fabric el = null;
        if (htinput.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(Fabric.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        htWhereClause.put(Fabric.getColumnInfo("FABRIC_WWN"), htinput.get(Fabric.getColumnInfo("FABRIC_WWN")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_FABRIC", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Fabric();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_FABRIC", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(Fabric.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_FABRIC", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setFabricWwn(DBrs.getString("FABRIC_WWN"));
        this.setFabricId(DBrs.getInt("FABRIC_ID"));
        this.setSanWwn(DBrs.getString("SAN_WWN"));
        this.setSupportsZoning(DBrs.getShort("SUPPORTS_ZONING"));
        this.setActive(DBrs.getShort("ACTIVE"));
        this.setParentFabricWwn(DBrs.getString("PARENT_FABRIC_WWN"));
        this.setIsPhysical(DBrs.getShort("IS_PHYSICAL"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(DBrs.getShort("PROPAGATED_STATUS"));
        this.setChangedTimestamp(DBrs.getTimestamp("CHANGED_TIMESTAMP"));
        this.setUserAttrib1(DBrs.getString("USER_ATTRIB1"));
        this.setUserAttrib2(DBrs.getString("USER_ATTRIB2"));
        this.setUserAttrib3(DBrs.getString("USER_ATTRIB3"));
        this.setName(DBrs.getString("NAME"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setGroupId(DBrs.getInt("GROUP_ID"));
    }

    public static class FabricCursor
    extends DBCursor {
        private Fabric element = new Fabric();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResFabricTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResFabricTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResFabricTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return htWhereClause;
        }

        public FabricCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_FABRIC", con, FabricCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public Fabric getObject() throws SQLException {
            Fabric el = null;
            if (this.DBrs != null) {
                el = new Fabric();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Fabric getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

