/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResPhyPeTable;

public class PhyPe
extends TResPhyPeTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static PhyPeCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new PhyPeCursor(con, htWhereClause, columns);
    }

    public PhyPe() {
        this.clear();
    }

    public PhyPe(int PhyPeId, String PeName, String SerialNumber, short VendorId, short ModelId, String FirmwareRevision, String MgmtTelAddr, String MgmtSnmpAddr, String MgmtUrlAddr, short ScsiType, short PlatformType, short RnidType, short ScsiSupport, String DisplayName, Timestamp UpdateTimestamp, short Detectable) {
        this.clear();
        this.m_PhyPeId = PhyPeId;
        this.m_PeName = PeName;
        this.m_SerialNumber = SerialNumber;
        this.m_VendorId = VendorId;
        this.m_ModelId = ModelId;
        this.m_FirmwareRevision = FirmwareRevision;
        this.m_MgmtTelAddr = MgmtTelAddr;
        this.m_MgmtSnmpAddr = MgmtSnmpAddr;
        this.m_MgmtUrlAddr = MgmtUrlAddr;
        this.m_ScsiType = ScsiType;
        this.m_PlatformType = PlatformType;
        this.m_RnidType = RnidType;
        this.m_ScsiSupport = ScsiSupport;
        this.m_DisplayName = DisplayName;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_Detectable = Detectable;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_PhyPeId != Integer.MIN_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("PHY_PE_ID"), String.valueOf(this.m_PhyPeId));
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_FirmwareRevision != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("FIRMWARE_REVISION"), this.m_FirmwareRevision);
        }
        if (this.m_MgmtTelAddr != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("MGMT_TEL_ADDR"), this.m_MgmtTelAddr);
        }
        if (this.m_MgmtSnmpAddr != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("MGMT_SNMP_ADDR"), this.m_MgmtSnmpAddr);
        }
        if (this.m_MgmtUrlAddr != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("MGMT_URL_ADDR"), this.m_MgmtUrlAddr);
        }
        if (this.m_ScsiType != Short.MIN_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("SCSI_TYPE"), String.valueOf(this.m_ScsiType));
        }
        if (this.m_PlatformType != Short.MIN_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("PLATFORM_TYPE"), String.valueOf(this.m_PlatformType));
        }
        if (this.m_RnidType != Short.MIN_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("RNID_TYPE"), String.valueOf(this.m_RnidType));
        }
        if (this.m_ScsiSupport != Short.MIN_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("SCSI_SUPPORT"), String.valueOf(this.m_ScsiSupport));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(PhyPe.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_PeName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key PE_NAME not found");
        }
        this.htColsAndValues.put(PhyPe.getColumnInfo("PE_NAME"), this.m_PeName);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_PHY_PE", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhyPe.getColumnInfo("PE_NAME")) == null) {
            throw new SQLException(" ERROR: key PE_NAME not found");
        }
        return DBQueryAssistant.performInsert("T_RES_PHY_PE", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_PeName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key PE_NAME not found");
        }
        this.htWhereClause.put(PhyPe.getColumnInfo("PE_NAME"), this.m_PeName);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHY_PE", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhyPe.getColumnInfo("PE_NAME")) == null) {
            throw new SQLException(" ERROR: key PE_NAME not found");
        }
        this.htWhereClause.put(PhyPe.getColumnInfo("PE_NAME"), htinput.get(PhyPe.getColumnInfo("PE_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHY_PE", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_PeName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key PE_NAME not found");
        }
        this.htWhereClause.put(PhyPe.getColumnInfo("PE_NAME"), this.m_PeName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHY_PE", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhyPe.getColumnInfo("PE_NAME")) == null) {
            throw new SQLException(" ERROR: key PE_NAME not found");
        }
        this.htWhereClause.put(PhyPe.getColumnInfo("PE_NAME"), htinput.get(PhyPe.getColumnInfo("PE_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHY_PE", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_PeName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key PE_NAME not found");
        }
        this.htWhereClause.put(PhyPe.getColumnInfo("PE_NAME"), this.m_PeName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_PHY_PE", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhyPe retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        PhyPe el = null;
        if (htinput.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(PhyPe.getColumnInfo("PE_NAME")) == null) {
            throw new SQLException(" ERROR: key PE_NAME not found");
        }
        htWhereClause.put(PhyPe.getColumnInfo("PE_NAME"), htinput.get(PhyPe.getColumnInfo("PE_NAME")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_PHY_PE", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new PhyPe();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_PHY_PE", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_PHY_PE", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setPhyPeId(DBrs.getInt("PHY_PE_ID"));
        this.setPeName(DBrs.getString("PE_NAME"));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setFirmwareRevision(DBrs.getString("FIRMWARE_REVISION"));
        this.setMgmtTelAddr(DBrs.getString("MGMT_TEL_ADDR"));
        this.setMgmtSnmpAddr(DBrs.getString("MGMT_SNMP_ADDR"));
        this.setMgmtUrlAddr(DBrs.getString("MGMT_URL_ADDR"));
        this.setScsiType(DBrs.getShort("SCSI_TYPE"));
        this.setPlatformType(DBrs.getShort("PLATFORM_TYPE"));
        this.setRnidType(DBrs.getShort("RNID_TYPE"));
        this.setScsiSupport(DBrs.getShort("SCSI_SUPPORT"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
    }

    public static class PhyPeCursor
    extends DBCursor {
        private PhyPe element = new PhyPe();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResPhyPeTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TResPhyPeTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TResPhyPeTable.getColumnInfo("VENDOR_ID")))));
            }
            if (htWhereClause.get(TResPhyPeTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TResPhyPeTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TResPhyPeTable.getColumnInfo("MODEL_ID")))));
            }
            return htWhereClause;
        }

        public PhyPeCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_PHY_PE", con, PhyPeCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public PhyPe getObject() throws SQLException {
            PhyPe el = null;
            if (this.DBrs != null) {
                el = new PhyPe();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public PhyPe getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

