/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResPortSnapshotTable;

public class PortSnapshot
extends TResPortSnapshotTable {
    public static PortSnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new PortSnapshotCursor(con, htWhereClause, columns);
    }

    public PortSnapshot() {
        this.clear();
    }

    public PortSnapshot(int SnapshotId, int PortId, String Name2, short NameFormat, String PortNumber, short Type2, int NodeId, String DisplayName, short DisplayIconType, int RioLoopId, short Detectable, int OperationalStatus, short ConsolidatedStatus, Timestamp UpdateTimestamp, String NetworkAddresses, long PortSpeed, int FcPortId, int SubsystemId) {
        this.clear();
        this.m_SnapshotId = SnapshotId;
        this.m_PortId = PortId;
        this.m_Name = Name2;
        this.m_NameFormat = NameFormat;
        this.m_PortNumber = PortNumber;
        this.m_Type = Type2;
        this.m_NodeId = NodeId;
        this.m_DisplayName = DisplayName;
        this.m_DisplayIconType = DisplayIconType;
        this.m_RioLoopId = RioLoopId;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_NetworkAddresses = NetworkAddresses;
        this.m_PortSpeed = PortSpeed;
        this.m_FcPortId = FcPortId;
        this.m_SubsystemId = SubsystemId;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_PortId != Integer.MIN_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("PORT_ID"), String.valueOf(this.m_PortId));
        }
        if (this.m_PortNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("PORT_NUMBER"), this.m_PortNumber);
        }
        if (this.m_Type != Short.MIN_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("TYPE"), String.valueOf(this.m_Type));
        }
        if (this.m_NodeId != Integer.MIN_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("NODE_ID"), String.valueOf(this.m_NodeId));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_DisplayIconType != Short.MIN_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("DISPLAY_ICON_TYPE"), String.valueOf(this.m_DisplayIconType));
        }
        if (this.m_RioLoopId != Integer.MIN_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("RIO_LOOP_ID"), String.valueOf(this.m_RioLoopId));
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_NetworkAddresses != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("NETWORK_ADDRESSES"), this.m_NetworkAddresses);
        }
        if (this.m_PortSpeed != Long.MIN_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("PORT_SPEED"), String.valueOf(this.m_PortSpeed));
        }
        if (this.m_FcPortId != Integer.MIN_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("FC_PORT_ID"), String.valueOf(this.m_FcPortId));
        }
        if (this.m_SubsystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(PortSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htColsAndValues.put(PortSnapshot.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htColsAndValues.put(PortSnapshot.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(PortSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_PORT_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(PortSnapshot.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        if (htinput.get(PortSnapshot.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        if (htinput.get(PortSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_PORT_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PORT_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(PortSnapshot.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("NAME"), htinput.get(PortSnapshot.getColumnInfo("NAME")));
        if (htinput.get(PortSnapshot.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("NAME_FORMAT"), htinput.get(PortSnapshot.getColumnInfo("NAME_FORMAT")));
        if (htinput.get(PortSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(PortSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PORT_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PORT_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(PortSnapshot.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("NAME"), htinput.get(PortSnapshot.getColumnInfo("NAME")));
        if (htinput.get(PortSnapshot.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("NAME_FORMAT"), htinput.get(PortSnapshot.getColumnInfo("NAME_FORMAT")));
        if (htinput.get(PortSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(PortSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PORT_SNAPSHOT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(PortSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_PORT_SNAPSHOT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PortSnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        PortSnapshot el = null;
        if (htinput.get(PortSnapshot.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        htWhereClause.put(PortSnapshot.getColumnInfo("NAME"), htinput.get(PortSnapshot.getColumnInfo("NAME")));
        if (htinput.get(PortSnapshot.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        htWhereClause.put(PortSnapshot.getColumnInfo("NAME_FORMAT"), htinput.get(PortSnapshot.getColumnInfo("NAME_FORMAT")));
        if (htinput.get(PortSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        htWhereClause.put(PortSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(PortSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_PORT_SNAPSHOT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new PortSnapshot();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_PORT_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_PORT_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnapshotId(DBrs.getInt("SNAPSHOT_ID"));
        this.setPortId(DBrs.getInt("PORT_ID"));
        this.setName(DBrs.getString("NAME"));
        this.setNameFormat(DBrs.getShort("NAME_FORMAT"));
        this.setPortNumber(DBrs.getString("PORT_NUMBER"));
        this.setType(DBrs.getShort("TYPE"));
        this.setNodeId(DBrs.getInt("NODE_ID"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setDisplayIconType(DBrs.getShort("DISPLAY_ICON_TYPE"));
        this.setRioLoopId(DBrs.getInt("RIO_LOOP_ID"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setNetworkAddresses(DBrs.getString("NETWORK_ADDRESSES"));
        this.setPortSpeed(DBrs.getLong("PORT_SPEED"));
        this.setFcPortId(DBrs.getInt("FC_PORT_ID"));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
    }

    public static class PortSnapshotCursor
    extends DBCursor {
        private PortSnapshot element = new PortSnapshot();
        private DBConnection con;

        public PortSnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_PORT_SNAPSHOT", con, htWhereClause, columns);
            this.con = con;
        }

        public PortSnapshot getObject() throws SQLException {
            PortSnapshot el = null;
            if (this.DBrs != null) {
                el = new PortSnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public PortSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

