/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TRunsTable;

public class Runs
extends TRunsTable {
    public static RunsCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new RunsCursor(con, htWhereClause, columns);
    }

    public Runs() {
        this.clear();
    }

    public Runs(double TimeStamp, int ScheduleId, int RunNumber, int NumberJobs, int SuccessfulJobs, double FinishTime, String Status2, int DeviceServerRunId, int DeviceServerId) {
        this.clear();
        this.m_TimeStamp = TimeStamp;
        this.m_ScheduleId = ScheduleId;
        this.m_RunNumber = RunNumber;
        this.m_NumberJobs = NumberJobs;
        this.m_SuccessfulJobs = SuccessfulJobs;
        this.m_FinishTime = FinishTime;
        this.m_Status = Status2;
        this.m_DeviceServerRunId = DeviceServerRunId;
        this.m_DeviceServerId = DeviceServerId;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_TimeStamp != Double.MIN_VALUE) {
            htColsAndValues.put(Runs.getColumnInfo("TIME_STAMP"), String.valueOf(this.m_TimeStamp));
        }
        if (this.m_NumberJobs != Integer.MIN_VALUE) {
            htColsAndValues.put(Runs.getColumnInfo("NUMBER_JOBS"), String.valueOf(this.m_NumberJobs));
        }
        if (this.m_SuccessfulJobs != Integer.MIN_VALUE) {
            htColsAndValues.put(Runs.getColumnInfo("SUCCESSFUL_JOBS"), String.valueOf(this.m_SuccessfulJobs));
        }
        if (this.m_FinishTime != Double.MIN_VALUE) {
            htColsAndValues.put(Runs.getColumnInfo("FINISH_TIME"), String.valueOf(this.m_FinishTime));
        }
        if (this.m_Status != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Runs.getColumnInfo("STATUS"), this.m_Status);
        }
        if (this.m_DeviceServerRunId != Integer.MIN_VALUE) {
            htColsAndValues.put(Runs.getColumnInfo("DEVICE_SERVER_RUN_ID"), String.valueOf(this.m_DeviceServerRunId));
        }
        if (this.m_DeviceServerId != Integer.MIN_VALUE) {
            htColsAndValues.put(Runs.getColumnInfo("DEVICE_SERVER_ID"), String.valueOf(this.m_DeviceServerId));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_RunNumber == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key RUN_NUMBER not found");
        }
        this.htColsAndValues.put(Runs.getColumnInfo("RUN_NUMBER"), String.valueOf(this.m_RunNumber));
        if (this.m_ScheduleId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SCHEDULE_ID not found");
        }
        this.htColsAndValues.put(Runs.getColumnInfo("SCHEDULE_ID"), String.valueOf(this.m_ScheduleId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RUNS", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Runs.getColumnInfo("RUN_NUMBER")) == null) {
            throw new SQLException(" ERROR: key RUN_NUMBER not found");
        }
        if (htinput.get(Runs.getColumnInfo("SCHEDULE_ID")) == null) {
            throw new SQLException(" ERROR: key SCHEDULE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RUNS", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_RunNumber == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key RUN_NUMBER not found");
        }
        this.htWhereClause.put(Runs.getColumnInfo("RUN_NUMBER"), String.valueOf(this.m_RunNumber));
        if (this.m_ScheduleId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SCHEDULE_ID not found");
        }
        this.htWhereClause.put(Runs.getColumnInfo("SCHEDULE_ID"), String.valueOf(this.m_ScheduleId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RUNS", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Runs.getColumnInfo("RUN_NUMBER")) == null) {
            throw new SQLException(" ERROR: key RUN_NUMBER not found");
        }
        this.htWhereClause.put(Runs.getColumnInfo("RUN_NUMBER"), htinput.get(Runs.getColumnInfo("RUN_NUMBER")));
        if (htinput.get(Runs.getColumnInfo("SCHEDULE_ID")) == null) {
            throw new SQLException(" ERROR: key SCHEDULE_ID not found");
        }
        this.htWhereClause.put(Runs.getColumnInfo("SCHEDULE_ID"), htinput.get(Runs.getColumnInfo("SCHEDULE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RUNS", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_RunNumber == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key RUN_NUMBER not found");
        }
        this.htWhereClause.put(Runs.getColumnInfo("RUN_NUMBER"), String.valueOf(this.m_RunNumber));
        if (this.m_ScheduleId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SCHEDULE_ID not found");
        }
        this.htWhereClause.put(Runs.getColumnInfo("SCHEDULE_ID"), String.valueOf(this.m_ScheduleId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RUNS", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Runs.getColumnInfo("RUN_NUMBER")) == null) {
            throw new SQLException(" ERROR: key RUN_NUMBER not found");
        }
        this.htWhereClause.put(Runs.getColumnInfo("RUN_NUMBER"), htinput.get(Runs.getColumnInfo("RUN_NUMBER")));
        if (htinput.get(Runs.getColumnInfo("SCHEDULE_ID")) == null) {
            throw new SQLException(" ERROR: key SCHEDULE_ID not found");
        }
        this.htWhereClause.put(Runs.getColumnInfo("SCHEDULE_ID"), htinput.get(Runs.getColumnInfo("SCHEDULE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RUNS", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_RunNumber == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key RUN_NUMBER not found");
        }
        this.htWhereClause.put(Runs.getColumnInfo("RUN_NUMBER"), String.valueOf(this.m_RunNumber));
        if (this.m_ScheduleId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SCHEDULE_ID not found");
        }
        this.htWhereClause.put(Runs.getColumnInfo("SCHEDULE_ID"), String.valueOf(this.m_ScheduleId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RUNS", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Runs retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Runs el = null;
        if (htinput.get(Runs.getColumnInfo("RUN_NUMBER")) == null) {
            throw new SQLException(" ERROR: key RUN_NUMBER not found");
        }
        htWhereClause.put(Runs.getColumnInfo("RUN_NUMBER"), htinput.get(Runs.getColumnInfo("RUN_NUMBER")));
        if (htinput.get(Runs.getColumnInfo("SCHEDULE_ID")) == null) {
            throw new SQLException(" ERROR: key SCHEDULE_ID not found");
        }
        htWhereClause.put(Runs.getColumnInfo("SCHEDULE_ID"), htinput.get(Runs.getColumnInfo("SCHEDULE_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RUNS", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Runs();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RUNS", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RUNS", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setTimeStamp(DBrs.getDouble("TIME_STAMP"));
        this.setScheduleId(DBrs.getInt("SCHEDULE_ID"));
        this.setRunNumber(DBrs.getInt("RUN_NUMBER"));
        this.setNumberJobs(DBrs.getInt("NUMBER_JOBS"));
        this.setSuccessfulJobs(DBrs.getInt("SUCCESSFUL_JOBS"));
        this.setFinishTime(DBrs.getDouble("FINISH_TIME"));
        this.setStatus(DBrs.getString("STATUS"));
        this.setDeviceServerRunId(DBrs.getInt("DEVICE_SERVER_RUN_ID"));
        this.setDeviceServerId(DBrs.getInt("DEVICE_SERVER_ID"));
    }

    public static class RunsCursor
    extends DBCursor {
        private Runs element = new Runs();
        private DBConnection con;

        public RunsCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RUNS", con, htWhereClause, columns);
            this.con = con;
        }

        public Runs getObject() throws SQLException {
            Runs el = null;
            if (this.DBrs != null) {
                el = new Runs();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Runs getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

