/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResScannerTable;

public class Scanner
extends TResScannerTable {
    public static ScannerCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new ScannerCursor(con, htWhereClause, columns);
    }

    public Scanner() {
        this.clear();
    }

    public Scanner(String ScannerId, String Version2, String Type2, int InactiveProcessed, int Port2, String AgentName, short Enabled, int Benchmark) {
        this.clear();
        this.m_ScannerId = ScannerId;
        this.m_Version = Version2;
        this.m_Type = Type2;
        this.m_InactiveProcessed = InactiveProcessed;
        this.m_Port = Port2;
        this.m_AgentName = AgentName;
        this.m_Enabled = Enabled;
        this.m_Benchmark = Benchmark;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_Version != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Scanner.getColumnInfo("VERSION"), this.m_Version);
        }
        if (this.m_Type != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Scanner.getColumnInfo("TYPE"), this.m_Type);
        }
        if (this.m_InactiveProcessed != Integer.MIN_VALUE) {
            htColsAndValues.put(Scanner.getColumnInfo("INACTIVE_PROCESSED"), String.valueOf(this.m_InactiveProcessed));
        }
        if (this.m_Port != Integer.MIN_VALUE) {
            htColsAndValues.put(Scanner.getColumnInfo("PORT"), String.valueOf(this.m_Port));
        }
        if (this.m_AgentName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Scanner.getColumnInfo("AGENT_NAME"), this.m_AgentName);
        }
        if (this.m_Enabled != Short.MIN_VALUE) {
            htColsAndValues.put(Scanner.getColumnInfo("ENABLED"), String.valueOf(this.m_Enabled));
        }
        if (this.m_Benchmark != Integer.MIN_VALUE) {
            htColsAndValues.put(Scanner.getColumnInfo("BENCHMARK"), String.valueOf(this.m_Benchmark));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ScannerId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SCANNER_ID not found");
        }
        this.htColsAndValues.put(Scanner.getColumnInfo("SCANNER_ID"), this.m_ScannerId);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SCANNER", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Scanner.getColumnInfo("SCANNER_ID")) == null) {
            throw new SQLException(" ERROR: key SCANNER_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SCANNER", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ScannerId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SCANNER_ID not found");
        }
        this.htWhereClause.put(Scanner.getColumnInfo("SCANNER_ID"), this.m_ScannerId);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SCANNER", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Scanner.getColumnInfo("SCANNER_ID")) == null) {
            throw new SQLException(" ERROR: key SCANNER_ID not found");
        }
        this.htWhereClause.put(Scanner.getColumnInfo("SCANNER_ID"), htinput.get(Scanner.getColumnInfo("SCANNER_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SCANNER", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ScannerId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SCANNER_ID not found");
        }
        this.htWhereClause.put(Scanner.getColumnInfo("SCANNER_ID"), this.m_ScannerId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SCANNER", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Scanner.getColumnInfo("SCANNER_ID")) == null) {
            throw new SQLException(" ERROR: key SCANNER_ID not found");
        }
        this.htWhereClause.put(Scanner.getColumnInfo("SCANNER_ID"), htinput.get(Scanner.getColumnInfo("SCANNER_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SCANNER", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ScannerId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SCANNER_ID not found");
        }
        this.htWhereClause.put(Scanner.getColumnInfo("SCANNER_ID"), this.m_ScannerId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SCANNER", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scanner retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Scanner el = null;
        if (htinput.get(Scanner.getColumnInfo("SCANNER_ID")) == null) {
            throw new SQLException(" ERROR: key SCANNER_ID not found");
        }
        htWhereClause.put(Scanner.getColumnInfo("SCANNER_ID"), htinput.get(Scanner.getColumnInfo("SCANNER_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SCANNER", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Scanner();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_SCANNER", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_SCANNER", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setScannerId(DBrs.getString("SCANNER_ID"));
        this.setVersion(DBrs.getString("VERSION"));
        this.setType(DBrs.getString("TYPE"));
        this.setInactiveProcessed(DBrs.getInt("INACTIVE_PROCESSED"));
        this.setPort(DBrs.getInt("PORT"));
        this.setAgentName(DBrs.getString("AGENT_NAME"));
        this.setEnabled(DBrs.getShort("ENABLED"));
        this.setBenchmark(DBrs.getInt("BENCHMARK"));
    }

    public static class ScannerCursor
    extends DBCursor {
        private Scanner element = new Scanner();
        private DBConnection con;

        public ScannerCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_SCANNER", con, htWhereClause, columns);
            this.con = con;
        }

        public Scanner getObject() throws SQLException {
            Scanner el = null;
            if (this.DBrs != null) {
                el = new Scanner();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Scanner getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

