/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolSnapshotTable;

public class StoragePoolSnapshot
extends TResStoragePoolSnapshotTable {
    private String m_ClassNameId_str;

    public void setClassName(String el) {
        this.m_ClassNameId_str = el;
    }

    public String getClassName() {
        return this.m_ClassNameId_str;
    }

    public static StoragePoolSnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new StoragePoolSnapshotCursor(con, htWhereClause, columns);
    }

    public StoragePoolSnapshot() {
        this.clear();
    }

    public StoragePoolSnapshot(int SnapshotId, int PoolId, long TotalManagedSpace, long RemainingManagedSpace, short Primordial, double Capacity, int ExtentSize, short NativeStatus, int NumberOfBackendVolumes, int NumberOfStorageVolumes, long TotalAvailableSpace, short ElementType, String RaidLevel, String InstanceId, int SubsystemId, short VolGroupType, int Lss, short Config2, int DiskGroupId, short Format2, long SurfacedLunCap, long UnsurfacedLunCap, Timestamp DiscoveredTime, Timestamp LastProbeTime, short Detectable, int OperationalStatus, short ConsolidatedStatus, short PropagatedStatus, String UserAttrib1, String UserAttrib2, String UserAttrib3, Timestamp UpdateTimestamp, String Name2, int DataRedundancyMin, int DataRedundancyMax, int DataRedundancyDef, int PckRedundancyMin, int PckRedundancyMax, int PckRedundancyDef, int DeltaResMin, int DeltaResMax, int DeltaResDef, String DisplayName, short RankGroup, short ClassNameId) {
        this.clear();
        this.m_SnapshotId = SnapshotId;
        this.m_PoolId = PoolId;
        this.m_TotalManagedSpace = TotalManagedSpace;
        this.m_RemainingManagedSpace = RemainingManagedSpace;
        this.m_Primordial = Primordial;
        this.m_Capacity = Capacity;
        this.m_ExtentSize = ExtentSize;
        this.m_NativeStatus = NativeStatus;
        this.m_NumberOfBackendVolumes = NumberOfBackendVolumes;
        this.m_NumberOfStorageVolumes = NumberOfStorageVolumes;
        this.m_TotalAvailableSpace = TotalAvailableSpace;
        this.m_ElementType = ElementType;
        this.m_RaidLevel = RaidLevel;
        this.m_InstanceId = InstanceId;
        this.m_SubsystemId = SubsystemId;
        this.m_VolGroupType = VolGroupType;
        this.m_Lss = Lss;
        this.m_Config = Config2;
        this.m_DiskGroupId = DiskGroupId;
        this.m_Format = Format2;
        this.m_SurfacedLunCap = SurfacedLunCap;
        this.m_UnsurfacedLunCap = UnsurfacedLunCap;
        this.m_DiscoveredTime = DiscoveredTime;
        this.m_LastProbeTime = LastProbeTime;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_UserAttrib1 = UserAttrib1;
        this.m_UserAttrib2 = UserAttrib2;
        this.m_UserAttrib3 = UserAttrib3;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_Name = Name2;
        this.m_DataRedundancyMin = DataRedundancyMin;
        this.m_DataRedundancyMax = DataRedundancyMax;
        this.m_DataRedundancyDef = DataRedundancyDef;
        this.m_PckRedundancyMin = PckRedundancyMin;
        this.m_PckRedundancyMax = PckRedundancyMax;
        this.m_PckRedundancyDef = PckRedundancyDef;
        this.m_DeltaResMin = DeltaResMin;
        this.m_DeltaResMax = DeltaResMax;
        this.m_DeltaResDef = DeltaResDef;
        this.m_DisplayName = DisplayName;
        this.m_RankGroup = RankGroup;
        this.m_ClassNameId = ClassNameId;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_PoolId != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("POOL_ID"), String.valueOf(this.m_PoolId));
        }
        if (this.m_TotalManagedSpace != Long.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("TOTAL_MANAGED_SPACE"), String.valueOf(this.m_TotalManagedSpace));
        }
        if (this.m_RemainingManagedSpace != Long.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("REMAINING_MANAGED_SPACE"), String.valueOf(this.m_RemainingManagedSpace));
        }
        if (this.m_Primordial != Short.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("PRIMORDIAL"), String.valueOf(this.m_Primordial));
        }
        if (this.m_Capacity != Double.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("CAPACITY"), String.valueOf(this.m_Capacity));
        }
        if (this.m_ExtentSize != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("EXTENT_SIZE"), String.valueOf(this.m_ExtentSize));
        }
        if (this.m_NativeStatus != Short.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("NATIVE_STATUS"), String.valueOf(this.m_NativeStatus));
        }
        if (this.m_NumberOfBackendVolumes != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("NUMBER_OF_BACKEND_VOLUMES"), String.valueOf(this.m_NumberOfBackendVolumes));
        }
        if (this.m_NumberOfStorageVolumes != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("NUMBER_OF_STORAGE_VOLUMES"), String.valueOf(this.m_NumberOfStorageVolumes));
        }
        if (this.m_TotalAvailableSpace != Long.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("TOTAL_AVAILABLE_SPACE"), String.valueOf(this.m_TotalAvailableSpace));
        }
        if (this.m_ElementType != Short.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("ELEMENT_TYPE"), String.valueOf(this.m_ElementType));
        }
        if (this.m_RaidLevel != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("RAID_LEVEL"), this.m_RaidLevel);
        }
        if (this.m_VolGroupType != Short.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("VOL_GROUP_TYPE"), String.valueOf(this.m_VolGroupType));
        }
        if (this.m_Lss != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("LSS"), String.valueOf(this.m_Lss));
        }
        if (this.m_Config != Short.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("CONFIG"), String.valueOf(this.m_Config));
        }
        if (this.m_DiskGroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("DISK_GROUP_ID"), String.valueOf(this.m_DiskGroupId));
        }
        if (this.m_Format != Short.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("FORMAT"), String.valueOf(this.m_Format));
        }
        if (this.m_SurfacedLunCap != Long.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("SURFACED_LUN_CAP"), String.valueOf(this.m_SurfacedLunCap));
        }
        if (this.m_UnsurfacedLunCap != Long.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("UNSURFACED_LUN_CAP"), String.valueOf(this.m_UnsurfacedLunCap));
        }
        if (this.m_DiscoveredTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("DISCOVERED_TIME"), this.m_DiscoveredTime);
        }
        if (this.m_LastProbeTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("LAST_PROBE_TIME"), this.m_LastProbeTime);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_DataRedundancyMin != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("DATA_REDUNDANCY_MIN"), String.valueOf(this.m_DataRedundancyMin));
        }
        if (this.m_DataRedundancyMax != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("DATA_REDUNDANCY_MAX"), String.valueOf(this.m_DataRedundancyMax));
        }
        if (this.m_DataRedundancyDef != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("DATA_REDUNDANCY_DEF"), String.valueOf(this.m_DataRedundancyDef));
        }
        if (this.m_PckRedundancyMin != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("PCK_REDUNDANCY_MIN"), String.valueOf(this.m_PckRedundancyMin));
        }
        if (this.m_PckRedundancyMax != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("PCK_REDUNDANCY_MAX"), String.valueOf(this.m_PckRedundancyMax));
        }
        if (this.m_PckRedundancyDef != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("PCK_REDUNDANCY_DEF"), String.valueOf(this.m_PckRedundancyDef));
        }
        if (this.m_DeltaResMin != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("DELTA_RES_MIN"), String.valueOf(this.m_DeltaResMin));
        }
        if (this.m_DeltaResMax != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("DELTA_RES_MAX"), String.valueOf(this.m_DeltaResMax));
        }
        if (this.m_DeltaResDef != Integer.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("DELTA_RES_DEF"), String.valueOf(this.m_DeltaResDef));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_RankGroup != Short.MIN_VALUE) {
            htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("RANK_GROUP"), String.valueOf(this.m_RankGroup));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ClassNameId_str != null) {
            this.m_ClassNameId = Normalizer.ClassNameGetID(con, this.m_ClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.m_ClassNameId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key CLASS_NAME_ID not found");
        }
        this.htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(this.m_ClassNameId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_STORAGE_POOL_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            htinput.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(con, (String)htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) == null) {
            throw new SQLException(" ERROR: key CLASS_NAME_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_STORAGE_POOL_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ClassNameId_str != null) {
            this.m_ClassNameId = Normalizer.ClassNameGetID(con, this.m_ClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.m_ClassNameId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(this.m_ClassNameId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_POOL_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            htinput.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(con, (String)htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), htinput.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), htinput.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")));
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) == null) {
            throw new SQLException(" ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_POOL_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ClassNameId_str != null) {
            this.m_ClassNameId = Normalizer.ClassNameGetID(con, this.m_ClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.m_ClassNameId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(this.m_ClassNameId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_POOL_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            htinput.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(con, (String)htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), htinput.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), htinput.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")));
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) == null) {
            throw new SQLException(" ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_POOL_SNAPSHOT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ClassNameId_str != null) {
            this.m_ClassNameId = Normalizer.ClassNameGetID(con, this.m_ClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.m_ClassNameId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(this.m_ClassNameId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_STORAGE_POOL_SNAPSHOT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StoragePoolSnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        StoragePoolSnapshot el = null;
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            htinput.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(con, (String)htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), htinput.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        htWhereClause.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), htinput.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")));
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) == null) {
            throw new SQLException(" ERROR: key CLASS_NAME_ID not found");
        }
        htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_STORAGE_POOL_SNAPSHOT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new StoragePoolSnapshot();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            htinput.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(con, (String)htinput.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(con, (String)htWhereClause.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_POOL_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(con, (String)htWhereClause.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_POOL_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnapshotId(DBrs.getInt("SNAPSHOT_ID"));
        this.setPoolId(DBrs.getInt("POOL_ID"));
        this.setTotalManagedSpace(DBrs.getLong("TOTAL_MANAGED_SPACE"));
        this.setRemainingManagedSpace(DBrs.getLong("REMAINING_MANAGED_SPACE"));
        this.setPrimordial(DBrs.getShort("PRIMORDIAL"));
        this.setCapacity(DBrs.getDouble("CAPACITY"));
        this.setExtentSize(DBrs.getInt("EXTENT_SIZE"));
        this.setNativeStatus(DBrs.getShort("NATIVE_STATUS"));
        this.setNumberOfBackendVolumes(DBrs.getInt("NUMBER_OF_BACKEND_VOLUMES"));
        this.setNumberOfStorageVolumes(DBrs.getInt("NUMBER_OF_STORAGE_VOLUMES"));
        this.setTotalAvailableSpace(DBrs.getLong("TOTAL_AVAILABLE_SPACE"));
        this.setElementType(DBrs.getShort("ELEMENT_TYPE"));
        this.setRaidLevel(DBrs.getString("RAID_LEVEL"));
        this.setInstanceId(DBrs.getString("INSTANCE_ID"));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
        this.setVolGroupType(DBrs.getShort("VOL_GROUP_TYPE"));
        this.setLss(DBrs.getInt("LSS"));
        this.setConfig(DBrs.getShort("CONFIG"));
        this.setDiskGroupId(DBrs.getInt("DISK_GROUP_ID"));
        this.setFormat(DBrs.getShort("FORMAT"));
        this.setSurfacedLunCap(DBrs.getLong("SURFACED_LUN_CAP"));
        this.setUnsurfacedLunCap(DBrs.getLong("UNSURFACED_LUN_CAP"));
        this.setDiscoveredTime(DBrs.getTimestamp("DISCOVERED_TIME"));
        this.setLastProbeTime(DBrs.getTimestamp("LAST_PROBE_TIME"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(DBrs.getShort("PROPAGATED_STATUS"));
        this.setUserAttrib1(DBrs.getString("USER_ATTRIB1"));
        this.setUserAttrib2(DBrs.getString("USER_ATTRIB2"));
        this.setUserAttrib3(DBrs.getString("USER_ATTRIB3"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setName(DBrs.getString("NAME"));
        this.setDataRedundancyMin(DBrs.getInt("DATA_REDUNDANCY_MIN"));
        this.setDataRedundancyMax(DBrs.getInt("DATA_REDUNDANCY_MAX"));
        this.setDataRedundancyDef(DBrs.getInt("DATA_REDUNDANCY_DEF"));
        this.setPckRedundancyMin(DBrs.getInt("PCK_REDUNDANCY_MIN"));
        this.setPckRedundancyMax(DBrs.getInt("PCK_REDUNDANCY_MAX"));
        this.setPckRedundancyDef(DBrs.getInt("PCK_REDUNDANCY_DEF"));
        this.setDeltaResMin(DBrs.getInt("DELTA_RES_MIN"));
        this.setDeltaResMax(DBrs.getInt("DELTA_RES_MAX"));
        this.setDeltaResDef(DBrs.getInt("DELTA_RES_DEF"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setRankGroup(DBrs.getShort("RANK_GROUP"));
        this.setClassNameId(DBrs.getShort("CLASS_NAME_ID"));
        this.setClassName(Normalizer.ClassNameGetName(con, this.m_ClassNameId));
    }

    public static class StoragePoolSnapshotCursor
    extends DBCursor {
        private StoragePoolSnapshot element = new StoragePoolSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResStoragePoolSnapshotTable.getColumnInfo("CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResStoragePoolSnapshotTable.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(con, (String)htWhereClause.get(TResStoragePoolSnapshotTable.getColumnInfo("CLASS_NAME_ID")))));
            }
            return htWhereClause;
        }

        public StoragePoolSnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_STORAGE_POOL_SNAPSHOT", con, StoragePoolSnapshotCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public StoragePoolSnapshot getObject() throws SQLException {
            StoragePoolSnapshot el = null;
            if (this.DBrs != null) {
                el = new StoragePoolSnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public StoragePoolSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

