/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemSnapshotTable;

public class StorageSubsystemSnapshot
extends TResStorageSubsystemSnapshotTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static StorageSubsystemSnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new StorageSubsystemSnapshotCursor(con, htWhereClause, columns);
    }

    public StorageSubsystemSnapshot() {
        this.clear();
    }

    public StorageSubsystemSnapshot(int SnapshotId, int SubsystemId, long AllocatedCapacity, long AvailableCapacity, long BackendStorageCapacity, short VendorId, short ModelId, String Name2, short NameFormat, long Cache2, long Nvs, long DgFreespace, int NDisks, int NLuns, Timestamp LastProbeTime, String ProbeStatus, int GroupId, int ProbingHostId, long VgCapacity, long VgFreespace, short OsType, String ProductStates, String Type2, String IpAddress, String CodeLevel, String SerialNumber, int PhysicalPackageId, double LgldiskAssignedCapacity, double LunCapacityZos, String DisplayName, short Detectable, int OperationalStatus, short ConsolidatedStatus, short PropagatedStatus, String UserAttrib1, String UserAttrib2, String UserAttrib3, Timestamp ChangedTimestamp, String AccessInfo, String UserProvidedName, String UserProvidedLocation, int CollectionStatus, Timestamp UpdateTimestamp, String TimeZone2) {
        this.clear();
        this.m_SnapshotId = SnapshotId;
        this.m_SubsystemId = SubsystemId;
        this.m_AllocatedCapacity = AllocatedCapacity;
        this.m_AvailableCapacity = AvailableCapacity;
        this.m_BackendStorageCapacity = BackendStorageCapacity;
        this.m_VendorId = VendorId;
        this.m_ModelId = ModelId;
        this.m_Name = Name2;
        this.m_NameFormat = NameFormat;
        this.m_Cache = Cache2;
        this.m_Nvs = Nvs;
        this.m_DgFreespace = DgFreespace;
        this.m_NDisks = NDisks;
        this.m_NLuns = NLuns;
        this.m_LastProbeTime = LastProbeTime;
        this.m_ProbeStatus = ProbeStatus;
        this.m_GroupId = GroupId;
        this.m_ProbingHostId = ProbingHostId;
        this.m_VgCapacity = VgCapacity;
        this.m_VgFreespace = VgFreespace;
        this.m_OsType = OsType;
        this.m_ProductStates = ProductStates;
        this.m_Type = Type2;
        this.m_IpAddress = IpAddress;
        this.m_CodeLevel = CodeLevel;
        this.m_SerialNumber = SerialNumber;
        this.m_PhysicalPackageId = PhysicalPackageId;
        this.m_LgldiskAssignedCapacity = LgldiskAssignedCapacity;
        this.m_LunCapacityZos = LunCapacityZos;
        this.m_DisplayName = DisplayName;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_UserAttrib1 = UserAttrib1;
        this.m_UserAttrib2 = UserAttrib2;
        this.m_UserAttrib3 = UserAttrib3;
        this.m_ChangedTimestamp = ChangedTimestamp;
        this.m_AccessInfo = AccessInfo;
        this.m_UserProvidedName = UserProvidedName;
        this.m_UserProvidedLocation = UserProvidedLocation;
        this.m_CollectionStatus = CollectionStatus;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_TimeZone = TimeZone2;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_SubsystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        }
        if (this.m_AllocatedCapacity != Long.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("ALLOCATED_CAPACITY"), String.valueOf(this.m_AllocatedCapacity));
        }
        if (this.m_AvailableCapacity != Long.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("AVAILABLE_CAPACITY"), String.valueOf(this.m_AvailableCapacity));
        }
        if (this.m_BackendStorageCapacity != Long.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("BACKEND_STORAGE_CAPACITY"), String.valueOf(this.m_BackendStorageCapacity));
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_Cache != Long.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("CACHE"), String.valueOf(this.m_Cache));
        }
        if (this.m_Nvs != Long.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("NVS"), String.valueOf(this.m_Nvs));
        }
        if (this.m_DgFreespace != Long.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("DG_FREESPACE"), String.valueOf(this.m_DgFreespace));
        }
        if (this.m_NDisks != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("N_DISKS"), String.valueOf(this.m_NDisks));
        }
        if (this.m_NLuns != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("N_LUNS"), String.valueOf(this.m_NLuns));
        }
        if (this.m_LastProbeTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("LAST_PROBE_TIME"), this.m_LastProbeTime);
        }
        if (this.m_ProbeStatus != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("PROBE_STATUS"), this.m_ProbeStatus);
        }
        if (this.m_GroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("GROUP_ID"), String.valueOf(this.m_GroupId));
        }
        if (this.m_ProbingHostId != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("PROBING_HOST_ID"), String.valueOf(this.m_ProbingHostId));
        }
        if (this.m_VgCapacity != Long.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("VG_CAPACITY"), String.valueOf(this.m_VgCapacity));
        }
        if (this.m_VgFreespace != Long.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("VG_FREESPACE"), String.valueOf(this.m_VgFreespace));
        }
        if (this.m_OsType != Short.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("OS_TYPE"), String.valueOf(this.m_OsType));
        }
        if (this.m_ProductStates != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("PRODUCT_STATES"), this.m_ProductStates);
        }
        if (this.m_Type != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("TYPE"), this.m_Type);
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_CodeLevel != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("CODE_LEVEL"), this.m_CodeLevel);
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_PhysicalPackageId != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("PHYSICAL_PACKAGE_ID"), String.valueOf(this.m_PhysicalPackageId));
        }
        if (this.m_LgldiskAssignedCapacity != Double.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("LGLDISK_ASSIGNED_CAPACITY"), String.valueOf(this.m_LgldiskAssignedCapacity));
        }
        if (this.m_LunCapacityZos != Double.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("LUN_CAPACITY_ZOS"), String.valueOf(this.m_LunCapacityZos));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
        if (this.m_ChangedTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("CHANGED_TIMESTAMP"), this.m_ChangedTimestamp);
        }
        if (this.m_AccessInfo != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("ACCESS_INFO"), this.m_AccessInfo);
        }
        if (this.m_UserProvidedName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("USER_PROVIDED_NAME"), this.m_UserProvidedName);
        }
        if (this.m_UserProvidedLocation != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("USER_PROVIDED_LOCATION"), this.m_UserProvidedLocation);
        }
        if (this.m_CollectionStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("COLLECTION_STATUS"), String.valueOf(this.m_CollectionStatus));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_TimeZone != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("TIME_ZONE"), this.m_TimeZone);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_STORAGE_SUBSYSTEM_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_STORAGE_SUBSYSTEM_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_SUBSYSTEM_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("NAME"), htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME")));
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT"), htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT")));
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_SUBSYSTEM_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_SUBSYSTEM_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("NAME"), htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME")));
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT"), htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT")));
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_SUBSYSTEM_SNAPSHOT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_STORAGE_SUBSYSTEM_SNAPSHOT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StorageSubsystemSnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        StorageSubsystemSnapshot el = null;
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("NAME"), htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME")));
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT"), htinput.get(StorageSubsystemSnapshot.getColumnInfo("NAME_FORMAT")));
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(StorageSubsystemSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_STORAGE_SUBSYSTEM_SNAPSHOT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new StorageSubsystemSnapshot();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_SUBSYSTEM_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(StorageSubsystemSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(StorageSubsystemSnapshot.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_SUBSYSTEM_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnapshotId(DBrs.getInt("SNAPSHOT_ID"));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
        this.setAllocatedCapacity(DBrs.getLong("ALLOCATED_CAPACITY"));
        this.setAvailableCapacity(DBrs.getLong("AVAILABLE_CAPACITY"));
        this.setBackendStorageCapacity(DBrs.getLong("BACKEND_STORAGE_CAPACITY"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setName(DBrs.getString("NAME"));
        this.setNameFormat(DBrs.getShort("NAME_FORMAT"));
        this.setCache(DBrs.getLong("CACHE"));
        this.setNvs(DBrs.getLong("NVS"));
        this.setDgFreespace(DBrs.getLong("DG_FREESPACE"));
        this.setNDisks(DBrs.getInt("N_DISKS"));
        this.setNLuns(DBrs.getInt("N_LUNS"));
        this.setLastProbeTime(DBrs.getTimestamp("LAST_PROBE_TIME"));
        this.setProbeStatus(DBrs.getString("PROBE_STATUS"));
        this.setGroupId(DBrs.getInt("GROUP_ID"));
        this.setProbingHostId(DBrs.getInt("PROBING_HOST_ID"));
        this.setVgCapacity(DBrs.getLong("VG_CAPACITY"));
        this.setVgFreespace(DBrs.getLong("VG_FREESPACE"));
        this.setOsType(DBrs.getShort("OS_TYPE"));
        this.setProductStates(DBrs.getString("PRODUCT_STATES"));
        this.setType(DBrs.getString("TYPE"));
        this.setIpAddress(DBrs.getString("IP_ADDRESS"));
        this.setCodeLevel(DBrs.getString("CODE_LEVEL"));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setPhysicalPackageId(DBrs.getInt("PHYSICAL_PACKAGE_ID"));
        this.setLgldiskAssignedCapacity(DBrs.getDouble("LGLDISK_ASSIGNED_CAPACITY"));
        this.setLunCapacityZos(DBrs.getDouble("LUN_CAPACITY_ZOS"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(DBrs.getShort("PROPAGATED_STATUS"));
        this.setUserAttrib1(DBrs.getString("USER_ATTRIB1"));
        this.setUserAttrib2(DBrs.getString("USER_ATTRIB2"));
        this.setUserAttrib3(DBrs.getString("USER_ATTRIB3"));
        this.setChangedTimestamp(DBrs.getTimestamp("CHANGED_TIMESTAMP"));
        this.setAccessInfo(DBrs.getString("ACCESS_INFO"));
        this.setUserProvidedName(DBrs.getString("USER_PROVIDED_NAME"));
        this.setUserProvidedLocation(DBrs.getString("USER_PROVIDED_LOCATION"));
        this.setCollectionStatus(DBrs.getInt("COLLECTION_STATUS"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setTimeZone(DBrs.getString("TIME_ZONE"));
    }

    public static class StorageSubsystemSnapshotCursor
    extends DBCursor {
        private StorageSubsystemSnapshot element = new StorageSubsystemSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResStorageSubsystemSnapshotTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TResStorageSubsystemSnapshotTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TResStorageSubsystemSnapshotTable.getColumnInfo("VENDOR_ID")))));
            }
            if (htWhereClause.get(TResStorageSubsystemSnapshotTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TResStorageSubsystemSnapshotTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TResStorageSubsystemSnapshotTable.getColumnInfo("MODEL_ID")))));
            }
            return htWhereClause;
        }

        public StorageSubsystemSnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_STORAGE_SUBSYSTEM_SNAPSHOT", con, StorageSubsystemSnapshotCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public StorageSubsystemSnapshot getObject() throws SQLException {
            StorageSubsystemSnapshot el = null;
            if (this.DBrs != null) {
                el = new StorageSubsystemSnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public StorageSubsystemSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

