/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchAttributeSnapshotTable;

public class SwitchAttributeSnapshot
extends TResSwitchAttributeSnapshotTable {
    public static SwitchAttributeSnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new SwitchAttributeSnapshotCursor(con, htWhereClause, columns);
    }

    public SwitchAttributeSnapshot() {
        this.clear();
    }

    public SwitchAttributeSnapshot(String SwitchWwn, String Version2, short Detectable, int OperationalStatus) {
        this.clear();
        this.m_SwitchWwn = SwitchWwn;
        this.m_Version = Version2;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_Version != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchAttributeSnapshot.getColumnInfo("VERSION"), this.m_Version);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(SwitchAttributeSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(SwitchAttributeSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htColsAndValues.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), htinput.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), htinput.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SwitchAttributeSnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        SwitchAttributeSnapshot el = null;
        if (htinput.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        htWhereClause.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), htinput.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new SwitchAttributeSnapshot();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSwitchWwn(DBrs.getString("SWITCH_WWN"));
        this.setVersion(DBrs.getString("VERSION"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
    }

    public static class SwitchAttributeSnapshotCursor
    extends DBCursor {
        private SwitchAttributeSnapshot element = new SwitchAttributeSnapshot();
        private DBConnection con;

        public SwitchAttributeSnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", con, htWhereClause, columns);
            this.con = con;
        }

        public SwitchAttributeSnapshot getObject() throws SQLException {
            SwitchAttributeSnapshot el = null;
            if (this.DBrs != null) {
                el = new SwitchAttributeSnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public SwitchAttributeSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

