/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeFrameTable;

public class TapeFrame
extends TResTapeFrameTable {
    private String m_CreationClassNameId_str;
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static TapeFrameCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new TapeFrameCursor(con, htWhereClause, columns);
    }

    public TapeFrame() {
        this.clear();
    }

    public TapeFrame(String Tag2, short CreationClassNameId, short LockPresent, short SecurityBreach, short IsLocked, String ElementName, short VendorId, short ModelId, String SerialNumber, int TapeLibraryId, Timestamp UpdateTimestamp) {
        this.clear();
        this.m_Tag = Tag2;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_LockPresent = LockPresent;
        this.m_SecurityBreach = SecurityBreach;
        this.m_IsLocked = IsLocked;
        this.m_ElementName = ElementName;
        this.m_VendorId = VendorId;
        this.m_ModelId = ModelId;
        this.m_SerialNumber = SerialNumber;
        this.m_TapeLibraryId = TapeLibraryId;
        this.m_UpdateTimestamp = UpdateTimestamp;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_LockPresent != Short.MIN_VALUE) {
            htColsAndValues.put(TapeFrame.getColumnInfo("LOCK_PRESENT"), String.valueOf(this.m_LockPresent));
        }
        if (this.m_SecurityBreach != Short.MIN_VALUE) {
            htColsAndValues.put(TapeFrame.getColumnInfo("SECURITY_BREACH"), String.valueOf(this.m_SecurityBreach));
        }
        if (this.m_IsLocked != Short.MIN_VALUE) {
            htColsAndValues.put(TapeFrame.getColumnInfo("IS_LOCKED"), String.valueOf(this.m_IsLocked));
        }
        if (this.m_ElementName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeFrame.getColumnInfo("ELEMENT_NAME"), this.m_ElementName);
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(TapeFrame.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(TapeFrame.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeFrame.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_TapeLibraryId != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeFrame.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(TapeFrame.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htColsAndValues.put(TapeFrame.getColumnInfo("TAG"), this.m_Tag);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TAPE_FRAME", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TAPE_FRAME", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeFrame.getColumnInfo("TAG"), this.m_Tag);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_FRAME", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeFrame.getColumnInfo("TAG"), htinput.get(TapeFrame.getColumnInfo("TAG")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_FRAME", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeFrame.getColumnInfo("TAG"), this.m_Tag);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_FRAME", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeFrame.getColumnInfo("TAG"), htinput.get(TapeFrame.getColumnInfo("TAG")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_FRAME", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeFrame.getColumnInfo("TAG"), this.m_Tag);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TAPE_FRAME", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TapeFrame retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        TapeFrame el = null;
        if (htinput.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        htWhereClause.put(TapeFrame.getColumnInfo("TAG"), htinput.get(TapeFrame.getColumnInfo("TAG")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TAPE_FRAME", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new TapeFrame();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(TapeFrame.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(TapeFrame.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(TapeFrame.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeFrame.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(TapeFrame.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TapeFrame.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(TapeFrame.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(TapeFrame.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TapeFrame.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_FRAME", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TapeFrame.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeFrame.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(TapeFrame.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TapeFrame.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(TapeFrame.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(TapeFrame.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TapeFrame.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_FRAME", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setTag(DBrs.getString("TAG"));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setLockPresent(DBrs.getShort("LOCK_PRESENT"));
        this.setSecurityBreach(DBrs.getShort("SECURITY_BREACH"));
        this.setIsLocked(DBrs.getShort("IS_LOCKED"));
        this.setElementName(DBrs.getString("ELEMENT_NAME"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setTapeLibraryId(DBrs.getInt("TAPE_LIBRARY_ID"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class TapeFrameCursor
    extends DBCursor {
        private TapeFrame element = new TapeFrame();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResTapeFrameTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResTapeFrameTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResTapeFrameTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            if (htWhereClause.get(TResTapeFrameTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TResTapeFrameTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TResTapeFrameTable.getColumnInfo("VENDOR_ID")))));
            }
            if (htWhereClause.get(TResTapeFrameTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TResTapeFrameTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TResTapeFrameTable.getColumnInfo("MODEL_ID")))));
            }
            return htWhereClause;
        }

        public TapeFrameCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_TAPE_FRAME", con, TapeFrameCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public TapeFrame getObject() throws SQLException {
            TapeFrame el = null;
            if (this.DBrs != null) {
                el = new TapeFrame();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public TapeFrame getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

