/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResTokenTable;

public class Token
extends TResTokenTable {
    public static TokenCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new TokenCursor(con, htWhereClause, columns);
    }

    public Token() {
        this.clear();
    }

    public Token(int TokenId, Timestamp Tstamp, String ResType, String ResId) {
        this.clear();
        this.m_TokenId = TokenId;
        this.m_Tstamp = Tstamp;
        this.m_ResType = ResType;
        this.m_ResId = ResId;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_TokenId != Integer.MIN_VALUE) {
            htColsAndValues.put(Token.getColumnInfo("TOKEN_ID"), String.valueOf(this.m_TokenId));
        }
        if (this.m_Tstamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Token.getColumnInfo("TSTAMP"), this.m_Tstamp);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ResType == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_TYPE not found");
        }
        this.htColsAndValues.put(Token.getColumnInfo("RES_TYPE"), this.m_ResType);
        if (this.m_ResId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_ID not found");
        }
        this.htColsAndValues.put(Token.getColumnInfo("RES_ID"), this.m_ResId);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TOKEN", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Token.getColumnInfo("RES_TYPE")) == null) {
            throw new SQLException(" ERROR: key RES_TYPE not found");
        }
        if (htinput.get(Token.getColumnInfo("RES_ID")) == null) {
            throw new SQLException(" ERROR: key RES_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TOKEN", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ResType == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_TYPE not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_TYPE"), this.m_ResType);
        if (this.m_ResId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_ID not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_ID"), this.m_ResId);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TOKEN", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Token.getColumnInfo("RES_TYPE")) == null) {
            throw new SQLException(" ERROR: key RES_TYPE not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_TYPE"), htinput.get(Token.getColumnInfo("RES_TYPE")));
        if (htinput.get(Token.getColumnInfo("RES_ID")) == null) {
            throw new SQLException(" ERROR: key RES_ID not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_ID"), htinput.get(Token.getColumnInfo("RES_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TOKEN", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ResType == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_TYPE not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_TYPE"), this.m_ResType);
        if (this.m_ResId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_ID not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_ID"), this.m_ResId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TOKEN", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Token.getColumnInfo("RES_TYPE")) == null) {
            throw new SQLException(" ERROR: key RES_TYPE not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_TYPE"), htinput.get(Token.getColumnInfo("RES_TYPE")));
        if (htinput.get(Token.getColumnInfo("RES_ID")) == null) {
            throw new SQLException(" ERROR: key RES_ID not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_ID"), htinput.get(Token.getColumnInfo("RES_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TOKEN", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ResType == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_TYPE not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_TYPE"), this.m_ResType);
        if (this.m_ResId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_ID not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_ID"), this.m_ResId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TOKEN", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Token retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Token el = null;
        if (htinput.get(Token.getColumnInfo("RES_TYPE")) == null) {
            throw new SQLException(" ERROR: key RES_TYPE not found");
        }
        htWhereClause.put(Token.getColumnInfo("RES_TYPE"), htinput.get(Token.getColumnInfo("RES_TYPE")));
        if (htinput.get(Token.getColumnInfo("RES_ID")) == null) {
            throw new SQLException(" ERROR: key RES_ID not found");
        }
        htWhereClause.put(Token.getColumnInfo("RES_ID"), htinput.get(Token.getColumnInfo("RES_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TOKEN", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Token();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_TOKEN", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_TOKEN", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setTokenId(DBrs.getInt("TOKEN_ID"));
        this.setTstamp(DBrs.getTimestamp("TSTAMP"));
        this.setResType(DBrs.getString("RES_TYPE"));
        this.setResId(DBrs.getString("RES_ID"));
    }

    public static class TokenCursor
    extends DBCursor {
        private Token element = new Token();
        private DBConnection con;

        public TokenCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_TOKEN", con, htWhereClause, columns);
            this.con = con;
        }

        public Token getObject() throws SQLException {
            Token el = null;
            if (this.DBrs != null) {
                el = new Token();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Token getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

