/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TUpgradeLogTable;

public class UpgradeLog
extends TUpgradeLogTable {
    public static UpgradeLogCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new UpgradeLogCursor(con, htWhereClause, columns);
    }

    public UpgradeLog() {
        this.clear();
    }

    public UpgradeLog(String Vendor2, short Versn, short Release, short Modification, short Submodification, int StatementNumber) {
        this.clear();
        this.m_Vendor = Vendor2;
        this.m_Versn = Versn;
        this.m_Release = Release;
        this.m_Modification = Modification;
        this.m_Submodification = Submodification;
        this.m_StatementNumber = StatementNumber;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_Vendor != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(UpgradeLog.getColumnInfo("VENDOR"), this.m_Vendor);
        }
        if (this.m_Versn != Short.MIN_VALUE) {
            htColsAndValues.put(UpgradeLog.getColumnInfo("VERSN"), String.valueOf(this.m_Versn));
        }
        if (this.m_Release != Short.MIN_VALUE) {
            htColsAndValues.put(UpgradeLog.getColumnInfo("RELEASE"), String.valueOf(this.m_Release));
        }
        if (this.m_Modification != Short.MIN_VALUE) {
            htColsAndValues.put(UpgradeLog.getColumnInfo("MODIFICATION"), String.valueOf(this.m_Modification));
        }
        if (this.m_Submodification != Short.MIN_VALUE) {
            htColsAndValues.put(UpgradeLog.getColumnInfo("SUBMODIFICATION"), String.valueOf(this.m_Submodification));
        }
        if (this.m_StatementNumber != Integer.MIN_VALUE) {
            htColsAndValues.put(UpgradeLog.getColumnInfo("STATEMENT_NUMBER"), String.valueOf(this.m_StatementNumber));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_UPGRADE_LOG", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_UPGRADE_LOG", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_UPGRADE_LOG", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_UPGRADE_LOG", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_UPGRADE_LOG", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_UPGRADE_LOG", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_UPGRADE_LOG", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpgradeLog retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        UpgradeLog el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_UPGRADE_LOG", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new UpgradeLog();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_UPGRADE_LOG", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_UPGRADE_LOG", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setVendor(DBrs.getString("VENDOR"));
        this.setVersn(DBrs.getShort("VERSN"));
        this.setRelease(DBrs.getShort("RELEASE"));
        this.setModification(DBrs.getShort("MODIFICATION"));
        this.setSubmodification(DBrs.getShort("SUBMODIFICATION"));
        this.setStatementNumber(DBrs.getInt("STATEMENT_NUMBER"));
    }

    public static class UpgradeLogCursor
    extends DBCursor {
        private UpgradeLog element = new UpgradeLog();
        private DBConnection con;

        public UpgradeLogCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_UPGRADE_LOG", con, htWhereClause, columns);
            this.con = con;
        }

        public UpgradeLog getObject() throws SQLException {
            UpgradeLog el = null;
            if (this.DBrs != null) {
                el = new UpgradeLog();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public UpgradeLog getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

