/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TViewVswitchTable;

public class Vswitch
extends TViewVswitchTable {
    private String m_ModelId_str;
    private String m_VendorId_str;

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public static VswitchCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new VswitchCursor(con, htWhereClause, columns);
    }

    public Vswitch() {
        this.clear();
    }

    public Vswitch(String PrefixId, int SwitchId, String DisplayName, String LogicalName, String SwitchWwn, String SerialNumber, String Description, String IpAddress, String Domain2, String Version2, short ModelId, short VendorId, String ParentSwitchWwn, String MgmtUrlAddr, short Detectable, int OperationalStatus, short ConsolidatedStatus, short PropagatedStatus, String UserAttrib1, String UserAttrib2, String UserAttrib3) {
        this.clear();
        this.m_PrefixId = PrefixId;
        this.m_SwitchId = SwitchId;
        this.m_DisplayName = DisplayName;
        this.m_LogicalName = LogicalName;
        this.m_SwitchWwn = SwitchWwn;
        this.m_SerialNumber = SerialNumber;
        this.m_Description = Description;
        this.m_IpAddress = IpAddress;
        this.m_Domain = Domain2;
        this.m_Version = Version2;
        this.m_ModelId = ModelId;
        this.m_VendorId = VendorId;
        this.m_ParentSwitchWwn = ParentSwitchWwn;
        this.m_MgmtUrlAddr = MgmtUrlAddr;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_UserAttrib1 = UserAttrib1;
        this.m_UserAttrib2 = UserAttrib2;
        this.m_UserAttrib3 = UserAttrib3;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_PrefixId != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("PREFIX_ID"), this.m_PrefixId);
        }
        if (this.m_SwitchId != Integer.MIN_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("SWITCH_ID"), String.valueOf(this.m_SwitchId));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_LogicalName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("LOGICAL_NAME"), this.m_LogicalName);
        }
        if (this.m_SwitchWwn != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_Description != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("DESCRIPTION"), this.m_Description);
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_Domain != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("DOMAIN"), this.m_Domain);
        }
        if (this.m_Version != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("VERSION"), this.m_Version);
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ParentSwitchWwn != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("PARENT_SWITCH_WWN"), this.m_ParentSwitchWwn);
        }
        if (this.m_MgmtUrlAddr != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("MGMT_URL_ADDR"), this.m_MgmtUrlAddr);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vswitch.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_VIEW_VSWITCH", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Vswitch.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Vswitch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Vswitch.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Vswitch.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Vswitch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Vswitch.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performInsert("T_VIEW_VSWITCH", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_VSWITCH", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Vswitch.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Vswitch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Vswitch.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Vswitch.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Vswitch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Vswitch.getColumnInfo("VENDOR_ID")))));
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_VSWITCH", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_VSWITCH", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Vswitch.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Vswitch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Vswitch.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Vswitch.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Vswitch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Vswitch.getColumnInfo("VENDOR_ID")))));
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_VSWITCH", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_VIEW_VSWITCH", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vswitch retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Vswitch el = null;
        if (htinput.get(Vswitch.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Vswitch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Vswitch.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Vswitch.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Vswitch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Vswitch.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_VIEW_VSWITCH", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Vswitch();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Vswitch.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Vswitch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Vswitch.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Vswitch.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Vswitch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Vswitch.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(Vswitch.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(Vswitch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(Vswitch.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(Vswitch.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(Vswitch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(Vswitch.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_VIEW_VSWITCH", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(Vswitch.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(Vswitch.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(Vswitch.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(Vswitch.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(Vswitch.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(Vswitch.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performDelete("T_VIEW_VSWITCH", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setPrefixId(DBrs.getString("PREFIX_ID"));
        this.setSwitchId(DBrs.getInt("SWITCH_ID"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setLogicalName(DBrs.getString("LOGICAL_NAME"));
        this.setSwitchWwn(DBrs.getString("SWITCH_WWN"));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setDescription(DBrs.getString("DESCRIPTION"));
        this.setIpAddress(DBrs.getString("IP_ADDRESS"));
        this.setDomain(DBrs.getString("DOMAIN"));
        this.setVersion(DBrs.getString("VERSION"));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setParentSwitchWwn(DBrs.getString("PARENT_SWITCH_WWN"));
        this.setMgmtUrlAddr(DBrs.getString("MGMT_URL_ADDR"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(DBrs.getShort("PROPAGATED_STATUS"));
        this.setUserAttrib1(DBrs.getString("USER_ATTRIB1"));
        this.setUserAttrib2(DBrs.getString("USER_ATTRIB2"));
        this.setUserAttrib3(DBrs.getString("USER_ATTRIB3"));
    }

    public static class VswitchCursor
    extends DBCursor {
        private Vswitch element = new Vswitch();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TViewVswitchTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TViewVswitchTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TViewVswitchTable.getColumnInfo("MODEL_ID")))));
            }
            if (htWhereClause.get(TViewVswitchTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TViewVswitchTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TViewVswitchTable.getColumnInfo("VENDOR_ID")))));
            }
            return htWhereClause;
        }

        public VswitchCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_VIEW_VSWITCH", con, VswitchCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public Vswitch getObject() throws SQLException {
            Vswitch el = null;
            if (this.DBrs != null) {
                el = new Vswitch();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Vswitch getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

