/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.detectability;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.history.detectability.DetSvcUtils;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.history.detectability.interfaces.DetectabilityConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public final class DetSvcTableInfo
implements DetectabilityConstants {
    private static ILogger traceLogger = null;
    private static String className = DetectabilityService.class.getName();
    private static boolean TRACE = false;
    private static final int DETECTABLE = 0;
    private static final int SUBSYS_CIMOM_UPD = 1;
    private static final int SUBSYS_CIMOM_AUTH = 2;
    private static final int FABRIC_AGENT_UPD = 3;
    private static final int FABRIC_AGENT_AUTH = 4;
    private static final int SWITCH_CIMOM_UPD = 5;
    private static final int SWITCH_CIMOM_AUTH = 6;
    private static final int HAS_PROBE_STATUS = 7;
    private static final int GENERATE_EVENTS = 8;
    private static Hashtable dsTableIndex;
    private static boolean[][] DSTI;
    private static Hashtable tableToFKeyName;
    private static Hashtable tableToAutoIDName;

    private static Hashtable populateDSTable() {
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        ht.put("T_RES_ALIAS", new Integer(0));
        ht.put("T_RES_ALIAS2MEMBER", new Integer(1));
        ht.put("T_RES_CIMKEY_PORT", new Integer(2));
        ht.put("T_RES_CIMKEY_VOLUME", new Integer(5));
        ht.put("T_RES_DATA_PATH", new Integer(7));
        ht.put("T_RES_DEVICE_AGENT", new Integer(8));
        ht.put("T_RES_DISK_GROUP", new Integer(9));
        ht.put("T_RES_FABRIC", new Integer(10));
        ht.put("T_RES_FABRIC2SWITCH", new Integer(11));
        ht.put("T_RES_HBA", new Integer(12));
        ht.put("T_RES_LPAR", new Integer(13));
        ht.put("T_RES_NODE", new Integer(14));
        ht.put("T_RES_NODE2HBA", new Integer(15));
        ht.put("T_RES_PE2NODE", new Integer(16));
        ht.put("T_RES_PHY_PE", new Integer(17));
        ht.put("T_RES_PHYSICAL_PACKAGE", new Integer(18));
        ht.put("T_RES_PHYSICAL_VOLUME", new Integer(19));
        ht.put("T_RES_PORT", new Integer(20));
        ht.put("T_RES_PORT2PORT", new Integer(21));
        ht.put("T_RES_REDUNDANCY", new Integer(23));
        ht.put("T_RES_STORAGE_EXTENT", new Integer(24));
        ht.put("T_RES_STORAGE_POOL", new Integer(25));
        ht.put("T_RES_STORAGE_SUBSYSTEM", new Integer(26));
        ht.put("T_RES_STORAGE_VOLUME", new Integer(27));
        ht.put("T_RES_SWITCH", new Integer(28));
        ht.put("T_RES_SWITCH_BLADE", new Integer(29));
        ht.put("T_RES_SWITCH2PORT", new Integer(30));
        ht.put("T_RES_TAPE_CARTRIDGE", new Integer(31));
        ht.put("T_RES_TAPE_DRIVE", new Integer(32));
        ht.put("T_RES_TAPE_FRAME", new Integer(33));
        ht.put("T_RES_TAPE_IOPORT", new Integer(34));
        ht.put("T_RES_TAPE_LIBRARY", new Integer(35));
        ht.put("T_RES_TAPE_MEDIA_CHANGER", new Integer(36));
        ht.put("T_RES_VOLUME2EXTENT", new Integer(37));
        ht.put("T_RES_ZONE", new Integer(38));
        ht.put("T_RES_ZONE_MEMBER", new Integer(39));
        ht.put("T_RES_ZONE2ALIAS", new Integer(40));
        ht.put("T_RES_ZONE2MEMBER", new Integer(41));
        ht.put("T_RES_ZSET", new Integer(42));
        ht.put("T_RES_ZSET2ZONE", new Integer(43));
        ht.put("T_RES_PHYSICALVOLUME2EXTENT", new Integer(44));
        ht.put("T_RES_TAPE_MEDIA_LOCATION", new Integer(45));
        return ht;
    }

    static void setDetectable() {
        Enumeration dsTables = dsTableIndex.keys();
        String T = null;
        int tableInt = 0;
        boolean result = false;
        Class tableClass = null;
        Method methodToExecute = null;
        ColumnInfo ciDet = null;
        String methodName = "setDetectable";
        while (dsTables.hasMoreElements()) {
            T = (String)dsTables.nextElement();
            tableInt = (Integer)dsTableIndex.get(T);
            tableClass = DetSvcUtils.getHelperSuper(T);
            try {
                methodToExecute = tableClass.getDeclaredMethod("getColumnInfo", String.class);
                ciDet = (ColumnInfo)methodToExecute.invoke((Object)tableClass, "DETECTABLE");
                if (ciDet != null) {
                    DetSvcTableInfo.DSTI[tableInt][0] = true;
                    if (!TRACE) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Table: " + T + " has detectable set to: true");
                    continue;
                }
                DetSvcTableInfo.DSTI[tableInt][0] = false;
                if (!TRACE) continue;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Table: " + T + " has detectable set to: false");
            }
            catch (Exception e) {
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                }
                if (!TRACE) continue;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
        }
    }

    private static void setProbeStatus() {
        for (int i = 0; i < DSTI.length; ++i) {
            DetSvcTableInfo.DSTI[i][7] = DSTI[i][1] && !DSTI[i][2] || DSTI[i][3] && !DSTI[i][4] || DSTI[i][5] && !DSTI[i][6];
        }
    }

    private static Hashtable populateFKeys() {
        Hashtable ht = new Hashtable();
        ht.put(dsTableIndex.get("T_RES_REDUNDANCY"), "SUBSYSTEM_ID");
        ht.put(dsTableIndex.get("T_RES_HBA"), "HOST_ID");
        ht.put(dsTableIndex.get("T_RES_STORAGE_VOLUME"), "SUBSYSTEM_ID");
        ht.put(dsTableIndex.get("T_RES_STORAGE_POOL"), "SUBSYSTEM_ID");
        ht.put(dsTableIndex.get("T_RES_DISK_GROUP"), "SUBSYSTEM_ID");
        ht.put(dsTableIndex.get("T_RES_STORAGE_EXTENT"), "SUBSYSTEM_ID");
        ht.put(dsTableIndex.get("T_RES_DATA_PATH"), "SUBSYSTEM_ID");
        ht.put(dsTableIndex.get("T_RES_LPAR"), "SUBSYSTEM_ID");
        ht.put(dsTableIndex.get("T_RES_TAPE_FRAME"), "TAPE_LIBRARY_ID");
        ht.put(dsTableIndex.get("T_RES_TAPE_IOPORT"), "TAPE_LIBRARY_ID");
        ht.put(dsTableIndex.get("T_RES_TAPE_MEDIA_CHANGER"), "TAPE_LIBRARY_ID");
        ht.put(dsTableIndex.get("T_RES_TAPE_CARTRIDGE"), "TAPE_LIBRARY_ID");
        ht.put(dsTableIndex.get("T_RES_PHYSICAL_VOLUME"), "SUBSYSTEM_ID");
        ht.put(dsTableIndex.get("T_RES_NODE"), "TAPE_LIBRARY_ID");
        ht.put(dsTableIndex.get("T_RES_PORT"), "SUBSYSTEM_ID");
        ht.put(dsTableIndex.get("T_RES_TAPE_DRIVE"), "TAPE_LIBRARY_ID");
        ht.put(dsTableIndex.get("T_RES_TAPE_MEDIA_LOCATION"), "TAPE_LIBRARY_ID");
        return ht;
    }

    public static String getFKeyName(String tableName) {
        Integer tableIndex = (Integer)dsTableIndex.get(tableName);
        return (String)tableToFKeyName.get(tableIndex);
    }

    private static Hashtable populateAutoIDs() {
        Hashtable ht = new Hashtable();
        ht.put(dsTableIndex.get("T_RES_ALIAS"), "ALIAS_ID");
        ht.put(dsTableIndex.get("T_RES_ALIAS2MEMBER"), "ALIAS2MEMBER_ID");
        ht.put(dsTableIndex.get("T_RES_CIMKEY_PORT"), "CIMKEY_PORT_ID");
        ht.put(dsTableIndex.get("T_RES_DEVICE_AGENT"), "DEVICE_AGENT_ID");
        ht.put(dsTableIndex.get("T_RES_FABRIC"), "FABRIC_ID");
        ht.put(dsTableIndex.get("T_RES_FABRIC2SWITCH"), "FABRIC2SWITCH_ID");
        ht.put(dsTableIndex.get("T_RES_NODE"), "NODE_ID");
        ht.put(dsTableIndex.get("T_RES_NODE2HBA"), "NODE2HBA_ID");
        ht.put(dsTableIndex.get("T_RES_PE2NODE"), "PE2NODE_ID");
        ht.put(dsTableIndex.get("T_RES_PHY_PE"), "PHY_PE_ID");
        ht.put(dsTableIndex.get("T_RES_PORT"), "PORT_ID");
        ht.put(dsTableIndex.get("T_RES_PORT2PORT"), "PORT2PORT_ID");
        ht.put(dsTableIndex.get("T_RES_STORAGE_SUBSYSTEM"), "SUBSYSTEM_ID");
        ht.put(dsTableIndex.get("T_RES_SWITCH"), "SWITCH_ID");
        ht.put(dsTableIndex.get("T_RES_SWITCH_BLADE"), "SWITCH_BLADE_ID");
        ht.put(dsTableIndex.get("T_RES_SWITCH2PORT"), "SWITCH2PORT_ID");
        ht.put(dsTableIndex.get("T_RES_TAPE_DRIVE"), "TAPE_DRIVE_ID");
        ht.put(dsTableIndex.get("T_RES_TAPE_MEDIA_CHANGER"), "TAPE_MEDIA_CHANGER_ID");
        ht.put(dsTableIndex.get("T_RES_TAPE_LIBRARY"), "TAPE_LIBRARY_ID");
        ht.put(dsTableIndex.get("T_RES_ZONE"), "ZONE_ID");
        ht.put(dsTableIndex.get("T_RES_ZONE_MEMBER"), "ZONE_MEMBER_ID");
        ht.put(dsTableIndex.get("T_RES_ZONE2ALIAS"), "ZONE2ALIAS_ID");
        ht.put(dsTableIndex.get("T_RES_ZONE2MEMBER"), "ZONE2MEMBER_ID");
        ht.put(dsTableIndex.get("T_RES_ZSET"), "ZSET_ID");
        ht.put(dsTableIndex.get("T_RES_ZSET2ZONE"), "ZSET2ZONE_ID");
        return ht;
    }

    public static String getAutoIDName(String tableName) {
        Integer tableIndex = (Integer)dsTableIndex.get(tableName);
        return (String)tableToAutoIDName.get(tableIndex);
    }

    public static boolean isDetSvcTable(String tableName) {
        return dsTableIndex.containsKey(tableName);
    }

    public static boolean isProbeStatusUpd(String tableName) {
        if (dsTableIndex.containsKey(tableName)) {
            Integer tableInt = (Integer)dsTableIndex.get(tableName);
            return DSTI[tableInt][7];
        }
        return false;
    }

    public static boolean isDetectableTracked(String tableName) {
        String methodName = "isDetectableTracked";
        if (dsTableIndex.containsKey(tableName)) {
            Integer tableInt = (Integer)dsTableIndex.get(tableName);
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " is returning " + DSTI[tableInt][0]);
            }
            return DSTI[tableInt][0];
        }
        return false;
    }

    public static boolean isSubsysCIMOMScanned(String tableName) {
        if (dsTableIndex.containsKey(tableName)) {
            Integer tableInt = (Integer)dsTableIndex.get(tableName);
            return DSTI[tableInt][1];
        }
        return false;
    }

    public static boolean isSubsysCIMOMAuth(String tableName) {
        if (dsTableIndex.containsKey(tableName)) {
            Integer tableInt = (Integer)dsTableIndex.get(tableName);
            return DSTI[tableInt][2];
        }
        return false;
    }

    public static boolean isFabricAgentScanned(String tableName) {
        if (dsTableIndex.containsKey(tableName)) {
            Integer tableInt = (Integer)dsTableIndex.get(tableName);
            return DSTI[tableInt][3];
        }
        return false;
    }

    public static boolean isFabricAgentAuth(String tableName) {
        if (dsTableIndex.containsKey(tableName)) {
            Integer tableInt = (Integer)dsTableIndex.get(tableName);
            return DSTI[tableInt][4];
        }
        return false;
    }

    public static boolean isSwitchCIMOMScanned(String tableName) {
        if (dsTableIndex.containsKey(tableName)) {
            Integer tableInt = (Integer)dsTableIndex.get(tableName);
            return DSTI[tableInt][5];
        }
        return false;
    }

    public static boolean isSwitchCIMOMAuth(String tableName) {
        if (dsTableIndex.containsKey(tableName)) {
            Integer tableInt = (Integer)dsTableIndex.get(tableName);
            return DSTI[tableInt][6];
        }
        return false;
    }

    public static boolean isHybrid(String tableName) {
        boolean subSysUpd = false;
        boolean fabAgtUpd = false;
        boolean swiCimUpd = false;
        boolean subSysAuth = false;
        boolean fabAgtAuth = false;
        boolean swiCimAuth = false;
        String methodName = "isHybrid";
        if (!dsTableIndex.containsKey(tableName)) {
            return false;
        }
        Integer tableInt = (Integer)dsTableIndex.get(tableName);
        subSysUpd = DSTI[tableInt][1];
        fabAgtUpd = DSTI[tableInt][3];
        swiCimUpd = DSTI[tableInt][5];
        subSysAuth = DSTI[tableInt][2];
        fabAgtAuth = DSTI[tableInt][4];
        swiCimAuth = DSTI[tableInt][6];
        if (subSysUpd && subSysAuth && (fabAgtUpd && !fabAgtAuth || swiCimUpd && !swiCimAuth)) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " is returning true");
            }
            return true;
        }
        if (fabAgtUpd && fabAgtAuth && (subSysUpd && !subSysAuth || swiCimUpd && !swiCimAuth)) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " is returning true");
            }
            return true;
        }
        if (swiCimUpd && swiCimAuth && (fabAgtUpd && !fabAgtAuth || subSysUpd && !subSysAuth)) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " is returning true");
            }
            return true;
        }
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " is returning false");
        }
        return false;
    }

    public static boolean isEventGen(String tableName) {
        if (dsTableIndex.containsKey(tableName)) {
            Integer tableInt = (Integer)dsTableIndex.get(tableName);
            return DSTI[tableInt][8];
        }
        return false;
    }

    public static int getMetaScannerClass(String scannerClass) {
        if (scannerClass.equals("StorageSubsystemScanType")) {
            return 100;
        }
        if (scannerClass.equals("FabricScanType")) {
            return 101;
        }
        if (scannerClass.equals("SwitchScanType")) {
            return 102;
        }
        if (scannerClass.equals("TapeScanType")) {
            return 100;
        }
        return -1;
    }

    public static short getElementType(String tableName) {
        return ((Integer)dsTableIndex.get(tableName)).shortValue();
    }

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
        dsTableIndex = DetSvcTableInfo.populateDSTable();
        DSTI = new boolean[][]{{false, false, false, true, false, true, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, true, true, false, false, true, false, false, false}, {false, true, false, false, false, true, false, false, false}, {false, false, false, false, false, true, false, false, false}, {false, true, true, false, false, false, false, false, false}, {false, true, true, false, false, true, true, false, false}, {false, true, true, false, false, false, false, false, true}, {false, false, false, true, false, false, false, false, false}, {false, true, true, false, false, false, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, false, false, true, true, false, false, false, true}, {false, true, true, false, false, false, false, false, false}, {false, true, true, true, false, true, false, false, true}, {false, false, false, true, false, false, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, true, true, false, false, false, false, false, false}, {false, true, true, false, false, false, false, false, true}, {false, true, true, true, false, true, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, true, true, false, false, false, false, false, false}, {false, true, true, false, false, false, false, false, true}, {false, true, true, false, false, false, false, false, true}, {false, true, true, false, false, false, false, false, true}, {false, true, false, true, false, false, false, false, true}, {false, true, true, false, false, false, false, false, true}, {false, true, false, true, false, true, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, true, true, false, false, false, false, false, false}, {false, true, true, false, false, false, false, false, true}, {false, true, true, false, false, false, false, false, false}, {false, true, true, false, false, false, false, false, false}, {false, true, false, false, false, false, false, false, true}, {false, true, true, false, false, false, false, false, true}, {false, true, true, false, false, false, false, false, false}, {false, false, false, true, false, true, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, false, false, true, false, true, false, false, true}, {false, true, true, false, false, false, false, false, false}, {false, true, true, false, false, false, false, false, false}};
        DetSvcTableInfo.setDetectable();
        DetSvcTableInfo.setProbeStatus();
        tableToFKeyName = DetSvcTableInfo.populateFKeys();
        tableToAutoIDName = DetSvcTableInfo.populateAutoIDs();
    }
}

