/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.detectability;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Null;
import org.eclipse.aperi.infrastructure.database.ParameterizedSql;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.ElementProbeStatus;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimkeyPort;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimkeyPortPort;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimkeyVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimkeyVolumeVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlElementProbeStatus;
import org.eclipse.aperi.infrastructure.database.sql.SqlNode;
import org.eclipse.aperi.infrastructure.database.sql.SqlNodePort;
import org.eclipse.aperi.infrastructure.database.sql.SqlPhysicalVolumePhysicalVolume2Extent;
import org.eclipse.aperi.infrastructure.database.sql.SqlPhysicalvolume2extent;
import org.eclipse.aperi.infrastructure.database.sql.SqlPort;
import org.eclipse.aperi.infrastructure.database.sql.SqlScantype2table;
import org.eclipse.aperi.infrastructure.database.sql.SqlStorageExtentVolume2Extent;
import org.eclipse.aperi.infrastructure.database.sql.SqlSwitch2port;
import org.eclipse.aperi.infrastructure.database.sql.SqlSwitchSwitch2Port;
import org.eclipse.aperi.infrastructure.database.sql.SqlVolume2extent;
import org.eclipse.aperi.infrastructure.database.tables.TResElementProbeStatusTable;
import org.eclipse.aperi.infrastructure.database.tables.TResScantype2tableTable;
import org.eclipse.aperi.infrastructure.history.detectability.DetSvcTableInfo;
import org.eclipse.aperi.infrastructure.history.detectability.DetSvcUtils;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityResult;
import org.eclipse.aperi.infrastructure.history.detectability.InFlightScan;
import org.eclipse.aperi.infrastructure.history.detectability.interfaces.DetectabilityConstants;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class DetectabilityService
implements DetectabilityConstants {
    private static Hashtable inFlight = new Hashtable();
    private static ILogger traceLogger = null;
    private static String className = DetectabilityService.class.getName();
    private static boolean TRACE = false;
    private static IEventMonitorService eventMonitor = null;
    public static HashMap scannerIdToClassMappings;
    private static Random randGen;

    public static int cancelDiscovery(String scanId) {
        return DetectabilityService.cancelDiscovery(scanId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int startDiscovery(String scanId, int systemType, int systemId, String processId) throws SQLException {
        InFlightScan scanner = null;
        String methodName = "startDiscovery (" + scanId + ", " + systemId + ", " + systemType + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (scanId == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return 1;
        }
        scanner = DetectabilityService.getCurrScanner(scanId, systemId, systemType, true);
        if (scanner == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had null scanner");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return 1;
        }
        if (!scanner.isNew()) {
            DetectabilityService.cancelDiscovery(scanId, scanner);
        }
        if (processId != null) {
            scanner.setProcessID(processId);
        } else if (TRACE) {
            traceLogger.text(IRecordType.TYPE_WARN, className, methodName, "Null processId received as input; using default " + scanner.getProcessID());
        }
        int metaClass = 0;
        String scannerClass = DetectabilityService.getClassFromScanId(scanId);
        metaClass = DetSvcTableInfo.getMetaScannerClass(scannerClass);
        scanner.setScannerClass(metaClass);
        String scanType = DetectabilityService.getTypeFromScanId(scanId);
        scanner.setScanType(scanType);
        try {
            scanner.setScanTime();
        }
        finally {
            scanner.resetLock();
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DetectabilityResult stopDiscovery(String scanId) throws SQLException, Exception {
        methodName = "stopDiscovery (" + scanId + ")";
        dr = new DetectabilityResult(0, null);
        if (DetectabilityService.TRACE) {
            DetectabilityService.traceLogger.entry(IRecordType.TYPE_ENTRY, DetectabilityService.className, methodName);
        }
        if (scanId == null) {
            if (DetectabilityService.TRACE) {
                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, methodName, methodName + " had null parm");
                DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, methodName, 1);
            }
            dr.result = 1;
            return dr;
        }
        scanner = null;
        hybridTable = false;
        detTracked = false;
        subCimUpd = false;
        subCimAuth = false;
        fabAgtUpd = false;
        fabAgtAuth = false;
        swiCimUpd = false;
        swiCimAuth = false;
        eventGen = false;
        rc = 0;
        scanner = DetectabilityService.getCurrScanner(scanId);
        if (scanner == null) {
            if (DetectabilityService.TRACE) {
                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, methodName, methodName + " had null scanner");
                DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, methodName, 1);
            }
            dr.result = 1;
            return dr;
        }
        rc = DetectabilityService.resolveTablesToScan(scanner);
        ds = DBConnPoolDataSource.getInstance();
        dbCon = null;
        try {
            dbCon = (DBConnection)ds.getPooledConnection();
        }
        catch (SQLException e) {
            DetectabilityService.endScannerFlight(scanner.getScanId());
            scanner.resetLock();
            throw e;
        }
        tableClass = null;
        helperClass = null;
        methodExecute = null;
        htColsToGet = null;
        colDet = null;
        colTS = null;
        colFKey = null;
        colAutoID = null;
        nameFKey = null;
        nameAutoID = null;
        result = -1;
        scanList = scanner.getList();
        iterTables = scanList.iterator();
        T = null;
        numRetries = 0;
        msWaitPeriod = 0L;
        toRetry = false;
        modEntries = new HashMap<K, V>();
        while (true) {
            block40: {
                try {
                    if (!iterTables.hasNext()) break;
                    T = (String)iterTables.next();
                    hybridTable = false;
                    detTracked = false;
                    subCimUpd = false;
                    subCimAuth = false;
                    fabAgtUpd = false;
                    fabAgtAuth = false;
                    swiCimUpd = false;
                    swiCimAuth = false;
                    helperClass = null;
                    tableClass = null;
                    methodExecute = null;
                    htColsToGet = null;
                    colDet = null;
                    colTS = null;
                    colFKey = null;
                    colAutoID = null;
                    nameFKey = null;
                    nameAutoID = null;
                    result = -1;
                    eventGen = false;
                    if (!DetectabilityService.TRACE) {
                        System.out.println("stopDiscovery: table=" + T);
                    }
                    while (true) {
                        try {
                            detTracked = DetSvcTableInfo.isDetectableTracked(T);
                            subCimUpd = DetSvcTableInfo.isSubsysCIMOMScanned(T);
                            subCimAuth = DetSvcTableInfo.isSubsysCIMOMAuth(T);
                            fabAgtUpd = DetSvcTableInfo.isFabricAgentScanned(T);
                            fabAgtAuth = DetSvcTableInfo.isFabricAgentAuth(T);
                            swiCimUpd = DetSvcTableInfo.isSwitchCIMOMScanned(T);
                            swiCimAuth = DetSvcTableInfo.isSwitchCIMOMAuth(T);
                            hybridTable = DetSvcTableInfo.isHybrid(T);
                            eventGen = DetSvcTableInfo.isEventGen(T);
                            helperClass = DetSvcUtils.getHelper(T);
                            tableClass = DetSvcUtils.getHelperSuper(T);
                            methodExecute = tableClass.getDeclaredMethod("getColumns", new Class[0]);
                            htColsToGet = (Hashtable)methodExecute.invoke((Object)tableClass, new Object[0]);
                            colTS = (ColumnInfo)htColsToGet.get("UPDATE_TIMESTAMP");
                            if (colTS != null) {
                                colTS = colTS.addOperator("<");
                            }
                            colDet = (ColumnInfo)htColsToGet.get("DETECTABLE");
                            nameFKey = DetSvcTableInfo.getFKeyName(T);
                            if (nameFKey != null) {
                                colFKey = (ColumnInfo)htColsToGet.get(nameFKey);
                            }
                            if ((nameAutoID = DetSvcTableInfo.getAutoIDName(T)) != null) {
                                colAutoID = (ColumnInfo)htColsToGet.get(nameAutoID);
                            }
                            if (!(scanner.getScannerClass() == 100 && subCimAuth == true || scanner.getScannerClass() == 101 && fabAgtAuth == true) && (scanner.getScannerClass() != 102 || !swiCimAuth)) ** GOTO lbl164
                            if (hybridTable && (result = DetectabilityService.deleteProbeStatus(dbCon, T, scanner, colTS, colAutoID, colFKey)) != 0) {
                                if (DetectabilityService.TRACE) {
                                    DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, methodName, methodName + " deleteProbeStatus returned " + result);
                                    DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, methodName, result);
                                }
                                dr.result = result;
                                var36_35 = dr;
                                if (dbCon == null) break block40;
                                break;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (SQLException e) {
                            if (!SQLExceptionHelper.isDeadlock(dbCon, e)) {
                                throw e;
                            }
                            if (DetectabilityService.TRACE) {
                                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, methodName, "Deadlock occured for table " + T + "; rolling back relevant changes");
                            } else {
                                System.out.println(DetectabilityService.className + " " + methodName + " Deadlock for table " + T);
                            }
                            dbCon.rollback();
                            if (++numRetries <= 6) {
                                if (DetectabilityService.TRACE) {
                                    DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, methodName, "Retry " + numRetries + " after deadlock");
                                } else {
                                    System.out.println(DetectabilityService.className + " " + methodName + " Retry " + numRetries);
                                }
                                toRetry = true;
                                msWaitPeriod = 15000L * (long)numRetries + (long)DetectabilityService.randGen.nextInt(15000);
                                Thread.sleep(msWaitPeriod);
                                continue;
                            }
                            if (DetectabilityService.TRACE) {
                                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, methodName, "Retries complete; aborting with SQLException");
                            }
                            throw e;
                        }
                        break;
                    }
                }
                catch (Throwable var38_39) {
                    if (dbCon != null && !dbCon.isClosed()) {
                        dbCon.close();
                    }
                    DetectabilityService.endScannerFlight(scanner.getScanId());
                    scanner.resetLock();
                    throw var38_39;
                }
                if (!dbCon.isClosed()) {
                    dbCon.close();
                }
            }
            DetectabilityService.endScannerFlight(scanner.getScanId());
            scanner.resetLock();
            return var36_35;
lbl-1000:
            // 1 sources

            {
                res = DetectabilityService.authScanUpdateDelete(dbCon, T, helperClass, htColsToGet, scanner, colTS, colDet, colFKey, detTracked, eventGen);
                if (res != null) ** GOTO lbl-1000
                if (DetectabilityService.TRACE) {
                    DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, methodName, methodName + " authScanUpd returned " + result);
                    DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, methodName, 1);
                }
                dr.result = 1;
                var37_37 = dr;
            }
            if (dbCon != null && !dbCon.isClosed()) {
                dbCon.close();
            }
            DetectabilityService.endScannerFlight(scanner.getScanId());
            scanner.resetLock();
            return var37_37;
lbl-1000:
            // 1 sources

            {
                modEntries.putAll(res);
                ** GOTO lbl177
lbl164:
                // 1 sources

                res = DetectabilityService.nonAuthScan(dbCon, T, scanner, detTracked, eventGen, tableClass);
                if (res != null) ** GOTO lbl-1000
                if (DetectabilityService.TRACE) {
                    DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, methodName, methodName + " nonAuthScan returned " + result);
                    DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, methodName, 1);
                }
                dr.result = 1;
                var37_38 = dr;
            }
            if (dbCon != null && !dbCon.isClosed()) {
                dbCon.close();
            }
            DetectabilityService.endScannerFlight(scanner.getScanId());
            scanner.resetLock();
            return var37_38;
lbl-1000:
            // 1 sources

            {
                modEntries.putAll(res);
lbl177:
                // 2 sources

                dbCon.commit();
                if (DetectabilityService.TRACE) {
                    DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, methodName, "Committed changes relevant to " + T);
                } else {
                    System.out.println(DetectabilityService.className + " " + methodName + " " + "committed " + T);
                }
                numRetries = 0;
                toRetry = false;
            }
            if (toRetry) ** continue;
        }
        if (dbCon != null && !dbCon.isClosed()) {
            dbCon.close();
        }
        DetectabilityService.endScannerFlight(scanner.getScanId());
        scanner.resetLock();
        if (DetectabilityService.TRACE) {
            DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, methodName, 0);
        }
        dr.modifiedEntities = modEntries;
        dr.result = 0;
        return dr;
    }

    public static void tableUpdated(String scanId, String tableName, Hashtable hTable) throws SQLException, Exception {
        InFlightScan scanner = null;
        String methodName = "tableUpdated (" + scanId + ", " + tableName + ", " + hTable + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (scanId == null || tableName == null || hTable == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return;
        }
        if (!DetSvcTableInfo.isDetSvcTable(tableName)) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " no-op on table " + tableName);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
            }
            return;
        }
        scanner = DetectabilityService.getCurrScanner(scanId);
        if (scanner == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had null scanner; table not processed");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return;
        }
        scanner.addTable(tableName);
        if (DetSvcTableInfo.isProbeStatusUpd(tableName)) {
            if (hTable == null || hTable.size() == 0) {
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + "Input hashtable null, cannot process this" + " tuple for table " + tableName);
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
                }
                scanner.resetLock();
                return;
            }
            Iterator iterRow = hTable.values().iterator();
            String strAutoIDVal = (String)iterRow.next();
            int autoID = Integer.parseInt(strAutoIDVal);
            short elemType = DetSvcTableInfo.getElementType(tableName);
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " " + tableName + " autoID = " + autoID);
            }
            Hashtable htCols = TResElementProbeStatusTable.getColumns();
            Iterator ciCols = htCols.values().iterator();
            Hashtable<ColumnInfo, Object> htInput = new Hashtable<ColumnInfo, Object>();
            ColumnInfo ciCol = null;
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            DBConnection dbCon = null;
            try {
                dbCon = (DBConnection)ds.getPooledConnection();
            }
            catch (SQLException e) {
                scanner.resetLock();
                throw e;
            }
            while (ciCols.hasNext()) {
                ciCol = (ColumnInfo)ciCols.next();
                if (ciCol.getName() == "ELEMENT_ID") {
                    htInput.put(ciCol, Integer.toString(autoID));
                    continue;
                }
                if (ciCol.getName() == "ELEMENT_TYPE") {
                    htInput.put(ciCol, Short.toString(elemType));
                    continue;
                }
                if (ciCol.getName() == "SCANNER_ID") {
                    htInput.put(ciCol, scanId);
                    continue;
                }
                if (ciCol.getName() == "UPDATE_TIMESTAMP") {
                    Timestamp currTime = null;
                    try {
                        currTime = CurrentTime.getTimestamp(dbCon);
                    }
                    catch (SQLException e) {
                        if (TRACE) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " error getting teimestamp, aborting");
                        }
                        DetectabilityService.abortDbCon(dbCon);
                        scanner.resetLock();
                        throw e;
                    }
                    htInput.put(ciCol, currTime);
                    continue;
                }
                if (ciCol.getName() == "PROBE_FOUND") {
                    htInput.put(ciCol, Short.toString((short)1));
                    continue;
                }
                if (TRACE) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
                }
                DetectabilityService.abortDbCon(dbCon);
                scanner.resetLock();
                return;
            }
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, hTable.toString());
            }
            ElementProbeStatus elProbeStatus = new ElementProbeStatus();
            try {
                int result;
                if (null != ElementProbeStatus.retrieve(dbCon, htInput)) {
                    result = elProbeStatus.update(dbCon, htInput);
                    if (result != 1) {
                        if (TRACE) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " incorrect number of rows updated: " + result);
                            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
                        }
                        DetectabilityService.abortDbCon(dbCon);
                        scanner.resetLock();
                        return;
                    }
                } else {
                    result = elProbeStatus.insert(dbCon, htInput) ? 1 : 0;
                    if (result == 0) {
                        if (TRACE) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had false result");
                            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
                        }
                        DetectabilityService.abortDbCon(dbCon);
                        return;
                    }
                }
                dbCon.commit();
            }
            catch (SQLException e) {
                dbCon.rollback();
                throw e;
            }
            finally {
                if (dbCon != null && !dbCon.isClosed()) {
                    dbCon.close();
                }
                scanner.resetLock();
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
    }

    private static void abortDbCon(DBConnection dbCon) throws SQLException {
        dbCon.rollback();
        dbCon.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map authScanUpdateDelete(DBConnection dbCon, String tableName, Class helperClass, Hashtable htCols, InFlightScan scanner, ColumnInfo colTTS, ColumnInfo colTDet, ColumnInfo colTFKey, boolean detTracked, boolean eventGen) throws SQLException, Exception {
        String methodName = "authScanUpdateDelete (" + dbCon + ", " + tableName + ", " + helperClass + "," + htCols + ", " + scanner + ", " + colTTS + ", " + colTDet + ", " + colTFKey + ")";
        HashMap retMap = new HashMap();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (dbCon == null || tableName == null || helperClass == null || htCols == null || scanner == null || colTTS == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return null;
        }
        retMap.put(tableName, null);
        int numRowsUpdated = -1;
        if (tableName.equals("T_RES_VOLUME2EXTENT") || tableName.equals("T_RES_CIMKEY_VOLUME") || tableName.equals("T_RES_CIMKEY_PORT") || tableName.equals("T_RES_SWITCH2PORT") || tableName.equals("T_RES_PHYSICALVOLUME2EXTENT") || 2 == scanner.getSystemType() && tableName.equals("T_RES_PORT")) {
            Map res = DetectabilityService.authScanSpecialCase(dbCon, tableName, helperClass, htCols, scanner, colTTS);
            if (res == null) {
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "authScanSpecialCase returned null");
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
                }
                return null;
            }
            retMap.put(tableName, res.get(tableName));
        } else {
            Method methodExecute = null;
            Hashtable<ColumnInfo, Object> htWhereClause = new Hashtable<ColumnInfo, Object>();
            htWhereClause.put(colTTS, scanner.getScanTime());
            htWhereClause.put(colTFKey, String.valueOf(scanner.getScanSystemID()));
            String paramQuery = DetectabilityService.createAuthParamQuery(tableName, detTracked ? DetectabilityService.getColsForEventGen(htCols) : null, htWhereClause);
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Query: " + paramQuery);
            } else {
                System.out.println(className + methodName + " Query: " + paramQuery);
            }
            DBResultSet rsUndetectedEntities = null;
            try {
                rsUndetectedEntities = ParameterizedSql.sqlQuery(dbCon, paramQuery, new Hashtable(), htWhereClause);
                if (rsUndetectedEntities == null && TRACE) {
                    traceLogger.text(IRecordType.TYPE_WARN, className, methodName, "sqlQuery returned null; no missing elements found to generate events or to return; continue with update");
                } else if (detTracked) {
                    Vector<String> v_id = new Vector<String>();
                    while (rsUndetectedEntities.next()) {
                        v_id.add(rsUndetectedEntities.getObject(1).toString());
                    }
                    retMap.put(tableName, v_id);
                } else if (eventGen) {
                    DetectabilityService.delEventGen(scanner.getProcessID(), tableName, rsUndetectedEntities);
                }
            }
            finally {
                if (rsUndetectedEntities != null) {
                    rsUndetectedEntities.close();
                    rsUndetectedEntities.getStatement().close();
                    rsUndetectedEntities = null;
                }
            }
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " table = " + tableName);
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " detTracked = " + detTracked);
            }
            if (detTracked) {
                methodExecute = helperClass.getDeclaredMethod("update", DBConnection.class, Hashtable.class, Hashtable.class);
                if (methodExecute == null) {
                    if (TRACE) {
                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
                    }
                    return null;
                }
                Hashtable<ColumnInfo, Object> htInput = new Hashtable<ColumnInfo, Object>();
                htInput.put(colTDet, String.valueOf(0));
                htInput.put(colTTS, CurrentTime.getTimestamp(dbCon));
                numRowsUpdated = (Integer)methodExecute.invoke((Object)helperClass, dbCon, htInput, htWhereClause);
            } else {
                methodExecute = helperClass.getDeclaredMethod("deletes", DBConnection.class, Hashtable.class);
                if (methodExecute == null) {
                    if (TRACE) {
                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
                    }
                    return null;
                }
                numRowsUpdated = (Integer)methodExecute.invoke((Object)helperClass, dbCon, htWhereClause);
            }
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " numrowsupdated=" + numRowsUpdated);
            }
        }
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map authScanSpecialCase(DBConnection dbCon, String tableName, Class helperClass, Hashtable htCols, InFlightScan scanner, ColumnInfo colTTS) throws SQLException, Exception {
        String methodName = "authScanSpecialCase (" + dbCon + ", " + tableName + ", " + helperClass + "," + htCols + ", " + scanner + ", " + colTTS + ")";
        HashMap retMap = new HashMap();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (dbCon == null || tableName == null || helperClass == null || htCols == null || scanner == null || colTTS == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return null;
        }
        retMap.put(tableName, null);
        Class tableClass = null;
        Method methodColInfo = null;
        StringBuffer strSQL = new StringBuffer();
        ColumnInfo colParent = null;
        Hashtable<ColumnInfo, Object> params = new Hashtable<ColumnInfo, Object>();
        DBResultSet rsUndetectedEntities = null;
        int result = 0;
        if (tableName.equals("T_RES_VOLUME2EXTENT")) {
            tableClass = DetSvcUtils.getHelperSuper("T_RES_STORAGE_EXTENT");
            methodColInfo = tableClass.getDeclaredMethod("getColumnInfo", String.class);
            colParent = (ColumnInfo)methodColInfo.invoke((Object)tableClass, new String("SUBSYSTEM_ID"));
            params.put(colParent, String.valueOf(scanner.getScanSystemID()));
            params.put(colTTS, scanner.getScanTime());
            strSQL.append(" where STORAGE_EXTENT_ID in (");
            strSQL.append(SqlStorageExtentVolume2Extent.getQueryString(SqlStorageExtentVolume2Extent.querySE));
            strSQL.append(") and UPDATE_TIMESTAMP < ?");
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "appended string=" + strSQL.toString());
            }
            result = SqlVolume2extent.sqlUpdate(dbCon, SqlVolume2extent.delAll, strSQL.toString(), params);
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " deleted rows = " + result);
            }
        } else if (tableName.equals("T_RES_CIMKEY_PORT")) {
            if (2 == scanner.getSystemType()) {
                tableClass = DetSvcUtils.getHelperSuper("T_RES_NODE");
                methodColInfo = tableClass.getDeclaredMethod("getColumnInfo", String.class);
                colParent = (ColumnInfo)methodColInfo.invoke((Object)tableClass, new String("TAPE_LIBRARY_ID"));
                params.put(colParent, String.valueOf(scanner.getScanSystemID()));
                params.put(colTTS, scanner.getScanTime());
                strSQL.append(" where PORT_ID in (");
                strSQL.append(SqlNodePort.getQueryString(SqlNodePort.queryPortsInTapeLibrary));
                strSQL.append(") and UPDATE_TIMESTAMP < ?");
            } else {
                tableClass = DetSvcUtils.getHelperSuper("T_RES_PORT");
                methodColInfo = tableClass.getDeclaredMethod("getColumnInfo", String.class);
                colParent = (ColumnInfo)methodColInfo.invoke((Object)tableClass, new String("SUBSYSTEM_ID"));
                params.put(colParent, String.valueOf(scanner.getScanSystemID()));
                params.put(colTTS, scanner.getScanTime());
                strSQL.append(" where CIMKEY_PORT_ID in (");
                strSQL.append(SqlCimkeyPortPort.getQueryString(SqlCimkeyPortPort.queryPort));
                strSQL.append(") and UPDATE_TIMESTAMP < ?");
            }
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "appended string=" + strSQL.toString());
            }
            result = SqlCimkeyPort.sqlUpdate(dbCon, SqlCimkeyPort.delAll, strSQL.toString(), params);
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " deleted rows = " + result);
            }
        } else if (tableName.equals("T_RES_SWITCH2PORT")) {
            tableClass = DetSvcUtils.getHelperSuper("T_RES_SWITCH");
            methodColInfo = tableClass.getDeclaredMethod("getColumnInfo", String.class);
            colParent = (ColumnInfo)methodColInfo.invoke((Object)tableClass, new String("SWITCH_ID"));
            params.put(colParent, String.valueOf(scanner.getScanSystemID()));
            params.put(colTTS, scanner.getScanTime());
            try {
                rsUndetectedEntities = ParameterizedSql.sqlQuery(dbCon, SqlSwitchSwitch2Port.getQueryString(SqlSwitchSwitch2Port.querySwitch2PortUpdatedBeforeTime), new Hashtable(), params);
                Vector<String> v_id = new Vector<String>();
                while (rsUndetectedEntities.next()) {
                    v_id.add(rsUndetectedEntities.getObject(1).toString());
                }
                retMap.put(tableName, v_id);
            }
            finally {
                if (rsUndetectedEntities != null) {
                    rsUndetectedEntities.close();
                    rsUndetectedEntities.getStatement().close();
                    rsUndetectedEntities = null;
                }
            }
            strSQL.append(", UPDATE_TIMESTAMP = '");
            strSQL.append(CurrentTime.getTimestamp(dbCon));
            strSQL.append("' where SWITCH2PORT_ID in (");
            strSQL.append(SqlSwitchSwitch2Port.getQueryString(SqlSwitchSwitch2Port.querySwitch2PortForSwitch));
            strSQL.append(") and UPDATE_TIMESTAMP < ?");
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "appended string=" + strSQL.toString());
            }
            result = SqlSwitch2port.sqlUpdate(dbCon, SqlSwitch2port.updateAllDetectable, strSQL.toString(), params);
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " deleted rows = " + result);
            }
        } else if (tableName.equals("T_RES_PHYSICALVOLUME2EXTENT")) {
            tableClass = DetSvcUtils.getHelperSuper("T_RES_PHYSICAL_VOLUME");
            methodColInfo = tableClass.getDeclaredMethod("getColumnInfo", String.class);
            colParent = (ColumnInfo)methodColInfo.invoke((Object)tableClass, new String("SUBSYSTEM_ID"));
            params.put(colParent, String.valueOf(scanner.getScanSystemID()));
            params.put(colTTS, scanner.getScanTime());
            strSQL.append(" where PHYSICAL_VOLUME_ID in (");
            strSQL.append(SqlPhysicalVolumePhysicalVolume2Extent.getQueryString(SqlPhysicalVolumePhysicalVolume2Extent.queryPVForSS));
            strSQL.append(") and UPDATE_TIMESTAMP < ?");
            result = SqlPhysicalvolume2extent.sqlUpdate(dbCon, SqlPhysicalvolume2extent.delAll, strSQL.toString(), params);
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " deleted rows = " + result);
            }
        } else if (tableName.equals("T_RES_CIMKEY_VOLUME")) {
            tableClass = DetSvcUtils.getHelperSuper("T_RES_STORAGE_VOLUME");
            methodColInfo = tableClass.getDeclaredMethod("getColumnInfo", String.class);
            colParent = (ColumnInfo)methodColInfo.invoke((Object)tableClass, new String("SUBSYSTEM_ID"));
            params.put(colParent, String.valueOf(scanner.getScanSystemID()));
            params.put(colTTS, scanner.getScanTime());
            strSQL.append(" where VOLUME_ID in (");
            strSQL.append(SqlCimkeyVolumeVolume.getQueryString(SqlCimkeyVolumeVolume.queryVolume));
            strSQL.append(") and UPDATE_TIMESTAMP < ?");
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "appended string=" + strSQL.toString());
            }
            result = SqlCimkeyVolume.sqlUpdate(dbCon, 1, strSQL.toString(), params);
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " deleted rows = " + result);
            }
        } else if (tableName.equals("T_RES_PORT")) {
            tableClass = DetSvcUtils.getHelperSuper("T_RES_NODE");
            methodColInfo = tableClass.getDeclaredMethod("getColumnInfo", String.class);
            colParent = (ColumnInfo)methodColInfo.invoke((Object)tableClass, new String("TAPE_LIBRARY_ID"));
            params.put(colParent, String.valueOf(scanner.getScanSystemID()));
            params.put(colTTS, scanner.getScanTime());
            try {
                rsUndetectedEntities = ParameterizedSql.sqlQuery(dbCon, SqlNodePort.getQueryString(SqlNodePort.queryPortsInTapeLibraryUpdatedBeforeTime), new Hashtable(), params);
                Vector<String> v_id = new Vector<String>();
                while (rsUndetectedEntities.next()) {
                    v_id.add(rsUndetectedEntities.getObject(1).toString());
                }
                retMap.put(tableName, v_id);
            }
            finally {
                if (rsUndetectedEntities != null) {
                    rsUndetectedEntities.close();
                    rsUndetectedEntities.getStatement().close();
                    rsUndetectedEntities = null;
                }
            }
            strSQL.append(", UPDATE_TIMESTAMP = '");
            strSQL.append(CurrentTime.getTimestamp(dbCon));
            strSQL.append("' where NODE_ID in (");
            strSQL.append(SqlNode.getQueryString(SqlNode.queryNodeForTapeLib));
            strSQL.append(") and UPDATE_TIMESTAMP < ?");
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "appended string=" + strSQL.toString());
            }
            result = SqlPort.sqlUpdate(dbCon, SqlPort.updateAllDetectable, strSQL.toString(), params);
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " updated rows = " + result);
            }
        } else {
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " tablename invalid " + tableName);
            }
            return null;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
        return retMap;
    }

    private static int deleteProbeStatus(DBConnection dbCon, String tableName, InFlightScan scanner, ColumnInfo colTTS, ColumnInfo colTAutoID, ColumnInfo colTFKey) throws SQLException, Exception {
        String methodName = "deleteProbeStatus (" + dbCon + ", " + tableName + ", " + scanner + ", " + colTTS + ", " + colTAutoID + ", " + colTFKey + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (dbCon == null || tableName == null || scanner == null || colTTS == null || colTAutoID == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return 1;
        }
        Class tableClass = null;
        Method methodColInfo = null;
        String paramSql = null;
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable params = null;
        Vector<ColumnInfo> vColInfo = new Vector<ColumnInfo>();
        Vector<Object> vValues = new Vector<Object>();
        ColumnInfo colParent = null;
        if (colTAutoID == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " Returning null as autoID missing for " + tableName);
            }
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return 1;
        }
        if (tableName.equals("T_RES_SWITCH2PORT")) {
            paramSql = SqlSwitchSwitch2Port.getQueryString(SqlSwitchSwitch2Port.querySwitch2PortUpdatedBeforeTime);
            try {
                tableClass = DetSvcUtils.getHelperSuper("T_RES_SWITCH");
                methodColInfo = tableClass.getDeclaredMethod("getColumnInfo", String.class);
                colParent = (ColumnInfo)methodColInfo.invoke((Object)tableClass, new String("SWITCH_ID"));
                vColInfo.add(colParent);
                vValues.add(String.valueOf(scanner.getScanSystemID()));
                vColInfo.add(colTTS);
                vValues.add(scanner.getScanTime());
                params = ComplexQuery.generateHashtable(vColInfo, vValues);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " DeleteProbeStatus: could " + " not find columninfo for switch_id for table T_RES_SWITCH");
                }
                throw e;
            }
        } else if (tableName.equals("T_RES_CIMKEY_PORT")) {
            paramSql = SqlCimkeyPortPort.getQueryString(SqlCimkeyPortPort.queryPortUpdatedBeforeTime);
            try {
                tableClass = DetSvcUtils.getHelperSuper("T_RES_PORT");
                methodColInfo = tableClass.getDeclaredMethod("getColumnInfo", String.class);
                colParent = (ColumnInfo)methodColInfo.invoke((Object)tableClass, new String("SUBSYSTEM_ID"));
                vColInfo.add(colParent);
                vValues.add(String.valueOf(scanner.getScanSystemID()));
                vColInfo.add(colTTS);
                vValues.add(scanner.getScanTime());
                params = ComplexQuery.generateHashtable(vColInfo, vValues);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " DeleteProbeStatus: could " + " not find columninfo for switch_id for table T_RES_SWITCH");
                }
                throw e;
            }
        } else {
            if (colTFKey == null) {
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " FKey is null for hybrid table " + tableName);
                }
                if (TRACE) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
                }
                return 1;
            }
            paramSql = "select T1.<<AUTOID-COL>> from <<TABLENAME>> T1 where T1.<<FKEY-COL>> = ? and T1.UPDATE_TIMESTAMP < ?";
            tokenParams.put("<<AUTOID-COL>>", colTAutoID.getName());
            tokenParams.put("<<TABLENAME>>", tableName);
            tokenParams.put("<<FKEY-COL>>", colTFKey.getName());
            vColInfo.add(colTFKey);
            vValues.add(String.valueOf(scanner.getScanSystemID()));
            vColInfo.add(colTTS);
            vValues.add(scanner.getScanTime());
            params = ComplexQuery.generateHashtable(vColInfo, vValues);
        }
        StringBuffer paramDel = new StringBuffer();
        paramDel.append("delete from T_RES_ELEMENT_PROBE_STATUS where T_RES_ELEMENT_PROBE_STATUS.ELEMENT_TYPE = ");
        paramDel.append(Short.toString(DetSvcTableInfo.getElementType(tableName)));
        paramDel.append(" AND T_RES_ELEMENT_PROBE_STATUS.ELEMENT_ID in (");
        paramDel.append(paramSql);
        paramDel.append(")");
        int result = -1;
        result = ParameterizedSql.sqlUpdate(dbCon, paramDel.toString(), tokenParams, params);
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " Updated rows = " + result);
        }
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " Result = " + result);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void endScannerFlight(String scanId) {
        String methodName = "endScannerFlight (" + scanId + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (scanId == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return;
        }
        Hashtable hashtable = inFlight;
        synchronized (hashtable) {
            inFlight.remove(scanId);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
    }

    private static int cancelDiscovery(String scanId, InFlightScan scannerIn) {
        InFlightScan scanner = null;
        String methodName = "createSnapshot (" + scanId + " " + scanner + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (scanId == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return 1;
        }
        scanner = scannerIn == null ? DetectabilityService.getCurrScanner(scanId) : scannerIn;
        if (scanner != null) {
            scanner.clearTables();
            if (scannerIn == null) {
                scanner.resetLock();
            }
        } else {
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return 1;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
        return 0;
    }

    private static HashSet dsRSToHSForResolveTab(DBResultSet rs) throws SQLException {
        String methodName = "dsRSToHSForResolveTab";
        HashSet<String> retResult = new HashSet<String>();
        String tableName = "";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        while (rs.next()) {
            tableName = rs.getString(2);
            retResult.add(tableName);
            if (!TRACE) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " adding table: " + tableName);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
        return retResult;
    }

    private static InFlightScan getCurrScanner(String scanId) {
        String methodName = "getCurrScanner (" + scanId + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        return DetectabilityService.getCurrScanner(scanId, -1, -1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InFlightScan getCurrScanner(String scanId, int systemId, int systemType, boolean firstCall) {
        InFlightScan scanner = null;
        String methodName = "getCurrScanner (" + scanId + ", " + systemId + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (scanId == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return null;
        }
        Hashtable hashtable = inFlight;
        synchronized (hashtable) {
            if (inFlight.containsKey(scanId)) {
                scanner = (InFlightScan)inFlight.get(scanId);
                scanner.setLock();
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " found scanner on scan " + scanId);
                }
            } else if (firstCall) {
                scanner = new InFlightScan(scanId, systemId, systemType);
                inFlight.put(scanId, scanner);
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " created scanner for scan " + scanId);
                }
            } else if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Scanner for scanId =" + scanId + " should already exist for this function call. \nCannot continue - returning null");
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
        return scanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map nonAuthScan(DBConnection dbCon, String T, InFlightScan scanner, boolean detTracked, boolean eventGen, Class tableClass) throws SQLException, Exception {
        String methodName = "nonAuthScan (" + dbCon + ", " + T + ", " + scanner + "," + detTracked + ", " + tableClass + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        } else {
            System.out.println(className + " " + methodName);
        }
        HashMap retMap = new HashMap();
        retMap.put(T, null);
        int updatePSResult = DetectabilityService.updateProbeStatus(scanner, dbCon, T);
        if (0 != updatePSResult) {
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, updatePSResult);
            }
            return null;
        }
        String nameAutoID = DetSvcTableInfo.getAutoIDName(T);
        if (nameAutoID == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " Auto ID not found for table " + T + "; CONTINUE WITH NEXT TABLE");
            }
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return null;
        }
        ColumnInfo colAutoID = null;
        try {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " nameAutoID = " + nameAutoID);
            }
            colAutoID = (ColumnInfo)tableClass.getDeclaredMethod("getColumnInfo", String.class).invoke((Object)tableClass, new String(nameAutoID));
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " colAutoID = " + colAutoID);
            }
        }
        catch (Exception e) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " column " + nameAutoID + " not found in helper for table " + T);
            }
            throw e;
        }
        Hashtable<ColumnInfo, String> params = new Hashtable<ColumnInfo, String>();
        ColumnInfo colEleType = TResElementProbeStatusTable.getColumnInfo("ELEMENT_TYPE");
        params.put(colEleType, Short.toString(DetSvcTableInfo.getElementType(T)));
        String concatSql = "(" + SqlElementProbeStatus.getQueryString(SqlElementProbeStatus.queryZeroMaxFound) + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        tokenParams.put("<<TABLENAME>>", T);
        tokenParams.put("<<AUTOID-COL>>", nameAutoID);
        String paramSql = null;
        paramSql = detTracked ? "update <<TABLENAME>> set DETECTABLE = 0, UPDATE_TIMESTAMP = '" + CurrentTime.getTimestamp(dbCon) + "' where <<AUTOID-COL>> in " : "delete from <<TABLENAME>> where <<AUTOID-COL>> in ";
        DBResultSet rsUndetectedEntities = null;
        try {
            if (detTracked) {
                rsUndetectedEntities = ParameterizedSql.sqlQuery(dbCon, SqlElementProbeStatus.getQueryString(SqlElementProbeStatus.queryZeroMaxFound), new Hashtable(), params);
                Vector<String> v_id = new Vector<String>();
                while (rsUndetectedEntities.next()) {
                    v_id.add(rsUndetectedEntities.getObject(1).toString());
                }
                retMap.put(T, v_id);
            } else if (eventGen) {
                rsUndetectedEntities = ParameterizedSql.sqlQuery(dbCon, SqlElementProbeStatus.getQueryString(SqlElementProbeStatus.queryZeroMaxFound2), tokenParams, params);
                DetectabilityService.delEventGen(scanner.getProcessID(), T, rsUndetectedEntities);
            }
        }
        finally {
            if (rsUndetectedEntities != null) {
                rsUndetectedEntities.close();
                rsUndetectedEntities.getStatement().close();
                rsUndetectedEntities = null;
            }
        }
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " paramSql = " + paramSql + "\n" + "concatSql = " + concatSql + "\n" + "tokenParams = " + tokenParams);
        }
        int result = ParameterizedSql.sqlUpdate(dbCon, paramSql, tokenParams, concatSql, params);
        if (!"T_RES_FABRIC".equals(T)) {
            String epsDelStmt = "delete from T_RES_ELEMENT_PROBE_STATUS where ELEMENT_TYPE = <<ELEM_TYPE>> AND ELEMENT_ID in (select T2.ELEMENT_ID from T_RES_ELEMENT_PROBE_STATUS T2 where T2.ELEMENT_TYPE = ? group by T2.ELEMENT_ID having MAX(T2.PROBE_FOUND) = 0)";
            tokenParams.clear();
            tokenParams.put("<<ELEM_TYPE>>", Short.toString(DetSvcTableInfo.getElementType(T)));
            ParameterizedSql.sqlUpdate(dbCon, epsDelStmt, tokenParams, params);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
        return retMap;
    }

    private static int resolveTablesToScan(InFlightScan scanner) throws SQLException {
        String methodName = "resolveTablesToScan (" + scanner + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (scanner == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return 1;
        }
        DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
        DBConnection dbCon = null;
        dbCon = (DBConnection)ds.getPooledConnection();
        HashSet inMemList = scanner.getList();
        String scanType = scanner.getScanType();
        ColumnInfo ciScanType = TResScantype2tableTable.getColumnInfo("SCAN_TYPE");
        ColumnInfo ciTableName = TResScantype2tableTable.getColumnInfo("TABLE_NAME");
        Hashtable<ColumnInfo, String> params = new Hashtable<ColumnInfo, String>();
        params.put(ciScanType, scanType);
        DBResultSet rs = null;
        try {
            rs = SqlScantype2table.sqlQuery(dbCon, SqlScantype2table.queryAllOfScanType, params);
        }
        catch (SQLException e) {
            DetectabilityService.abortDbCon(dbCon);
            throw e;
        }
        HashSet listTables = DetectabilityService.dsRSToHSForResolveTab(rs);
        Iterator iterInMemList = inMemList.iterator();
        String tableName = null;
        while (iterInMemList.hasNext()) {
            tableName = (String)iterInMemList.next();
            if (listTables.contains(tableName)) continue;
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " adding table " + tableName);
            }
            listTables.add(tableName);
            params.put(ciTableName, tableName);
            try {
                SqlScantype2table.sqlUpdate(dbCon, SqlScantype2table.insertRow, params);
            }
            catch (SQLException e) {
                rs.close();
                DetectabilityService.abortDbCon(dbCon);
                throw e;
            }
        }
        scanner.replaceList(listTables);
        rs.close();
        dbCon.commit();
        if (dbCon != null && !dbCon.isClosed()) {
            dbCon.close();
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
        return 0;
    }

    private static int updateProbeStatus(InFlightScan scanner, DBConnection dbCon, String tableName) throws SQLException {
        String methodName = "updateProbeStatus (" + scanner + ", " + dbCon + ", " + tableName + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (scanner == null || dbCon == null || tableName == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, methodName + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return 1;
        }
        Hashtable<ColumnInfo, String> htInput = new Hashtable<ColumnInfo, String>();
        Hashtable<ColumnInfo, Object> htWhereClause = new Hashtable<ColumnInfo, Object>();
        String scannerID = scanner.getScanId();
        Timestamp scanTS = scanner.getScanTime();
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "scannerID = " + scannerID + ", " + "scanTS = " + scanTS);
        }
        ColumnInfo colFound = TResElementProbeStatusTable.getColumnInfo("PROBE_FOUND");
        ColumnInfo colScannerID = TResElementProbeStatusTable.getColumnInfo("SCANNER_ID");
        ColumnInfo colEleID = TResElementProbeStatusTable.getColumnInfo("ELEMENT_ID");
        ColumnInfo colEleType = TResElementProbeStatusTable.getColumnInfo("ELEMENT_TYPE");
        ColumnInfo colTS = TResElementProbeStatusTable.getColumnInfo("UPDATE_TIMESTAMP");
        colTS = colTS.addOperator("<");
        htInput.put(colFound, Short.toString((short)0));
        htWhereClause.put(colScannerID, scannerID);
        htWhereClause.put(colEleType, Short.toString(DetSvcTableInfo.getElementType(tableName)));
        htWhereClause.put(colTS, scanTS);
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Calling getCursor: \nhtInput = \n\t" + htInput + "\n" + "Where clause = \n\t" + htWhereClause + "\n");
        }
        int result = ElementProbeStatus.update(dbCon, htInput, htWhereClause);
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "result = " + result);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
        return 0;
    }

    private static Vector getColsForEventGen(Hashtable columns) {
        String methodName = "getColsForEventGen(" + columns + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        Vector<ColumnInfo> retVector = new Vector<ColumnInfo>();
        Iterator iterHT = columns.values().iterator();
        ColumnInfo valCI = null;
        Object iterContent = null;
        while (iterHT.hasNext()) {
            iterContent = iterHT.next();
            if (iterContent instanceof ColumnInfo) {
                valCI = iterContent;
                if (!valCI.isAutoGenerated()) continue;
                retVector.add(valCI);
                continue;
            }
            if (!TRACE) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Input hashtable has non-ColumnInfo object; ignoring...");
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
        return retVector;
    }

    private static String createAuthParamQuery(String tableName, Vector columns, Hashtable htWhereClause) {
        String methodName = "createAuthParamQuery(" + tableName + "," + columns + "," + htWhereClause + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        StringBuffer sqlStatement = new StringBuffer();
        sqlStatement.append("SELECT ");
        if (columns == null || columns.size() == 0) {
            sqlStatement.append("* ");
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                sqlStatement.append(((ColumnInfo)columns.elementAt(i)).getName());
                if (i >= columns.size() - 1) continue;
                sqlStatement.append(",");
            }
        }
        sqlStatement.append(" FROM ");
        sqlStatement.append(tableName);
        if (htWhereClause != null && htWhereClause.size() != 0) {
            sqlStatement.append(" WHERE ");
            String whereString = DetectabilityService.buildWhereClause(htWhereClause);
            sqlStatement.append(whereString);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
        return sqlStatement.toString();
    }

    private static String buildWhereClause(Hashtable htWhereClause) {
        String methodName = "buildWhereClause (" + htWhereClause + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        StringBuffer sb = new StringBuffer();
        TreeMap tMap = new TreeMap(htWhereClause);
        Iterator iterator = tMap.keySet().iterator();
        ColumnInfo colInfo = null;
        while (iterator.hasNext()) {
            colInfo = (ColumnInfo)iterator.next();
            sb.append(colInfo.getName());
            if (htWhereClause.get(colInfo).getClass() != Null.class) {
                if (colInfo.getOperator() != null) {
                    sb.append(colInfo.getOperator());
                } else {
                    sb.append("=");
                }
                sb.append("?");
            } else {
                sb.append(" IS NULL");
            }
            if (!iterator.hasNext()) continue;
            sb.append(" AND ");
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
        return sb.toString();
    }

    private static void delEventGen(String processId, String tableName, DBResultSet rs) throws SQLException {
        boolean justLog;
        String methodName = "delEventGen(" + processId + "," + tableName + "," + "DBResultSet with missing entities' autoIDs";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (processId == null || tableName == null || rs == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Null input parameter");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 1);
            }
            return;
        }
        int numColumns = rs.getMetaData().getColumnCount();
        if (eventMonitor == null) {
            eventMonitor = DetectabilityService.getEventMonitorProxy();
        }
        boolean bl = justLog = eventMonitor == null;
        while (rs.next()) {
            HashMap<String, Object> entity = new HashMap<String, Object>();
            for (int i = 1; i <= numColumns; ++i) {
                entity.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
            }
            if (!justLog) {
                eventMonitor.handleDeletedDevice(processId, tableName, entity);
                continue;
            }
            if (!TRACE) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Cannot obtain IEventMonitorService instance; cannot generate events for:" + entity.toString());
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, 0);
        }
    }

    private static IEventMonitorService getEventMonitorProxy() {
        if (eventMonitor == null) {
            eventMonitor = (IEventMonitorService)Activator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return eventMonitor;
    }

    public static String getTypeFromScanId(String scanId) {
        int index = scanId.indexOf(":");
        if (index == -1) {
            return null;
        }
        return scanId.substring(0, scanId.indexOf(":"));
    }

    public static String getClassFromScanId(String scanId) {
        String prefix = DetectabilityService.getTypeFromScanId(scanId);
        if (prefix == null) {
            return null;
        }
        return (String)scannerIdToClassMappings.get(prefix);
    }

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
        eventMonitor = DetectabilityService.getEventMonitorProxy();
        scannerIdToClassMappings = new HashMap();
        scannerIdToClassMappings.put("DS2", "StorageSubsystemScanType");
        scannerIdToClassMappings.put("PS1", "StorageSubsystemScanType");
        scannerIdToClassMappings.put("PS2", "StorageSubsystemScanType");
        scannerIdToClassMappings.put("PO2", "FabricScanType");
        scannerIdToClassMappings.put("PO4", "FabricScanType");
        scannerIdToClassMappings.put("PI1", "FabricScanType");
        scannerIdToClassMappings.put("PI2", "FabricScanType");
        scannerIdToClassMappings.put("PT1", "TapeScanType");
        scannerIdToClassMappings.put("DF1", "SwitchScanType");
        randGen = new Random();
    }
}

