/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Hba;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.sql.SqlHost;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class ControllerXmlToDBMapper
extends DBAttributeMapper {
    private static final String GUID = "GUID";
    private static final String NAME = "Name";
    private static final String UNINAME = "Uni Name";
    private static final String SERIALNUMBER = "Serial Number";
    private static final String DRIVERVERSION = "Driver Version";
    private static final String OPTIONALROMVERSION = "Optional Rom Version";
    private static final String HARDWAREVERSION = "Hardware Version";
    private static final String FIRMWAREVERSION = "Firmware Version";
    private static final String DRIVERNAME = "Driver Name";
    private static final String COMMONAPIVERSION = "Common API Version";
    private static final String MODEL = "Model";
    private static final String VENDOR = "Vendor";
    private static final String HOSTID = "Host ID";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "ControllerXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public ControllerXmlToDBMapper() {
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml".toLowerCase(), ":", 3);
        this.m_dataConverter.addComplexDataConversion(UNINAME.toLowerCase(), ":", 4);
        ColumnInfo hbaName = Hba.getColumnInfo("NAME");
        hbaName.setIsPrimaryKey();
        MapperInfo hbaNameMap = new MapperInfo(hbaName);
        this.m_htAttribToMapperInfo.put(NAME.toLowerCase(), hbaNameMap);
        this.m_htAttribToMapperInfo.put(UNINAME.toLowerCase(), hbaNameMap);
        this.m_htAttribToMapperInfo.put(SERIALNUMBER.toLowerCase(), new MapperInfo(Hba.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put(DRIVERVERSION.toLowerCase(), new MapperInfo(Hba.getColumnInfo("DRIVER_VERSION")));
        this.m_htAttribToMapperInfo.put(OPTIONALROMVERSION.toLowerCase(), new MapperInfo(Hba.getColumnInfo("ROM_VERSION")));
        this.m_htAttribToMapperInfo.put(HARDWAREVERSION.toLowerCase(), new MapperInfo(Hba.getColumnInfo("HW_VERSION")));
        this.m_htAttribToMapperInfo.put(FIRMWAREVERSION.toLowerCase(), new MapperInfo(Hba.getColumnInfo("FIRMWARE_VERSION")));
        this.m_htAttribToMapperInfo.put(DRIVERNAME.toLowerCase(), new MapperInfo(Hba.getColumnInfo("DRIVER_NAME")));
        this.m_htAttribToMapperInfo.put(COMMONAPIVERSION.toLowerCase(), new MapperInfo(Hba.getColumnInfo("API_VERSION")));
        ColumnInfo hbaHostID = Hba.getColumnInfo("HOST_ID");
        hbaHostID.setIsPrimaryKey();
        MapperInfo hbaHostMap = new MapperInfo(hbaHostID);
        this.m_htAttribToMapperInfo.put(HOSTID.toLowerCase(), hbaHostMap);
        ColumnInfo hbaWwnColInfo = Hba.getColumnInfo("HBA_WWN");
        hbaWwnColInfo.setIsPrimaryKey();
        MapperInfo hbaWwnMapperInfo = new MapperInfo(hbaWwnColInfo);
        ColumnInfo hbaWwnId = Hba.getColumnInfo("HBA_ID");
        hbaWwnId.setAutoGenerated();
        hbaWwnMapperInfo.setDerivedColumn(hbaWwnId);
        this.m_htAttribToMapperInfo.put("UniqueIdXml".toLowerCase(), hbaWwnMapperInfo);
        this.m_htAttribToMapperInfo.put(MODEL.toLowerCase(), new MapperInfo(Hba.getColumnInfo("MODEL_ID")));
        this.m_htAttribToMapperInfo.put(VENDOR.toLowerCase(), new MapperInfo(Hba.getColumnInfo("VENDOR_ID")));
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        block15: {
            String methodName = "persist(DBConnection conn, Hashtable htValues,String scanID)";
            if (conn == null || htValues == null) {
                throw new SQLException("ControllerXml mapper requires non-null DBConnection and Hashtable objects.");
            }
            String gV = (String)htValues.get("UniqueIdXml");
            if (gV == null) {
                throw new SQLException("ControllerXML mapper requires the UniqueIdXml key.");
            }
            String name = (String)htValues.get(NAME.toLowerCase());
            if (name == null) {
                htValues.put(UNINAME, gV);
            }
            Hashtable<String, String> temp = new Hashtable<String, String>();
            temp.put(GUID, gV);
            this.m_dataConverter.addComplexDataConversion(GUID, ":", 2);
            this.m_dataConverter.performDataConversion(temp);
            gV = (String)temp.get(GUID);
            if (gV != null && gV.indexOf(46) >= 0) {
                try {
                    GUID guidO = new GUID(gV);
                    gV = guidO.toNoDotString();
                }
                catch (Exception exp) {
                    gV = null;
                }
            }
            if (gV != null) {
                Hashtable<ColumnInfo, String> params = new Hashtable<ColumnInfo, String>();
                params.put(Host.getColumnInfo(GUID), gV);
                DBResultSet rs = null;
                try {
                    this.logInfo(this.myClassname, methodName, "About to query to T_RES_HOST table for an entry with GUID: " + gV);
                    rs = SqlHost.sqlQuery(conn, 2, params);
                    if (rs.next()) {
                        int autoId = rs.getInt("COMPUTER_ID");
                        this.logInfo(this.myClassname, methodName, "Query for entry in T_RES_HOST table returned an auto-id value of: " + autoId);
                        htValues.put(HOSTID, String.valueOf(autoId));
                        break block15;
                    }
                    this.logInfo(this.myClassname, methodName, "Query for entry in T_RES_HOST table returned no results, meaning the HOST has yet to be added to the database.  This information is required to persist the HBA.");
                    throw new SQLException("ControllerXml mapper requires that an entry for the guid provided to it (" + gV + ") be in T_RES_HOST");
                }
                catch (Exception e) {
                    this.logException(this.myClassname, methodName, e, "Error occurred while attempting to retrieve the HOST auto-id value, the HOST_ID column will be blank.");
                    throw new SQLException("ControllerXml mapper requires that an entry for the guid provided to it (" + gV + ") be in T_RES_HOST");
                }
                finally {
                    if (rs != null) {
                        rs.close();
                        if (rs.getStatement() != null) {
                            rs.getStatement().close();
                        }
                    }
                }
            }
        }
        this.m_dataConverter.removeComplexDataConversion(GUID);
        return super.persist(conn, htValues, scanID);
    }
}

