/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Switch2port;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.FcPortXmlToDBMapper;
import org.eclipse.aperi.infrastructure.mapping.InterconnectElementXmlToDBMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class InterconnectElementXml2FcPortIdXmlToDBMapper
extends DBAttributeMapper {
    private static final String SWITCHWWN = "Switch WWN";
    private static final String PORTID = "Port ID";
    private static final String NAMEFORMAT = "Name Format";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "InterconnectElementXml2FcPortIdXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public InterconnectElementXml2FcPortIdXmlToDBMapper() {
        ColumnInfo s2PortPortWwn = Switch2port.getColumnInfo("SWITCH_WWN");
        s2PortPortWwn.setIsPrimaryKey();
        ColumnInfo switchWwn = Switch.getColumnInfo("SWITCH_WWN");
        s2PortPortWwn.setReferencedColumn(switchWwn);
        this.m_htAttribToMapperInfo.put(SWITCHWWN.toLowerCase(), new MapperInfo(s2PortPortWwn));
        ColumnInfo s2PortId = Switch2port.getColumnInfo("PORT_ID");
        s2PortId.setIsPrimaryKey();
        ColumnInfo portId = Port.getColumnInfo("PORT_ID");
        s2PortId.setReferencedColumn(portId);
        ColumnInfo switch2PortId = Switch2port.getColumnInfo("SWITCH2PORT_ID");
        switch2PortId.setAutoGenerated();
        MapperInfo portMapper = new MapperInfo(s2PortId);
        portMapper.setDerivedColumn(switch2PortId);
        this.m_htAttribToMapperInfo.put(PORTID.toLowerCase(), portMapper);
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        String parentWWN = (String)htValues.get("FromUniqueIdXml");
        Hashtable<String, String> temp1 = new Hashtable<String, String>();
        temp1.put("UniqueIdXml", parentWWN);
        InterconnectElementXmlToDBMapper switchMapper = new InterconnectElementXmlToDBMapper();
        String wwn = (String)htValues.get("ToUniqueIdXml");
        Hashtable<String, String> temp2 = new Hashtable<String, String>();
        temp2.put("UniqueIdXml", wwn);
        FcPortXmlToDBMapper portMapper = new FcPortXmlToDBMapper();
        MapperResult mr = this.persist(conn, switchMapper, temp1, portMapper, temp2, scanID);
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }

    public MapperResult persist(DBConnection conn, DBAttributeMapper m1, Hashtable ht1, DBAttributeMapper m2, Hashtable ht2, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, m1, ht1, m2, ht2, scanID});
        String format = DBConstants.getValueFromKey("Name_Format", "FC_WWN");
        ht1.put(NAMEFORMAT, format);
        ht2.put(NAMEFORMAT, format);
        MapperResult mr = super.persist(conn, m1, ht1, m2, ht2, scanID);
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }
}

