/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SLPToDBMapper
extends DBAttributeMapper {
    private static final String cT_RES_REGISTERED_CIMOM = "T_RES_REGISTERED_CIMOM";
    private static final String cT_RES_CIMOM2NAMESPACE = "T_RES_CIMOM2NAMESPACE";
    public static final String sTEMPLATE_URL_SYNTAX = "template-url-syntax";
    public static final String sSERVICE_HI_NAME = "service-hi-name";
    public static final String sSERVICE_HI_DESCRIPTION = "service-hi-description";
    public static final String sPROTOCOLVERSION = "protocolversion";
    public static final String sINTEROPSCHEMANAMESPACE = "interopschemanamespace";
    public static final String sSOFTWARE_LEVEL = "software_level";
    public static final String sAUTHENTICATION_MECHANISM = "authentication_mechanism";
    public static final String sUSER_ID = "user_id";
    public static final String sPASSWORD = "password";
    public static final String sTRUST_STORE_LOCATION = "trust_store_location";
    public static final String sTRUST_STORE_PASSPHRASE = "trust_store_passphrase";
    public static final String sDISPLAY_NAME = "display_name";
    public static final String sSLP_ATTRIBUTES = "slp_attributes";
    public static final String sPROTOCOL = "protocol";
    public static final String sNAMESPACE = "namespace";
    public static final String sSTATUS = "status";
    public static final String sSTATUSTIMESTAMP = "statustimestamp";
    public static final String sREF_SERVICEURL = "ref_serviceurl";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "SLP";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SLPToDBMapper() {
        this.m_htAttribToMapperInfo.put(sSERVICE_HI_NAME, new MapperInfo(RegisteredCimom.getColumnInfo("HI_NAME")));
        this.m_htAttribToMapperInfo.put(sSERVICE_HI_DESCRIPTION, new MapperInfo(RegisteredCimom.getColumnInfo("DESCRIPTION")));
        this.m_htAttribToMapperInfo.put(sPROTOCOLVERSION, new MapperInfo(RegisteredCimom.getColumnInfo("PROTOCOL_VERSION")));
        this.m_htAttribToMapperInfo.put(sINTEROPSCHEMANAMESPACE, new MapperInfo(RegisteredCimom.getColumnInfo("INTEROP_SCHEMA_NAMESPACE")));
        this.m_htAttribToMapperInfo.put(sSOFTWARE_LEVEL, new MapperInfo(RegisteredCimom.getColumnInfo("SOFTWARE_LEVEL")));
        this.m_htAttribToMapperInfo.put(sAUTHENTICATION_MECHANISM, new MapperInfo(RegisteredCimom.getColumnInfo("AUTHENTICATION_MECHANISM")));
        this.m_htAttribToMapperInfo.put(sUSER_ID, new MapperInfo(RegisteredCimom.getColumnInfo("USER_ID")));
        this.m_htAttribToMapperInfo.put(sPASSWORD, new MapperInfo(RegisteredCimom.getColumnInfo("PASSWORD")));
        this.m_htAttribToMapperInfo.put(sTRUST_STORE_LOCATION, new MapperInfo(RegisteredCimom.getColumnInfo("TRUST_STORE_LOCATION")));
        this.m_htAttribToMapperInfo.put(sTRUST_STORE_PASSPHRASE, new MapperInfo(RegisteredCimom.getColumnInfo("TRUST_STORE_PASSPHRASE")));
        this.m_htAttribToMapperInfo.put(sDISPLAY_NAME, new MapperInfo(RegisteredCimom.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put(sPROTOCOL, new MapperInfo(RegisteredCimom.getColumnInfo("PROTOCOL")));
        this.m_htAttribToMapperInfo.put(sSTATUS, new MapperInfo(RegisteredCimom.getColumnInfo("STATUS")));
        this.m_htAttribToMapperInfo.put(sSTATUSTIMESTAMP, new MapperInfo(RegisteredCimom.getColumnInfo("STATUS_TIMESTAMP")));
        ColumnInfo serviceURLname = RegisteredCimom.getColumnInfo("SERVICE_URL");
        serviceURLname.setIsPrimaryKey();
        MapperInfo serviceURLMapperInfo = new MapperInfo(serviceURLname);
        ColumnInfo reginfoIdInfo = RegisteredCimom.getColumnInfo("REG_CIMOM_ID");
        reginfoIdInfo.setAutoGenerated();
        serviceURLMapperInfo.setDerivedColumn(reginfoIdInfo);
        this.m_htAttribToMapperInfo.put(sTEMPLATE_URL_SYNTAX, serviceURLMapperInfo);
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        int pos;
        String bServiceURL;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        if (pParams.get(sREF_SERVICEURL) != null) {
            pParams.put(sTEMPLATE_URL_SYNTAX, pParams.get(sREF_SERVICEURL));
        }
        if ((bServiceURL = (String)pParams.get(sTEMPLATE_URL_SYNTAX)) != null && (pos = bServiceURL.indexOf(":")) != -1) {
            String bProtocol = bServiceURL.substring(0, bServiceURL.indexOf(":"));
            pParams.put(sPROTOCOL, bProtocol);
        }
        if (pParams.get(sSTATUS) != null) {
            pParams.put(sSTATUSTIMESTAMP, CurrentTime.getTimestamp(pConn).toString());
        }
        MapperResult mResultRegisteredCIMOM = super.persist(pConn, pParams, pScanID);
        Hashtable mAllHTregCIMOM = mResultRegisteredCIMOM.getAllRows();
        Hashtable mUpdatedHTregCIMOM = mResultRegisteredCIMOM.getUpdatedRows();
        Hashtable mInsertHTregCIMOM = mResultRegisteredCIMOM.getInsertedRows();
        String mCimomID = (String)((Hashtable)mAllHTregCIMOM.get(cT_RES_REGISTERED_CIMOM)).get(RegisteredCimom.getColumnInfo("REG_CIMOM_ID"));
        String mServiceurl = (String)((Hashtable)mAllHTregCIMOM.get(cT_RES_REGISTERED_CIMOM)).get(RegisteredCimom.getColumnInfo("SERVICE_URL"));
        if (mCimomID.equalsIgnoreCase("NULL") || mCimomID.equalsIgnoreCase("-1")) {
            Hashtable<ColumnInfo, String> regCIMOMHT = new Hashtable<ColumnInfo, String>();
            regCIMOMHT.put(RegisteredCimom.getColumnInfo("SERVICE_URL"), mServiceurl);
            RegisteredCimom regCIMOM = RegisteredCimom.retrieve(pConn, regCIMOMHT);
            mCimomID = "" + regCIMOM.getRegCimomId();
        }
        Hashtable<String, String> mCIMOM2NamspaceParams = new Hashtable<String, String>();
        mCIMOM2NamspaceParams.put("registered_cimom_id_exists", mCimomID);
        String mNamespace = (String)pParams.get(sNAMESPACE);
        if (mNamespace != null) {
            mCIMOM2NamspaceParams.put("namespace_cimom_new", mNamespace);
            CIMOM2NSMapper mCIMOM2NSMapper = new CIMOM2NSMapper();
            MapperResult mResultCIMOM2Namespace = mCIMOM2NSMapper.persist(pConn, mCIMOM2NamspaceParams, pScanID);
            mResultCIMOM2Namespace.addKeyReference("ref_namespace", Cimom2namespace.getColumnInfo("NAMESPACE"));
            mResultRegisteredCIMOM.addMapperResult(mResultCIMOM2Namespace);
        }
        mResultRegisteredCIMOM.addKeyReference(sREF_SERVICEURL, RegisteredCimom.getColumnInfo("SERVICE_URL"));
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mResultRegisteredCIMOM);
        return mResultRegisteredCIMOM;
    }

    private class CIMOM2NSMapper
    extends DBAttributeMapper {
        public CIMOM2NSMapper() {
            ColumnInfo nsTargetColumn = Cimom2namespace.getColumnInfo("NAMESPACE");
            nsTargetColumn.setIsPrimaryKey();
            MapperInfo nsMapperInfo = new MapperInfo(nsTargetColumn);
            ColumnInfo cimom2nsCol = Cimom2namespace.getColumnInfo("CIM_NAMESPACE_ID");
            cimom2nsCol.setAutoGenerated();
            nsMapperInfo.setDerivedColumn(cimom2nsCol);
            this.m_htAttribToMapperInfo.put("namespace_cimom_new", nsMapperInfo);
            ColumnInfo idTargetColumn = Cimom2namespace.getColumnInfo("CIMOM_ID");
            idTargetColumn.setIsPrimaryKey();
            MapperInfo idMapperInfo = new MapperInfo(idTargetColumn);
            cimom2nsCol = Cimom2namespace.getColumnInfo("CIM_NAMESPACE_ID");
            cimom2nsCol.setAutoGenerated();
            idMapperInfo.setDerivedColumn(cimom2nsCol);
            this.m_htAttribToMapperInfo.put("registered_cimom_id_exists", idMapperInfo);
        }
    }
}

