/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_SoftwareIdentityToDBMapper
extends DBAttributeMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_SoftwareIdentity";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMISCIM_SoftwareIdentityToDBMapper() {
        ColumnInfo ssName = StorageSubsystem.getColumnInfo("NAME");
        ssName.setIsPrimaryKey();
        MapperInfo ssnameMapperInfo = new MapperInfo(ssName);
        ColumnInfo ssIdInfo = StorageSubsystem.getColumnInfo("SUBSYSTEM_ID");
        ssIdInfo.setAutoGenerated();
        ssnameMapperInfo.setDerivedColumn(ssIdInfo);
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_name", ssnameMapperInfo);
        ColumnInfo ssNameFormat = StorageSubsystem.getColumnInfo("NAME_FORMAT");
        ssNameFormat.setIsPrimaryKey();
        MapperInfo ssnameFormatMapperInfo = new MapperInfo(ssNameFormat);
        ssnameFormatMapperInfo.setDerivedColumn(ssIdInfo);
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_nameformat", ssnameFormatMapperInfo);
        this.m_htAttribToMapperInfo.put("versionstring", new MapperInfo(StorageSubsystem.getColumnInfo("CODE_LEVEL")));
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        MapperResult returnResult = new MapperResult();
        if (htValues.get("ref_switch_wwn") != null) {
            SMISSwitchVersionToDBMapper mapper = new SMISSwitchVersionToDBMapper();
            returnResult = mapper.persist(conn, htValues, scanID);
        } else if (htValues.get("ref_tape_library_id") != null) {
            SMISTapeVersionToDBMapper mapper = new SMISTapeVersionToDBMapper();
            returnResult = mapper.persist(conn, htValues, scanID);
        } else {
            returnResult = super.persist(conn, htValues, scanID);
        }
        this.logExit(this.myClassname, methodName, returnResult);
        return returnResult;
    }

    private class SMISTapeVersionToDBMapper
    extends DBAttributeMapper {
        public SMISTapeVersionToDBMapper() {
            ColumnInfo ssName = TapeLibrary.getColumnInfo("NAME");
            ssName.setIsPrimaryKey();
            MapperInfo ssnameMapperInfo = new MapperInfo(ssName);
            ColumnInfo ssIdInfo = TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID");
            ssIdInfo.setAutoGenerated();
            ssnameMapperInfo.setDerivedColumn(ssIdInfo);
            this.m_htAttribToMapperInfo.put("ref_toplevelsystem_name", ssnameMapperInfo);
            ColumnInfo ssNameFormat = TapeLibrary.getColumnInfo("NAME_FORMAT");
            ssNameFormat.setIsPrimaryKey();
            MapperInfo ssnameFormatMapperInfo = new MapperInfo(ssNameFormat);
            ssnameFormatMapperInfo.setDerivedColumn(ssIdInfo);
            this.m_htAttribToMapperInfo.put("ref_toplevelsystem_nameformat", ssnameFormatMapperInfo);
            this.m_htAttribToMapperInfo.put("versionstring", new MapperInfo(TapeLibrary.getColumnInfo("FIRMWARE_VERSION")));
        }
    }

    private class SMISSwitchVersionToDBMapper
    extends DBAttributeMapper {
        public SMISSwitchVersionToDBMapper() {
            ColumnInfo ssName = Switch.getColumnInfo("SWITCH_WWN");
            ssName.setIsPrimaryKey();
            MapperInfo ssnameMapperInfo = new MapperInfo(ssName);
            ColumnInfo ssIdInfo = Switch.getColumnInfo("SWITCH_ID");
            ssIdInfo.setAutoGenerated();
            ssnameMapperInfo.setDerivedColumn(ssIdInfo);
            this.m_htAttribToMapperInfo.put("ref_switch_wwn", ssnameMapperInfo);
            this.m_htAttribToMapperInfo.put("versionstring", new MapperInfo(Switch.getColumnInfo("VERSION")));
        }
    }
}

