/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_StoragePoolToDBMapper
extends DBAttributeMapper {
    private static final String sELEMENTNAME = "elementname";
    private static final String sREMAININGMANAGEDSPACE = "remainingmanagedspace";
    private static final String sTOTALMANAGEDSPACE = "totalmanagedspace";
    private static final String sTOTALMANAGEDLOGICALSPACE = "totalmanagedlogicalspace";
    protected static final String sAVAILABLESPACE = "remainingmanagedspace_availablespace";
    protected static final String sCAPACITY = "totalmanagedspace_capacity";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_StoragePool";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.1.0";
        DBAttributeMapper.RegistrationData mR3 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2, mR3};
    }

    public SMISCIM_StoragePoolToDBMapper() {
        this.m_htAttribToMapperInfo.put("name", new MapperInfo(StoragePool.getColumnInfo("NAME")));
        this.m_htAttribToMapperInfo.put("operationalstatus", new MapperInfo(StoragePool.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(StoragePool.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_dataConverter.addSimpleDataConversion("primordial", "Boolean");
        this.m_htAttribToMapperInfo.put("primordial", new MapperInfo(StoragePool.getColumnInfo("PRIMORDIAL")));
        this.m_dataConverter.addCalculationDataConversion(sREMAININGMANAGEDSPACE, "/", "512");
        this.m_htAttribToMapperInfo.put(sREMAININGMANAGEDSPACE, new MapperInfo(StoragePool.getColumnInfo("REMAINING_MANAGED_SPACE")));
        this.m_dataConverter.addCalculationDataConversion(sTOTALMANAGEDSPACE, "/", "512");
        this.m_htAttribToMapperInfo.put(sTOTALMANAGEDSPACE, new MapperInfo(StoragePool.getColumnInfo("TOTAL_MANAGED_SPACE")));
        this.m_dataConverter.addCalculationDataConversion(sAVAILABLESPACE, "/", "512");
        this.m_htAttribToMapperInfo.put(sAVAILABLESPACE, new MapperInfo(StoragePool.getColumnInfo("TOTAL_AVAILABLE_SPACE")));
        this.m_dataConverter.addCalculationDataConversion(sCAPACITY, "/", "512");
        this.m_htAttribToMapperInfo.put(sCAPACITY, new MapperInfo(StoragePool.getColumnInfo("CAPACITY")));
        this.m_htAttribToMapperInfo.put(sELEMENTNAME, new MapperInfo(StoragePool.getColumnInfo("DISPLAY_NAME")));
        ColumnInfo mClassNameInfo = StoragePool.getColumnInfo("CLASS_NAME_ID");
        mClassNameInfo.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put("ref_classname", new MapperInfo(mClassNameInfo));
        ColumnInfo mInstanceIDCol = StoragePool.getColumnInfo("INSTANCE_ID");
        mInstanceIDCol.setIsPrimaryKey();
        MapperInfo mInstanceIDMapperInfo = new MapperInfo(mInstanceIDCol);
        ColumnInfo mPoolIDCol = StoragePool.getColumnInfo("POOL_ID");
        mPoolIDCol.setAutoGenerated();
        mInstanceIDMapperInfo.setDerivedColumn(mPoolIDCol);
        this.m_htAttribToMapperInfo.put("instanceid", mInstanceIDMapperInfo);
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", new MapperInfo(StoragePool.getColumnInfo("SUBSYSTEM_ID")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String opstatus;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mAvailableSpace = (String)pParams.get(sAVAILABLESPACE);
        String mRemainingSpace = (String)pParams.get(sREMAININGMANAGEDSPACE);
        if (mAvailableSpace == null && mRemainingSpace != null) {
            pParams.put(sAVAILABLESPACE, mRemainingSpace);
        }
        String mCapacity = (String)pParams.get(sCAPACITY);
        String mTotalManagedSpace = (String)pParams.get(sTOTALMANAGEDSPACE);
        String mTotalManagedLogicalSpace = (String)pParams.get(sTOTALMANAGEDLOGICALSPACE);
        if (mCapacity == null) {
            if (mTotalManagedLogicalSpace != null) {
                pParams.put(sCAPACITY, mTotalManagedLogicalSpace);
            } else if (mTotalManagedSpace != null) {
                pParams.put(sCAPACITY, mTotalManagedSpace);
            }
        }
        if ((opstatus = (String)pParams.get("operationalstatus")) != null) {
            Vector opArray = SMISCIM_StoragePoolToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                pParams.put("operationalstatus", opstatus);
            } else {
                pParams.remove("operationalstatus");
            }
            opstatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue(opArray);
            if (opstatus != null) {
                pParams.put("CONSOLIDATED_STATUS".toLowerCase(), opstatus);
            }
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        mReturnResult.addKeyReference("ref_instance_id", StoragePool.getColumnInfo("INSTANCE_ID"));
        mReturnResult.addKeyReference("ref_toplevelsystem_id", StoragePool.getColumnInfo("SUBSYSTEM_ID"));
        mReturnResult.addKeyReference("ref_storagepool_id", StoragePool.getColumnInfo("POOL_ID"));
        mReturnResult.addKeyReference("ref_storagepool_class_id", StoragePool.getColumnInfo("CLASS_NAME_ID"));
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }
}

