/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_StorageVolumeToDBMapper;

public class SMISHITACHI_StorageVolumeToDBMapper
extends SMISCIM_StorageVolumeToDBMapper {
    public SMISHITACHI_StorageVolumeToDBMapper() {
        this.m_htAttribToMapperInfo.put("UNIQUE_ID".toLowerCase(), new MapperInfo(StorageVolume.getColumnInfo("UNIQUE_ID")));
    }

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "HITACHI_StorageVolume";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.1.0";
        DBAttributeMapper.RegistrationData mR3 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2, mR3};
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mElementName = (String)pParams.get("elementname");
        String mTopLevelCS = (String)pParams.get("ref_toplevelsystem_name");
        if (mElementName != null && mTopLevelCS != null && mElementName.trim().length() > 0 && mTopLevelCS.trim().length() > 0) {
            int col;
            String deviceId = null;
            String ssSerialNumber = null;
            boolean decimalValue = false;
            String[] bTokens = mTopLevelCS.split("\\.");
            if (bTokens.length >= 2) {
                String tempSerialNumber = bTokens[bTokens.length - 1];
                if (tempSerialNumber.length() > 5) {
                    decimalValue = true;
                    ssSerialNumber = tempSerialNumber.substring(4);
                } else {
                    ssSerialNumber = this.charToHex(tempSerialNumber, 4);
                }
            }
            if ((col = mElementName.indexOf(58)) > -1 && mElementName.toLowerCase().matches("[0-9a-f]:[0-9a-f][0-9a-f]")) {
                deviceId = decimalValue ? this.charHexToDecimal("0" + mElementName.charAt(col - 1) + mElementName.charAt(col + 1) + mElementName.charAt(col + 2), 4) : mElementName.charAt(col - 1) + "0" + mElementName.charAt(col + 1) + mElementName.charAt(col + 2);
            } else if (decimalValue) {
                deviceId = this.appendZero(mElementName, 4);
            } else {
                String hexData = this.charToHex(mElementName, 4);
                if (hexData != null) {
                    deviceId = hexData.charAt(0) == '0' ? hexData.charAt(1) + "0" + hexData.charAt(2) + hexData.charAt(3) : hexData.charAt(0) + "0" + hexData.charAt(2) + hexData.charAt(3);
                }
            }
            if (ssSerialNumber != null && deviceId != null) {
                String uniqueId = ssSerialNumber + "/" + deviceId;
                pParams.put("UNIQUE_ID".toLowerCase(), uniqueId);
            } else {
                pParams.put("UNIQUE_ID".toLowerCase(), null);
            }
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }

    private String charToHex(String strIN, int outLen) {
        String inHex;
        if (strIN == null) {
            return null;
        }
        try {
            inHex = Integer.toHexString(Integer.parseInt(strIN)).toUpperCase();
        }
        catch (NumberFormatException e) {
            return null;
        }
        int inLen = inHex.length();
        char[] work = new char[outLen];
        int iDiff = outLen - inLen;
        int i = 0;
        int z = 0;
        if (iDiff > 0) {
            for (i = 0; i < iDiff; ++i) {
                work[i] = 48;
            }
        }
        while (i < outLen) {
            work[i] = inHex.charAt(z);
            ++z;
            ++i;
        }
        return String.valueOf(work);
    }

    private String charHexToDecimal(String strIN, int outLen) {
        String inDecimal;
        if (strIN == null) {
            return null;
        }
        char[] work = new char[outLen];
        try {
            inDecimal = Integer.toString(Integer.parseInt(strIN, 16));
        }
        catch (NumberFormatException e) {
            return null;
        }
        int inLen = inDecimal.length();
        work = new char[outLen];
        int iDiff = outLen - inLen;
        int i = 0;
        int z = 0;
        if (iDiff > 0) {
            for (i = 0; i < iDiff; ++i) {
                work[i] = 48;
            }
        }
        while (i < outLen) {
            work[i] = inDecimal.charAt(z);
            ++z;
            ++i;
        }
        return String.valueOf(work);
    }

    private String appendZero(String strIN, int outLen) {
        if (strIN == null) {
            return null;
        }
        char[] work = new char[outLen];
        int inLen = strIN.length();
        work = new char[outLen];
        int iDiff = outLen - inLen;
        int i = 0;
        int z = 0;
        if (iDiff > 0) {
            for (i = 0; i < iDiff; ++i) {
                work[i] = 48;
            }
        }
        while (i < outLen) {
            work[i] = strIN.charAt(z);
            ++z;
            ++i;
        }
        return String.valueOf(work);
    }
}

