/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_StorageVolumeToDBMapper;

public class SMISIBMTSESS_VolumeToDBMapper
extends SMISCIM_StorageVolumeToDBMapper {
    private static final String sCONTROLLED = "controlled";
    private static final String sVOLUMENUMBER = "volumenumber";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSESS_Volume";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2};
    }

    public SMISIBMTSESS_VolumeToDBMapper() {
        this.m_htAttribToMapperInfo.put("lss", new MapperInfo(TResStorageVolumeTable.getColumnInfo("LSS")));
        this.m_dataConverter.addSimpleDataConversion("format", "ESS_Format");
        this.m_htAttribToMapperInfo.put("format", new MapperInfo(TResStorageVolumeTable.getColumnInfo("FORMAT")));
        this.m_dataConverter.addSimpleDataConversion(sCONTROLLED, "Boolean");
        this.m_htAttribToMapperInfo.put(sCONTROLLED, new MapperInfo(TResStorageVolumeTable.getColumnInfo("IS_ASSIGNED")));
        this.m_htAttribToMapperInfo.put(sVOLUMENUMBER, new MapperInfo(StorageVolume.getColumnInfo("VOLUME_NUMBER")));
        this.m_htAttribToMapperInfo.put("UNIQUE_ID".toLowerCase(), new MapperInfo(StorageVolume.getColumnInfo("UNIQUE_ID")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String mDeviceID;
        String lss;
        String capacity;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mName = (String)pParams.get("name");
        String mSystemName = (String)pParams.get("systemname");
        if (mName != null && mSystemName != null) {
            if (mSystemName.startsWith("2107") || mSystemName.startsWith("1750")) {
                String mElementName = (String)pParams.get("elementname");
                if (mElementName != null) {
                    String bDisplayName = mElementName + " (ID:" + mName.substring(mName.length() - 4, mName.length()) + ")";
                    pParams.put("DISPLAY_NAME".toLowerCase(), bDisplayName);
                }
            } else if (mSystemName.startsWith("2105")) {
                String bDisplayName = mName.substring(mName.length() - 4, mName.length());
                pParams.put("DISPLAY_NAME".toLowerCase(), bDisplayName);
            }
            try {
                String bVolNumPrep = mName.trim();
                bVolNumPrep = bVolNumPrep.substring(bVolNumPrep.length() - 2, bVolNumPrep.length());
                pParams.put(sVOLUMENUMBER, Integer.parseInt(bVolNumPrep.trim(), 16) + "");
            }
            catch (Exception e) {
                this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Could not convert name(hex) to VOLUME_NUMBER (dec)");
            }
            String replacementString = new String("");
            String serialNumber = mName.replaceFirst("0+", replacementString).trim();
            pParams.put("serialnumber", serialNumber);
        }
        if ((capacity = (String)pParams.get("cap")) != null) {
            try {
                int aPoint = capacity.indexOf(".");
                int anE = capacity.indexOf("E");
                if (anE == -1) {
                    anE = capacity.indexOf("e");
                }
                if (aPoint != -1) {
                    if (anE != -1) {
                        int anExponent = Integer.parseInt(capacity.substring(anE + 1));
                        anExponent -= anE - aPoint - 1;
                        String cap = capacity.substring(0, aPoint) + capacity.substring(aPoint + 1, anE);
                        for (int i = 0; i < anExponent; ++i) {
                            cap = cap + "0";
                        }
                        pParams.put("CAPACITY".toLowerCase(), cap);
                    } else {
                        pParams.put("CAPACITY".toLowerCase(), capacity.substring(0, aPoint));
                    }
                }
            }
            catch (Exception e) {
                pParams.remove("cap");
                this.logException(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", e, "Capacity convertion from real to double threw an exception, continue without saving capacity.");
            }
        }
        if ((lss = (String)pParams.get("lss")) != null) {
            try {
                int mLssInt = Integer.parseInt(lss, 16);
                pParams.put("lss", String.valueOf(mLssInt));
            }
            catch (Exception e) {
                pParams.remove("lss");
                this.logException(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", e, "LSS convertion from hexvalue to integer threw an exception, continue without saving lss.");
            }
        }
        if ((mDeviceID = (String)pParams.get("deviceid")) != null && mSystemName != null) {
            String serialNumber = new String();
            StringTokenizer tokens = new StringTokenizer(mSystemName, ".");
            if (tokens.hasMoreTokens()) {
                serialNumber = tokens.nextToken();
            }
            if (tokens.hasMoreTokens()) {
                serialNumber = tokens.nextToken();
            }
            String mUniqueID = serialNumber + "/" + mDeviceID;
            pParams.put("UNIQUE_ID".toLowerCase(), mUniqueID);
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }
}

