/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_ComputerSystem_TopLevelToDBMapper;

public class SMISIBMTSSVC_ClusterToDBMapper
extends SMISCIM_ComputerSystem_TopLevelToDBMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSSVC_Cluster";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        String mDedicated = "15";
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2};
    }

    public SMISIBMTSSVC_ClusterToDBMapper() {
        this.m_dataConverter.addCalculationDataConversion("allocatedcapacity", "/", "512");
        this.m_htAttribToMapperInfo.put("allocatedcapacity", new MapperInfo(StorageSubsystem.getColumnInfo("ALLOCATED_CAPACITY")));
        this.m_dataConverter.addCalculationDataConversion("availablecapacity", "/", "512");
        this.m_htAttribToMapperInfo.put("availablecapacity", new MapperInfo(StorageSubsystem.getColumnInfo("AVAILABLE_CAPACITY")));
        this.m_dataConverter.addCalculationDataConversion("backendstoragecapacity", "/", "512");
        this.m_htAttribToMapperInfo.put("backendstoragecapacity", new MapperInfo(StorageSubsystem.getColumnInfo("BACKEND_STORAGE_CAPACITY")));
        this.m_htAttribToMapperInfo.put("codelevel", new MapperInfo(StorageSubsystem.getColumnInfo("CODE_LEVEL")));
        this.m_htAttribToMapperInfo.put("otheridentifyinginfo", new MapperInfo(StorageSubsystem.getColumnInfo("IP_ADDRESS")));
        this.m_htAttribToMapperInfo.put("timezone", new MapperInfo(StorageSubsystem.getColumnInfo("TIME_ZONE")));
        this.m_htAttribToMapperInfo.put("requiredmemory", new MapperInfo(StorageSubsystem.getColumnInfo("CACHE")));
        this.m_htAttribToMapperInfo.put("SERIAL_NUMBER".toLowerCase(), new MapperInfo(StorageSubsystem.getColumnInfo("SERIAL_NUMBER")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String mReqMemStr;
        String name;
        String elementname;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String opstatus = (String)pParams.get("otheridentifyinginfo");
        if (opstatus != null) {
            Vector opArray = SMISIBMTSSVC_ClusterToDBMapper.processArrayvalues(opstatus);
            pParams.put("otheridentifyinginfo", (String)opArray.firstElement());
        }
        if ((elementname = (String)pParams.get("elementname")) != null) {
            pParams.put("elementname", "SVC-2145-" + elementname + "-IBM");
        }
        if ((name = (String)pParams.get("name")) != null) {
            StringTokenizer tokens = new StringTokenizer(name, ":");
            if (tokens.hasMoreTokens()) {
                name = tokens.nextToken();
            }
            if (tokens.hasMoreTokens()) {
                name = tokens.nextToken();
                pParams.put("SERIAL_NUMBER".toLowerCase(), name);
            }
        }
        if ((mReqMemStr = (String)pParams.get("requiredmemory")) != null) {
            try {
                long megInBytes = Long.parseLong(mReqMemStr) * 1024L * 1024L;
                pParams.put("requiredmemory", String.valueOf(megInBytes));
            }
            catch (NumberFormatException e) {
                pParams.remove("requiredmemory");
            }
        }
        pParams.put("OS_TYPE".toLowerCase(), String.valueOf(21));
        pParams.put("TYPE".toLowerCase(), "SVC");
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }
}

