/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.IoGroup;
import org.eclipse.aperi.infrastructure.database.tables.TResRedundancyTable;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_ComputerSystem_NodeToDBMapper;

public class SMISIBMTSSVC_NodeToDBMapper
extends SMISCIM_ComputerSystem_NodeToDBMapper {
    public static final String sGROUPNAME = "groupname";
    public static final String sGROUPID = "groupid";
    public static final String sSUBSYSTEMIDIO = "ref_toplevelsystem_id";
    public static final String sAUTOIOGROUPID = "autoiogrpid";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSSVC_Node";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        String mDedicated = "0";
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2};
    }

    public SMISIBMTSSVC_NodeToDBMapper() {
        this.m_htAttribToMapperInfo.remove("iogroupid");
        this.m_htAttribToMapperInfo.put(sAUTOIOGROUPID, new MapperInfo(TResRedundancyTable.getColumnInfo("IO_GROUP_ID")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String name;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String opstatus = (String)pParams.get("otheridentifyinginfo");
        if (opstatus != null) {
            Vector opArray = SMISIBMTSSVC_NodeToDBMapper.processArrayvalues(opstatus);
            if (opArray.size() > 4) {
                pParams.put("wwn", (String)opArray.elementAt(4));
            }
            if (opArray.size() > 0) {
                pParams.put(sGROUPNAME, (String)opArray.elementAt(0));
            }
            if (opArray.size() > 1) {
                pParams.put(sGROUPID, (String)opArray.elementAt(1));
            }
        }
        if (pParams.get("componentid") == null && (name = (String)pParams.get("name")) != null) {
            pParams.put("componentid", name);
        }
        if (pParams.get("ipaddress") == null && (name = (String)pParams.get("name")) != null) {
            StringTokenizer tokens = new StringTokenizer(name, ":");
            if (tokens.hasMoreTokens()) {
                name = tokens.nextToken();
            }
            pParams.put("ipaddress", name);
        }
        MapperResult mIOResult = null;
        if (pParams.get(sGROUPNAME) != null) {
            pParams.put(sSUBSYSTEMIDIO, pParams.get(sSUBSYSTEMIDIO));
            IOGroupMapper mIOGroupMapper = new IOGroupMapper();
            mIOResult = mIOGroupMapper.persist(pConn, pParams, pScanID);
            Hashtable mAllRowsIOGRP = mIOResult.getAllRows();
            String mAutoGenIOGRPID = (String)((Hashtable)mAllRowsIOGRP.get(IoGroup.getTablename())).get(IoGroup.getColumnInfo("IO_GROUP_ID"));
            pParams.put(sAUTOIOGROUPID, mAutoGenIOGRPID);
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        if (mIOResult != null) {
            mReturnResult.addMapperResult(mIOResult);
        }
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }

    private class IOGroupMapper
    extends DBAttributeMapper {
        public IOGroupMapper() {
            ColumnInfo mNameInfo = IoGroup.getColumnInfo("NAME");
            mNameInfo.setIsPrimaryKey();
            MapperInfo mNameMapperInfo = new MapperInfo(mNameInfo);
            ColumnInfo mIOGroupIdColumn = IoGroup.getColumnInfo("IO_GROUP_ID");
            mIOGroupIdColumn.setAutoGenerated();
            mNameMapperInfo.setDerivedColumn(mIOGroupIdColumn);
            this.m_htAttribToMapperInfo.put(SMISIBMTSSVC_NodeToDBMapper.sGROUPNAME, mNameMapperInfo);
            this.m_htAttribToMapperInfo.put(SMISIBMTSSVC_NodeToDBMapper.sSUBSYSTEMIDIO, new MapperInfo(IoGroup.getColumnInfo("SUBSYSTEM_ID")));
            this.m_htAttribToMapperInfo.put(SMISIBMTSSVC_NodeToDBMapper.sGROUPID, new MapperInfo(IoGroup.getColumnInfo("GROUP_ID")));
        }
    }
}

