/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.sql.SqlHost;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SystemXmlToDBMapper
extends DBAttributeMapper {
    private static final String GUID = "GUID";
    private static final String HOSTNAME = "Hostname";
    private static final String IPADDRESS = "IP Address";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "SystemXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SystemXmlToDBMapper() {
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml".toLowerCase(), ":", 2);
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        MapperResult mr = new MapperResult();
        this.m_dataConverter.performDataConversion(htValues);
        String guid = (String)htValues.get("UniqueIdXml");
        if (guid == null) {
            guid = (String)htValues.get(GUID);
        }
        if (guid != null && guid.indexOf(46) >= 0) {
            try {
                GUID guidO = new GUID(guid);
                guid = guidO.toNoDotString();
            }
            catch (Exception exp) {
                guid = null;
            }
        }
        String hostname = (String)htValues.get(HOSTNAME);
        String ip = (String)htValues.get(IPADDRESS);
        if (guid == null && hostname == null && ip == null) {
            throw new SQLException("SystemXml mapper requires at least one of the following attributes: Hostname, IP Address, and GUID (or UniqueIdXml.");
        }
        String whereStmt = "";
        whereStmt = guid != null ? (hostname != null ? (ip != null ? " where GUID = '" + guid + "' OR HOST_NAME = '" + hostname + "' OR IP_ADDRESS = '" + ip + "'" : " where GUID = '" + guid + "' OR HOST_NAME = '" + hostname + "'") : (ip != null ? " where GUID = '" + guid + "' OR IP_ADDRESS = '" + ip + "'" : " where GUID = '" + guid + "'")) : (hostname != null ? (ip != null ? " where HOST_NAME = '" + hostname + "' OR IP_ADDRESS = '" + ip + "'" : " where HOST_NAME = '" + hostname + "'") : " where IP_ADDRESS = '" + ip + "'");
        if (hostname == null) {
            hostname = "";
        }
        if (ip == null) {
            ip = "";
        }
        if (guid == null) {
            guid = "";
        }
        Vector<ColumnInfo> v1 = new Vector<ColumnInfo>();
        Vector<Object> v2 = new Vector<Object>();
        Hashtable<ColumnInfo, Object> values = new Hashtable<ColumnInfo, Object>();
        Host host = new Host();
        host.setDetectable((short)1);
        values.put(Host.getColumnInfo("DETECTABLE"), "1");
        v1.add(Host.getColumnInfo("DETECTABLE"));
        v2.add("1");
        Timestamp time = CurrentTime.getTimestamp(conn);
        host.setUpdateTimestamp(time);
        ColumnInfo c = Host.getColumnInfo("UPDATE_TIMESTAMP");
        values.put(c, time);
        v1.add(c);
        v2.add(time);
        host.setGuid(guid);
        values.put(Host.getColumnInfo(GUID), guid);
        v1.add(Host.getColumnInfo(GUID));
        v2.add(guid);
        host.setHostName(hostname);
        values.put(Host.getColumnInfo("HOST_NAME"), hostname);
        v1.add(Host.getColumnInfo("HOST_NAME"));
        v2.add(hostname);
        host.setIpAddress(ip);
        values.put(Host.getColumnInfo("IP_ADDRESS"), ip);
        v1.add(Host.getColumnInfo("IP_ADDRESS"));
        v2.add(ip);
        Hashtable params = ComplexQuery.generateHashtable(v1, v2);
        int rowsEffected = 0;
        rowsEffected = SqlHost.sqlUpdate(conn, 0, whereStmt, params);
        int autoId = -1;
        Hashtable<ColumnInfo, String> autoIDHash = new Hashtable<ColumnInfo, String>();
        if (rowsEffected == 0) {
            host.setDiscoveredTime(time);
            values.put(Host.getColumnInfo("DISCOVERED_TIME"), time);
            autoId = AutoIdentifier.getIdentifier(1, 1);
            host.setComputerId(autoId);
            values.put(Host.getColumnInfo("COMPUTER_ID"), String.valueOf(autoId));
            boolean insert = host.insert(conn, values);
            if (insert) {
                mr.addInsertedRow(Host.getTablename(), values);
            }
        } else {
            mr.addUpdatedRow(Host.getTablename(), values);
            try {
                DBResultSet rs = SqlHost.sqlQuery(conn, 1, whereStmt, null);
                rs.next();
                autoId = rs.getShort("COMPUTER_ID");
                rs.close();
            }
            catch (Exception e) {
                this.logException(this.myClassname, methodName, e, "Attempt to retrieve auto-generated COMPUTER_ID value from T_RES_HOST failed.");
            }
        }
        conn.commit();
        autoIDHash.put(Host.getColumnInfo("COMPUTER_ID"), String.valueOf(autoId));
        try {
            DetectabilityService.tableUpdated(scanID, Host.getTablename(), autoIDHash);
        }
        catch (Exception e) {
            this.logException(this.myClassname, methodName, e, "Call to detectability layer's tableUpdated function produced following exception.  Will attempt to continue.");
        }
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }
}

