/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Zone;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class ZoneXmlToDBMapper
extends DBAttributeMapper {
    private static final String ZONETYPE = "Zone Type";
    private static final String ZONEVENDORTYPE = "Zone Vendor Type";
    private static final String ZONEVENDORSUBTYPE = "Zone Vendor Subtype";
    private static final String SANWWN = "SanWWN";
    private static final String ZSET = "ZSet";
    private static final String NAME = "Name";
    private static final String ZONEACTIVE = "Zone Active";
    private static final String ZONEDESCRIPTION = "Zone Description";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "ZoneXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public ZoneXmlToDBMapper() {
        this.m_dataConverter.addSimpleDataConversion(ZONETYPE.toLowerCase(), "Zone_Type");
        this.m_dataConverter.addSimpleDataConversion(ZONEVENDORTYPE.toLowerCase(), "Zone_Vendor_Type");
        this.m_dataConverter.addSimpleDataConversion(ZONEVENDORSUBTYPE.toLowerCase(), "Zone_Vendor_Sub_Type");
        this.m_dataConverter.addComplexDataConversion(SANWWN.toLowerCase(), ":", 2);
        this.m_dataConverter.addComplexDataConversion(ZSET.toLowerCase(), ":", 3);
        this.m_dataConverter.addComplexDataConversion(NAME.toLowerCase(), ":", 4);
        this.m_dataConverter.addComplexDataConversion(ZONEACTIVE.toLowerCase(), ":", 5);
        ColumnInfo zonename = Zone.getColumnInfo("ZONE_NAME");
        zonename.setIsPrimaryKey();
        MapperInfo zonenameMapperInfo = new MapperInfo(zonename);
        ColumnInfo zoneIdInfo = Zone.getColumnInfo("ZONE_ID");
        zoneIdInfo.setAutoGenerated();
        zonenameMapperInfo.setDerivedColumn(zoneIdInfo);
        this.m_htAttribToMapperInfo.put(NAME.toLowerCase(), zonenameMapperInfo);
        this.m_htAttribToMapperInfo.put(ZONETYPE.toLowerCase(), new MapperInfo(Zone.getColumnInfo("ZONE_TYPE")));
        this.m_htAttribToMapperInfo.put(SANWWN.toLowerCase(), new MapperInfo(Zone.getColumnInfo("FABRIC_WWN")));
        this.m_htAttribToMapperInfo.put(ZONEACTIVE.toLowerCase(), new MapperInfo(Zone.getColumnInfo("ACTIVE")));
        this.m_htAttribToMapperInfo.put(ZONEDESCRIPTION.toLowerCase(), new MapperInfo(Zone.getColumnInfo("DESCRIPTION")));
        this.m_htAttribToMapperInfo.put(ZONEVENDORTYPE.toLowerCase(), new MapperInfo(Zone.getColumnInfo("VENDOR_TYPE")));
        this.m_htAttribToMapperInfo.put(ZONEVENDORSUBTYPE.toLowerCase(), new MapperInfo(Zone.getColumnInfo("VENDOR_SUBTYPE")));
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        MapperResult mr = null;
        String uniqueXML = (String)htValues.get("UniqueIdXml");
        if (uniqueXML != null) {
            htValues.put(SANWWN.toLowerCase(), uniqueXML);
            htValues.put(ZSET.toLowerCase(), uniqueXML);
            htValues.put(NAME.toLowerCase(), uniqueXML);
            htValues.put(ZONEACTIVE.toLowerCase(), uniqueXML);
            mr = super.persist(conn, htValues, scanID);
        }
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }
}

