/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.logging;

import com.ibm.log.Level;
import com.ibm.log.LogEventProducer;
import com.ibm.log.PDLogger;
import com.ibm.log.mgr.DataStore;
import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.LogManager;
import com.ibm.log.mgr.PropertyFileDataStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.constants.RequestType;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class TraceLoggerFactory {
    public static Map<String, Integer> servicesFlags = new HashMap<String, Integer>();
    public static Map<String, PDLogger> loggers = new HashMap<String, PDLogger>();
    public static LogManager mgr;
    private static String agentMachine;
    private static final String SEP1 = " ";
    private static final String SEP2 = " | ";
    private static final String SEP3 = ", rc=";

    public static void initializeTraceLogger(String traceConfigFile, String traceFile) {
        TraceLoggerFactory.initializeTraceLogger(traceConfigFile, traceFile, null);
    }

    public static void initializeTraceLogger(String traceConfigFile, String traceFile, String auditFile) {
        TraceLoggerFactory.disableTraceFlag();
        Iterator serviceCodeIt = RequestType.getValues().iterator();
        while (serviceCodeIt.hasNext()) {
            servicesFlags.put((String)serviceCodeIt.next(), 0);
        }
        PropertyFileDataStore pfds = null;
        try {
            pfds = new PropertyFileDataStore(traceConfigFile);
            DataStoreConfig cfg = pfds.getConfig("ITSRM.handler.file");
            cfg.setProperty("fileName", traceFile);
            pfds.updateConfig(cfg);
            if (auditFile != null) {
                cfg = pfds.getConfig("ITSRMaudit.handler.file");
                cfg.setProperty("fileName", auditFile);
                pfds.updateConfig(cfg);
            }
            mgr = LogManager.getManagerWithMergedDataStore((DataStore)pfds, (boolean)false);
        }
        catch (Exception e) {
            MessageLog.logException("GEN2014E", e);
        }
    }

    public static void startLogger(String loggerName, String requestTypeCode) {
        if (mgr != null) {
            try {
                loggers.put(requestTypeCode, (PDLogger)mgr.getLogger(loggerName));
            }
            catch (Exception e) {
                mgr = null;
                TraceLoggerFactory.disableTraceFlag();
                MessageLog.logException("GEN2019E", e, loggerName);
            }
            if (loggers.get(requestTypeCode) != null) {
                if (loggers.get(requestTypeCode).isLogging()) {
                    Level lvl = loggers.get(requestTypeCode).getLevel();
                    servicesFlags.put(requestTypeCode, lvl.getValue());
                    TraceLoggerFactory.enableTraceFlag();
                }
                if (requestTypeCode.equals("org.eclipse.aperi.common.svp.AuditSvp")) {
                    TraceLoggerFactory.enableAuditFlag();
                }
                loggers.get(requestTypeCode).text(Level.DEBUG_MIN, (Object)"TraceLogger", "startLogger", loggerName + " started.");
            }
        } else {
            MessageLog.logMessage("GEN2015E", loggerName);
        }
    }

    public static void stopLogger(String requestTypeCode) {
        if (mgr != null) {
            if (loggers.get(requestTypeCode) != null) {
                mgr.returnLogger((LogEventProducer)loggers.get(requestTypeCode));
            }
            loggers.put(requestTypeCode, null);
            servicesFlags.put(requestTypeCode, 0);
            int k = 0;
            Iterator serviceCodeIt = RequestType.getValues().iterator();
            while (serviceCodeIt.hasNext()) {
                k += servicesFlags.get(serviceCodeIt.next()).intValue();
            }
            if (k > 0) {
                TraceLoggerFactory.enableTraceFlag();
            } else {
                TraceLoggerFactory.disableTraceFlag();
            }
            if (requestTypeCode == "org.eclipse.aperi.common.svp.AuditSvp") {
                TraceLoggerFactory.disableAuditFlag();
            }
        }
    }

    public static void setTraceConfig(HashMap traceConfig, String requestTypeCode) throws LocalizableException {
        Boolean loggingFlag = (Boolean)traceConfig.get("enableFlag");
        String logLevel = (String)traceConfig.get("level");
        String maxFiles = (String)traceConfig.get("maxFiles");
        String maxFileSize = (String)traceConfig.get("maxFileSize");
        int mfs = Integer.parseInt(maxFileSize) / 1000;
        maxFileSize = Integer.toString(mfs);
        if (mgr == null) {
            String errMsg = MessageLog.getMessage("GEN2016E");
            throw new LocalizableException(errMsg, null);
        }
        DataStore ds = mgr.getDataStore();
        DataStoreConfig cfg = ds.getConfig("ITSRM.handler.file");
        cfg.setProperty("maxFiles", maxFiles);
        cfg.setProperty("maxFileSize", maxFileSize);
        if (requestTypeCode.equals("org.eclipse.aperi.server.svp.ServerSvp")) {
            cfg = ds.getConfig("ITSRM.logger.trace.Server");
            cfg.setProperty("logging", loggingFlag.toString());
            cfg.setProperty("level", logLevel);
        } else if (requestTypeCode.equals("org.eclipse.aperi.agent.svp.AgentSvp")) {
            cfg = ds.getConfig("ITSRM.logger.trace.Agent");
            cfg.setProperty("logging", loggingFlag.toString());
            cfg.setProperty("level", logLevel);
        } else if (requestTypeCode.equals("org.eclipse.aperi.server.svp.SchedulerSvp")) {
            cfg = ds.getConfig("ITSRM.logger.trace.Scheduler");
            cfg.setProperty("logging", loggingFlag.toString());
            cfg.setProperty("level", logLevel);
        } else if (requestTypeCode.equals("org.eclipse.aperi.server.svp.AgentSvp")) {
            cfg = ds.getConfig("ITSRM.logger.trace.TivoliSRM-Agent");
            cfg.setProperty("logging", loggingFlag.toString());
            cfg.setProperty("level", logLevel);
        } else if (requestTypeCode.equals("org.eclipse.aperi.server.svp.GuiSvp")) {
            cfg = ds.getConfig("ITSRM.logger.trace.TivoliSRM-GUI");
            cfg.setProperty("logging", loggingFlag.toString());
            cfg.setProperty("level", logLevel);
        } else if (requestTypeCode.equals("org.eclipse.aperi.server.svp.CimomSvp")) {
            cfg = ds.getConfig("ITSRM.logger.trace.TivoliSRM-CIMOM");
            cfg.setProperty("logging", loggingFlag.toString());
            cfg.setProperty("level", logLevel);
        }
        if (loggingFlag.booleanValue()) {
            Level lvl = Level.getLevel((String)logLevel);
            TraceLoggerFactory.enableTraceFlag();
            servicesFlags.put(requestTypeCode, lvl.getValue());
        } else {
            servicesFlags.put(requestTypeCode, 0);
            int k = 0;
            Iterator serviceCodeIt = RequestType.getValues().iterator();
            while (serviceCodeIt.hasNext()) {
                k += servicesFlags.get(serviceCodeIt.next()).intValue();
            }
            if (k > 0) {
                TraceLoggerFactory.enableTraceFlag();
            } else {
                TraceLoggerFactory.disableTraceFlag();
            }
        }
        try {
            ds.updateConfig(cfg);
            ds.saveConfig(false);
        }
        catch (Exception e) {
            String errMsg = MessageLog.getMessage("GEN2013E");
            throw new LocalizableException(errMsg, null);
        }
    }

    public static HashMap getTraceConfig(String requestTypeCode) throws LocalizableException {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (mgr == null) {
            String errMsg = MessageLog.getMessage("GEN2017E");
            throw new LocalizableException(errMsg, null);
        }
        DataStore ds = mgr.getDataStore();
        DataStoreConfig cfg = ds.getConfig("ITSRM.handler.file");
        String maxFiles = cfg.getProperty("maxFiles");
        int mfs = Integer.parseInt(cfg.getProperty("maxFileSize")) * 1000;
        String maxFileSize = Integer.toString(mfs);
        config.put("maxFiles", maxFiles);
        config.put("maxFileSize", maxFileSize);
        if (requestTypeCode.equals("org.eclipse.aperi.server.svp.ServerSvp")) {
            cfg = ds.getConfig("ITSRM.logger.trace.Server");
            String loggingFlag = cfg.getProperty("logging");
            String logLevel = cfg.getProperty("level");
            Boolean b = Boolean.valueOf(loggingFlag);
            config.put("enableFlag", b);
            config.put("level", logLevel);
        } else if (requestTypeCode.equals("org.eclipse.aperi.agent.svp.AgentSvp")) {
            cfg = ds.getConfig("ITSRM.logger.trace.Agent");
            String loggingFlag = cfg.getProperty("logging");
            String logLevel = cfg.getProperty("level");
            Boolean b = Boolean.valueOf(loggingFlag);
            config.put("enableFlag", b);
            config.put("level", logLevel);
        } else if (requestTypeCode.equals("org.eclipse.aperi.server.svp.SchedulerSvp")) {
            cfg = ds.getConfig("ITSRM.logger.trace.Scheduler");
            String loggingFlag = cfg.getProperty("logging");
            String logLevel = cfg.getProperty("level");
            Boolean b = Boolean.valueOf(loggingFlag);
            config.put("enableFlag", b);
            config.put("level", logLevel);
        } else if (requestTypeCode.equals("org.eclipse.aperi.server.svp.AgentSvp")) {
            cfg = ds.getConfig("ITSRM.logger.trace.TivoliSRM-Agent");
            String loggingFlag = cfg.getProperty("logging");
            String logLevel = cfg.getProperty("level");
            Boolean b = Boolean.valueOf(loggingFlag);
            config.put("enableFlag", b);
            config.put("level", logLevel);
        } else if (requestTypeCode.equals("org.eclipse.aperi.server.svp.GuiSvp")) {
            cfg = ds.getConfig("ITSRM.logger.trace.TivoliSRM-GUI");
            String loggingFlag = cfg.getProperty("logging");
            String logLevel = cfg.getProperty("level");
            Boolean b = Boolean.valueOf(loggingFlag);
            config.put("enableFlag", b);
            config.put("level", logLevel);
        } else if (requestTypeCode.equals("org.eclipse.aperi.server.svp.CimomSvp")) {
            cfg = ds.getConfig("ITSRM.logger.trace.TivoliSRM-CIMOM");
            String loggingFlag = cfg.getProperty("logging");
            String logLevel = cfg.getProperty("level");
            Boolean b = Boolean.valueOf(loggingFlag);
            config.put("enableFlag", b);
            config.put("level", logLevel);
        }
        return config;
    }

    public static void setAuditConfig(HashMap traceConfig, String requestTypeCode) throws LocalizableException {
        Boolean loggingFlag = (Boolean)traceConfig.get("enableFlag");
        String logLevel = (String)traceConfig.get("level");
        String maxFiles = (String)traceConfig.get("maxFiles");
        String maxFileSize = (String)traceConfig.get("maxFileSize");
        int mfs = Integer.parseInt(maxFileSize) / 1000;
        maxFileSize = Integer.toString(mfs);
        if (mgr == null) {
            String errMsg = MessageLog.getMessage("GEN2016E");
            throw new LocalizableException(errMsg, null);
        }
        DataStore ds = mgr.getDataStore();
        DataStoreConfig cfg = ds.getConfig("ITSRMaudit.handler.file");
        cfg.setProperty("maxFiles", maxFiles);
        cfg.setProperty("maxFileSize", maxFileSize);
        cfg = ds.getConfig("ITSRM.logger.audit");
        cfg.setProperty("logging", loggingFlag.toString());
        cfg.setProperty("level", logLevel);
        if (loggingFlag.booleanValue()) {
            Level lvl = Level.getLevel((String)logLevel);
            TraceLoggerFactory.enableTraceFlag();
            servicesFlags.put(requestTypeCode, lvl.getValue());
        } else {
            servicesFlags.put(requestTypeCode, 0);
            int k = 0;
            Iterator serviceCodeIt = RequestType.getValues().iterator();
            while (serviceCodeIt.hasNext()) {
                k += servicesFlags.get(serviceCodeIt.next()).intValue();
            }
            if (k > 0) {
                TraceLoggerFactory.enableTraceFlag();
            } else {
                TraceLoggerFactory.disableTraceFlag();
            }
        }
        try {
            ds.updateConfig(cfg);
            ds.saveConfig(false);
        }
        catch (Exception e) {
            String errMsg = MessageLog.getMessage("GEN2013E");
            throw new LocalizableException(errMsg, null);
        }
    }

    public static HashMap getAuditConfig(String requestTypeCode) throws LocalizableException {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (mgr == null) {
            String errMsg = MessageLog.getMessage("GEN2017E");
            throw new LocalizableException(errMsg, null);
        }
        DataStore ds = mgr.getDataStore();
        DataStoreConfig cfg = ds.getConfig("ITSRMaudit.handler.file");
        String maxFiles = cfg.getProperty("maxFiles");
        int mfs = Integer.parseInt(cfg.getProperty("maxFileSize")) * 1000;
        String maxFileSize = Integer.toString(mfs);
        config.put("maxFiles", maxFiles);
        config.put("maxFileSize", maxFileSize);
        cfg = ds.getConfig("ITSRM.logger.audit");
        String loggingFlag = cfg.getProperty("logging");
        String logLevel = cfg.getProperty("level");
        Boolean b = Boolean.valueOf(loggingFlag);
        config.put("enableFlag", b);
        config.put("level", logLevel);
        return config;
    }

    public static void entry(String className, String method, String args) {
        String serviceID = TSThread.getServiceID();
        if (loggers.get(serviceID) == null) {
            return;
        }
        if (servicesFlags.get(serviceID) > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(SEP1);
            sb.append(method);
            sb.append("(");
            sb.append(args);
            sb.append(")");
            sb.append("  --");
            sb.append(RequestTypeManager.getInternalName(serviceID));
            if (loggers.get(serviceID) != null) {
                loggers.get(serviceID).entry(Level.DEBUG_MAX, (Object)className, sb.toString());
            }
        }
    }

    public static void exit(String className, String method) {
        String serviceID = TSThread.getServiceID();
        if (loggers.get(serviceID) == null) {
            return;
        }
        if (servicesFlags.get(serviceID) > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(SEP1);
            sb.append(method);
            sb.append("  --");
            sb.append(RequestTypeManager.getInternalName(serviceID));
            if (loggers.get(serviceID) != null) {
                loggers.get(serviceID).exit(Level.DEBUG_MAX, (Object)className, sb.toString());
            }
        }
    }

    public static void exit(String className, String method, Object returnVal) {
        String serviceID = TSThread.getServiceID();
        if (loggers.get(serviceID) == null) {
            return;
        }
        if (servicesFlags.get(serviceID) > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(SEP1);
            sb.append(method);
            sb.append(SEP3);
            sb.append(returnVal);
            sb.append("  --");
            sb.append(RequestTypeManager.getInternalName(serviceID));
            if (loggers.get(serviceID) != null) {
                loggers.get(serviceID).exit(Level.DEBUG_MAX, (Object)className, sb.toString());
            }
        }
    }

    public static void exit(String className, String method, boolean returnVal) {
        TraceLoggerFactory.exit(className, method, new Boolean(returnVal));
    }

    public static void exit(String className, String method, int returnVal) {
        TraceLoggerFactory.exit(className, method, Integer.toString(returnVal));
    }

    public static void exit(String className, String method, short returnVal) {
        TraceLoggerFactory.exit(className, method, Integer.toString(returnVal));
    }

    public static void exit(String className, String method, char returnVal) {
        TraceLoggerFactory.exit(className, method, Integer.toString(returnVal));
    }

    public static void exit(String className, String method, byte returnVal) {
        TraceLoggerFactory.exit(className, method, Integer.toString(returnVal));
    }

    public static void exit(String className, String method, long returnVal) {
        TraceLoggerFactory.exit(className, method, Integer.toString((int)returnVal));
    }

    public static void exception(String className, String method, Throwable e) {
        String serviceID = TSThread.getServiceID();
        if (loggers.get(serviceID) == null) {
            return;
        }
        if (servicesFlags.get(serviceID) > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("EXCEPTION ");
            if (loggers.get(serviceID) != null) {
                loggers.get(serviceID).exception(Level.DEBUG_MIN, (Object)className, method, e, sb.toString());
            }
        }
    }

    public static void traceMessage(int debugLevel, String className, String method, String msg) {
        String serviceID = TSThread.getServiceID();
        if (loggers.get(serviceID) == null) {
            return;
        }
        if (servicesFlags.get(serviceID) > 0) {
            Level levelValue = Level.DEBUG_MAX;
            switch (debugLevel) {
                case 1: {
                    levelValue = Level.DEBUG_MIN;
                    break;
                }
                case 2: {
                    levelValue = Level.DEBUG_MID;
                    break;
                }
                case 3: {
                    levelValue = Level.DEBUG_MAX;
                }
            }
            PDLogger pdlogger = loggers.get(serviceID);
            if (pdlogger != null) {
                StringBuffer requestCode = new StringBuffer();
                requestCode.append(method);
                requestCode.append("  --");
                requestCode.append(RequestTypeManager.getInternalName(serviceID));
                pdlogger.text(levelValue, (Object)className, requestCode.toString(), msg);
            }
        }
    }

    private static synchronized void enableTraceFlag() {
        TraceLogger.enableTrace = true;
    }

    private static synchronized void disableTraceFlag() {
        TraceLogger.enableTrace = false;
    }

    private static synchronized void enableAuditFlag() {
        TraceLogger.enableAudit = true;
    }

    private static synchronized void disableAuditFlag() {
        TraceLogger.enableAudit = false;
    }

    public static void auditMessage(String className, String method, String msg) {
        Level levelValue = Level.DEBUG_MAX;
        loggers.get("org.eclipse.aperi.common.svp.AuditSvp").text(levelValue, (Object)className, method, msg);
    }

    static {
        agentMachine = null;
    }
}

