/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.cmdline;

import org.eclipse.aperi.sanmgmt.cmdline.Column;

public class ColumnManager {
    private static final boolean DEBUG = false;
    private static ColumnManager cm;
    private static final int INITIAL_CAPACITY = 8;
    private static final int CAPACITY_INCREMENT = 4;
    Column[] columns;
    boolean[] inUse;
    int size = 0;

    private ColumnManager(int initSize) {
        this.columns = new Column[initSize];
        this.inUse = new boolean[initSize];
        for (int i = 0; i < initSize; ++i) {
            this.columns[i] = new Column();
            this.inUse[i] = false;
        }
    }

    public static synchronized ColumnManager getManager() {
        if (cm == null) {
            cm = new ColumnManager(8);
        }
        return cm;
    }

    public synchronized Column getColumn() {
        for (int i = 0; i < this.inUse.length; ++i) {
            if (this.inUse[i]) continue;
            this.inUse[i] = true;
            ++this.size;
            return this.columns[i];
        }
        Column[] old_c = this.columns;
        boolean[] old_b = this.inUse;
        this.columns = new Column[old_c.length + 4];
        this.inUse = new boolean[old_b.length + 4];
        System.arraycopy(old_c, 0, this.columns, 0, old_c.length);
        System.arraycopy(old_b, 0, this.inUse, 0, old_b.length);
        for (int i = old_c.length; i < this.columns.length; ++i) {
            this.columns[i] = new Column();
            this.inUse[i] = false;
        }
        this.inUse[old_c.length] = true;
        ++this.size;
        return this.columns[old_c.length];
    }

    public synchronized void returnColumn(Column c) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] != c) continue;
            this.inUse[i] = false;
            --this.size;
            this.columns[i].resetColumn();
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getCapacity() {
        return this.columns.length;
    }
}

