/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.dbconnparms;

import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.aperi.common.ReqHandler;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.objects.ConfigData;
import org.eclipse.aperi.infrastructure.database.objects.Server;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketRegistry;
import org.eclipse.aperi.sanmgmt.dbconnparms.ConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.SRMServerInfo;

public class DBAccess {
    private static ILogger traceLogger = null;
    private static ILogger messageLogger = null;

    public DBAccess() {
        traceLogger = ConfigService.traceLogger;
        messageLogger = ConfigService.messageLogger;
    }

    public void closeDS() {
        block2: {
            String method = "closeDS";
            try {
                DBConnPoolDataSource.closeInstance();
            }
            catch (SQLException e) {
                messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "closeDS", e);
                if (!traceLogger.isLogging()) break block2;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "closeDS", e);
            }
        }
    }

    private DBConnection connectToDB() throws SQLException {
        String methodName = "connectDB";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, methodName, "entered");
        }
        DBConnection dbc = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, methodName, "exited");
        }
        return dbc;
    }

    private void closeDBConn(DBConnection dbc) {
        block3: {
            if (dbc != null) {
                try {
                    dbc.close();
                }
                catch (SQLException e) {
                    messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "closeDBConn", e);
                    if (!traceLogger.isLogging()) break block3;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "closeDBConn", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(String context, Properties p) {
        String methodName = "getProperties";
        if (p == null) {
            p = new Properties();
        }
        Hashtable<ColumnInfo, String> htWhere = new Hashtable<ColumnInfo, String>();
        if (context == null || context.trim().length() == 0) {
            htWhere = null;
        } else {
            htWhere.put(ConfigData.getColumnInfo("CONTEXT"), context);
        }
        DBConnection dbc = null;
        DBCursor cdc = null;
        try {
            dbc = this.connectToDB();
            cdc = ConfigData.getCursor(dbc, htWhere, null);
            while (cdc.next()) {
                ConfigData cd = ((ConfigData.ConfigDataCursor)cdc).getAttributes();
                p.put(cd.getAttribute(), cd.getValue());
            }
        }
        catch (SQLException e) {
            messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "getProperties", e);
        }
        finally {
            if (cdc != null) {
                try {
                    cdc.close();
                }
                catch (SQLException ignore) {}
            }
            this.closeDBConn(dbc);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readDB(String key) {
        String methodName = "readDB";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, methodName, "entered");
        }
        String value = null;
        DBConnection dbc = null;
        try {
            dbc = this.connectToDB();
            ConfigData cd = new ConfigData();
            cd.setAttribute(key);
            cd.retrieve(dbc);
            value = cd.getValue();
        }
        catch (SQLException e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, methodName, e);
            }
        }
        finally {
            this.closeDBConn(dbc);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, methodName, "exited");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDB(String key, String value, String context) throws SQLException {
        String methodName = "updateDB";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, methodName, "entered");
        }
        DBConnection dbc = null;
        try {
            dbc = this.connectToDB();
            boolean inserted = false;
            ConfigData cd = new ConfigData();
            cd.setAttribute(key);
            cd.setValue(value);
            if (context != null && context.trim().length() > 0) {
                cd.setContext(context.trim());
            }
            try {
                inserted = cd.insert(dbc);
            }
            catch (SQLException e) {
                String st = e.getSQLState();
                if (st.equals("23505") || st.equals("23500") || st.equals("23L01") || st.equals("23L02")) {
                    if (traceLogger.isLogging()) {
                        String msg = "T_RES_CONFIG_DATA row already exist for key = " + key + "updaing value only!";
                        traceLogger.text(IRecordType.TYPE_WARNING, this, methodName, msg);
                    }
                    inserted = false;
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, methodName, e);
                }
                throw e;
            }
            if (!inserted) {
                cd.update(dbc);
            }
        }
        finally {
            this.closeDBConn(dbc);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, methodName, "exited");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDB(String key) throws SQLException {
        String methodName = "removeDB";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, methodName, "entered");
        }
        DBConnection dbc = null;
        try {
            dbc = this.connectToDB();
            ConfigData cd = new ConfigData();
            cd.setAttribute(key);
            cd.delete(dbc);
        }
        finally {
            this.closeDBConn(dbc);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, methodName, "exited");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncInstallPassword(String serverId, String password) {
        String methodName = "syncInstallPassword";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, methodName, "entered");
        }
        DBConnection dbc = null;
        try {
            int id = 0;
            try {
                id = Integer.parseInt(serverId);
            }
            catch (RuntimeException e1) {
                traceLogger.text(IRecordType.TYPE_WARNING, this, methodName, "The serverId, " + serverId + ", was not an integer; using 0 as default.");
            }
            Server server = new Server();
            server.setServerId(id);
            server.setPassword(password);
            dbc = this.connectToDB();
            server.update(dbc);
            dbc.commit();
            Hashtable<ColumnInfo, String> htWhere = new Hashtable<ColumnInfo, String>();
            htWhere.put(Server.getColumnInfo("SERVER_TYPE"), "0");
            Server.ServerCursor sc = Server.getCursor(dbc, htWhere, null);
            if (sc.next()) {
                Server svr = sc.getAttributes();
                String dataServer = svr.getServerName();
                int dataPort = svr.getPortNumber();
                this.notifyDataServer(dataServer, dataPort);
            }
            sc.close();
            this.closeDBConn(dbc);
        }
        catch (Exception e) {
            messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, methodName, e);
            }
        }
        finally {
            this.closeDBConn(dbc);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, methodName, "exited");
        }
    }

    private void notifyDataServer(String dataServerHost, int dataServerPort) throws UnknownHostException {
        Socket connection;
        String methodName = "notifyDataServer";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, methodName, "entered");
        }
        if ((connection = SocketRegistry.connect(dataServerHost, dataServerPort)) == null) {
            traceLogger.text(IRecordType.TYPE_WARN, this, methodName, "Data Server request to refresh failed! Data Server seems down!");
            return;
        }
        ReqHandler rh = new ReqHandler();
        Object transceiverObject = rh.getSocketTransceiverObject(connection, dataServerHost);
        Object requestObject = rh.getRequestObject();
        rh.setRequestTypeCode(requestObject, "org.eclipse.aperi.server.svp.ServerSvp");
        rh.setRequestServiceName(requestObject, RequestTypeManager.getInternalName("org.eclipse.aperi.server.svp.ServerSvp"));
        rh.setRequestSubType(requestObject, "org.eclipse.aperi.server.handler.server.DeviceServerRegHndlr");
        rh.setRequestMachineName(requestObject, dataServerHost);
        rh.setRequestFlags(requestObject, (byte)5);
        SRMServerInfo dsi = new SRMServerInfo();
        dsi.setType(SRMServerInfo.REFRESH);
        Request rObj = (Request)requestObject;
        rObj.requestData = dsi;
        Response responseObject = (Response)rh.transmitRequestObject(transceiverObject, requestObject, null);
        if (responseObject.status == 0) {
            traceLogger.text(IRecordType.TYPE_INFO, this, methodName, "DataServer request to refresh successful");
        } else {
            traceLogger.text(IRecordType.TYPE_WARN, this, methodName, "DataServer request to refresh failed");
        }
        rh.transceiverClose(transceiverObject);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, methodName, "exited");
        }
    }
}

