/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.logging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogFileHandler;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

class LogFileReader {
    static final String TRACE_NAME = "aperi.logger.trace.FabricManager";
    static final String MESSAGE_NAME = "aperi.logger.message.FabricManager";
    protected static ILogger msgLogger = null;
    protected static ILogger traceLogger = null;
    private static final String className = LogFileHandler.class.getName();
    public static byte FORWARD = 1;
    public static byte BACKWARDS = (byte)-1;
    private static byte DEFAULT_POS = (byte)-1;
    private static String NEW_LINE = System.getProperty("line.separator");
    static final char UNIX_FILE_SEPARATOR = '/';
    static final char WINDOWS_FILE_SEPARATOR = '\\';
    static final int NOT_FOUND = -1;
    private static long startFilePosition = 0L;
    protected static byte status = 1;
    private static long initialFilePosition = 0L;
    private static long filePosition = -1L;
    protected static int foundIndex;
    protected static int foundOffset;
    private static boolean eof;

    LogFileReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String[] readFile(String fileName) throws FileNotFoundException {
        String methodName = "readFile";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        ArrayList<String> dataArray = new ArrayList<String>();
        String[] fileArray = null;
        try {
            String str;
            String fileToRead = LogFileReader.getFileName(fileName);
            BufferedReader in = new BufferedReader(new FileReader(fileToRead));
            while ((str = in.readLine()) != null) {
                dataArray.add(str + NEW_LINE);
            }
            fileArray = new String[dataArray.size()];
            fileArray = dataArray.toArray(fileArray);
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
            }
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        return fileArray;
    }

    protected static String[] getDesiredString(String[] fileArray, byte direction, LogFilePos position, int linesDesired) {
        String methodName = "getDesiredString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        ArrayList<String> desiredOutput = new ArrayList<String>();
        long offset = position.offset;
        int size = fileArray.length;
        if (offset == (long)DEFAULT_POS) {
            if (direction == BACKWARDS) {
                int firstLine = 0;
                firstLine = linesDesired < size ? size - linesDesired : 0;
                for (int i = firstLine; i < size; ++i) {
                    desiredOutput.add(fileArray[i]);
                }
                position.offset = firstLine;
            } else {
                int lastLine = size;
                lastLine = linesDesired > size ? size : linesDesired;
                for (int i = 0; i < lastLine; ++i) {
                    desiredOutput.add(fileArray[i]);
                }
                position.offset = lastLine;
            }
        } else if (direction == BACKWARDS) {
            long firstLine = 0L;
            firstLine = (long)linesDesired > offset ? 0L : offset - (long)linesDesired;
            for (long i = firstLine; i < offset; ++i) {
                desiredOutput.add(fileArray[(int)i]);
            }
            position.offset = firstLine;
        } else {
            long lastLine = (long)linesDesired + offset;
            if (lastLine > (long)size) {
                lastLine = size;
            }
            for (long i = offset; i < lastLine; ++i) {
                desiredOutput.add(fileArray[(int)i]);
            }
            position.offset = lastLine;
        }
        String[] output = new String[desiredOutput.size()];
        output = desiredOutput.toArray(output);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return output;
    }

    protected static String[] getDesiredString(String[] fileArray, byte direction, LogFilePos position, String search, int linesDesired) {
        long lastLine;
        long firstLine;
        String methodName = "getDesiredString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        ArrayList<String> desiredOutput = new ArrayList<String>();
        long offset = position.offset;
        int size = fileArray.length;
        if (offset == (long)DEFAULT_POS) {
            if (direction == BACKWARDS) {
                firstLine = 0L;
                offset = LogFileReader.searchBackwards(fileArray, size - 1, search);
                firstLine = (long)linesDesired > offset ? 0L : offset - (long)linesDesired + 1L;
                for (long i = firstLine; i <= offset; ++i) {
                    desiredOutput.add(fileArray[(int)i]);
                }
                position.offset = firstLine;
            } else {
                offset = LogFileReader.searchForward(fileArray, 0, search);
                lastLine = (long)linesDesired + offset;
                long i = offset;
                long j = 0L;
                while (i < lastLine) {
                    desiredOutput.add(fileArray[(int)i]);
                    ++i;
                    ++j;
                }
                position.offset = lastLine;
            }
        } else if (direction == BACKWARDS) {
            firstLine = 0L;
            firstLine = (long)linesDesired > (offset = (long)LogFileReader.searchBackwards(fileArray, size - (int)offset, search)) ? 0L : offset - (long)linesDesired + 1L;
            for (long i = firstLine; i <= offset; ++i) {
                desiredOutput.add(fileArray[(int)i]);
            }
            System.out.println("Test - String was found at line " + offset);
            position.offset = firstLine;
        } else {
            offset = LogFileReader.searchForward(fileArray, (int)offset, search);
            lastLine = (long)linesDesired + offset;
            long i = offset;
            long j = 0L;
            while (i < lastLine) {
                desiredOutput.add(fileArray[(int)i]);
                ++i;
                ++j;
            }
            position.offset = lastLine;
        }
        String[] output = new String[desiredOutput.size()];
        output = desiredOutput.toArray(output);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return output;
    }

    protected static int searchForward(String[] fileArray, int startLine, String searchFor) {
        String methodName = "searchForward";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        int length = searchFor.length();
        int index = startLine;
        int pos = 0;
        boolean going = true;
        while (going && index < fileArray.length) {
            String target = fileArray[index];
            int maxPos = target.length() - length;
            pos = 0;
            while (going && pos <= maxPos) {
                if (target.regionMatches(true, pos, searchFor, 0, length)) {
                    going = false;
                    continue;
                }
                ++pos;
            }
            if (!going) continue;
            ++index;
        }
        if (going) {
            index = -1;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return index;
    }

    protected static int searchBackwards(String[] fileArray, int startLine, String searchFor) {
        String methodName = "searchBackwards";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        int length = searchFor.length();
        int index = startLine;
        int pos = 0;
        boolean going = true;
        while (going && index >= 0) {
            String target = fileArray[index];
            int maxPos = target.length() - length;
            pos = 0;
            if (target.toLowerCase().lastIndexOf(searchFor.toLowerCase()) != -1) {
                going = false;
            }
            while (going && pos >= maxPos) {
                if (target.regionMatches(true, pos, searchFor, 0, length)) {
                    going = false;
                    continue;
                }
                --pos;
            }
            if (!going) continue;
            --index;
        }
        if (going) {
            index = -1;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return index;
    }

    protected static String getFileName(String name) {
        String fileName = name;
        char fileSeparator = File.separatorChar;
        boolean appendPath = true;
        if (name.indexOf(47) != -1 || name.indexOf(92) != -1) {
            fileName = fileName.replace('/', fileSeparator);
            fileName = fileName.replace('\\', fileSeparator);
            appendPath = false;
        }
        if (appendPath) {
            String baseDir = Variables.getBaseDirectory();
            StringBuffer sb = new StringBuffer(baseDir);
            sb.append("log");
            sb.append(fileSeparator);
            sb.append(fileName);
            fileName = sb.toString();
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String[] readForward(String fileToRead, LogFilePos position, String search, int linesDesired) throws FileNotFoundException {
        String methodName = "readForward";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        filePosition = position.offset;
        ArrayList<String> dataArray = new ArrayList<String>();
        String[] fileArray = null;
        long charsSkipped = 0L;
        int desiredLines = linesDesired;
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(fileToRead));
            if (position.offset != (long)DEFAULT_POS) {
                charsSkipped = in.skip(position.offset);
            }
            startFilePosition = charsSkipped;
            if (search != null) {
                int index = -1;
                while ((str = in.readLine()) != null) {
                    index = str.toLowerCase().indexOf(search.toLowerCase());
                    if (index != -1) {
                        status = 0;
                        str = str.substring(index);
                        dataArray.add(str + NEW_LINE);
                        --desiredLines;
                        filePosition += (long)(str.length() + NEW_LINE.length());
                        break;
                    }
                    filePosition += (long)(str.length() + NEW_LINE.length());
                }
            }
            for (int i = 0; i < desiredLines && (str = in.readLine()) != null; ++i) {
                dataArray.add(str + NEW_LINE);
                filePosition += (long)(str.length() + NEW_LINE.length());
            }
            fileArray = new String[dataArray.size()];
            fileArray = dataArray.toArray(fileArray);
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
            }
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String[] readBackwards(String fileToRead, LogFilePos position, String search, int linesDesired) throws FileNotFoundException {
        String methodName = "readBackwards";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        filePosition = position.offset;
        ArrayList<String> dataArray = new ArrayList<String>();
        String[] fileArray = null;
        long size = 0L;
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(fileToRead));
            Object tempStr = null;
            while ((str = in.readLine()) != null) {
                str = str + NEW_LINE;
                if (dataArray.size() > linesDesired && search == null) {
                    dataArray.remove(0);
                }
                if (position.offset != (long)DEFAULT_POS && size + (long)str.length() >= position.offset) {
                    str = str.substring(0, (int)(position.offset - size));
                    dataArray.add(str);
                    size += (long)str.length();
                    break;
                }
                size += (long)str.length();
                dataArray.add(str);
            }
            if (dataArray.size() > linesDesired && search == null) {
                dataArray.remove(0);
            }
            if (search != null) {
                int index = -1;
                String lastString = null;
                int i = 0;
                for (i = dataArray.size() - 1; i >= 0; --i) {
                    lastString = (String)dataArray.get(i);
                    index = lastString.toLowerCase().lastIndexOf(search.toLowerCase());
                    if (index != -1) {
                        status = 0;
                        size -= (long)lastString.length();
                        lastString = lastString.substring(0, index + search.length());
                        size += (long)lastString.length();
                        dataArray.set(i, lastString);
                        break;
                    }
                    size -= (long)lastString.length();
                    dataArray.remove(i);
                }
                i -= linesDesired;
                while (i-- >= 0) {
                    dataArray.remove(0);
                }
            }
            fileArray = new String[dataArray.size()];
            fileArray = dataArray.toArray(fileArray);
            for (int i = 0; i < fileArray.length; ++i) {
                size -= (long)fileArray[i].length();
            }
            filePosition = size;
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
            }
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readForward(String fileToRead, LogFilePos position, int linesDesired) throws FileNotFoundException {
        String methodName = "readForward";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        filePosition = position.offset;
        ArrayList<String> dataArray = new ArrayList<String>();
        String[] fileArray = null;
        long charsSkipped = 0L;
        int desiredLines = linesDesired;
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileToRead));
            if (position.offset != (long)DEFAULT_POS) {
                charsSkipped = in.skip(position.offset);
            } else {
                filePosition = 0L;
            }
            initialFilePosition = charsSkipped;
            for (int i = 0; i < desiredLines; ++i) {
                String str = in.readLine();
                if (str == null) {
                    eof = true;
                    break;
                }
                dataArray.add(str + NEW_LINE);
                filePosition += (long)(str.length() + NEW_LINE.length());
            }
            fileArray = new String[dataArray.size()];
            fileArray = dataArray.toArray(fileArray);
            status = 0;
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            System.out.println("out of readFile");
        }
        return fileArray;
    }

    private static String[] searchForward(String fileToRead, LogFilePos position, String search, int linesDesired) throws FileNotFoundException {
        String methodName = "searchForward";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        int offset = -1;
        String[] desiredLines = null;
        eof = false;
        while (!eof) {
            desiredLines = LogFileReader.readForward(fileToRead, position, linesDesired);
            for (int i = 0; i < desiredLines.length; ++i) {
                offset = desiredLines[i].toLowerCase().indexOf(search.toLowerCase());
                if (offset == -1) continue;
                foundOffset = offset;
                foundIndex = i;
                break;
            }
            if (offset != -1) break;
            position.offset = filePosition;
        }
        if (offset == -1) {
            status = 1;
        }
        return desiredLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readBackwards(String fileToRead, LogFilePos position, int linesDesired) throws FileNotFoundException {
        String methodName = "readBackwards";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        filePosition = position.offset;
        ArrayList<String> dataArray = new ArrayList<String>();
        String[] fileArray = null;
        long size = 0L;
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(fileToRead));
            Object tempStr = null;
            while ((str = in.readLine()) != null) {
                str = str + NEW_LINE;
                if (dataArray.size() > linesDesired) {
                    initialFilePosition = size - (long)((String)dataArray.get(0)).length();
                    dataArray.remove(0);
                }
                if (position.offset != (long)DEFAULT_POS && size + (long)str.length() >= position.offset) {
                    str = str.substring(0, (int)(position.offset - size));
                    dataArray.add(str);
                    size += (long)str.length();
                    break;
                }
                size += (long)str.length();
                dataArray.add(str);
            }
            if (str == null) {
                eof = true;
            }
            if (dataArray.size() > linesDesired) {
                initialFilePosition = size - (long)((String)dataArray.get(0)).length();
                dataArray.remove(0);
            }
            fileArray = new String[dataArray.size()];
            fileArray = dataArray.toArray(fileArray);
            filePosition = size;
            for (int i = 0; i < fileArray.length; ++i) {
                size -= (long)fileArray[i].length();
            }
            initialFilePosition = size;
            status = 0;
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
            }
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        return fileArray;
    }

    private static String[] searchBackwards(String fileToRead, LogFilePos position, String search, int linesDesired) throws FileNotFoundException {
        String methodName = "searchBackwards";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        int offset = -1;
        String[] desiredLines = null;
        eof = false;
        try {
            while (!eof) {
                desiredLines = LogFileReader.readBackwards(fileToRead, position, linesDesired);
                for (int i = desiredLines.length - 1; i >= 0; --i) {
                    offset = desiredLines[i].toLowerCase().lastIndexOf(search.toLowerCase());
                    if (offset == -1) continue;
                    foundOffset = offset;
                    foundIndex = i;
                    break;
                }
                if (offset != -1) break;
                position.offset = filePosition;
            }
            if (offset == -1) {
                status = 1;
            }
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        return desiredLines;
    }

    protected static String[] read(String fileName, byte direction, LogFilePos position, String search, int linesDesired) throws FileNotFoundException {
        String methodName = "read";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        String[] desiredLines = new String[linesDesired];
        try {
            String name = LogFileReader.getFileName(fileName);
            if (search == null) {
                if (direction == FORWARD) {
                    desiredLines = LogFileReader.readForward(name, position, linesDesired);
                } else if (direction == BACKWARDS) {
                    desiredLines = LogFileReader.readBackwards(name, position, linesDesired);
                }
            } else if (direction == FORWARD) {
                desiredLines = LogFileReader.searchForward(name, position, search, linesDesired);
            } else if (direction == BACKWARDS) {
                desiredLines = LogFileReader.searchBackwards(name, position, search, linesDesired);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        return desiredLines;
    }

    protected static long getFilePosition() {
        return filePosition;
    }

    protected static long getInitialFilePosition() {
        return initialFilePosition;
    }

    static {
        eof = false;
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
    }
}

