/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.eclipse.aperi.sanmgmt.middleware.data.JavaObjectSerializer;

public class MappingRegistry
extends SOAPMappingRegistry {
    private static final String soapEncURI = "http://schemas.xmlsoap.org/soap/encoding/";
    private final JavaObjectSerializer jos = new JavaObjectSerializer();
    private static MappingRegistry instance = new MappingRegistry();

    public MappingRegistry() {
    }

    public MappingRegistry(SOAPMappingRegistry parent, String schemaURI) {
        super(parent, schemaURI);
    }

    public static MappingRegistry getInstance() {
        return instance;
    }

    private void mapJavaObject(Class javaType) {
        this.mapTypes(soapEncURI, new QName(javaType.getName(), "JavaObject"), javaType, this.jos, this.jos);
    }

    public QName queryElementType(Class javaType, String encodingStyleURI) throws IllegalArgumentException {
        try {
            return super.queryElementType(javaType, encodingStyleURI);
        }
        catch (IllegalArgumentException e) {
            if (javaType != null && encodingStyleURI != null && encodingStyleURI.equals(soapEncURI)) {
                this.mapJavaObject(javaType);
                return new QName(javaType.getName(), "JavaObject");
            }
            throw e;
        }
    }

    public Serializer querySerializer(Class javaType, String encodingStyleURI) throws IllegalArgumentException {
        try {
            return super.querySerializer(javaType, encodingStyleURI);
        }
        catch (IllegalArgumentException e) {
            if (javaType != null && encodingStyleURI != null && encodingStyleURI.equals(soapEncURI)) {
                this.mapJavaObject(javaType);
                return this.jos;
            }
            throw e;
        }
    }

    public Deserializer queryDeserializer(QName elementType, String encodingStyleURI) throws IllegalArgumentException {
        try {
            return super.queryDeserializer(elementType, encodingStyleURI);
        }
        catch (IllegalArgumentException e) {
            if (elementType != null && encodingStyleURI != null && encodingStyleURI.equals(soapEncURI)) {
                String javaTypeString = elementType.getNamespaceURI();
                Class javaType = Object.class;
                try {
                    javaType = Class.forName(javaTypeString);
                }
                catch (Exception e1) {
                    throw new IllegalArgumentException(e.toString());
                }
                this.mapJavaObject(javaType);
                return this.jos;
            }
            throw e;
        }
    }

    public Class queryJavaType(QName elementType, String encodingStyleURI) throws IllegalArgumentException {
        try {
            return super.queryJavaType(elementType, encodingStyleURI);
        }
        catch (IllegalArgumentException e) {
            if (elementType != null && encodingStyleURI != null && encodingStyleURI.equals(soapEncURI)) {
                String javaTypeString = elementType.getNamespaceURI();
                Class javaType = Object.class;
                try {
                    javaType = Class.forName(javaTypeString);
                }
                catch (Exception e1) {
                    throw new IllegalArgumentException(e.toString());
                }
                this.mapJavaObject(javaType);
                return javaType;
            }
            throw e;
        }
    }
}

