/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import org.eclipse.aperi.sanmgmt.middleware.data.SecurityContext;
import org.eclipse.aperi.sanmgmt.middleware.data.SoapClient;

public class SoapServiceProxy
extends SoapClient
implements InvocationHandler,
Serializable {
    public String hostUrl;
    public String service;
    private boolean isInitialized = false;

    public SoapServiceProxy(String host, int port, String serviceName, SecurityContext sc) throws Exception {
        super(host + ":" + port, serviceName, sc);
        this.hostUrl = host + ":" + port;
        this.service = serviceName;
    }

    public SoapServiceProxy(String hostUrl, String serviceName, SecurityContext sc) throws Exception {
        super(hostUrl, serviceName, sc);
        this.hostUrl = hostUrl;
        this.service = serviceName;
    }

    public static Object newInstance(String host, int port, String serviceName, Class c, SecurityContext sc) throws Exception {
        return SoapServiceProxy.newInstance(host + ":" + port, serviceName, c, sc);
    }

    public static Object newInstance(String hostUrl, String serviceName, Class c, SecurityContext sc) throws Exception {
        return Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)new SoapServiceProxy(hostUrl, serviceName, sc));
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        try {
            if (!this.isInitialized) {
                this.init(this.hostUrl, this.service);
                this.isInitialized = true;
            }
            this.setMethod(m, args);
            return this.invoke();
        }
        catch (UndeclaredThrowableException ute) {
            throw ute.getUndeclaredThrowable();
        }
    }
}

