/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;

public class Status
implements Serializable {
    public static final int BACKEDOFF = 0;
    public static final int CONFIGURED = 1;
    public static final int FAILED = 2;
    public static final int INIT = 3;
    public static final int INITIALIZED = 4;
    public static final int INSTALLED = 5;
    public static final int NONE = 6;
    public static final int NOT_INSTALLED = 7;
    public static final int RUNNING = 8;
    public static final int STARTING = 9;
    public static final int STOPPED = 10;
    public static final int STOPPING = 11;
    public static final int UPGRADED = 12;
    public static final int UPGRADEFAILED = 13;
    public static final String[] statusText = new String[]{"Backed Off", "Configured", "Failed", "Initializing", "Initialized", "Installed", "None", "Not Installed", "Running", "Starting", "Stopped", "Stopping", "Upgraded", "Upgrade Failed"};
    private Throwable error = null;
    private int installStatus = 6;
    private int runStatus = 6;

    public Status() {
    }

    public Status(int installStatus, int runStatus) {
        this.installStatus = installStatus;
        this.runStatus = runStatus;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable e) {
        this.error = e;
    }

    public int getInstallStatus() {
        return this.installStatus;
    }

    public void setInstallStatus(int status) {
        this.installStatus = status;
    }

    public String getInstallStatusAsText() {
        return statusText[this.installStatus];
    }

    public int getRunStatus() {
        return this.runStatus;
    }

    public void setRunStatus(int status) {
        this.runStatus = status;
    }

    public String getRunStatusAsText() {
        return statusText[this.runStatus];
    }

    public String getLocalizedStatusAsText(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("STATUS_" + statusText[this.runStatus]);
    }

    public String toString() {
        return "Install status: " + this.getInstallStatusAsText() + ", Run status: " + this.getRunStatusAsText();
    }

    public String toDisplayString() {
        return this.toString();
    }

    public static String toStatusText(int status) {
        return statusText[status];
    }
}

