/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.tsanm.zone.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone2ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone2ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias2ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet2Zone;

public class ZoneDefinition
implements Serializable,
Cloneable {
    static final long serialVersionUID = 7902029858130148138L;
    private String version = "5.0.0";
    protected ArrayList zonesets = new ArrayList();
    protected ArrayList zones = new ArrayList();
    protected ArrayList members = new ArrayList();
    protected ArrayList aliases = new ArrayList();
    protected ArrayList zoneset2zone = new ArrayList();
    protected ArrayList zone2member = new ArrayList();
    protected ArrayList zone2alias = new ArrayList();
    protected ArrayList alias2member = new ArrayList();
    private String activeZoneSet = null;
    private String lastActiveZoneSet = null;
    static final String className = ZoneDefinition.class.getName();

    public synchronized Object clone() {
        try {
            ZoneDefinition z = (ZoneDefinition)super.clone();
            z.zonesets = (ArrayList)this.zonesets.clone();
            z.zones = (ArrayList)this.zones.clone();
            z.members = (ArrayList)this.members.clone();
            z.aliases = (ArrayList)this.aliases.clone();
            z.zoneset2zone = (ArrayList)this.zoneset2zone.clone();
            z.zone2member = (ArrayList)this.zone2member.clone();
            z.zone2alias = (ArrayList)this.zone2alias.clone();
            z.alias2member = (ArrayList)this.alias2member.clone();
            return z;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        String zd = null;
        zd = new String();
        if (this.zonesets.size() > 0 || this.zones.size() > 0 || this.members.size() > 0 || this.aliases.size() > 0) {
            int i;
            zd = zd.concat("\n\n===========================================================");
            zd = zd.concat("\nZone Definition members:\n");
            zd = zd.concat("\n\tZoneSets:\n");
            ZoneSet[] zsArray = this.zonesets.toArray(new ZoneSet[0]);
            for (int i2 = 0; i2 < zsArray.length; ++i2) {
                zd = zd.concat("\t\t" + zsArray[i2].getName() + "\n");
            }
            zd = zd.concat("\n\tActive ZoneSet:\n");
            if (this.activeZoneSet != null) {
                zd = zd.concat("\t\t" + this.activeZoneSet + "\n");
            }
            zd = zd.concat("\n\tZones:\n");
            Zone[] zArray = this.zones.toArray(new Zone[0]);
            for (int i3 = 0; i3 < zArray.length; ++i3) {
                zd = zd.concat("\t\t" + zArray[i3].getName() + "; " + zArray[i3].getVendorType() + "\n");
                Enumeration e = zArray[i3].getParameterNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    zd = zd.concat("\t\t\tParameter: " + name + ", " + zArray[i3].getParameterValue(name) + "\n");
                }
            }
            zd = zd.concat("\n\tZoneAliases:\n");
            ZoneAlias[] zaArray = this.aliases.toArray(new ZoneAlias[0]);
            for (int i4 = 0; i4 < zaArray.length; ++i4) {
                zd = zd.concat("\t\t" + zaArray[i4].getName() + "\n");
            }
            zd = zd.concat("\n\tZoneMembers:\n");
            ZoneMember[] zmArray = this.members.toArray(new ZoneMember[0]);
            for (i = 0; i < zmArray.length; ++i) {
                zd = zd.concat("\t\t" + zmArray[i].getName() + "; " + zmArray[i].getType() + "\n");
            }
            zd = zd.concat("\n\nZone Definition relationships:\n");
            for (i = 0; i < zsArray.length; ++i) {
                String zs = zsArray[i].getName();
                zd = this.activeZoneSet != null && zs.equals(this.activeZoneSet) ? zd.concat("\n\tActive ZoneSet: " + zs + "\n") : zd.concat("\n\tZoneSet: " + zs + "\n");
                ZoneSet2Zone[] zs2zArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
                for (int j = 0; j < zs2zArray.length; ++j) {
                    if (!zs2zArray[j].getZoneSetName().equals(zsArray[i].getName())) continue;
                    zd = zd.concat("\t\tZone: " + zs2zArray[j].getZoneName() + "; " + zs2zArray[j].getZoneVendorType() + "\n");
                    Zone thisZone = this.getZone(zs2zArray[j].getZoneName(), zs2zArray[j].getZoneVendorType());
                    Enumeration e = thisZone.getParameterNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        zd = zd.concat("\t\t\tParameter: " + name + ", " + thisZone.getParameterValue(name) + "\n");
                    }
                    Zone2ZoneAlias[] z2zaArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
                    for (int k = 0; k < z2zaArray.length; ++k) {
                        if (!z2zaArray[k].getZoneName().equals(zs2zArray[j].getZoneName())) continue;
                        zd = zd.concat("\t\t\tZoneAlias: " + z2zaArray[k].getZoneAliasName() + "\n");
                        ZoneAlias2ZoneMember[] za2zmArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
                        for (int l = 0; l < za2zmArray.length; ++l) {
                            if (!za2zmArray[l].getZoneAliasName().equals(z2zaArray[k].getZoneAliasName())) continue;
                            ZoneMember tempMem = this.getZoneMember(za2zmArray[l].getZoneMemberName(), za2zmArray[l].getZoneMemberType());
                            zd = zd.concat("\t\t\t\tZoneMember: " + tempMem.getName() + "; " + tempMem.getType() + "\n");
                        }
                    }
                    Zone2ZoneMember[] z2zmArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
                    for (int k = 0; k < z2zmArray.length; ++k) {
                        if (!z2zmArray[k].getZoneName().equals(zs2zArray[j].getZoneName())) continue;
                        ZoneMember tempMem = this.getZoneMember(z2zmArray[k].getZoneMemberName(), z2zmArray[k].getZoneMemberType());
                        zd = zd.concat("\t\t\tZoneMember: " + tempMem.getName() + "; " + tempMem.getType() + "\n");
                    }
                }
            }
            for (i = 0; i < zArray.length; ++i) {
                if (!this.isOrphaned(zArray[i]) || this.isEmpty(zArray[i])) continue;
                zd = zd.concat("\n\tZone: " + zArray[i].getName() + "; " + zArray[i].getVendorType() + "\n");
                Enumeration e = zArray[i].getParameterNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    zd = zd.concat("\t\tParameter: " + name + ", " + zArray[i].getParameterValue(name) + "\n");
                }
                Zone2ZoneAlias[] z2zaArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
                for (int k = 0; k < z2zaArray.length; ++k) {
                    if (!z2zaArray[k].getZoneName().equals(zArray[i].getName())) continue;
                    zd = zd.concat("\t\tZoneAlias: " + z2zaArray[k].getZoneAliasName() + "\n");
                    ZoneAlias2ZoneMember[] za2zmArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
                    for (int l = 0; l < za2zmArray.length; ++l) {
                        if (!za2zmArray[l].getZoneAliasName().equals(z2zaArray[k].getZoneAliasName())) continue;
                        ZoneMember tempMem = this.getZoneMember(za2zmArray[l].getZoneMemberName(), za2zmArray[l].getZoneMemberType());
                        zd = zd.concat("\t\t\tZoneMember: " + tempMem.getName() + "; " + tempMem.getType() + "\n");
                    }
                }
                Zone2ZoneMember[] z2zmArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
                for (int k = 0; k < z2zmArray.length; ++k) {
                    if (!z2zmArray[k].getZoneName().equals(zArray[i].getName())) continue;
                    ZoneMember tempMem = this.getZoneMember(z2zmArray[k].getZoneMemberName(), z2zmArray[k].getZoneMemberType());
                    zd = zd.concat("\t\tZoneMember: " + tempMem.getName() + "; " + tempMem.getType() + "\n");
                }
            }
            for (i = 0; i < zaArray.length; ++i) {
                if (!this.isOrphaned(zaArray[i]) || this.isEmpty(zaArray[i])) continue;
                zd = zd.concat("\n\tZoneAlias: " + zaArray[i].getName() + "\n");
                ZoneAlias2ZoneMember[] za2zmArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
                for (int l = 0; l < za2zmArray.length; ++l) {
                    if (!za2zmArray[l].getZoneAliasName().equals(zaArray[i].getName())) continue;
                    ZoneMember tempMem = this.getZoneMember(za2zmArray[l].getZoneMemberName(), za2zmArray[l].getZoneMemberType());
                    zd = zd.concat("\t\tZoneMember: " + tempMem.getName() + "; " + tempMem.getType() + "\n");
                }
            }
            zd = zd.concat("===========================================================\n\n");
        } else {
            zd = zd.concat("\nNothing present in the Zone Definition\n");
        }
        return zd;
    }

    public void addZoneSets(ZoneSet[] zonesets) {
        for (int i = 0; i < zonesets.length; ++i) {
            this.addZoneSet(zonesets[i]);
        }
    }

    public void addZoneSet(ZoneSet zoneset) {
        if (zoneset != null && !this.zonesets.contains(zoneset)) {
            this.zonesets.add(zoneset);
            if (this.activeZoneSet == null && this.lastActiveZoneSet != null && this.lastActiveZoneSet.equals(zoneset.getName())) {
                this.activeZoneSet = zoneset.getName();
                this.lastActiveZoneSet = null;
            }
        }
    }

    public ZoneSet[] getZoneSets() {
        return this.zonesets.toArray(new ZoneSet[0]);
    }

    public ZoneSet[] getZoneSets(Zone zone) {
        ArrayList<ZoneSet> zonesets = new ArrayList<ZoneSet>();
        if (zone != null) {
            ZoneSet2Zone[] zs2zArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            for (int i = 0; i < zs2zArray.length; ++i) {
                if (!zs2zArray[i].getZoneName().equals(zone.getName())) continue;
                zonesets.add(this.getZoneSet(zs2zArray[i].getZoneSetName()));
            }
        }
        return zonesets.toArray(new ZoneSet[0]);
    }

    public ZoneSet getZoneSet(String zsName) {
        if (zsName != null) {
            ZoneSet[] zsArray = this.zonesets.toArray(new ZoneSet[0]);
            for (int i = 0; i < zsArray.length; ++i) {
                if (!zsArray[i].getName().equals(zsName)) continue;
                return zsArray[i];
            }
        }
        return null;
    }

    public void deleteZoneSets(ZoneSet[] zsArray) {
        for (int i = 0; i < zsArray.length; ++i) {
            this.deleteZoneSet(zsArray[i]);
        }
    }

    public void deleteZoneSet(ZoneSet zs) {
        if (zs != null) {
            if (this.activeZoneSet != null && this.activeZoneSet.equals(zs.getName())) {
                this.activeZoneSet = null;
                this.lastActiveZoneSet = zs.getName();
            }
            this.zonesets.remove(zs);
            ZoneSet2Zone[] zs2zArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            for (int j = 0; j < zs2zArray.length; ++j) {
                if (!zs2zArray[j].getZoneSetName().equals(zs.getName())) continue;
                Zone zone = this.getZone(zs2zArray[j].getZoneName(), zs2zArray[j].getZoneVendorType());
                this.zoneset2zone.remove(zs2zArray[j]);
            }
        }
    }

    public void activateZoneSet(ZoneSet zoneSet) {
        if (zoneSet != null) {
            this.addZoneSet(zoneSet);
            this.activeZoneSet = zoneSet.getName();
            this.lastActiveZoneSet = null;
        }
    }

    public void deactivateZoneSet() {
        this.activeZoneSet = null;
        this.lastActiveZoneSet = null;
    }

    public void deactivateZoneSet(ZoneSet zoneSet) {
        if (zoneSet != null && this.activeZoneSet != null && this.activeZoneSet.equals(zoneSet.getName())) {
            this.activeZoneSet = null;
            this.lastActiveZoneSet = null;
        }
    }

    public ZoneSet getActiveZoneSet() {
        if (this.activeZoneSet != null) {
            return this.getZoneSet(this.activeZoneSet);
        }
        return null;
    }

    private boolean isEmpty(ZoneSet zoneSet) {
        String methodName = "isEmpty(zoneset)";
        boolean empty = true;
        if (zoneSet == null) {
            empty = false;
        } else {
            ZoneSet2Zone[] zs2zArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            for (int j = 0; j < zs2zArray.length; ++j) {
                if (!zs2zArray[j].getZoneSetName().equals(zoneSet.getName())) continue;
                empty = false;
                break;
            }
        }
        return empty;
    }

    public void addZones(Zone[] zones) {
        for (int i = 0; i < zones.length; ++i) {
            this.addZone(zones[i]);
        }
    }

    public void addZone(Zone zone) {
        if (zone != null && !this.zones.contains(zone)) {
            this.zones.add(zone);
        }
    }

    public void addZone(ZoneSet zoneset, Zone zone) {
        if (zoneset != null && zone != null) {
            this.addZoneSet(zoneset);
            this.addZone(zone);
            ZoneSet2Zone zs2z = new ZoneSet2Zone(zoneset.getName(), zone.getName(), zone.getVendorType());
            if (!this.zoneset2zone.contains(zs2z)) {
                this.zoneset2zone.add(zs2z);
            }
        }
    }

    public void removeZone(ZoneSet zoneset, Zone zone) {
        if (zoneset != null && zone != null) {
            ZoneSet2Zone[] zs2zArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            for (int j = 0; j < zs2zArray.length; ++j) {
                if (!zs2zArray[j].getZoneSetName().equals(zoneset.getName()) || !zs2zArray[j].getZoneName().equals(zone.getName())) continue;
                ZoneSet zs = this.getZoneSet(zs2zArray[j].getZoneSetName());
                this.zoneset2zone.remove(zs2zArray[j]);
                if (!this.isEmpty(zs)) continue;
                this.deleteZoneSet(zs);
            }
        }
    }

    public ZoneSet[] removeZoneAndReturnDeletedZoneSets(ZoneSet zoneset, Zone zone) {
        ArrayList<ZoneSet> deletedZoneSets = new ArrayList<ZoneSet>();
        if (zoneset != null && zone != null) {
            ZoneSet2Zone[] zs2zArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            for (int j = 0; j < zs2zArray.length; ++j) {
                if (!zs2zArray[j].getZoneSetName().equals(zoneset.getName()) || !zs2zArray[j].getZoneName().equals(zone.getName())) continue;
                ZoneSet zs = this.getZoneSet(zs2zArray[j].getZoneSetName());
                this.zoneset2zone.remove(zs2zArray[j]);
                if (!this.isEmpty(zs)) continue;
                if (!deletedZoneSets.contains(zs)) {
                    deletedZoneSets.add(zs);
                }
                this.deleteZoneSet(zs);
            }
        }
        return deletedZoneSets.toArray(new ZoneSet[0]);
    }

    public Zone[] getZones() {
        return this.zones.toArray(new Zone[0]);
    }

    public Zone getZone(String name) {
        if (name != null) {
            Zone[] zoneArray = this.zones.toArray(new Zone[0]);
            for (int i = 0; i < zoneArray.length; ++i) {
                if (!zoneArray[i].getName().equals(name) || zoneArray[i].getVendorType() != 1) continue;
                return zoneArray[i];
            }
        }
        return null;
    }

    public Zone getZone(String name, short vendorType) {
        if (name != null) {
            Zone[] zoneArray = this.zones.toArray(new Zone[0]);
            for (int i = 0; i < zoneArray.length; ++i) {
                if (!zoneArray[i].getName().equals(name) || zoneArray[i].getVendorType() != vendorType) continue;
                return zoneArray[i];
            }
        }
        return null;
    }

    public Zone[] getZones(ZoneSet zoneset) {
        ArrayList<Zone> zones = new ArrayList<Zone>();
        if (zoneset != null) {
            ZoneSet2Zone[] zs2zArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            for (int i = 0; i < zs2zArray.length; ++i) {
                if (!zs2zArray[i].getZoneSetName().equals(zoneset.getName())) continue;
                zones.add(this.getZone(zs2zArray[i].getZoneName(), zs2zArray[i].getZoneVendorType()));
            }
        }
        return zones.toArray(new Zone[0]);
    }

    public Zone[] getZones(ZoneAlias alias) {
        ArrayList<Zone> zones = new ArrayList<Zone>();
        if (alias != null) {
            Zone2ZoneAlias[] z2zaArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            for (int i = 0; i < z2zaArray.length; ++i) {
                if (!z2zaArray[i].getZoneAliasName().equals(alias.getName())) continue;
                zones.add(this.getZone(z2zaArray[i].getZoneName(), z2zaArray[i].getZoneVendorType()));
            }
        }
        return zones.toArray(new Zone[0]);
    }

    public Zone[] getZones(ZoneMember member) {
        ArrayList<Zone> zones = new ArrayList<Zone>();
        if (member != null) {
            Zone2ZoneMember[] z2zmArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            for (int i = 0; i < z2zmArray.length; ++i) {
                if (!z2zmArray[i].getZoneMemberName().equalsIgnoreCase(member.getName()) || z2zmArray[i].getZoneMemberType() != member.getType()) continue;
                zones.add(this.getZone(z2zmArray[i].getZoneName(), z2zmArray[i].getZoneVendorType()));
            }
        }
        return zones.toArray(new Zone[0]);
    }

    public void deleteZones(Zone[] zoneArray) {
        for (int i = 0; i < zoneArray.length; ++i) {
            this.deleteZone(zoneArray[i]);
        }
    }

    public void deleteZone(Zone zone) {
        String methodName = "deleteZone";
        if (zone != null) {
            this.zones.remove(zone);
            ZoneSet2Zone[] zs2zArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            for (int j = 0; j < zs2zArray.length; ++j) {
                if (!zs2zArray[j].getZoneName().equals(zone.getName())) continue;
                ZoneSet zs = this.getZoneSet(zs2zArray[j].getZoneSetName());
                this.zoneset2zone.remove(zs2zArray[j]);
                if (!this.isEmpty(zs)) continue;
                this.deleteZoneSet(zs);
            }
            Zone2ZoneAlias[] z2zaArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            for (int j = 0; j < z2zaArray.length; ++j) {
                if (!z2zaArray[j].getZoneName().equals(zone.getName())) continue;
                ZoneAlias za = this.getZoneAlias(z2zaArray[j].getZoneAliasName());
                this.zone2alias.remove(z2zaArray[j]);
            }
            Zone2ZoneMember[] z2zmArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            for (int j = 0; j < z2zmArray.length; ++j) {
                if (!z2zmArray[j].getZoneName().equals(zone.getName())) continue;
                ZoneMember zm = this.getZoneMember(z2zmArray[j].getZoneMemberName(), z2zmArray[j].getZoneMemberType());
                this.zone2member.remove(z2zmArray[j]);
                if (!this.isOrphaned(zm)) continue;
                this.deleteMember(zm);
            }
        }
    }

    public ZoneSet[] deleteZoneAndReturnDeletedZoneSets(Zone zone) {
        ArrayList deletedZoneSets = new ArrayList();
        this.deleteZone(zone, deletedZoneSets);
        return deletedZoneSets.toArray(new ZoneSet[0]);
    }

    public ZoneSet[] deleteZonesAndReturnDeletedZoneSets(Zone[] zoneArray) {
        ArrayList deletedZoneSets = new ArrayList();
        for (int i = 0; i < zoneArray.length; ++i) {
            this.deleteZone(zoneArray[i], deletedZoneSets);
        }
        return deletedZoneSets.toArray(new ZoneSet[0]);
    }

    public void deleteZone(Zone zone, ArrayList deletedZoneSets) {
        if (zone != null) {
            this.zones.remove(zone);
            ZoneSet2Zone[] zs2zArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            for (int j = 0; j < zs2zArray.length; ++j) {
                if (!zs2zArray[j].getZoneName().equals(zone.getName())) continue;
                ZoneSet zs = this.getZoneSet(zs2zArray[j].getZoneSetName());
                this.zoneset2zone.remove(zs2zArray[j]);
                if (!this.isEmpty(zs)) continue;
                if (!deletedZoneSets.contains(zs)) {
                    deletedZoneSets.add(zs);
                }
                this.deleteZoneSet(zs);
            }
            Zone2ZoneAlias[] z2zaArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            for (int j = 0; j < z2zaArray.length; ++j) {
                if (!z2zaArray[j].getZoneName().equals(zone.getName())) continue;
                ZoneAlias za = this.getZoneAlias(z2zaArray[j].getZoneAliasName());
                this.zone2alias.remove(z2zaArray[j]);
            }
            Zone2ZoneMember[] z2zmArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            for (int j = 0; j < z2zmArray.length; ++j) {
                if (!z2zmArray[j].getZoneName().equals(zone.getName())) continue;
                ZoneMember zm = this.getZoneMember(z2zmArray[j].getZoneMemberName(), z2zmArray[j].getZoneMemberType());
                this.zone2member.remove(z2zmArray[j]);
                if (!this.isOrphaned(zm)) continue;
                this.deleteMember(zm);
            }
        }
    }

    private boolean isOrphaned(Zone zone) {
        String methodName = "isOrphaned(zone)";
        boolean orphaned = true;
        if (zone == null) {
            orphaned = false;
        } else {
            ZoneSet2Zone[] zs2zArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            for (int j = 0; j < zs2zArray.length; ++j) {
                if (!zs2zArray[j].getZoneName().equals(zone.getName())) continue;
                orphaned = false;
                break;
            }
        }
        return orphaned;
    }

    private boolean isEmpty(Zone zone) {
        String methodName = "isEmpty(zone)";
        boolean empty = true;
        if (zone == null) {
            empty = false;
        } else {
            Zone2ZoneAlias[] z2zaArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            for (int j = 0; j < z2zaArray.length; ++j) {
                if (!z2zaArray[j].getZoneName().equals(zone.getName())) continue;
                empty = false;
                break;
            }
            if (empty) {
                Zone2ZoneMember[] z2zmArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
                for (int j = 0; j < z2zmArray.length; ++j) {
                    if (!z2zmArray[j].getZoneName().equals(zone.getName())) continue;
                    empty = false;
                    break;
                }
            }
        }
        return empty;
    }

    public void addMembers(ZoneMember[] members) {
        String methodName = "addMembers";
        for (int i = 0; i < members.length; ++i) {
            this.addMember(members[i]);
        }
    }

    public void addMember(ZoneMember member) {
        String methodName = "addMember";
        if (member != null && !this.members.contains(member)) {
            this.members.add(member);
        }
    }

    public void addMember(Zone zone, ZoneMember member) {
        if (zone != null && member != null) {
            this.addZone(zone);
            this.addMember(member);
            Zone2ZoneMember z2zm = new Zone2ZoneMember(zone.getName(), zone.getVendorType(), member.getName(), member.getType());
            if (!this.zone2member.contains(z2zm)) {
                this.zone2member.add(z2zm);
            }
        }
    }

    public void addMembers(Zone zone, ZoneMember[] members) {
        if (zone != null) {
            this.addZone(zone);
            this.addMembers(members);
            for (int i = 0; i < members.length; ++i) {
                Zone2ZoneMember z2zm;
                if (members[i] == null || this.zone2member.contains(z2zm = new Zone2ZoneMember(zone.getName(), zone.getVendorType(), members[i].getName(), members[i].getType()))) continue;
                this.zone2member.add(z2zm);
            }
        }
    }

    public void addMember(ZoneAlias alias, ZoneMember member) {
        if (alias != null && member != null) {
            this.addAlias(alias);
            this.addMember(member);
            ZoneAlias2ZoneMember za2zm = new ZoneAlias2ZoneMember(alias.getName(), member.getName(), member.getType());
            if (!this.alias2member.contains(za2zm)) {
                this.alias2member.add(za2zm);
            }
        }
    }

    public void addMembers(ZoneAlias alias, ZoneMember[] members) {
        if (alias != null) {
            this.addAlias(alias);
            this.addMembers(members);
            for (int i = 0; i < members.length; ++i) {
                ZoneAlias2ZoneMember za2zm;
                if (members[i] == null || this.alias2member.contains(za2zm = new ZoneAlias2ZoneMember(alias.getName(), members[i].getName(), members[i].getType()))) continue;
                this.alias2member.add(za2zm);
            }
        }
    }

    public void removeMember(Zone zone, ZoneMember member) {
        String methodName = "removeMember(zone, member)";
        if (zone != null && member != null) {
            Zone2ZoneMember[] z2zmArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            for (int j = 0; j < z2zmArray.length; ++j) {
                if (!z2zmArray[j].getZoneName().equals(zone.getName()) || !z2zmArray[j].getZoneMemberName().equalsIgnoreCase(member.getName()) || z2zmArray[j].getZoneMemberType() != member.getType()) continue;
                Zone z = this.getZone(z2zmArray[j].getZoneName(), z2zmArray[j].getZoneVendorType());
                this.zone2member.remove(z2zmArray[j]);
                if (!this.isEmpty(z)) continue;
                this.deleteZone(z);
            }
        }
    }

    public void removeMember(ZoneAlias alias, ZoneMember member) {
        if (alias != null && member != null) {
            ZoneAlias2ZoneMember[] za2zmArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            for (int j = 0; j < za2zmArray.length; ++j) {
                if (!za2zmArray[j].getZoneAliasName().equals(alias.getName()) || !za2zmArray[j].getZoneMemberName().equalsIgnoreCase(member.getName()) || za2zmArray[j].getZoneMemberType() != member.getType()) continue;
                ZoneAlias za = this.getZoneAlias(za2zmArray[j].getZoneAliasName());
                this.alias2member.remove(za2zmArray[j]);
                if (!this.isEmpty(za)) continue;
                this.deleteAlias(za);
            }
        }
    }

    public ZoneMember[] getMembers() {
        String methodName = "getMembers";
        return this.members.toArray(new ZoneMember[0]);
    }

    public ZoneMember[] getMembers(Zone zone) {
        String methodName = "getMembers(zone)";
        ArrayList<ZoneMember> members = new ArrayList<ZoneMember>();
        if (zone != null) {
            Zone2ZoneMember[] z2zmArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            for (int i = 0; i < z2zmArray.length; ++i) {
                if (!z2zmArray[i].getZoneName().equals(zone.getName())) continue;
                members.add(this.getZoneMember(z2zmArray[i].getZoneMemberName(), z2zmArray[i].getZoneMemberType()));
            }
        }
        return members.toArray(new ZoneMember[0]);
    }

    public ZoneMember[] getMembers(ZoneAlias alias) {
        ArrayList<ZoneMember> members = new ArrayList<ZoneMember>();
        if (alias != null) {
            ZoneAlias2ZoneMember[] za2zmArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            for (int i = 0; i < za2zmArray.length; ++i) {
                if (!za2zmArray[i].getZoneAliasName().equals(alias.getName())) continue;
                members.add(this.getZoneMember(za2zmArray[i].getZoneMemberName(), za2zmArray[i].getZoneMemberType()));
            }
        }
        return members.toArray(new ZoneMember[0]);
    }

    public ZoneMember getZoneMember(String name, short type) {
        String methodName = "getZoneMember";
        if (name != null) {
            ZoneMember[] zoneMemberArray = this.members.toArray(new ZoneMember[0]);
            for (int i = 0; i < zoneMemberArray.length; ++i) {
                if (!zoneMemberArray[i].getName().equalsIgnoreCase(name) || zoneMemberArray[i].getType() != type) continue;
                return zoneMemberArray[i];
            }
        }
        return null;
    }

    public void deleteMembers(ZoneMember[] zoneMemberArray) {
        String methodName = "deleteMembers";
        for (int i = 0; i < zoneMemberArray.length; ++i) {
            this.deleteMember(zoneMemberArray[i]);
        }
    }

    public void deleteMember(ZoneMember member) {
        if (member != null) {
            this.members.remove(member);
            Zone2ZoneMember[] z2zmArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            for (int j = 0; j < z2zmArray.length; ++j) {
                if (!z2zmArray[j].getZoneMemberName().equalsIgnoreCase(member.getName()) || z2zmArray[j].getZoneMemberType() != member.getType()) continue;
                Zone zone = this.getZone(z2zmArray[j].getZoneName(), z2zmArray[j].getZoneVendorType());
                this.zone2member.remove(z2zmArray[j]);
                if (!this.isEmpty(zone)) continue;
                this.deleteZone(zone);
            }
            ZoneAlias2ZoneMember[] za2zmArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            for (int j = 0; j < za2zmArray.length; ++j) {
                if (!za2zmArray[j].getZoneMemberName().equalsIgnoreCase(member.getName()) || za2zmArray[j].getZoneMemberType() != member.getType()) continue;
                ZoneAlias za = this.getZoneAlias(za2zmArray[j].getZoneAliasName());
                this.alias2member.remove(za2zmArray[j]);
                if (!this.isEmpty(za)) continue;
                this.deleteAlias(za);
            }
        }
    }

    private boolean isOrphaned(ZoneMember member) {
        String methodName = "isOrphaned(member)";
        boolean orphaned = true;
        if (member == null) {
            orphaned = false;
        } else {
            Zone2ZoneMember[] z2zmArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            for (int j = 0; j < z2zmArray.length; ++j) {
                if (!z2zmArray[j].getZoneMemberName().equals(member.getName()) || z2zmArray[j].getZoneMemberType() != member.getType()) continue;
                orphaned = false;
                break;
            }
            if (orphaned) {
                ZoneAlias2ZoneMember[] za2zmArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
                for (int j = 0; j < za2zmArray.length; ++j) {
                    if (!za2zmArray[j].getZoneMemberName().equals(member.getName()) || za2zmArray[j].getZoneMemberType() != member.getType()) continue;
                    orphaned = false;
                    break;
                }
            }
        }
        return orphaned;
    }

    public void addAliases(ZoneAlias[] aliases) {
        for (int i = 0; i < aliases.length; ++i) {
            this.addAlias(aliases[i]);
        }
    }

    public void addAlias(ZoneAlias alias) {
        if (alias != null && !this.aliases.contains(alias)) {
            this.aliases.add(alias);
        }
    }

    public void addAlias(Zone zone, ZoneAlias alias) {
        String methodName = "addAlias(zone, alias)";
        if (zone != null && alias != null) {
            this.addZone(zone);
            this.addAlias(alias);
            Zone2ZoneAlias z2za = new Zone2ZoneAlias(zone.getName(), zone.getVendorType(), alias.getName());
            if (!this.zone2alias.contains(z2za)) {
                this.zone2alias.add(z2za);
            }
        }
    }

    public void removeAlias(Zone zone, ZoneAlias alias) {
        String methodName = "removeAlias";
        if (zone != null && alias != null) {
            Zone2ZoneAlias[] z2zaArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            for (int j = 0; j < z2zaArray.length; ++j) {
                if (!z2zaArray[j].getZoneName().equals(zone.getName()) || !z2zaArray[j].getZoneAliasName().equals(alias.getName())) continue;
                Zone z = this.getZone(z2zaArray[j].getZoneName(), z2zaArray[j].getZoneVendorType());
                this.zone2alias.remove(z2zaArray[j]);
                if (!this.isEmpty(z)) continue;
                this.deleteZone(z);
            }
        }
    }

    public ZoneAlias[] getAliases() {
        String methodName = "getAliases";
        return this.aliases.toArray(new ZoneAlias[0]);
    }

    public ZoneAlias[] getAliases(Zone zone) {
        ArrayList<ZoneAlias> aliases = new ArrayList<ZoneAlias>();
        if (zone != null) {
            Zone2ZoneAlias[] z2zaArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            for (int i = 0; i < z2zaArray.length; ++i) {
                if (!z2zaArray[i].getZoneName().equals(zone.getName())) continue;
                aliases.add(this.getZoneAlias(z2zaArray[i].getZoneAliasName()));
            }
        }
        return aliases.toArray(new ZoneAlias[0]);
    }

    public ZoneAlias[] getAliases(ZoneMember member) {
        String methodName = "getAliases(member)";
        ArrayList<ZoneAlias> aliases = new ArrayList<ZoneAlias>();
        if (member != null) {
            ZoneAlias2ZoneMember[] za2zmArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            for (int i = 0; i < za2zmArray.length; ++i) {
                if (!za2zmArray[i].getZoneMemberName().equalsIgnoreCase(member.getName()) || za2zmArray[i].getZoneMemberType() != member.getType()) continue;
                aliases.add(this.getZoneAlias(za2zmArray[i].getZoneAliasName()));
            }
        }
        return aliases.toArray(new ZoneAlias[0]);
    }

    public ZoneAlias getZoneAlias(String name) {
        String methodName = "getZoneAlias";
        if (name != null) {
            ZoneAlias[] zoneAliasArray = this.aliases.toArray(new ZoneAlias[0]);
            for (int i = 0; i < zoneAliasArray.length; ++i) {
                if (!zoneAliasArray[i].getName().equals(name)) continue;
                return zoneAliasArray[i];
            }
        }
        return null;
    }

    public void deleteAliases(ZoneAlias[] zoneAliasArray) {
        String methodName = "deleteAliases";
        for (int i = 0; i < zoneAliasArray.length; ++i) {
            this.deleteAlias(zoneAliasArray[i]);
        }
    }

    public void deleteAlias(ZoneAlias alias) {
        String methodName = "deleteAlias";
        if (alias != null) {
            this.aliases.remove(alias);
            Zone2ZoneAlias[] z2zaArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            for (int j = 0; j < z2zaArray.length; ++j) {
                if (!z2zaArray[j].getZoneAliasName().equals(alias.getName())) continue;
                Zone zone = this.getZone(z2zaArray[j].getZoneName(), z2zaArray[j].getZoneVendorType());
                this.zone2alias.remove(z2zaArray[j]);
                if (!this.isEmpty(zone)) continue;
                this.deleteZone(zone);
            }
            ZoneAlias2ZoneMember[] za2zmArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            for (int j = 0; j < za2zmArray.length; ++j) {
                if (!za2zmArray[j].getZoneAliasName().equals(alias.getName())) continue;
                ZoneMember member = this.getZoneMember(za2zmArray[j].getZoneMemberName(), za2zmArray[j].getZoneMemberType());
                this.alias2member.remove(za2zmArray[j]);
                if (!this.isOrphaned(member)) continue;
                this.deleteMember(member);
            }
        }
    }

    private boolean isOrphaned(ZoneAlias alias) {
        boolean orphaned = true;
        if (alias == null) {
            orphaned = false;
        } else {
            Zone2ZoneAlias[] z2zaArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            for (int j = 0; j < z2zaArray.length; ++j) {
                if (!z2zaArray[j].getZoneAliasName().equals(alias.getName())) continue;
                orphaned = false;
                break;
            }
        }
        return orphaned;
    }

    private boolean isEmpty(ZoneAlias alias) {
        boolean empty = true;
        if (alias == null) {
            empty = false;
        } else {
            ZoneAlias2ZoneMember[] za2zmArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            for (int j = 0; j < za2zmArray.length; ++j) {
                if (!za2zmArray[j].getZoneAliasName().equals(alias.getName())) continue;
                empty = false;
                break;
            }
        }
        return empty;
    }

    public boolean isSameZoneSet(ZoneDefinition otherDef, String zoneSetName) {
        return this.isSameZoneSet(otherDef, zoneSetName, false);
    }

    public boolean isSameZoneSet(ZoneDefinition otherDef, String zoneSetName, boolean bCompareDescriptions) {
        boolean isSame = true;
        if (otherDef == null) {
            isSame = false;
        } else {
            ZoneSet zoneSet1 = this.getZoneSet(zoneSetName);
            ZoneSet zoneSet2 = otherDef.getZoneSet(zoneSetName);
            if (zoneSet1 != null && zoneSet1.isIdenticalTo(zoneSet2)) {
                if (bCompareDescriptions) {
                    isSame = this.compareDescriptions(zoneSet1.getDescription(), zoneSet2.getDescription());
                }
                if (isSame) {
                    Zone[] otherZ;
                    Zone[] z = this.getZones(zoneSet1);
                    if (z.length == (otherZ = otherDef.getZones(zoneSet2)).length) {
                        for (int i = 0; i < z.length; ++i) {
                            if (otherDef.zoneSetContainsZone(zoneSet2, z[i]) && this.isSameZone(otherDef, z[i].getName(), z[i].getVendorType(), bCompareDescriptions)) continue;
                            isSame = false;
                            break;
                        }
                    } else {
                        isSame = false;
                    }
                }
            } else {
                isSame = false;
            }
        }
        return isSame;
    }

    public boolean isSameZoneSet(ZoneDefinition otherDef, String zoneSetName, ArrayList uniqueZones, ArrayList otherUniqueZones) {
        boolean isSame;
        block6: {
            block5: {
                isSame = true;
                uniqueZones.clear();
                otherUniqueZones.clear();
                if (otherDef != null) break block5;
                isSame = false;
                ZoneSet zoneSet1 = this.getZoneSet(zoneSetName);
                Zone[] z = this.getZones(zoneSet1);
                for (int i = 0; i < z.length; ++i) {
                    uniqueZones.add(z[i]);
                }
                break block6;
            }
            isSame = this.isSameZoneSet(otherDef, zoneSetName);
            if (isSame) break block6;
            ZoneSet zoneSet1 = this.getZoneSet(zoneSetName);
            Zone[] z = this.getZones(zoneSet1);
            ZoneSet zoneSet2 = otherDef.getZoneSet(zoneSetName);
            for (int i = 0; i < z.length; ++i) {
                if (zoneSet2 != null && otherDef.zoneSetContainsZone(zoneSet2, z[i]) && this.isSameZone(otherDef, z[i].getName(), z[i].getVendorType())) continue;
                uniqueZones.add(z[i]);
            }
            if (zoneSet2 != null) {
                Zone[] otherZ = otherDef.getZones(zoneSet2);
                for (int i = 0; i < otherZ.length; ++i) {
                    if (this.getZone(otherZ[i].getName(), otherZ[i].getVendorType()) == null) {
                        otherUniqueZones.add(otherZ[i]);
                        continue;
                    }
                    if (this.zoneSetContainsZone(zoneSet1, otherZ[i]) && this.isSameZone(otherDef, otherZ[i].getName(), otherZ[i].getVendorType())) continue;
                    otherUniqueZones.add(otherZ[i]);
                }
            }
        }
        return isSame;
    }

    public boolean isSameZone(ZoneDefinition otherDef, String zoneName, short zoneVendorType) {
        return this.isSameZone(otherDef, zoneName, zoneVendorType, false);
    }

    public boolean isSameZone(ZoneDefinition otherDef, String zoneName, short zoneVendorType, boolean bCompareDescriptions) {
        boolean isSame = true;
        if (otherDef == null) {
            isSame = false;
        } else {
            Zone zone1 = this.getZone(zoneName, zoneVendorType);
            Zone zone2 = otherDef.getZone(zoneName, zoneVendorType);
            if (zone1 != null && zone1.isIdenticalTo(zone2)) {
                if (bCompareDescriptions) {
                    isSame = this.compareDescriptions(zone1.getDescription(), zone2.getDescription());
                }
                if (isSame) {
                    ZoneMember[] otherZm;
                    ZoneMember[] zm = this.getMembers(zone1);
                    if (zm.length == (otherZm = otherDef.getMembers(zone2)).length) {
                        for (int i = 0; i < zm.length; ++i) {
                            if (otherDef.zoneContainsMember(zone2, zm[i]) && zm[i].isIdenticalTo(otherDef.getZoneMember(zm[i].getName(), zm[i].getType()))) continue;
                            isSame = false;
                            break;
                        }
                        if (isSame) {
                            ZoneAlias[] otherZa;
                            ZoneAlias[] za = this.getAliases(zone1);
                            if (za.length == (otherZa = otherDef.getAliases(zone2)).length) {
                                for (int i = 0; i < za.length; ++i) {
                                    if (otherDef.zoneContainsAlias(zone2, za[i]) && this.isSameAlias(otherDef, za[i].getName(), bCompareDescriptions)) continue;
                                    isSame = false;
                                    break;
                                }
                            } else {
                                isSame = false;
                            }
                        }
                    } else {
                        isSame = false;
                    }
                }
            } else {
                isSame = false;
            }
        }
        return isSame;
    }

    public boolean isSameAlias(ZoneDefinition otherDef, String aliasName) {
        return this.isSameAlias(otherDef, aliasName, false);
    }

    public boolean isSameAlias(ZoneDefinition otherDef, String aliasName, boolean bCompareDescriptions) {
        boolean isSame = true;
        if (otherDef == null) {
            isSame = false;
        } else {
            ZoneAlias alias1 = this.getZoneAlias(aliasName);
            ZoneAlias alias2 = otherDef.getZoneAlias(aliasName);
            if (alias1 != null && alias1.isIdenticalTo(alias2)) {
                if (bCompareDescriptions) {
                    isSame = this.compareDescriptions(alias1.getDescription(), alias2.getDescription());
                }
                if (isSame) {
                    ZoneMember[] otherZm;
                    ZoneMember[] zm = this.getMembers(alias1);
                    if (zm.length == (otherZm = otherDef.getMembers(alias2)).length) {
                        for (int i = 0; i < zm.length; ++i) {
                            if (otherDef.zoneAliasContainsMember(alias2, zm[i]) && zm[i].isIdenticalTo(otherDef.getZoneMember(zm[i].getName(), zm[i].getType()))) continue;
                            isSame = false;
                            break;
                        }
                    } else {
                        isSame = false;
                    }
                }
            } else {
                isSame = false;
            }
        }
        return isSame;
    }

    public boolean zoneSetContainsZone(ZoneSet zs, Zone z) {
        boolean containsZone = false;
        if (zs != null && z != null) {
            ZoneSet2Zone[] zs2zArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            for (int j = 0; j < zs2zArray.length; ++j) {
                Zone zone;
                if (!zs2zArray[j].getZoneSetName().equals(zs.getName()) || !z.equals(zone = this.getZone(zs2zArray[j].getZoneName(), zs2zArray[j].getZoneVendorType()))) continue;
                containsZone = true;
                break;
            }
        }
        return containsZone;
    }

    public boolean zoneContainsMember(Zone z, ZoneMember zm) {
        boolean containsMember = false;
        if (z != null && zm != null) {
            Zone2ZoneMember[] z2zmArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            for (int j = 0; j < z2zmArray.length; ++j) {
                ZoneMember member;
                if (!z2zmArray[j].getZoneName().equals(z.getName()) || !zm.equals(member = this.getZoneMember(z2zmArray[j].getZoneMemberName(), z2zmArray[j].getZoneMemberType()))) continue;
                containsMember = true;
                break;
            }
        }
        return containsMember;
    }

    public boolean zoneAliasContainsMember(ZoneAlias za, ZoneMember zm) {
        boolean containsMember = false;
        if (za != null && zm != null) {
            ZoneAlias2ZoneMember[] za2zmArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            for (int j = 0; j < za2zmArray.length; ++j) {
                ZoneMember member;
                if (!za2zmArray[j].getZoneAliasName().equals(za.getName()) || !zm.equals(member = this.getZoneMember(za2zmArray[j].getZoneMemberName(), za2zmArray[j].getZoneMemberType()))) continue;
                containsMember = true;
                break;
            }
        }
        return containsMember;
    }

    public boolean zoneContainsAlias(Zone z, ZoneAlias za) {
        boolean containsAlias = false;
        if (z != null && za != null) {
            Zone2ZoneAlias[] z2zaArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            for (int j = 0; j < z2zaArray.length; ++j) {
                ZoneAlias alias;
                if (!z2zaArray[j].getZoneName().equals(z.getName()) || !za.equals(alias = this.getZoneAlias(z2zaArray[j].getZoneAliasName()))) continue;
                containsAlias = true;
                break;
            }
        }
        return containsAlias;
    }

    private boolean compareDescriptions(String description1, String description2) {
        boolean isSame = description1 != null ? description1.equals(description2) : description2 == null;
        return isSame;
    }

    public boolean equals(Object o) {
        ZoneSet[] otherZoneSets;
        ZoneSet[] zoneSets;
        boolean isSame = false;
        if (o != null && o instanceof ZoneDefinition && (zoneSets = this.getZoneSets()).length == (otherZoneSets = ((ZoneDefinition)o).getZoneSets()).length) {
            isSame = true;
            for (int i = 0; i < zoneSets.length; ++i) {
                if (this.isSameZoneSet((ZoneDefinition)o, zoneSets[i].getName(), true)) continue;
                isSame = false;
                break;
            }
        }
        return isSame;
    }

    public boolean equalsIgnoreDescriptions(Object o) {
        ZoneSet[] otherZoneSets;
        ZoneSet[] zoneSets;
        boolean isSame = false;
        if (o != null && o instanceof ZoneDefinition && (zoneSets = this.getZoneSets()).length == (otherZoneSets = ((ZoneDefinition)o).getZoneSets()).length) {
            isSame = true;
            for (int i = 0; i < zoneSets.length; ++i) {
                if (this.isSameZoneSet((ZoneDefinition)o, zoneSets[i].getName())) continue;
                isSame = false;
                break;
            }
        }
        return isSame;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = "1.3.0";
        }
        return this.version;
    }
}

